/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mapping.DefaultedItemStackList;
import forge.ziyue.tjmetro.mapping.MetalDetectionDoorEntity;
import forge.ziyue.tjmetro.mapping.PlayerInventoryHelper;
import forge.ziyue.tjmetro.mapping.RegistryHelper;
import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.BlockList;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import forge.ziyue.tjmetro.mod.data.IGuiExtension;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Entity;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.SoundCategory;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.SoundEvents;
import org.mtr.mod.block.IBlock;

public class BlockMetalDetectionDoor
extends BlockExtension
implements DirectionHelper,
BlockWithEntity,
IBlock {
    public static final BooleanProperty OPEN = BooleanProperty.of((String)"open");

    public BlockMetalDetectionDoor() {
        this(Blocks.createDefaultBlockSettings((boolean)true));
    }

    public BlockMetalDetectionDoor(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nullable
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        BlockState state = this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockMetalDetectionDoor.FACING.data), (Comparable)ctx.getPlayerFacing().data);
        BlockPos pos = ctx.getBlockPos();
        World world = ctx.getWorld();
        if (IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)Direction.UP, (int)3)) {
            world.setBlockState(pos.up(1), state.with(new org.mtr.mapping.holder.Property((Property)BlockMetalDetectionDoor.THIRD.data), (Comparable)IBlock.EnumThird.MIDDLE));
            world.setBlockState(pos.up(2), state.with(new org.mtr.mapping.holder.Property((Property)BlockMetalDetectionDoor.THIRD.data), (Comparable)IBlock.EnumThird.UPPER));
            return state.with(new org.mtr.mapping.holder.Property((Property)BlockMetalDetectionDoor.THIRD.data), (Comparable)IBlock.EnumThird.LOWER);
        }
        return null;
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlockExtension.checkHoldingBrushOrWrench(world, player, () -> {
            MetalDetectionDoorEntity entity = new MetalDetectionDoorEntity(world, switch ((IBlock.EnumThird)IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)THIRD)) {
                case IBlock.EnumThird.LOWER -> pos;
                case IBlock.EnumThird.MIDDLE -> pos.down(1);
                default -> pos.down(2);
            }, (BlockEntity)((Object)((Object)world.getBlockEntity((BlockPos)(switch ((IBlock.EnumThird)IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)THIRD)) {
                case IBlock.EnumThird.LOWER -> pos;
                case IBlock.EnumThird.MIDDLE -> pos.down(1);
                default -> pos.down(2);
            })).data)));
            world.spawnEntity(new Entity((net.minecraft.world.entity.Entity)entity));
            entity.m_6096_((Player)player.data, hand.data);
            BlockEntity lower = (BlockEntity)((Object)((Object)world.getBlockEntity((BlockPos)blockPos).data));
            BlockEntity middle = (BlockEntity)((Object)((Object)world.getBlockEntity((BlockPos)blockPos.up((int)1)).data));
            BlockEntity upper = (BlockEntity)((Object)((Object)world.getBlockEntity((BlockPos)blockPos.up((int)2)).data));
            middle.setData(lower.inventory);
            upper.setData(lower.inventory);
        });
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)THIRD) == IBlock.EnumThird.UPPER) {
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)6.0, (double)15.0, (Direction)direction);
        }
        VoxelShape left = IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (Direction)direction);
        VoxelShape right = IBlock.getVoxelShapeByDirection((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0, (Direction)direction);
        return VoxelShapes.union((VoxelShape)left, (VoxelShape)right);
    }

    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        VoxelShape shape = this.getOutlineShape2(state, world, pos, context);
        if (!IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)OPEN) && IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)THIRD) != IBlock.EnumThird.UPPER) {
            VoxelShape barrier = IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)2.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
            return VoxelShapes.union((VoxelShape)shape, (VoxelShape)barrier);
        }
        return shape;
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        switch ((IBlock.EnumThird)IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)THIRD)) {
            case UPPER: {
                IBlockExtension.breakBlock(world, pos.down(1), BlockList.METAL_DETECTION_DOOR.get());
                IBlockExtension.breakBlock(world, pos.down(2), BlockList.METAL_DETECTION_DOOR.get());
                break;
            }
            case MIDDLE: {
                IBlockExtension.breakBlock(world, pos.up(1), BlockList.METAL_DETECTION_DOOR.get());
                IBlockExtension.breakBlock(world, pos.down(1), BlockList.METAL_DETECTION_DOOR.get());
                break;
            }
            case LOWER: {
                IBlockExtension.breakBlock(world, pos.up(1), BlockList.METAL_DETECTION_DOOR.get());
                IBlockExtension.breakBlock(world, pos.up(2), BlockList.METAL_DETECTION_DOOR.get());
            }
        }
        super.onBreak2(world, pos, state, player);
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.metal_detection_door", (Object[])new Object[0]));
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)THIRD);
        properties.add((HolderBase<?>)OPEN);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        public final DefaultedItemStackList inventory = DefaultedItemStackList.ofSize(9);

        public BlockEntity(BlockPos blockPos, BlockState blockState) {
            super(BlockEntityTypes.METAL_DETECTION_DOOR.get(), blockPos, blockState);
        }

        public void blockEntityTick() {
            if (IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (EnumProperty)IBlock.THIRD) != IBlock.EnumThird.LOWER) {
                return;
            }
            PlayerEntity player = this.getWorld2().getClosestPlayer((double)this.getPos2().getX(), (double)this.getPos2().getY(), (double)this.getPos2().getZ(), 1.0, false);
            if (player != null) {
                if ((double)this.getPos2().getX() == Math.floor(player.getX()) && (long)this.getPos2().getY() == Math.round(player.getY()) && (double)this.getPos2().getZ() == Math.floor(player.getZ())) {
                    List items = ((NonNullList)this.inventory.data).stream().map(itemStack -> itemStack.m_41720_()).collect(Collectors.toList());
                    PlayerInventoryHelper.clearItems(player, items::contains);
                    if (IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (BooleanProperty)OPEN)) {
                        return;
                    }
                    this.getWorld2().playSound(null, this.getPos2(), SoundEvents.TICKET_BARRIER.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.getWorld2().setBlockState(this.getPos2(), this.getCachedState2().with(new org.mtr.mapping.holder.Property((Property)BlockMetalDetectionDoor.OPEN.data), (Comparable)Boolean.valueOf(true)));
                }
            } else {
                this.getWorld2().setBlockState(this.getPos2(), this.getCachedState2().with(new org.mtr.mapping.holder.Property((Property)BlockMetalDetectionDoor.OPEN.data), (Comparable)Boolean.valueOf(false)));
            }
        }

        public void writeCompoundTag(org.mtr.mapping.holder.CompoundTag compoundTag) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                ((CompoundTag)compoundTag.data).m_128359_(Integer.toString(i), ((ResourceLocation)RegistryHelper.getIdentifierByItem((Item)this.inventory.get((int)i).m_41720_()).data).toString());
            }
            super.writeCompoundTag(compoundTag);
        }

        public void readCompoundTag(org.mtr.mapping.holder.CompoundTag compoundTag) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                this.inventory.set(i, RegistryHelper.getItemStackByIdentifier(new Identifier(compoundTag.getString(Integer.toString(i)))));
            }
            super.readCompoundTag(compoundTag);
        }

        public void setData(DefaultedItemStackList list) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                this.inventory.set(i, RegistryHelper.cloneSingleItemStack(list.get(i)));
            }
            this.markDirty2();
        }
    }
}

