/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.Registry;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import forge.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongList;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.BlockPIDSHorizontalBase;
import org.mtr.mod.block.IBlock;

public class BlockPIDSTianjin
extends BlockPIDSHorizontalBase {
    public static final Map<Long, Category> CATEGORIES = new HashMap<Long, Category>();

    public BlockPIDSTianjin() {
        super(2);
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlockExtension.checkHoldingBrushOrWrench(world, player, () -> {
            BlockPos newBlockPos = BlockPIDSTianjin.getBlockPosWithData(world, pos);
            org.mtr.mapping.holder.BlockEntity entity = world.getBlockEntity(newBlockPos);
            if (entity != null && entity.data instanceof BlockEntity) {
                ((BlockEntity)((Object)((Object)entity.data))).markDirty2();
                Registry.REGISTRY.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), (PacketHandler)new PacketOpenBlockEntityScreen(newBlockPos));
            }
        });
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static boolean canStoreData(World world, BlockPos blockPos) {
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)FACING);
        return facing == Direction.NORTH || facing == Direction.EAST;
    }

    public static BlockPos getBlockPosWithData(World world, BlockPos blockPos) {
        if (BlockPIDSTianjin.canStoreData(world, blockPos)) {
            return blockPos;
        }
        return blockPos.offset(IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)FACING));
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        protected final LongAVLTreeSet platformIds = new LongAVLTreeSet();
        protected final LongArrayList categories = new LongArrayList();
        protected int displayPage;
        public static final String PLATFORM_IDS_ID = "platform_ids";
        public static final String DISPLAY_PAGE_ID = "display_page";
        public static final String CATEGORIES_ID = "categories";

        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.PIDS_TIANJIN.get(), pos, state);
            this.categories.add((long)"tjmetro".hashCode());
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            long[] categoriesArray;
            long[] platformIdsArray;
            this.platformIds.clear();
            for (long platformId : platformIdsArray = compoundTag.getLongArray(PLATFORM_IDS_ID)) {
                this.platformIds.add(platformId);
            }
            this.categories.clear();
            for (long category : categoriesArray = compoundTag.getLongArray(CATEGORIES_ID)) {
                this.categories.add(category);
            }
            this.displayPage = compoundTag.getInt(DISPLAY_PAGE_ID);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLongArray(PLATFORM_IDS_ID, new ArrayList(this.platformIds));
            compoundTag.putLongArray(CATEGORIES_ID, new ArrayList(this.categories));
            compoundTag.putInt(DISPLAY_PAGE_ID, this.displayPage);
        }

        public LongArrayList getCategories() {
            return this.categories;
        }

        public LongAVLTreeSet getPlatformIds() {
            return this.platformIds;
        }

        public int getDisplayPage() {
            return this.displayPage;
        }

        public void setData(LongArrayList categories) {
            this.categories.clear();
            this.categories.addAll((LongList)categories);
            this.markDirty2();
        }

        public void setData(LongAVLTreeSet platformIds, int displayPage) {
            this.platformIds.clear();
            this.platformIds.addAll((LongCollection)platformIds);
            this.displayPage = displayPage;
            this.markDirty2();
        }
    }

    public static class Category
    extends ArrayList<Advertisement> {
        public final long id;
        public final Color color;
        public final MutableText name;
        public final MutableText description;

        public Category(long id, Color color, MutableText name, MutableText description) {
            this.id = id;
            this.color = color;
            this.name = name;
            this.description = description;
        }
    }

    public static class Advertisement {
        private final Identifier image;
        private final MutableText text;

        public Advertisement(Identifier image, MutableText text) {
            this.image = image;
            this.text = text;
        }

        public Identifier getImage() {
            return this.image;
        }

        public MutableText getText() {
            return this.text;
        }
    }
}

