/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block;

import fabric.ziyue.tjmetro.mod.BlockEntityTypes;
import fabric.ziyue.tjmetro.mod.BlockList;
import fabric.ziyue.tjmetro.mod.ItemList;
import fabric.ziyue.tjmetro.mod.Registry;
import fabric.ziyue.tjmetro.mod.block.IBlockExtension;
import fabric.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import fabric.ziyue.tjmetro.mod.block.base.IRailwaySign;
import fabric.ziyue.tjmetro.mod.data.IGuiExtension;
import fabric.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2769;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.Items;
import org.mtr.mod.block.IBlock;

public class BlockStationNavigator
extends BlockRailwaySignBase {
    public static final BooleanProperty ARROW_LEFT = BooleanProperty.of((String)"arrow_left");
    public final int length;

    public BlockStationNavigator(int length) {
        this(length, Blocks.createDefaultBlockSettings((boolean)true, state -> 15));
    }

    public BlockStationNavigator(int length, BlockSettings blockSettings) {
        super(blockSettings, length, true);
        this.length = length;
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return IRailwaySign.getStateForNeighborUpdate(state, direction, neighborState, BlockList.STATION_NAVIGATOR_MIDDLE.get());
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        if (IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)2) && IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYCounterclockwise(), (int)2)) {
            World world = ctx.getWorld();
            BlockPos pos = ctx.getBlockPos();
            world.setBlockState(pos.offset(facing.rotateYCounterclockwise()), this.getDefaultState2().with(new Property((class_2769)BlockStationNavigator.FACING.data), (Comparable)facing.data));
            world.setBlockState(pos.offset(facing.rotateYClockwise()), this.getDefaultState2().with(new Property((class_2769)BlockStationNavigator.FACING.data), (Comparable)facing.getOpposite().data));
            world.updateNeighbors(pos, org.mtr.mapping.holder.Blocks.getAirMapped());
            this.getDefaultState2().updateNeighbors(new WorldAccess((class_1936)world.data), pos, 3);
            return BlockList.STATION_NAVIGATOR_MIDDLE.get().getDefaultState().with(new Property((class_2769)BlockStationNavigator.FACING.data), (Comparable)facing.data);
        }
        return null;
    }

    @Override
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> {
            BlockPos checkPos = this.findEndWithDirection(world, pos, hit.getSide().getOpposite(), false);
            if (item.data == ItemList.WRENCH.get().data) {
                Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(checkPos));
            } else {
                world.setBlockState(checkPos, world.getBlockState(checkPos).cycle(new Property((class_2769)BlockStationNavigator.ARROW_LEFT.data)));
            }
        }, null, (Item[])new Item[]{ItemList.WRENCH.get(), Items.BRUSH.get()});
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
    }

    @Override
    protected int getMiddleLength() {
        return 1;
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TextHelper.translatable((String)"tooltip.mtr.railway_sign_length", (Object[])new Object[]{this.length}).formatted(TextFormatting.GRAY));
        IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.station_navigator", (Object[])new Object[0]));
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (IBlockExtension.isBlock(state, BlockList.STATION_NAVIGATOR_MIDDLE.get())) {
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0, (Direction)facing);
        }
        return IBlock.getVoxelShapeByDirection((double)((double)this.getXStart() - 0.5), (double)0.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0, (Direction)facing);
    }

    @Override
    protected BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        return IRailwaySign.findEndWithDirection(world, startPos, direction, allowOpposite, BlockList.STATION_NAVIGATOR_MIDDLE.get());
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)ARROW_LEFT);
    }

    @Override
    @Nonnull
    public String getTranslationKey2() {
        return "block.tjmetro.station_navigator";
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this.length != 0) {
            return new BlockEntity(this.length, blockPos, blockState);
        }
        return null;
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        public final int length;
        protected LongAVLTreeSet selectedRoutes;
        protected static final String KEY_SELECTED_ROUTES = "selected_routes";

        public BlockEntity(int length, BlockPos pos, BlockState state) {
            super(BlockEntity.getType(length), pos, state);
            this.length = length;
            this.selectedRoutes = new LongAVLTreeSet();
        }

        public static BlockEntityType<?> getType(int length) {
            switch (length) {
                case 3: {
                    return BlockEntityTypes.STATION_NAVIGATOR_3.get();
                }
                case 4: {
                    return BlockEntityTypes.STATION_NAVIGATOR_4.get();
                }
                case 5: {
                    return BlockEntityTypes.STATION_NAVIGATOR_5.get();
                }
            }
            throw new InvalidParameterException();
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.selectedRoutes = new LongAVLTreeSet();
            Arrays.stream(compoundTag.getLongArray(KEY_SELECTED_ROUTES)).forEach(arg_0 -> ((LongAVLTreeSet)this.selectedRoutes).add(arg_0));
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLongArray(KEY_SELECTED_ROUTES, new ArrayList(this.selectedRoutes));
        }

        public void setData(LongAVLTreeSet selectedIds) {
            this.selectedRoutes = new LongAVLTreeSet();
            this.selectedRoutes.addAll((LongCollection)selectedIds);
            this.markDirty2();
        }

        public LongAVLTreeSet getSelectedRoutes() {
            return this.selectedRoutes;
        }
    }
}

