/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.render;

import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockPSDTop;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.DynamicTextureCache;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public abstract class RenderRouteBase<T extends BlockPSDTop.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
IBlock {
    public final float topPadding;
    public final float bottomPadding;
    public final float sidePadding;
    public final float z;
    public final boolean transparentWhite;
    public final int platformSearchYOffset;
    public final IntegerProperty arrowDirectionProperty;

    public RenderRouteBase(BlockEntityRenderer.Argument dispatcher, float z, float topPadding, float bottomPadding, float sidePadding, boolean transparentWhite, int platformSearchYOffset, IntegerProperty arrowDirectionProperty) {
        super(dispatcher);
        this.z = z / 16.0f;
        this.topPadding = topPadding / 16.0f;
        this.bottomPadding = bottomPadding / 16.0f;
        this.sidePadding = sidePadding / 16.0f;
        this.transparentWhite = transparentWhite;
        this.platformSearchYOffset = platformSearchYOffset;
        this.arrowDirectionProperty = arrowDirectionProperty;
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos blockPos = entity.getPos2();
        BlockState state = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)DirectionHelper.FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> graphicsHolderNew.rotateYDegrees(-facing.asRotation()));
        this.renderAdditionalUnmodified(storedMatrixTransformations.copy(), state, facing, light);
        InitClient.findClosePlatform((BlockPos)blockPos.down(this.platformSearchYOffset), (int)5, platform -> {
            long platformId = platform.getId();
            storedMatrixTransformations.add(graphicsHolderNew -> {
                graphicsHolderNew.translate(0.0, 1.0, 0.0);
                graphicsHolderNew.rotateZDegrees(180.0f);
                graphicsHolderNew.translate(-0.5, (double)(-this.getAdditionalOffset(state)), (double)this.z);
            });
            int leftBlocks = this.getTextureNumber(world, blockPos, facing, true);
            int rightBlocks = this.getTextureNumber(world, blockPos, facing, false);
            int color = org.mtr.mod.render.RenderRouteBase.getShadingColor((Direction)facing, (int)-1);
            RenderType renderType = this.getRenderType(world, blockPos.offset(facing.rotateYCounterclockwise(), leftBlocks), state);
            if (renderType != RenderType.NONE && IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                float height = 1.0f - this.topPadding - this.bottomPadding;
                int arrowDirection = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)this.arrowDirectionProperty);
                Identifier identifier = renderType == RenderType.ARROW ? DynamicTextureCache.instance.getDirectionArrow((long)platformId, (boolean)((arrowDirection & 1) > 0 ? true : false), (boolean)((arrowDirection & 2) > 0 ? true : false), (IGui.HorizontalAlignment)IGui.HorizontalAlignment.CENTER, (boolean)true, (float)0.25f, (float)(width / height), (int)-1, (int)-16777216, (int)(this.transparentWhite ? -1 : 0)).identifier : DynamicTextureCache.instance.getRouteMap((long)platformId, (boolean)false, (boolean)(arrowDirection == 2 ? true : false), (float)(width / height), (boolean)this.transparentWhite).identifier;
                MainRenderer.scheduleRender((Identifier)identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)(leftBlocks == 0 ? this.sidePadding : 0.0f), (float)this.topPadding, (float)0.0f, (float)(1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f)), (float)(1.0f - this.bottomPadding), (float)0.0f, (float)(((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)0.0f, (float)((width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)1.0f, (Direction)facing.getOpposite(), (int)color, (int)light);
                    graphicsHolderNew.pop();
                });
            }
            this.renderAdditional(storedMatrixTransformations, platformId, state, leftBlocks, rightBlocks, facing.getOpposite(), color, light);
        });
    }

    public boolean rendersOutsideBoundingBox2(T blockEntity) {
        return true;
    }

    protected void renderAdditionalUnmodified(StoredMatrixTransformations storedMatrixTransformations, BlockState state, Direction facing, int light) {
    }

    protected float getAdditionalOffset(BlockState state) {
        return 0.0f;
    }

    protected boolean isLeft(BlockState state) {
        return IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE_EXTENDED) == IBlock.EnumSide.LEFT;
    }

    protected boolean isRight(BlockState state) {
        return IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE_EXTENDED) == IBlock.EnumSide.RIGHT;
    }

    protected abstract RenderType getRenderType(World var1, BlockPos var2, BlockState var3);

    protected abstract void renderAdditional(StoredMatrixTransformations var1, long var2, BlockState var4, int var5, int var6, Direction var7, int var8, int var9);

    public int getTextureNumber(World world, BlockPos pos, Direction facing, boolean searchLeft) {
        BlockState state;
        int number = 0;
        Block thisBlock = world.getBlockState(pos).getBlock();
        while ((state = world.getBlockState(pos.offset(searchLeft ? facing.rotateYCounterclockwise() : facing.rotateYClockwise(), number))).getBlock().equals((Object)thisBlock)) {
            boolean isLeft = this.isLeft(state);
            boolean isRight = this.isRight(state);
            if (number != 0 && !(searchLeft ? !isRight : !isLeft)) break;
            ++number;
            if (!(searchLeft ? isLeft : isRight)) continue;
            break;
        }
        return number - 1;
    }

    public static enum RenderType {
        ARROW,
        ROUTE,
        NONE;

    }
}

