/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.BlockList;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import forge.ziyue.tjmetro.mod.block.base.BlockCustomColorBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.IBlock;

public class BlockMetalPoleBMT
extends BlockCustomColorBase
implements DirectionHelper {
    public static final BooleanProperty NORTH = BooleanProperty.of((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.of((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.of((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.of((String)"west");

    public BlockMetalPoleBMT() {
        this(Blocks.createDefaultBlockSettings((boolean)false).nonOpaque());
    }

    public BlockMetalPoleBMT(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nullable
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction direction = ctx.getSide();
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.NORTH.data), (Comparable)Boolean.valueOf(false)).with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.EAST.data), (Comparable)Boolean.valueOf(false)).with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.SOUTH.data), (Comparable)Boolean.valueOf(false)).with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.WEST.data), (Comparable)Boolean.valueOf(false)).with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.FACING_NORMAL.data), (Comparable)(direction == Direction.UP ? Direction.DOWN.data : direction.data));
    }

    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        if (IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING_NORMAL) != Direction.DOWN) {
            return state;
        }
        boolean shouldConnect = false;
        if (IBlockExtension.isBlock(neighborState, BlockList.METAL_POLE_BMT.get()) && IBlock.getStatePropertySafe((BlockState)neighborState, (DirectionProperty)FACING_NORMAL) != Direction.DOWN) {
            shouldConnect = true;
        }
        switch (direction) {
            case NORTH: {
                return state.with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.NORTH.data), (Comparable)Boolean.valueOf(shouldConnect));
            }
            case EAST: {
                return state.with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.EAST.data), (Comparable)Boolean.valueOf(shouldConnect));
            }
            case SOUTH: {
                return state.with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.SOUTH.data), (Comparable)Boolean.valueOf(shouldConnect));
            }
            case WEST: {
                return state.with(new org.mtr.mapping.holder.Property((Property)BlockMetalPoleBMT.WEST.data), (Comparable)Boolean.valueOf(shouldConnect));
            }
        }
        return state;
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING_NORMAL);
        if (direction == Direction.DOWN) {
            VoxelShape pole = Block.createCuboidShape((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
            VoxelShape connect = Block.createCuboidShape((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            if (IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)NORTH)) {
                connect = VoxelShapes.union((VoxelShape)connect, (VoxelShape)IBlock.getVoxelShapeByDirection((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)6.0, (Direction)Direction.NORTH));
            }
            if (IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)EAST)) {
                connect = VoxelShapes.union((VoxelShape)connect, (VoxelShape)IBlock.getVoxelShapeByDirection((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)6.0, (Direction)Direction.EAST));
            }
            if (IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)SOUTH)) {
                connect = VoxelShapes.union((VoxelShape)connect, (VoxelShape)IBlock.getVoxelShapeByDirection((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)6.0, (Direction)Direction.SOUTH));
            }
            if (IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)WEST)) {
                connect = VoxelShapes.union((VoxelShape)connect, (VoxelShape)IBlock.getVoxelShapeByDirection((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)6.0, (Direction)Direction.WEST));
            }
            return VoxelShapes.union((VoxelShape)pole, (VoxelShape)connect);
        }
        return IBlock.getVoxelShapeByDirection((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)16.0, (Direction)direction);
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    @Override
    @Nonnull
    public String getTranslationKey2() {
        return "block.tjmetro.metal_pole_bmt";
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING_NORMAL);
        properties.add((HolderBase<?>)NORTH);
        properties.add((HolderBase<?>)EAST);
        properties.add((HolderBase<?>)SOUTH);
        properties.add((HolderBase<?>)WEST);
    }

    public static class BlockEntity
    extends BlockCustomColorBase.BlockEntityBase {
        public BlockEntity(BlockPos blockPos, BlockState blockState) {
            super(BlockEntityTypes.METAL_POLE_BMT.get(), blockPos, blockState);
        }

        @Override
        public int getDefaultColor(BlockPos pos) {
            return 0xFFF100;
        }
    }
}

