/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.block;

import fabric.ziyue.tjmetro.mod.BlockEntityTypes;
import fabric.ziyue.tjmetro.mod.BlockList;
import fabric.ziyue.tjmetro.mod.Registry;
import fabric.ziyue.tjmetro.mod.block.IBlockExtension;
import fabric.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import fabric.ziyue.tjmetro.mod.block.base.IRailwaySign;
import fabric.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.IBlock;

public class BlockRailwaySignWall
extends BlockRailwaySignBase
implements IRailwaySign {
    public static final BooleanProperty EOS = BooleanProperty.of((String)"eos");

    public BlockRailwaySignWall(int length) {
        super(Blocks.createDefaultBlockSettings((boolean)true, blockState -> 15).noCollision(), length, false);
    }

    @Override
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        return IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)(this.getMiddleLength() + 1)) ? this.getDefaultState2().with(new Property((class_2769)BlockRailwaySignWall.FACING.data), (Comparable)facing.data).with(new Property((class_2769)BlockRailwaySignWall.EOS.data), (Comparable)Boolean.valueOf(false)) : null;
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        boolean isNext;
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        boolean bl = isNext = !IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)EOS) && direction == facing.rotateYClockwise() || IBlockExtension.isBlock(state, BlockList.RAILWAY_SIGN_WALL_MIDDLE.get()) && direction == facing.rotateYCounterclockwise();
        if (isNext && !(neighborState.getBlock().data instanceof BlockRailwaySignWall)) {
            return org.mtr.mapping.holder.Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        BlockPos checkPos = this.findEndWithDirection(world, pos, facing, false);
        return IBlockExtension.checkHoldingBrushOrWrench(world, player, () -> {
            if (checkPos != null) {
                Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(checkPos));
            }
        });
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world.isClient()) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        for (int i = 1; i < this.getMiddleLength(); ++i) {
            world.setBlockState(pos.offset(facing.rotateYClockwise(), i), BlockList.RAILWAY_SIGN_WALL_MIDDLE.get().getDefaultState().with(new Property((class_2769)BlockRailwaySignWall.FACING.data), (Comparable)facing.data).with(new Property((class_2769)BlockRailwaySignWall.EOS.data), (Comparable)Boolean.valueOf(false)), 3);
        }
        world.setBlockState(pos.offset(facing.rotateYClockwise(), this.getMiddleLength()), BlockList.RAILWAY_SIGN_WALL_MIDDLE.get().getDefaultState().with(new Property((class_2769)BlockRailwaySignWall.FACING.data), (Comparable)facing.data).with(new Property((class_2769)BlockRailwaySignWall.EOS.data), (Comparable)Boolean.valueOf(true)), 3);
        world.updateNeighbors(pos, org.mtr.mapping.holder.Blocks.getAirMapped());
        state.updateNeighbors(new WorldAccess((class_1936)world.data), pos, 3);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TextHelper.translatable((String)"tooltip.mtr.railway_sign_length", (Object[])new Object[]{this.length}).formatted(TextFormatting.GRAY));
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    @Override
    @Nonnull
    public String getTranslationKey2() {
        return "block.tjmetro.railway_sign_wall";
    }

    @Override
    protected BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        return IRailwaySign.findEndWithDirection(world, startPos, direction, allowOpposite, BlockList.RAILWAY_SIGN_WALL_MIDDLE.get());
    }

    @Override
    public int getXStart() {
        return 0;
    }

    @Override
    protected int getMiddleLength() {
        return this.length / 2 - 1;
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)EOS);
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == BlockList.RAILWAY_SIGN_WALL_MIDDLE.get().data) {
            return null;
        }
        return new BlockEntity(this.length, blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockRailwaySignBase.BlockEntityBase {
        public BlockEntity(int length, BlockPos pos, BlockState state) {
            super(BlockEntity.getType(length), length, pos, state);
        }

        public static BlockEntityType<?> getType(int length) {
            switch (length) {
                case 4: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_4.get();
                }
                case 6: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_6.get();
                }
                case 8: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_8.get();
                }
                case 10: {
                    return BlockEntityTypes.RAILWAY_SIGN_WALL_10.get();
                }
            }
            return null;
        }
    }
}

