/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.client;

import fabric.ziyue.tjmetro.mod.TianjinMetro;
import fabric.ziyue.tjmetro.mod.block.BlockStationNameEntranceTianjin;
import fabric.ziyue.tjmetro.mod.client.RouteMapGenerator;
import fabric.ziyue.tjmetro.mod.config.ConfigClient;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1044;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.mapping.holder.AbstractTexture;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageBackedTexture;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.config.Config;
import org.mtr.mod.config.LanguageDisplay;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;

public class DynamicTextureCache {
    public Font font;
    public Font fontCjk;
    public final Object2ObjectLinkedOpenHashMap<String, DynamicResource> dynamicResources = new Object2ObjectLinkedOpenHashMap();
    public final ObjectOpenHashSet<String> generatingResources = new ObjectOpenHashSet();
    public final ObjectArrayList<Runnable> resourceRegistryQueue = new ObjectArrayList();
    public static DynamicTextureCache instance;
    public static final int COOL_DOWN_TIME = 10000;
    public static final Identifier DEFAULT_BLACK_RESOURCE;
    public static final Identifier DEFAULT_WHITE_RESOURCE;
    public static final Identifier DEFAULT_TRANSPARENT_RESOURCE;

    public void reload() {
        this.font = null;
        this.fontCjk = null;
        TianjinMetro.LOGGER.debug("Refreshing dynamic resources");
        this.dynamicResources.values().forEach(dynamicResource -> {
            dynamicResource.needsRefresh = true;
        });
        this.generatingResources.clear();
    }

    public void tick() {
        ObjectArrayList keysToRemove = new ObjectArrayList();
        this.dynamicResources.forEach((checkKey, checkDynamicResource) -> {
            if (checkDynamicResource.expiryTime < System.currentTimeMillis()) {
                checkDynamicResource.remove();
                keysToRemove.add(checkKey);
            }
        });
        keysToRemove.forEach(arg_0 -> this.dynamicResources.remove(arg_0));
    }

    public DynamicResource getDirectionArrow(long platformId, boolean hasLeft, boolean hasRight, IGui.HorizontalAlignment horizontalAlignment, boolean showToString, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("tjmetro_direction_arrow_%s_%s_%s_%s_%s_%s_%s_%s_%s_%s", platformId, hasLeft, hasRight, horizontalAlignment, showToString, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor), () -> RouteMapGenerator.generateDirectionArrow(platformId, hasLeft, hasRight, horizontalAlignment, showToString, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationName(long platformId, boolean isAPG, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("tjmetro_station_name_%s_%s_%s_%s_%s_%s_%s_%s", platformId, isAPG, horizontalAlignment, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor), () -> RouteMapGenerator.generateStationName(platformId, isAPG, horizontalAlignment, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getSingleRowStationName(long platformId, float aspectRatio) {
        return this.getResource(String.format("tjmetro_single_row_station_name_%s_%s", platformId, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateSingleRowStationName(platformId, aspectRatio), DefaultRenderingColor.WHITE);
    }

    public DynamicResource getStationNameBMT(long platformId, boolean flip, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("tjmetro_station_name_bmt_%s_%s_%s_%s_%s_%s_%s_%s", platformId, flip, horizontalAlignment, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor), () -> RouteMapGenerator.generateStationNameBMT(platformId, flip, horizontalAlignment, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getNextStation(long platformId, int arrowDirection, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("tjmetro_next_station_%s_%s_%s_%s_%s_%s_%s", platformId, arrowDirection, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor), () -> RouteMapGenerator.generateNextStation(platformId, arrowDirection, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getNextStationJinjing(long platformId, int arrowDirection, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        return this.getResource(String.format("tjmetro_next_station_jinjing_%s_%s_%s_%s_%s_%s_%s", platformId, arrowDirection, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), backgroundColor, textColor, transparentColor), () -> RouteMapGenerator.generateNextStationJinjing(platformId, arrowDirection, paddingScale, aspectRatio, backgroundColor, textColor, transparentColor), transparentColor == 0 && backgroundColor == -1 ? DefaultRenderingColor.WHITE : DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getRouteMap(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        return this.getResource(String.format("tjmetro_route_map_%s_%s_%s_%s_%s", platformId, vertical, flip, Float.valueOf(aspectRatio), transparentWhite), () -> RouteMapGenerator.generateRouteMap(platformId, vertical, flip, aspectRatio, transparentWhite), transparentWhite ? DefaultRenderingColor.TRANSPARENT : DefaultRenderingColor.WHITE);
    }

    public DynamicResource getRouteMapJinjing(long platformId, int arrowDirection, float aspectRatio, boolean transparentWhite) {
        return this.getResource(String.format("tjmetro_route_map_jinjing_%s_%s_%s_%s", platformId, arrowDirection, Float.valueOf(aspectRatio), transparentWhite), () -> RouteMapGenerator.generateRouteMapJinjing(platformId, arrowDirection, aspectRatio, transparentWhite), transparentWhite ? DefaultRenderingColor.TRANSPARENT : DefaultRenderingColor.WHITE);
    }

    public DynamicResource getRouteMapTRT(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        return this.getResource(String.format("tjmetro_route_map_trt_%s_%s_%s_%s_%s", platformId, vertical, flip, Float.valueOf(aspectRatio), transparentWhite), () -> RouteMapGenerator.generateRouteMapTRT(platformId, vertical, flip, aspectRatio, transparentWhite), transparentWhite ? DefaultRenderingColor.TRANSPARENT : DefaultRenderingColor.WHITE);
    }

    public DynamicResource getRouteMapPSDBMT(long platformId, boolean flip, float aspectRatio, boolean transparentWhite) {
        return this.getResource(String.format("tjmetro_route_map_psd_bmt_%s_%s_%s_%s", platformId, flip, Float.valueOf(aspectRatio), transparentWhite), () -> RouteMapGenerator.generateRouteMapPSDBMT(platformId, flip, aspectRatio, transparentWhite), transparentWhite ? DefaultRenderingColor.TRANSPARENT : DefaultRenderingColor.WHITE);
    }

    public DynamicResource getRouteMapBMT(long platformId, boolean arrowLeft, float aspectRatio, int backgroundColor) {
        return this.getResource(String.format("tjmetro_route_map_bmt_%s_%s_%s_%s", platformId, arrowLeft, Float.valueOf(aspectRatio), backgroundColor), () -> RouteMapGenerator.generateRouteMapBMT(platformId, arrowLeft, aspectRatio, backgroundColor), DefaultRenderingColor.WHITE);
    }

    public DynamicResource getRouteSquare(int color, String routeName, IGui.HorizontalAlignment horizontalAlignment) {
        return this.getResource(String.format("tjmetro_route_square_%s_%s_%s", color, routeName, horizontalAlignment), () -> RouteMapGenerator.generateRouteSquare(color, routeName, horizontalAlignment), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getExitSignLetter(String exitLetter, String exitNumber, int backgroundColor) {
        return this.getResource(String.format("tjmetro_exit_sign_letter_%s_%s", exitLetter, exitNumber), () -> RouteMapGenerator.generateExitSignLetter(exitLetter, exitNumber, backgroundColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getExitSignLetterTianjin(String exitLetter, String exitNumber, int backgroundColor, int textColor, boolean forceMTRFont) {
        return this.getResource(String.format("tjmetro_exit_sign_letter_tianjin_%s_%s_%s_%s_%s", exitLetter, exitNumber, backgroundColor, textColor, forceMTRFont), () -> RouteMapGenerator.generateExitSignLetterTianjin(exitLetter, exitNumber, backgroundColor, textColor, forceMTRFont), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getBoundFor(long platformId, IGui.HorizontalAlignment horizontalAlignment, float aspectRatio, float paddingScale, int backgroundColor, int textColor, boolean forceMTRFont) {
        return this.getResource(String.format("tjmetro_bound_for_%s_%s_%s_%s_%s_%s_%s", platformId, horizontalAlignment, Float.valueOf(aspectRatio), Float.valueOf(paddingScale), backgroundColor, textColor, forceMTRFont), () -> RouteMapGenerator.generateBoundFor(platformId, horizontalAlignment, aspectRatio, paddingScale, backgroundColor, textColor, forceMTRFont), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getTrainTo(long platformId, IGui.HorizontalAlignment horizontalAlignment, float aspectRatio, float paddingScale, int backgroundColor, int textColor, boolean forceMTRFont) {
        return this.getResource(String.format("tjmetro_train_to_%s_%s_%s_%s_%s_%s_%s", platformId, horizontalAlignment, Float.valueOf(aspectRatio), Float.valueOf(paddingScale), backgroundColor, textColor, forceMTRFont), () -> RouteMapGenerator.generateTrainTo(platformId, horizontalAlignment, aspectRatio, paddingScale, backgroundColor, textColor, forceMTRFont), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getCrossLineTrainTo(long platformId, IGui.HorizontalAlignment horizontalAlignment, float aspectRatio, float paddingScale, int backgroundColor, int textColor, boolean forceMTRFont) {
        return this.getResource(String.format("tjmetro_cross_line_train_to_%s_%s_%s_%s_%s_%s_%s", platformId, horizontalAlignment, Float.valueOf(aspectRatio), Float.valueOf(paddingScale), backgroundColor, textColor, forceMTRFont), () -> RouteMapGenerator.generateCrossLineTrainTo(platformId, horizontalAlignment, aspectRatio, paddingScale, backgroundColor, textColor, forceMTRFont), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getSignText(String string, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, int backgroundColor, int textColor) {
        return this.getResource(String.format("tjmetro_sign_text_%s_%s_%s_%s_%s", string, horizontalAlignment, Float.valueOf(paddingScale), backgroundColor, textColor), () -> RouteMapGenerator.generateSignText(string, horizontalAlignment, paddingScale, backgroundColor, textColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationNameEntrance(long stationId, long selectedId, int style, String stationName, BlockStationNameEntranceTianjin.Type type, float aspectRatio) {
        return this.getResource(String.format("tjmetro_station_name_entrance_%s_%s_%s_%s_%s_%s", new Object[]{stationId, selectedId, style, stationName, type, Float.valueOf(aspectRatio)}), () -> RouteMapGenerator.generateStationNameEntrance(stationId, selectedId, style, stationName, type, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationNamePlate(long platformId, int arrowDirection, int backgroundColor, float paddingScale, float aspectRatio, int textColor, int transparentColor) {
        return this.getResource(String.format("tjmetro_station_name_plate_%s_%s_%s_%s_%s_%s_%s", platformId, arrowDirection, backgroundColor, Float.valueOf(paddingScale), Float.valueOf(aspectRatio), textColor, transparentColor), () -> RouteMapGenerator.generateStationNamePlate(platformId, arrowDirection, backgroundColor, paddingScale, aspectRatio, textColor, transparentColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationNameSignTianjin(long platformId, float aspectRatio, int backgroundColor) {
        return this.getResource(String.format("tjmetro_station_name_sign_tianjin_%s_%s_%s", platformId, Float.valueOf(aspectRatio), backgroundColor), () -> RouteMapGenerator.generateStationNameSignTianjin(platformId, aspectRatio, backgroundColor), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationNavigator(LongAVLTreeSet selectedRoutes, boolean arrowLeft, int backgroundColor, float aspectRatio) {
        return this.getResource(String.format("tjmetro_station_navigator_%s_%s_%s_%s", System.identityHashCode(selectedRoutes), arrowLeft, backgroundColor, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateStationNavigator(selectedRoutes, arrowLeft, backgroundColor, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getStationNameProjector(String stationName, float aspectRatio) {
        return this.getResource(String.format("tjmetro_station_name_projector_%s_%s", stationName, Float.valueOf(aspectRatio)), () -> RouteMapGenerator.generateStationNameProjector(stationName, aspectRatio), DefaultRenderingColor.TRANSPARENT);
    }

    public DynamicResource getPlainText(String text, int backgroundColor, int textColor) {
        return this.getResource(String.format("tjmetro_plain_text_%s_%s_%s", text, backgroundColor, textColor), () -> RouteMapGenerator.generatePlainText(text, backgroundColor, textColor), DefaultRenderingColor.TRANSPARENT);
    }

    public Text getText(String text, int fontSizeCjk, int fontSize) {
        return this.getText(text, Integer.MAX_VALUE, (int)((float)Math.max(fontSizeCjk, fontSize) * 1.25f), fontSizeCjk, fontSize, 0, null);
    }

    public Text getText(String text, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, IGui.HorizontalAlignment horizontalAlignment) {
        return this.getText(text, maxWidth, maxHeight, fontSizeCjk, fontSize, padding, horizontalAlignment, 1.25f, false);
    }

    public Text getText(String text, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, IGui.HorizontalAlignment horizontalAlignment, boolean forceMTRFont) {
        return this.getText(text, maxWidth, maxHeight, fontSizeCjk, fontSize, padding, horizontalAlignment, 1.25f, forceMTRFont);
    }

    public Text getText(String text, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, IGui.HorizontalAlignment horizontalAlignment, float lineHeightMultiply, boolean forceMTRFont) {
        return this.getText(text, maxWidth, maxHeight, fontSizeCjk, fontSize, padding, horizontalAlignment, lineHeightMultiply, forceMTRFont, false);
    }

    public Text getText(String text, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, IGui.HorizontalAlignment horizontalAlignment, float lineHeightMultiply, boolean forceMTRFont, boolean rotateNeg45Degree) {
        String[] tempTextSplit;
        if (forceMTRFont) {
            int[] dimensions = new int[2];
            byte[] pixels = org.mtr.mod.client.DynamicTextureCache.instance.getTextPixels(text, dimensions, maxWidth, maxHeight, fontSizeCjk, fontSize, padding, horizontalAlignment);
            return new Text(pixels, dimensions[0], dimensions[1], dimensions[0]);
        }
        if (maxWidth <= 0) {
            return new Text(new byte[0], 0, 0, 0);
        }
        boolean customFont = ConfigClient.USE_TIANJIN_METRO_FONT.get();
        boolean oneRow = horizontalAlignment == null;
        String[] defaultTextSplit = IGui.textOrUntitled((String)text).split("\\|");
        String[] textSplit = Config.getClient().getLanguageDisplay() == LanguageDisplay.NORMAL ? defaultTextSplit : ((tempTextSplit = (String[])Arrays.stream(IGui.textOrUntitled((String)text).split("\\|")).filter(textPart -> IGui.isCjk((String)textPart) == (Config.getClient().getLanguageDisplay() == LanguageDisplay.CJK_ONLY)).toArray(String[]::new)).length == 0 ? defaultTextSplit : tempTextSplit);
        AttributedString[] attributedStrings = new AttributedString[textSplit.length];
        int[] textWidths = new int[textSplit.length];
        int[] fontSizes = new int[textSplit.length];
        FontRenderContext context = new FontRenderContext(new AffineTransform(), false, false);
        int width = 0;
        int height = 0;
        for (int index = 0; index < textSplit.length; ++index) {
            int newFontSize = IGui.isCjk((String)textSplit[index]) || this.font.canDisplayUpTo(textSplit[index]) >= 0 ? fontSizeCjk : fontSize;
            attributedStrings[index] = new AttributedString(textSplit[index]);
            fontSizes[index] = newFontSize;
            if (this.font == null) {
                ResourceManagerHelper.readResource((Identifier)(ConfigClient.USE_TIANJIN_METRO_FONT.get() != false ? new Identifier("tjmetro", "font/dengxian.ttf") : new Identifier("mtr", "font/noto-sans-semibold.ttf")), inputStream -> {
                    try {
                        this.font = Font.createFont(0, inputStream);
                    }
                    catch (Exception e) {
                        TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
            if (this.fontCjk == null) {
                ResourceManagerHelper.readResource((Identifier)(ConfigClient.USE_TIANJIN_METRO_FONT.get() != false ? new Identifier("tjmetro", "font/dengxian.ttf") : new Identifier("mtr", "font/noto-serif-cjk-tc-semibold.ttf")), inputStream -> {
                    try {
                        this.fontCjk = Font.createFont(0, inputStream);
                    }
                    catch (Exception e) {
                        TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
            Font fontSized = this.font.deriveFont(0, newFontSize);
            Font fontCjkSized = this.fontCjk.deriveFont(0, newFontSize);
            for (int characterIndex = 0; characterIndex < textSplit[index].length(); ++characterIndex) {
                Font newFont;
                char character = textSplit[index].charAt(characterIndex);
                if (fontSized.canDisplay(character)) {
                    newFont = fontSized;
                } else if (fontCjkSized.canDisplay(character)) {
                    newFont = fontCjkSized;
                } else {
                    Font defaultFont = null;
                    for (Font testFont : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
                        if (!testFont.canDisplay(character)) continue;
                        defaultFont = testFont;
                        break;
                    }
                    newFont = (defaultFont == null ? new Font(null) : defaultFont).deriveFont(0, newFontSize);
                }
                int n = index;
                textWidths[n] = textWidths[n] + newFont.getStringBounds((String)textSplit[index].substring((int)characterIndex, (int)(characterIndex + 1)), (FontRenderContext)context).getBounds().width;
                attributedStrings[index].addAttribute(TextAttribute.FONT, newFont, characterIndex, characterIndex + 1);
            }
            if (oneRow) {
                if (index > 0) {
                    width += padding;
                }
                width += textWidths[index];
                height = Math.max(height, (int)((float)fontSizes[index] * lineHeightMultiply));
                continue;
            }
            width = Math.max(width, Math.min(maxWidth, textWidths[index]));
            height += (int)((float)fontSizes[index] * lineHeightMultiply);
        }
        int textOffset = 0;
        int realWidth = 0;
        if (rotateNeg45Degree) {
            maxWidth = (int)((double)maxHeight * Math.sqrt(2.0) - (double)height);
            for (int index = 0; index < textSplit.length; ++index) {
                if (oneRow) continue;
                float textWidth = Math.min(maxWidth, textWidths[index]);
                realWidth = Math.max(realWidth, (int)textWidth);
            }
            double imageWidth = (double)(realWidth + height) / Math.sqrt(2.0);
            BufferedImage image = new BufferedImage((int)imageWidth, (int)imageWidth, 10);
            Graphics2D graphics2D = image.createGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            for (int index = 0; index < textSplit.length; ++index) {
                if (oneRow) {
                    graphics2D.drawString(attributedStrings[index].getIterator(), (float)textOffset, (float)height / lineHeightMultiply - (customFont ? (float)height * 0.035f : 0.0f));
                    textOffset += textWidths[index] + padding;
                    continue;
                }
                float scaleY = 1.0f;
                float textWidth = Math.min(maxWidth, textWidths[index]);
                float scaleX = textWidth / (float)textWidths[index];
                float rotatedWidth = (float)((double)realWidth / Math.sqrt(2.0));
                AffineTransform stretch = new AffineTransform();
                stretch.rotate(Math.toRadians(-45.0), 0.0, rotatedWidth);
                stretch.concatenate(AffineTransform.getScaleInstance(scaleX, 1.0));
                graphics2D.setTransform(stretch);
                graphics2D.drawString(attributedStrings[index].getIterator(), horizontalAlignment.getOffset(0.0f, textWidth - (float)width) / 1.0f + (float)padding / scaleX, rotatedWidth + (float)textOffset + (float)fontSizes[index] - (customFont ? (float)height * 0.035f : 0.0f));
                textOffset += (int)((float)fontSizes[index] * lineHeightMultiply);
            }
            byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
            graphics2D.dispose();
            image.flush();
            return new Text(pixels, (int)imageWidth, (int)imageWidth, (int)imageWidth);
        }
        int imageHeight = Math.min(height, maxHeight);
        BufferedImage image = new BufferedImage(width + (oneRow ? 0 : padding * 2), imageHeight + (oneRow ? 0 : padding * 2), 10);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        for (int index = 0; index < textSplit.length; ++index) {
            if (oneRow) {
                graphics2D.drawString(attributedStrings[index].getIterator(), (float)textOffset, (float)height / lineHeightMultiply - (customFont ? (float)height * 0.035f : 0.0f));
                textOffset += textWidths[index] + padding;
                continue;
            }
            float scaleY = (float)imageHeight / (float)height;
            float textWidth = Math.min((float)maxWidth, (float)textWidths[index] * scaleY);
            float scaleX = textWidth / (float)textWidths[index];
            AffineTransform stretch = new AffineTransform();
            stretch.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
            graphics2D.setTransform(stretch);
            graphics2D.drawString(attributedStrings[index].getIterator(), horizontalAlignment.getOffset(0.0f, textWidth - (float)width) / scaleY + (float)padding / scaleX, (float)(textOffset + fontSizes[index]) + (float)padding / scaleY - (customFont ? (float)height * 0.035f : 0.0f));
            textOffset += (int)((float)fontSizes[index] * lineHeightMultiply);
            realWidth = Math.max(realWidth, (int)textWidth);
        }
        height = imageHeight + (oneRow ? 0 : padding * 2);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        graphics2D.dispose();
        image.flush();
        return new Text(pixels, realWidth += padding, height, width += oneRow ? 0 : padding * 2);
    }

    public DynamicResource getResource(String key, Supplier<NativeImage> supplier, DefaultRenderingColor defaultRenderingColor) {
        DynamicResource dynamicResource;
        Runnable runnable;
        if (ConfigClient.DISABLE_DYNAMIC_TEXTURES.get().booleanValue()) {
            return DefaultRenderingColor.BLACK_PURPLE.dynamicResource;
        }
        if (!this.resourceRegistryQueue.isEmpty() && (runnable = (Runnable)this.resourceRegistryQueue.remove(0)) != null) {
            runnable.run();
        }
        if ((dynamicResource = (DynamicResource)this.dynamicResources.get((Object)key)) != null && !dynamicResource.needsRefresh) {
            dynamicResource.expiryTime = System.currentTimeMillis() + 10000L;
            return dynamicResource;
        }
        if (this.generatingResources.contains((Object)key)) {
            return defaultRenderingColor.dynamicResource;
        }
        MainRenderer.WORKER_THREAD.scheduleDynamicTextures(() -> {
            while (this.font == null) {
                ResourceManagerHelper.readResource((Identifier)(ConfigClient.USE_TIANJIN_METRO_FONT.get() != false ? new Identifier("tjmetro", "font/dengxian.ttf") : new Identifier("mtr", "font/noto-sans-semibold.ttf")), inputStream -> {
                    try {
                        this.font = Font.createFont(0, inputStream);
                    }
                    catch (Exception e) {
                        TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
            while (this.fontCjk == null) {
                ResourceManagerHelper.readResource((Identifier)(ConfigClient.USE_TIANJIN_METRO_FONT.get() != false ? new Identifier("tjmetro", "font/dengxian.ttf") : new Identifier("mtr", "font/noto-serif-cjk-tc-semibold.ttf")), inputStream -> {
                    try {
                        this.fontCjk = Font.createFont(0, inputStream);
                    }
                    catch (Exception e) {
                        TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
            NativeImage nativeImage = (NativeImage)supplier.get();
            this.resourceRegistryQueue.add(() -> {
                DynamicResource staticTextureProviderOld = (DynamicResource)this.dynamicResources.get((Object)key);
                if (staticTextureProviderOld != null) {
                    staticTextureProviderOld.remove();
                }
                if (nativeImage != null) {
                    NativeImageBackedTexture nativeImageBackedTexture = new NativeImageBackedTexture(nativeImage);
                    Identifier identifier = new Identifier("tjmetro", Utilities.numberToPaddedHexString((long)UUID.randomUUID().getMostSignificantBits()).toLowerCase(Locale.ENGLISH));
                    MinecraftClient.getInstance().getTextureManager().registerTexture(identifier, new AbstractTexture((class_1044)nativeImageBackedTexture.data));
                    DynamicResource dynamicResourceNew = new DynamicResource(identifier, nativeImageBackedTexture);
                    this.dynamicResources.put((Object)key, (Object)dynamicResourceNew);
                }
                this.generatingResources.remove((Object)key);
            });
        });
        RouteMapGenerator.setConstants();
        this.generatingResources.add((Object)key);
        if (dynamicResource == null) {
            return defaultRenderingColor.dynamicResource;
        }
        dynamicResource.expiryTime = System.currentTimeMillis() + 10000L;
        dynamicResource.needsRefresh = false;
        return dynamicResource;
    }

    static {
        DEFAULT_BLACK_RESOURCE = new Identifier("mtr", "textures/block/black.png");
        DEFAULT_WHITE_RESOURCE = new Identifier("mtr", "textures/block/white.png");
        DEFAULT_TRANSPARENT_RESOURCE = new Identifier("mtr", "textures/block/transparent.png");
    }

    public static enum DefaultRenderingColor {
        BLACK(DEFAULT_BLACK_RESOURCE),
        WHITE(DEFAULT_WHITE_RESOURCE),
        TRANSPARENT(DEFAULT_TRANSPARENT_RESOURCE),
        BLACK_PURPLE(new Identifier("tjmetro", "deliberate.black_purple_tile"));

        private final DynamicResource dynamicResource;

        private DefaultRenderingColor(Identifier identifier) {
            this.dynamicResource = new DynamicResource(identifier, null);
        }
    }

    public static class DynamicResource {
        public long expiryTime;
        public boolean needsRefresh;
        public final int width;
        public final int height;
        public final Identifier identifier;

        public DynamicResource(Identifier identifier, @Nullable NativeImageBackedTexture nativeImageBackedTexture) {
            this.identifier = identifier;
            if (nativeImageBackedTexture != null) {
                NativeImage nativeImage = nativeImageBackedTexture.getImage();
                if (nativeImage != null) {
                    this.width = nativeImage.getWidth();
                    this.height = nativeImage.getHeight();
                } else {
                    this.width = 16;
                    this.height = 16;
                }
            } else {
                this.width = 16;
                this.height = 16;
            }
        }

        public void remove() {
            MinecraftClient.getInstance().getTextureManager().destroyTexture(this.identifier);
            MainRenderer.cancelRender((Identifier)this.identifier);
        }
    }

    public static final class Text {
        private final byte[] pixels;
        private final int width;
        private final int height;
        private final int renderWidth;

        public Text(byte[] pixels, int width, int height, int renderWidth) {
            this.pixels = pixels;
            this.width = width;
            this.height = height;
            this.renderWidth = renderWidth;
        }

        public byte[] pixels() {
            return this.pixels;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public int renderWidth() {
            return this.renderWidth;
        }

        public static Text empty() {
            return new Text(null, 0, 0, 0);
        }
    }
}

