/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;

public interface IGuiExtension {
    public static String filterLanguage(String text) {
        StringBuilder noCommentString = new StringBuilder(text);
        int commentIndex = noCommentString.indexOf("||");
        int separatorIndex = noCommentString.indexOf("|");
        if (commentIndex != -1) {
            noCommentString.delete(commentIndex, noCommentString.length());
        }
        if (separatorIndex != -1) {
            switch (Config.getClient().getLanguageDisplay()) {
                case CJK_ONLY: {
                    noCommentString.delete(separatorIndex, noCommentString.length());
                    break;
                }
                case NON_CJK_ONLY: {
                    noCommentString.delete(0, separatorIndex);
                }
            }
        }
        return noCommentString.toString();
    }

    public static String mergeTranslation(String keyCJK, String key) {
        switch (Config.getClient().getLanguageDisplay()) {
            default: {
                return TextHelper.translatable((String)keyCJK, (Object[])new Object[0]).getString() + "|" + TextHelper.translatable((String)key, (Object[])new Object[0]).getString();
            }
            case CJK_ONLY: {
                return TextHelper.translatable((String)keyCJK, (Object[])new Object[0]).getString();
            }
            case NON_CJK_ONLY: 
        }
        return TextHelper.translatable((String)key, (Object[])new Object[0]).getString();
    }

    public static ImmutablePair<String, String> splitTranslation(String text) {
        int separatorIndex = text.indexOf("|");
        if (separatorIndex == -1) {
            if (IGui.isCjk((String)text)) {
                return ImmutablePair.of((Object)text, (Object)"");
            }
            return ImmutablePair.of((Object)"", (Object)text);
        }
        return ImmutablePair.of((Object)text.substring(0, separatorIndex), (Object)text.substring(separatorIndex + 1));
    }

    public static String insertTranslation(String keyCJK, String key, @Nullable String overrideFirst, int expectedArguments, String ... arguments) {
        if (arguments.length < expectedArguments) {
            return "";
        }
        ArrayList<String[]> dataCJK = new ArrayList<String[]>();
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (int i = 0; i < arguments.length; ++i) {
            String[] argumentSplit = arguments[i].split("\\|");
            int indexCJK = 0;
            int index = 0;
            for (String text : argumentSplit) {
                if (IGui.isCjk((String)text)) {
                    if (indexCJK == dataCJK.size()) {
                        dataCJK.add(new String[expectedArguments]);
                    }
                    ((String[])dataCJK.get((int)indexCJK))[i] = text;
                    ++indexCJK;
                    continue;
                }
                if (index == data.size()) {
                    data.add(new String[expectedArguments]);
                }
                ((String[])data.get((int)index))[i] = text;
                ++index;
            }
        }
        StringBuilder result = new StringBuilder();
        dataCJK.forEach(combinedArguments -> {
            if (Arrays.stream(combinedArguments).allMatch(Objects::nonNull)) {
                result.append("|");
                if (overrideFirst == null) {
                    result.append(TextHelper.translatable((String)keyCJK, (Object[])combinedArguments).getString());
                } else {
                    String[] newCombinedArguments = new String[expectedArguments + 1];
                    System.arraycopy(combinedArguments, 0, newCombinedArguments, 1, expectedArguments);
                    newCombinedArguments[0] = overrideFirst;
                    result.append(TextHelper.translatable((String)keyCJK, (Object[])newCombinedArguments).getString());
                }
            }
        });
        data.forEach(combinedArguments -> {
            if (Arrays.stream(combinedArguments).allMatch(Objects::nonNull)) {
                result.append("|");
                if (overrideFirst == null) {
                    result.append(TextHelper.translatable((String)key, (Object[])combinedArguments).getString());
                } else {
                    String[] newCombinedArguments = new String[expectedArguments + 1];
                    System.arraycopy(combinedArguments, 0, newCombinedArguments, 1, expectedArguments);
                    newCombinedArguments[0] = overrideFirst;
                    result.append(TextHelper.translatable((String)key, (Object[])newCombinedArguments).getString());
                }
            }
        });
        if (result.length() > 0) {
            return result.substring(1);
        }
        return "";
    }

    public static String insertTranslation(String keyCJK, String key, int expectedArguments, String ... arguments) {
        return IGuiExtension.insertTranslation(keyCJK, key, null, expectedArguments, arguments);
    }

    public static List<MutableText> addHoldShiftTooltip(List<MutableText> list, MutableText component, boolean wordWarp, String regex, int limit) {
        if (Screen.hasShiftDown()) {
            String[] texts = (component.getString() + " ").split(regex, limit);
            if (wordWarp) {
                for (String text : texts) {
                    int start = 0;
                    while (start < text.length()) {
                        int end;
                        int currentWidth = 0;
                        int lastSpace = -1;
                        for (end = start; end < text.length() && currentWidth + GraphicsHolder.getTextWidth((String)text.substring(start, end + 1)) <= 380; ++end) {
                            if (text.charAt(end) == ' ') {
                                lastSpace = end;
                            }
                            currentWidth += GraphicsHolder.getTextWidth((String)text.substring(end, end + 1));
                        }
                        if (lastSpace != -1 && lastSpace > start) {
                            list.add(TextHelper.literal((String)text.substring(start, lastSpace)));
                            start = lastSpace + 1;
                            continue;
                        }
                        list.add(TextHelper.literal((String)text.substring(start, end)));
                        start = end;
                    }
                }
            } else {
                for (String text : texts) {
                    list.add(TextHelper.literal((String)text));
                }
            }
        } else {
            list.add(TextHelper.translatable((String)"tooltip.tjmetro.shift", (Object[])new Object[0]).formatted(TextFormatting.YELLOW));
        }
        return list;
    }

    public static List<MutableText> addHoldShiftTooltip(List<MutableText> list, MutableText component, boolean wordWarp, String regex) {
        return IGuiExtension.addHoldShiftTooltip(list, component, wordWarp, regex, 0);
    }

    public static List<MutableText> addHoldShiftTooltip(List<MutableText> list, MutableText component, boolean wordWarp) {
        return IGuiExtension.addHoldShiftTooltip(list, component, wordWarp, "\n", 0);
    }

    public static List<MutableText> addHoldShiftTooltip(List<MutableText> list, MutableText component) {
        return IGuiExtension.addHoldShiftTooltip(list, component, true, "\n", 0);
    }
}

