/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.config;

import fabric.ziyue.tjmetro.mapping.ModLoaderHelper;
import fabric.ziyue.tjmetro.mod.TianjinMetro;
import fabric.ziyue.tjmetro.mod.screen.ClientConfigScreen;
import fabric.ziyue.tjmetro.mod.screen.MissingClothConfigScreen;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_437;
import org.mtr.core.tool.Utilities;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.libraries.com.google.gson.JsonParser;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.TextHelper;

public class ConfigClient {
    private static final HashSet<Property<?>> PROPERTIES = new HashSet();
    public static final Property<Boolean> USE_TIANJIN_METRO_FONT = new Property<Boolean>("use_tianjin_metro_font", true);
    public static final Property<Boolean> ROTATED_STATION_NAME = new Property<Boolean>("rotated_station_name", true);
    public static final Property<Boolean> DISABLE_DYNAMIC_TEXTURES = new Property<Boolean>("disable_dynamic_textures", false);
    public static final Property<Boolean> DISABLE_TRAIN_RENDERING = new Property<Boolean>("disable_train_rendering", false);
    protected static final Path CONFIG_FILE_PATH = MinecraftClient.getInstance().getRunDirectoryMapped().toPath().resolve("config/tjmetro.json");
    public static final List<Footer> FOOTERS = Arrays.asList(new Footer(() -> TextHelper.translatable((String)"footer.tjmetro.sources", (Object[])new Object[0]), "https://github.com/ZiYueCommentary/Tianjin-Metro"), new Footer(() -> TextHelper.translatable((String)"footer.tjmetro.forum", (Object[])new Object[0]), "https://forum.ziyuesinicization.site/t/tianjin-metro"), new Footer(() -> TextHelper.translatable((String)"footer.tjmetro.contributors", (Object[])new Object[0]), "https://github.com/ZiYueCommentary/Tianjin-Metro/graphs/contributors"), new Footer(() -> TextHelper.translatable((String)"footer.tjmetro.weblate", (Object[])new Object[0]), "https://weblate.ziyuesinicization.site/engage/tianjin-metro/"), new Footer(() -> TextHelper.translatable((String)"footer.tjmetro.discord", (Object[])new Object[0]), "https://discord.gg/mEvEjPnVXe"), new Footer(() -> TextHelper.translatable((String)"footer.tjmetro.prevent_block_falling", (Object[])new Object[0]), "https://github.com/ZiYueCommentary/Tianjin-Metro/wiki/Prevent-block-falling"));

    public static Screen getConfigScreen(Screen parent) {
        if (ModLoaderHelper.hasClothConfig()) {
            return ClientConfigScreen.getClothConfigScreen(parent);
        }
        return new Screen((class_437)new MissingClothConfigScreen(parent));
    }

    public static void refreshProperties() {
        TianjinMetro.LOGGER.info("Refreshed Tianjin Metro config");
        try {
            JsonObject jsonConfig = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(CONFIG_FILE_PATH))).getAsJsonObject();
            for (Property<?> property : PROPERTIES) {
                Property<?> converted;
                if (property.get() instanceof Boolean) {
                    converted = property;
                    try {
                        converted.set(jsonConfig.get(converted.getId()).getAsBoolean());
                    }
                    catch (Exception e) {
                        converted.set((Boolean)converted.getDefault());
                    }
                    continue;
                }
                if (property.get() instanceof Number) {
                    converted = property;
                    try {
                        converted.set(jsonConfig.get(converted.getId()).getAsNumber());
                    }
                    catch (Exception e) {
                        converted.set((Number)converted.getDefault());
                    }
                    continue;
                }
                if (property.get() instanceof Enum) {
                    converted = property;
                    try {
                        converted.set(Enum.valueOf(((Enum)converted.get()).getClass(), jsonConfig.get(converted.getId()).getAsString()));
                    }
                    catch (Exception e) {
                        converted.set((Enum)converted.getDefault());
                    }
                    continue;
                }
                TianjinMetro.LOGGER.warn("Unrecognized config property: {}, type: {}", (Object)property.getId(), (Object)property.get().getClass().getName());
            }
        }
        catch (Exception e) {
            ConfigClient.writeToFile();
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void writeToFile() {
        TianjinMetro.LOGGER.info("Wrote Tianjin Metro config to file");
        JsonObject jsonConfig = new JsonObject();
        for (Property<?> property : PROPERTIES) {
            if (property.get() instanceof Boolean) {
                jsonConfig.addProperty(property.getId(), (Boolean)property.get());
                continue;
            }
            if (property.get() instanceof Number) {
                jsonConfig.addProperty(property.getId(), (Number)property.get());
                continue;
            }
            if (property.get() instanceof Enum) {
                jsonConfig.addProperty(property.getId(), property.get().toString());
                continue;
            }
            TianjinMetro.LOGGER.warn("Unrecognized config property: {}, type: {}", (Object)property.getId(), (Object)property.get().getClass().getName());
        }
        try {
            Files.write(CONFIG_FILE_PATH, Collections.singleton(Utilities.prettyPrint((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error((Object)e);
        }
    }

    public static class Property<T> {
        protected T value;
        protected final T defaultValue;
        protected final String id;

        public Property(String id, T defaultValue) {
            this.id = id;
            this.value = defaultValue;
            this.defaultValue = defaultValue;
            PROPERTIES.add(this);
        }

        public String getId() {
            return this.id;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public T getDefault() {
            return this.defaultValue;
        }
    }

    public static final class Footer {
        private final Supplier<MutableText> text;
        private final String link;

        public Footer(Supplier<MutableText> text, String link) {
            this.text = text;
            this.link = link;
        }

        public Supplier<MutableText> text() {
            return this.text;
        }

        public String link() {
            return this.link;
        }
    }
}

