/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.packet;

import fabric.ziyue.tjmetro.mod.RegistryClient;
import fabric.ziyue.tjmetro.mod.TianjinMetro;
import fabric.ziyue.tjmetro.mod.block.BlockRailwaySignWallDouble;
import fabric.ziyue.tjmetro.mod.block.BlockRoadblockSign;
import fabric.ziyue.tjmetro.mod.block.BlockStationNameEntranceTianjin;
import fabric.ziyue.tjmetro.mod.block.BlockStationNamePlate;
import fabric.ziyue.tjmetro.mod.block.BlockStationNavigator;
import fabric.ziyue.tjmetro.mod.block.base.BlockCustomColorBase;
import fabric.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import fabric.ziyue.tjmetro.mod.packet.PacketUpdateStationNavigatorConfig;
import fabric.ziyue.tjmetro.mod.screen.ColorPickerScreen;
import fabric.ziyue.tjmetro.mod.screen.RailwaySignDoubleScreen;
import fabric.ziyue.tjmetro.mod.screen.RailwaySignScreen;
import fabric.ziyue.tjmetro.mod.screen.RoadblockContentScreen;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_437;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongSortedSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Screen;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;

public final class ClientPacketHelper {
    public static void openBlockEntityScreen(BlockPos blockPos) {
        ClientPacketHelper.getBlockEntity(blockPos, blockEntity -> {
            if (blockEntity.data instanceof BlockRoadblockSign.BlockEntity) {
                BlockRoadblockSign.BlockEntity entity = (BlockRoadblockSign.BlockEntity)((Object)((Object)blockEntity.data));
                ClientPacketHelper.openScreen(new RoadblockContentScreen(blockPos, entity.content), screen -> screen instanceof RoadblockContentScreen);
            } else if (blockEntity.data instanceof BlockCustomColorBase.BlockEntityBase) {
                BlockCustomColorBase.BlockEntityBase entity = (BlockCustomColorBase.BlockEntityBase)((Object)((Object)blockEntity.data));
                ClientPacketHelper.openScreen(new ColorPickerScreen(blockPos, entity), screen -> screen instanceof ColorPickerScreen);
            } else if (blockEntity.data instanceof BlockRailwaySignWallDouble.BlockEntity) {
                ClientPacketHelper.openScreen(new RailwaySignDoubleScreen(blockPos), screen -> screen instanceof RailwaySignDoubleScreen);
            } else if (blockEntity.data instanceof BlockRailwaySignBase.BlockEntityBase) {
                ClientPacketHelper.openScreen(new RailwaySignScreen(blockPos), screen -> screen instanceof RailwaySignScreen);
            } else if (blockEntity.data instanceof BlockStationNameEntranceTianjin.BlockEntity) {
                ClientPacketHelper.openScreen(new RailwaySignScreen(blockPos), screen -> screen instanceof RailwaySignScreen);
            } else if (blockEntity.data instanceof BlockStationNamePlate.BlockEntity) {
                ClientPacketHelper.openScreen(new RailwaySignScreen(blockPos), screen -> screen instanceof RailwaySignScreen);
            } else if (blockEntity.data instanceof BlockStationNavigator.BlockEntity) {
                ObjectArraySet routes = new ObjectArraySet();
                MinecraftClientData.getInstance().simplifiedRoutes.forEach(route -> routes.add((Object)new DashboardListItem(route.getId(), route.getName().split("\\|\\|")[0], route.getColor())));
                LongAVLTreeSet selectedRoutes = new LongAVLTreeSet((LongSortedSet)((BlockStationNavigator.BlockEntity)((Object)((Object)blockEntity.data))).getSelectedRoutes());
                ClientPacketHelper.openScreen((ScreenExtension)new DashboardListSelectorScreen(() -> RegistryClient.sendPacketToServer(new PacketUpdateStationNavigatorConfig(blockPos, selectedRoutes)), new ObjectImmutableList((Collection)routes), (LongCollection)selectedRoutes, false, false, null), screen -> screen instanceof DashboardListSelectorScreen);
            } else {
                TianjinMetro.LOGGER.warn("Unknown block entity data at {}: {}", (Object)blockPos.toShortString(), blockEntity.data);
            }
        });
    }

    public static void openScreen(ScreenExtension screenExtension, Predicate<ScreenExtension> isInstance) {
        MinecraftClient minecraftClient = MinecraftClient.getInstance();
        Screen screen = minecraftClient.getCurrentScreenMapped();
        if (screen == null || screen.data instanceof ScreenExtension && !isInstance.test((ScreenExtension)screen.data)) {
            minecraftClient.openScreen(new Screen((class_437)screenExtension));
        }
    }

    public static void getBlockEntity(BlockPos blockPos, Consumer<BlockEntity> consumer) {
        BlockEntity blockEntity;
        ClientWorld clientWorld = MinecraftClient.getInstance().getWorldMapped();
        if (clientWorld != null && (blockEntity = clientWorld.getBlockEntity(blockPos)) != null) {
            consumer.accept(blockEntity);
        }
    }
}

