/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.render;

import fabric.ziyue.tjmetro.mod.block.BlockStationNameEntranceTianjin;
import fabric.ziyue.tjmetro.mod.client.DynamicTextureCache;
import fabric.ziyue.tjmetro.mod.data.IGuiExtension;
import javax.annotation.Nullable;
import org.mtr.core.data.Station;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderStationNameEntranceTianjin<T extends BlockStationNameEntranceTianjin.BlockEntity>
extends BlockEntityRenderer<T>
implements IGui,
IDrawing {
    public RenderStationNameEntranceTianjin(BlockEntityRenderer.Argument argument) {
        super(argument);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        DynamicTextureCache.DynamicResource resource;
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.getPos2();
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock().data instanceof BlockStationNameEntranceTianjin)) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)BlockStationNameBase.FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)pos.getX(), 0.5 + (double)((BlockStationNameEntranceTianjin.BlockEntity)((Object)entity)).yOffset + (double)pos.getY(), 0.5 + (double)pos.getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
            graphicsHolderNew.translate(0.0, 0.0, 0.5 - (double)entity.zOffset - (double)0.003125f);
        });
        Station station = InitClient.findStation((BlockPos)pos);
        int lengthLeft = this.getLength(world, pos, false);
        int lengthRight = this.getLength(world, pos, true);
        int totalLength = lengthLeft + lengthRight - 1;
        int propagateProperty = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (IntegerProperty)BlockStationNameEntranceTianjin.STYLE);
        float logoSize = propagateProperty % 2 == 0 ? 0.5f : 1.0f;
        BlockStationNameEntranceTianjin block = (BlockStationNameEntranceTianjin)((Object)state.getBlock().data);
        if (station == null) {
            resource = DynamicTextureCache.instance.getStationNameEntrance(-1L, -1L, switch (propagateProperty) {
                case 0, 1, 4, 5 -> propagateProperty + 2;
                default -> propagateProperty;
            }, IGuiExtension.insertTranslation("gui.mtr.station_cjk", "gui.mtr.station", 1, TextHelper.translatable((String)"gui.mtr.untitled", (Object[])new Object[0]).getString()), block.type, (float)totalLength / logoSize);
        } else {
            resource = DynamicTextureCache.instance.getStationNameEntrance(station.getId(), ((BlockStationNameEntranceTianjin.BlockEntity)((Object)entity)).getSelectedId(), propagateProperty, IGuiExtension.insertTranslation("gui.mtr.station_cjk", block.pinyin ? "gui.tjmetro.station_pinyin" : "gui.mtr.station", 1, station.getName()), block.type, (float)totalLength / logoSize);
        }
        MainRenderer.scheduleRender((Identifier)resource.identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)-0.5f, (float)(-logoSize / 2.0f), (float)1.0f, (float)logoSize, (float)((float)(lengthLeft - 1) / (float)totalLength), (float)0.0f, (float)((float)lengthLeft / (float)totalLength), (float)1.0f, (Direction)facing, (int)-1, (int)light);
            graphicsHolderNew.pop();
        });
    }

    protected int getLength(@Nullable World world, BlockPos pos, boolean lookRight) {
        if (world == null) {
            return 1;
        }
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)pos, (DirectionProperty)BlockStationNameEntranceTianjin.FACING);
        Block thisBlock = world.getBlockState(pos).getBlock();
        int length = 1;
        while (true) {
            Block checkBlock = world.getBlockState(pos.offset(lookRight ? facing.rotateYClockwise() : facing.rotateYCounterclockwise(), length)).getBlock();
            if (!(checkBlock.data instanceof BlockStationNameEntranceTianjin) || checkBlock.data != thisBlock.data) break;
            ++length;
        }
        return length;
    }
}

