/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.render;

import fabric.ziyue.tjmetro.mod.block.BlockStationNameProjector;
import fabric.ziyue.tjmetro.mod.client.DynamicTextureCache;
import org.mtr.core.data.Station;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.generated.lang.TranslationProvider;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderStationNameProjector<T extends BlockStationNameProjector.BlockEntity>
extends BlockEntityRenderer<T>
implements IGui,
IDrawing {
    public RenderStationNameProjector(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.getPos2();
        BlockState state = world.getBlockState(pos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)BlockStationNameBase.FACING);
        int scale = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)BlockStationNameProjector.SCALE);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)pos.getX(), 0.5 + (double)pos.getY(), 0.5 + (double)pos.getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
            graphicsHolderNew.translate(0.0, 0.0, 0.49687499995343387);
            graphicsHolderNew.scale((float)scale, (float)scale, (float)scale);
        });
        Station station = InitClient.findStation((BlockPos)pos);
        MainRenderer.scheduleRender((Identifier)DynamicTextureCache.instance.getStationNameProjector((String)(station == null ? TranslationProvider.GUI_MTR_UNTITLED.getString((Object[])new Object[0]) : station.getName()), (float)10.0f).identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
            storedMatrixTransformations.transform(graphicsHolderNew, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)-5.0f, (float)-0.5f, (float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)(entity.color == -1 ? entity.getDefaultColor(pos) : 0xFF000000 | entity.color), (int)light);
            graphicsHolderNew.pop();
        });
    }
}

