/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.client;

import forge.ziyue.tjmetro.mod.config.ConfigClient;
import javax.annotation.Nullable;
import org.mtr.libraries.it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.LightmapTextureManager;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.OrderedText;
import org.mtr.mapping.holder.Style;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;

public interface IDrawingExtension {
    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, float x, float y, int light) {
        IDrawingExtension.drawStringWithFont(graphicsHolder, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, x, y, -1.0f, -1.0f, 1.0f, -1, true, light, null);
    }

    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, @Nullable IDrawing.DrawingCallback drawingCallback) {
        IDrawingExtension.drawStringWithFont(graphicsHolder, text, horizontalAlignment, verticalAlignment, horizontalAlignment, x, y, maxWidth, maxHeight, scale, textColor, shadow, light, drawingCallback);
    }

    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColor, boolean shadow, int light, @Nullable IDrawing.DrawingCallback drawingCallback) {
        IDrawingExtension.drawStringWithFont(graphicsHolder, text, horizontalAlignment, verticalAlignment, xAlignment, x, y, maxWidth, maxHeight, scale, textColor, textColor, 2.0f, shadow, light, false, drawingCallback);
    }

    public static void drawStringWithFont(GraphicsHolder graphicsHolder, String text, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, IGui.HorizontalAlignment xAlignment, float x, float y, float maxWidth, float maxHeight, float scale, int textColorCjk, int textColor, float fontSizeRatio, boolean shadow, int light, boolean forceMinecraftFont, @Nullable IDrawing.DrawingCallback drawingCallback) {
        float scaleX;
        float totalWidthScaled;
        boolean isCJK;
        int height;
        Style style;
        if (!forceMinecraftFont && ConfigClient.USE_TIANJIN_METRO_FONT.get().booleanValue()) {
            style = Style.getEmptyMapped().withFont(new Identifier("tjmetro", "tjmetro"));
            y += 0.05f;
            height = 8;
        } else {
            style = Style.getEmptyMapped();
            height = 10;
        }
        while (text.contains("||")) {
            text = text.replace("||", "|");
        }
        String[] stringSplit = text.split("\\|");
        BooleanArrayList isCJKList = new BooleanArrayList();
        ObjectArrayList orderedTexts = new ObjectArrayList();
        int totalHeight = 0;
        int totalWidth = 0;
        for (String stringSplitPart : stringSplit) {
            isCJK = IGui.isCjk((String)stringSplitPart);
            isCJKList.add(isCJK);
            OrderedText orderedText = TextHelper.mutableTextToOrderedText((MutableText)TextHelper.setStyle((MutableText)TextHelper.literal((String)stringSplitPart), (Style)style));
            orderedTexts.add((Object)orderedText);
            totalHeight += Math.round((float)height * (isCJK ? fontSizeRatio : 1.0f));
            int width = (int)Math.ceil((float)GraphicsHolder.getTextWidth((OrderedText)orderedText) * (isCJK ? fontSizeRatio : 1.0f));
            if (width <= totalWidth) continue;
            totalWidth = width;
        }
        if (maxHeight >= 0.0f && (float)totalHeight / scale > maxHeight) {
            scale = (float)totalHeight / maxHeight;
        }
        graphicsHolder.push();
        if (maxWidth >= 0.0f && (float)totalWidth > maxWidth * scale) {
            totalWidthScaled = maxWidth * scale;
            scaleX = (float)totalWidth / maxWidth;
        } else {
            totalWidthScaled = totalWidth;
            scaleX = scale;
        }
        graphicsHolder.scale(1.0f / scaleX, 1.0f / scale, 1.0f / scale);
        float offset = verticalAlignment.getOffset(y * scale, (float)totalHeight);
        for (int i = 0; i < orderedTexts.size(); ++i) {
            float extraScale;
            isCJK = isCJKList.getBoolean(i);
            float f = extraScale = isCJK ? fontSizeRatio : 1.0f;
            if (isCJK) {
                graphicsHolder.push();
                graphicsHolder.scale(extraScale, extraScale, 1.0f);
            }
            float xOffset = horizontalAlignment.getOffset(xAlignment.getOffset(x * scaleX, (float)totalWidth), (float)GraphicsHolder.getTextWidth((OrderedText)((OrderedText)orderedTexts.get(i))) * extraScale - (float)totalWidth);
            float shade = light == GraphicsHolder.getDefaultLight() ? 1.0f : Math.min((float)LightmapTextureManager.getBlockLightCoordinates((int)light) / 16.0f * 0.1f + 0.7f, 1.0f);
            int a = (isCJK ? textColorCjk : textColor) >> 24 & 0xFF;
            int r = (int)((float)((isCJK ? textColorCjk : textColor) >> 16 & 0xFF) * shade);
            int g = (int)((float)((isCJK ? textColorCjk : textColor) >> 8 & 0xFF) * shade);
            int b = (int)((float)((isCJK ? textColorCjk : textColor) & 0xFF) * shade);
            graphicsHolder.drawText((OrderedText)orderedTexts.get(i), Math.round(xOffset / extraScale), Math.round(offset / extraScale), (a << 24) + (r << 16) + (g << 8) + b, shadow, light);
            if (isCJK) {
                graphicsHolder.pop();
            }
            offset += (float)height * extraScale;
        }
        graphicsHolder.pop();
        if (drawingCallback != null) {
            float x1 = xAlignment.getOffset(x, totalWidthScaled / scale);
            float y1 = verticalAlignment.getOffset(y, (float)totalHeight / scale);
            drawingCallback.drawingCallback(x1, y1, x1 + totalWidthScaled / scale, y1 + (float)totalHeight / scale);
        }
    }
}

