/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.packet;

import forge.ziyue.tjmetro.mod.block.BlockStationNameEntranceTianjin;
import forge.ziyue.tjmetro.mod.block.BlockStationNamePlate;
import forge.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public final class PacketUpdateRailwaySignConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final LongAVLTreeSet selectedIds;
    private final String[] signIds;

    public PacketUpdateRailwaySignConfig(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        int selectedIdsLength = packetBufferReceiver.readInt();
        this.selectedIds = new LongAVLTreeSet();
        for (int i = 0; i < selectedIdsLength; ++i) {
            this.selectedIds.add(packetBufferReceiver.readLong());
        }
        int signLength = packetBufferReceiver.readInt();
        this.signIds = new String[signLength];
        for (int i = 0; i < signLength; ++i) {
            String signId = packetBufferReceiver.readString();
            this.signIds[i] = signId.isEmpty() ? null : signId;
        }
    }

    public PacketUpdateRailwaySignConfig(BlockPos blockPos, LongAVLTreeSet selectedIds, String[] signIds) {
        this.blockPos = blockPos;
        this.selectedIds = selectedIds;
        this.signIds = signIds;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.selectedIds.size());
        this.selectedIds.forEach(arg_0 -> ((PacketBufferSender)packetBufferSender).writeLong(arg_0));
        packetBufferSender.writeInt(this.signIds.length);
        for (String signType : this.signIds) {
            packetBufferSender.writeString(signType == null ? "" : signType);
        }
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null) {
            if (entity.data instanceof BlockRailwaySignBase.BlockEntityBase) {
                BlockRailwaySignBase.BlockEntityBase entity1 = (BlockRailwaySignBase.BlockEntityBase)((Object)entity.data);
                entity1.setData(this.selectedIds, this.signIds);
            } else if (entity.data instanceof BlockStationNameEntranceTianjin.BlockEntity) {
                BlockStationNameEntranceTianjin.BlockEntity entity1 = (BlockStationNameEntranceTianjin.BlockEntity)((Object)entity.data);
                long platformId = this.selectedIds.isEmpty() ? -1L : (Long)this.selectedIds.toArray()[0];
                entity1.setData(platformId);
            } else if (entity.data instanceof BlockStationNamePlate.BlockEntity) {
                BlockStationNamePlate.BlockEntity entity1 = (BlockStationNamePlate.BlockEntity)((Object)entity.data);
                long platformId = this.selectedIds.isEmpty() ? 0L : (Long)this.selectedIds.toArray()[0];
                entity1.setPlatformId(platformId);
            }
        }
    }
}

