/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.render;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EntityAbstractMapping;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityModelExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderPSDDoorTianjinBMT<T extends BlockPSDAPGDoorBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
IBlock {
    protected static final ModelSingleCube MODEL_PSD = new ModelSingleCube(36, 18, 0.0f, 0.0f, 0.0f, 16, 16, 2);
    protected static final ModelSingleCube MODEL_PSD_END_LEFT_1 = new ModelSingleCube(20, 18, 0.0f, 0.0f, 0.0f, 8, 16, 2);
    protected static final ModelSingleCube MODEL_PSD_END_RIGHT_1 = new ModelSingleCube(20, 18, 8.0f, 0.0f, 0.0f, 8, 16, 2);
    protected static final ModelSingleCube MODEL_PSD_END_LEFT_2 = new ModelSingleCube(20, 18, 8.0f, 0.0f, 2.0f, 8, 16, 2);
    protected static final ModelSingleCube MODEL_PSD_END_RIGHT_2 = new ModelSingleCube(20, 18, 0.0f, 0.0f, 2.0f, 8, 16, 2);
    protected static final ModelSingleCube MODEL_PSD_LIGHT_LEFT = new ModelSingleCube(16, 16, 0.0f, -3.7f, 5.3f, 1, 1, 1);
    protected static final ModelSingleCube MODEL_PSD_LIGHT_RIGHT = new ModelSingleCube(16, 16, 15.0f, -3.7f, 5.3f, 1, 1, 1);
    protected static final ModelSingleCube MODEL_PSD_DOOR_LOCKED = new ModelSingleCube(6, 6, 5.0f, 6.0f, 1.0f, 6, 6, 0);

    public RenderPSDDoorTianjinBMT(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        entity.tick(tickDelta);
        BlockPos blockPos = entity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)BlockPSDAPGDoorBase.FACING);
        boolean side = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockPSDAPGDoorBase.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockPSDAPGDoorBase.HALF) == IBlock.DoubleBlockHalf.UPPER;
        boolean end = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (BooleanProperty)BlockPSDAPGDoorBase.END);
        boolean unlocked = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (BooleanProperty)BlockPSDAPGDoorBase.UNLOCKED);
        double open = Math.min(entity.getDoorValue(), 1.0);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateXDegrees(180.0f);
        });
        StoredMatrixTransformations storedMatrixTransformationsLight = storedMatrixTransformations.copy();
        if (half) {
            MainRenderer.scheduleRender((Identifier)new Identifier(String.format("mtr:textures/block/light_%s.png", open > 0.0 ? "on" : "off")), (boolean)false, (QueuedRenderLayer)(open > 0.0 ? QueuedRenderLayer.LIGHT : QueuedRenderLayer.EXTERIOR), (graphicsHolderNew, offset) -> {
                storedMatrixTransformationsLight.transform(graphicsHolderNew, offset);
                (side ? MODEL_PSD_LIGHT_RIGHT : MODEL_PSD_LIGHT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        }
        if (end) {
            MainRenderer.scheduleRender((Identifier)new Identifier(String.format("mtr:textures/block/psd_door_end_%s_%s_2_%s.png", half ? "top" : "bottom", side ? "right" : "left", "1")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformationsLight.transform(graphicsHolderNew, offset);
                graphicsHolderNew.translate(open / 2.0 * (double)(side ? -1 : 1), 0.0, 0.0);
                (side ? MODEL_PSD_END_RIGHT_2 : MODEL_PSD_END_LEFT_2).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        }
        storedMatrixTransformations.add(matricesNew -> matricesNew.translate(open * (double)(side ? -1 : 1), 0.0, 0.0));
        if (end) {
            MainRenderer.scheduleRender((Identifier)new Identifier(String.format("mtr:textures/block/psd_door_end_%s_%s_1_%s.png", half ? "top" : "bottom", side ? "right" : "left", "1")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                (side ? MODEL_PSD_END_RIGHT_1 : MODEL_PSD_END_LEFT_1).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        } else {
            MainRenderer.scheduleRender((Identifier)new Identifier(String.format("mtr:textures/block/psd_door_%s_%s_%s.png", half ? "top" : "bottom", side ? "right" : "left", "1")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                MODEL_PSD.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        }
        if (half && !unlocked) {
            MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                storedMatrixTransformations.transform(graphicsHolderNew, offset);
                if (end) {
                    graphicsHolderNew.translate(side ? 0.25 : -0.25, 0.0, 0.0);
                }
                MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                graphicsHolderNew.pop();
            });
        }
    }

    public boolean rendersOutsideBoundingBox2(T blockEntity) {
        return true;
    }

    protected static class ModelSingleCube
    extends EntityModelExtension<EntityAbstractMapping> {
        protected final ModelPartExtension cube = this.createModelPart();

        protected ModelSingleCube(int textureWidth, int textureHeight, float x, float y, float z, int length, int height, int depth) {
            super(textureWidth, textureHeight);
            this.cube.setTextureUVOffset(0, 0).addCuboid(x - 8.0f, y - 16.0f, z - 8.0f, length, height, depth, 0.0f, false);
            this.buildModel();
        }

        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.cube.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

