/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.render;

import forge.ziyue.tjmetro.mod.block.BlockPSDTopTianjinBMT;
import forge.ziyue.tjmetro.mod.client.DynamicTextureCache;
import forge.ziyue.tjmetro.mod.render.RenderRouteBase;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.BlockPSDAPGGlassEndBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderPSDTopTianjinBMT
extends RenderRouteBase<BlockPSDTopTianjinBMT.BlockEntity> {
    protected static final float END_FRONT_OFFSET = 1.0f / (MathHelper.getSquareRootOfTwoMapped() * 16.0f);
    protected static final float BOTTOM_DIAGONAL_OFFSET = ((float)Math.sqrt(3.0) - 1.0f) / 32.0f;
    protected static final float ROOT_TWO_SCALED = MathHelper.getSquareRootOfTwoMapped() / 16.0f;
    protected static final float BOTTOM_END_DIAGONAL_OFFSET = END_FRONT_OFFSET - BOTTOM_DIAGONAL_OFFSET / MathHelper.getSquareRootOfTwoMapped();
    protected static final float COLOR_STRIP_START = 0.90625f;
    protected static final float COLOR_STRIP_END = 0.9375f;

    public RenderPSDTopTianjinBMT(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher, 1.95f, 4.5f, 1.5f, 0.125f, true, 3, BlockPSDTopTianjinBMT.ARROW_DIRECTION);
    }

    @Override
    public void render(BlockPSDTopTianjinBMT.BlockEntity entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos blockPos = entity.getPos2();
        BlockState state = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)DirectionHelper.FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> graphicsHolderNew.rotateYDegrees(-facing.asRotation()));
        this.renderAdditionalUnmodified(storedMatrixTransformations.copy(), state, facing, light);
        InitClient.findClosePlatform((BlockPos)blockPos.down(this.platformSearchYOffset), (int)5, platform -> {
            long platformId = platform.getId();
            storedMatrixTransformations.add(graphicsHolderNew -> {
                graphicsHolderNew.translate(0.0, 1.0, 0.0);
                graphicsHolderNew.rotateZDegrees(180.0f);
                graphicsHolderNew.translate(-0.5, (double)(-this.getAdditionalOffset(state)), (double)this.z);
            });
            int leftBlocks = this.getTextureNumber(world, blockPos, facing, true);
            int rightBlocks = this.getTextureNumber(world, blockPos, facing, false);
            int color = org.mtr.mod.render.RenderRouteBase.getShadingColor((Direction)facing, (int)-1);
            RenderRouteBase.RenderType renderType = this.getRenderType(world, blockPos.offset(facing.rotateYCounterclockwise(), leftBlocks), state);
            if ((renderType == RenderRouteBase.RenderType.ARROW || renderType == RenderRouteBase.RenderType.ROUTE) && IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE_EXTENDED) != IBlock.EnumSide.SINGLE) {
                float width = (float)(leftBlocks + rightBlocks + 1) - this.sidePadding * 2.0f;
                float height = 1.0f - this.topPadding - this.bottomPadding;
                int arrowDirection = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)this.arrowDirectionProperty);
                Identifier identifier = renderType == RenderRouteBase.RenderType.ARROW ? DynamicTextureCache.instance.getStationNameBMT((long)platformId, (boolean)(arrowDirection == 1 ? true : false), (IGui.HorizontalAlignment)IGui.HorizontalAlignment.CENTER, (float)0.25f, (float)(width / height), (int)-1, (int)-16777216, (int)(this.transparentWhite ? -1 : 0)).identifier : DynamicTextureCache.instance.getRouteMapBMT((long)platformId, (boolean)(arrowDirection == 1 ? true : false), (float)(width / height), (boolean)this.transparentWhite).identifier;
                MainRenderer.scheduleRender((Identifier)identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)(leftBlocks == 0 ? this.sidePadding : 0.0f), (float)this.topPadding, (float)0.0f, (float)(1.0f - (rightBlocks == 0 ? this.sidePadding : 0.0f)), (float)(1.0f - this.bottomPadding), (float)0.0f, (float)(((float)leftBlocks - (leftBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)0.0f, (float)((width - (float)rightBlocks + (rightBlocks == 0 ? 0.0f : this.sidePadding)) / width), (float)1.0f, (Direction)facing.getOpposite(), (int)color, (int)light);
                    graphicsHolderNew.pop();
                });
            }
            this.renderAdditional(storedMatrixTransformations, platformId, state, leftBlocks, rightBlocks, facing.getOpposite(), color, light);
        });
    }

    @Override
    protected RenderRouteBase.RenderType getRenderType(World world, BlockPos pos, BlockState state) {
        Block blockBelow = world.getBlockState(pos.down()).getBlock();
        if (blockBelow.data instanceof BlockPSDAPGDoorBase) {
            return RenderRouteBase.RenderType.ARROW;
        }
        if (!(blockBelow.data instanceof BlockPSDAPGGlassEndBase)) {
            return RenderRouteBase.RenderType.ROUTE;
        }
        return RenderRouteBase.RenderType.NONE;
    }

    @Override
    protected void renderAdditionalUnmodified(StoredMatrixTransformations storedMatrixTransformations, BlockState state, Direction facing, int light) {
        boolean airLeft = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)BlockPSDTopTianjinBMT.AIR_LEFT);
        boolean airRight = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)BlockPSDTopTianjinBMT.AIR_RIGHT);
        if (!airLeft && !airRight) {
            return;
        }
        MainRenderer.scheduleRender((Identifier)new Identifier("tjmetro", "textures/block/psd_tianjin_bmt_top.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform(graphicsHolder, offset);
            if (airLeft) {
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)-0.125f, (float)0.0f, (float)0.5f, (float)0.5f, (float)0.0f, (float)-0.125f, (float)0.5f, (float)1.0f, (float)-0.125f, (float)-0.125f, (float)1.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(0.5f - END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)(-0.25f - END_FRONT_OFFSET), (float)0.0625f, (float)(0.25f - END_FRONT_OFFSET), (float)(-0.25f - END_FRONT_OFFSET), (float)1.0f, (float)(0.25f - END_FRONT_OFFSET), (float)(0.5f - END_FRONT_OFFSET), (float)1.0f, (float)(-0.5f - END_FRONT_OFFSET), (float)0.0f, (float)0.0f, (float)1.0f, (float)0.9375f, (Direction)facing.getOpposite(), (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(-0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)(-0.25f - BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(0.25f - BOTTOM_END_DIAGONAL_OFFSET), (float)(-0.25f - END_FRONT_OFFSET), (float)0.0625f, (float)(0.25f - END_FRONT_OFFSET), (float)(0.5f - END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)0.0f, (float)0.9375f, (float)1.0f, (float)0.96875f, (Direction)facing.getOpposite(), (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.5f, (float)0.0f, (float)-0.5f, (float)-0.25f, (float)0.0f, (float)0.25f, (float)(-0.25f - BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(0.25f - BOTTOM_END_DIAGONAL_OFFSET), (float)(0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(-0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)0.0f, (float)0.96875f, (float)1.0f, (float)1.0f, (Direction)facing.getOpposite(), (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.5f, (float)0.003125f, (float)-0.125f, (float)-0.125f, (float)0.003125f, (float)0.5f, (float)-0.125f, (float)0.003125f, (float)0.125f, (float)0.5f, (float)0.003125f, (float)-0.5f, (float)0.125f, (float)0.125f, (float)0.1875f, (float)0.1875f, (Direction)facing, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.5f, (float)0.996875f, (float)-0.5f, (float)-0.125f, (float)0.996875f, (float)0.125f, (float)-0.125f, (float)0.996875f, (float)0.5f, (float)0.5f, (float)0.996875f, (float)-0.125f, (float)0.125f, (float)0.125f, (float)0.1875f, (float)0.1875f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(0.5f - END_FRONT_OFFSET), (float)0.996875f, (float)(-0.5f - END_FRONT_OFFSET), (float)(-0.125f - ROOT_TWO_SCALED), (float)0.996875f, (float)0.125f, (float)-0.125f, (float)0.996875f, (float)0.125f, (float)0.5f, (float)0.996875f, (float)-0.5f, (float)0.125f, (float)0.125f, (float)0.1875f, (float)0.1875f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.5f, (float)0.0625f, (float)-0.5f, (float)(0.5f - END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)(0.5f - END_FRONT_OFFSET), (float)1.0f, (float)(-0.5f - END_FRONT_OFFSET), (float)0.5f, (float)1.0f, (float)-0.5f, (float)0.9375f, (float)0.0f, (float)1.0f, (float)0.9375f, (Direction)facing, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.5f, (float)0.0f, (float)-0.5f, (float)(0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(-0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)(0.5f - END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)0.5f, (float)0.0625f, (float)-0.5f, (float)0.9375f, (float)0.9375f, (float)1.0f, (float)1.0f, (Direction)facing, (int)-1, (int)light);
            }
            if (airRight) {
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)-0.5f, (float)0.0f, (float)-0.125f, (float)0.125f, (float)0.0f, (float)0.5f, (float)0.125f, (float)1.0f, (float)0.5f, (float)-0.5f, (float)1.0f, (float)-0.125f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)facing, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(0.25f + END_FRONT_OFFSET), (float)0.0625f, (float)(0.25f - END_FRONT_OFFSET), (float)(-0.5f + END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)(-0.5f + END_FRONT_OFFSET), (float)1.0f, (float)(-0.5f - END_FRONT_OFFSET), (float)(0.25f + END_FRONT_OFFSET), (float)1.0f, (float)(0.25f - END_FRONT_OFFSET), (float)0.0f, (float)0.0f, (float)1.0f, (float)0.9375f, (Direction)facing.getOpposite(), (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(0.25f + BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(0.25f - BOTTOM_END_DIAGONAL_OFFSET), (float)(-0.5f + BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(-0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)(-0.5f + END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)(0.25f + END_FRONT_OFFSET), (float)0.0625f, (float)(0.25f - END_FRONT_OFFSET), (float)0.0f, (float)0.9375f, (float)1.0f, (float)0.96875f, (Direction)facing.getOpposite(), (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.25f, (float)0.0f, (float)0.25f, (float)-0.5f, (float)0.0f, (float)-0.5f, (float)(-0.5f + BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(-0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)(0.25f + BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(0.25f - BOTTOM_END_DIAGONAL_OFFSET), (float)0.0f, (float)0.96875f, (float)1.0f, (float)1.0f, (Direction)facing.getOpposite(), (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.125f, (float)0.003125f, (float)0.5f, (float)-0.5f, (float)0.003125f, (float)-0.125f, (float)-0.5f, (float)0.003125f, (float)-0.5f, (float)0.125f, (float)0.003125f, (float)0.125f, (float)0.125f, (float)0.125f, (float)0.1875f, (float)0.1875f, (Direction)facing, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.125f, (float)0.996875f, (float)0.125f, (float)-0.5f, (float)0.996875f, (float)-0.5f, (float)-0.5f, (float)0.996875f, (float)-0.125f, (float)0.125f, (float)0.996875f, (float)0.5f, (float)0.125f, (float)0.125f, (float)0.1875f, (float)0.1875f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(0.125f + ROOT_TWO_SCALED), (float)0.996875f, (float)0.125f, (float)(-0.5f + END_FRONT_OFFSET), (float)0.996875f, (float)(-0.5f - END_FRONT_OFFSET), (float)-0.5f, (float)0.996875f, (float)-0.5f, (float)0.125f, (float)0.996875f, (float)0.125f, (float)0.125f, (float)0.125f, (float)0.1875f, (float)0.1875f, (Direction)Direction.UP, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-0.5f + END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)-0.5f, (float)0.0625f, (float)-0.5f, (float)-0.5f, (float)1.0f, (float)-0.5f, (float)(-0.5f + END_FRONT_OFFSET), (float)1.0f, (float)(-0.5f - END_FRONT_OFFSET), (float)0.0f, (float)0.0f, (float)0.0625f, (float)0.9375f, (Direction)facing, (int)-1, (int)light);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-0.5f + BOTTOM_END_DIAGONAL_OFFSET), (float)BOTTOM_DIAGONAL_OFFSET, (float)(-0.5f - BOTTOM_END_DIAGONAL_OFFSET), (float)-0.5f, (float)0.0f, (float)-0.5f, (float)-0.5f, (float)0.0625f, (float)-0.5f, (float)(-0.5f + END_FRONT_OFFSET), (float)0.0625f, (float)(-0.5f - END_FRONT_OFFSET), (float)0.0f, (float)0.9375f, (float)0.0625f, (float)1.0f, (Direction)facing, (int)-1, (int)light);
            }
            graphicsHolder.pop();
        });
    }

    @Override
    protected void renderAdditional(StoredMatrixTransformations storedMatrixTransformations, long platformId, BlockState state, int leftBlocks, int rightBlocks, Direction facing, int color, int light) {
        boolean airLeft = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)BlockPSDTopTianjinBMT.AIR_LEFT);
        boolean airRight = IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)BlockPSDTopTianjinBMT.AIR_RIGHT);
        MainRenderer.scheduleRender((Identifier)org.mtr.mod.client.DynamicTextureCache.instance.getColorStrip((long)platformId).identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolder, offset) -> {
            storedMatrixTransformations.transform(graphicsHolder, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(airLeft ? 0.625f : 0.0f), (float)0.90625f, (float)0.0f, (float)(airRight ? 0.375f : 1.0f), (float)0.9375f, (float)0.0f, (Direction)facing, (int)color, (int)light);
            if (airLeft) {
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)END_FRONT_OFFSET, (float)0.90625f, (float)(-0.625f - END_FRONT_OFFSET), (float)(0.75f + END_FRONT_OFFSET), (float)0.9375f, (float)(0.125f - END_FRONT_OFFSET), (Direction)facing, (int)-1, (int)light);
            }
            if (airRight) {
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(0.25f - END_FRONT_OFFSET), (float)0.90625f, (float)(0.125f - END_FRONT_OFFSET), (float)(1.0f - END_FRONT_OFFSET), (float)0.9375f, (float)(-0.625f - END_FRONT_OFFSET), (Direction)facing, (int)-1, (int)light);
            }
            graphicsHolder.pop();
        });
    }
}

