/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.render;

import forge.ziyue.tjmetro.mod.block.BlockTimeDisplay;
import forge.ziyue.tjmetro.mod.block.BlockTimeDisplayEven;
import forge.ziyue.tjmetro.mod.client.IDrawingExtension;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderTimeDisplay<T extends BlockTimeDisplay.BlockEntity>
extends BlockEntityRenderer<T>
implements IGui,
IDrawing {
    public RenderTimeDisplay(BlockEntityRenderer.Argument argument) {
        super(argument);
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.getPos2();
        BlockState state = world.getBlockState(pos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)DirectionHelper.FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)pos.getX(), 0.5 + (double)((BlockTimeDisplay.BlockEntity)((Object)entity)).yOffset + (double)pos.getY(), 0.5 + (double)pos.getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateZDegrees(180.0f);
        });
        if (entity instanceof BlockTimeDisplayEven.BlockEntity) {
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
            storedMatrixTransformations2.add(graphicsHolderNew -> graphicsHolderNew.translate(0.516, -0.04, 0.5 - (double)entity.zOffset - (double)0.003125f));
            MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.TEXT, (newGraphicsHolder, offset) -> {
                storedMatrixTransformations2.transform(newGraphicsHolder, offset);
                IDrawingExtension.drawStringWithFont(newGraphicsHolder, RenderTimeDisplay.getFormattedTime(entity.getWorld2().getLunarTime()), IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, 0.0f, 0.03f, -1.0f, -1.0f, 30.0f, -3276781, -3276781, 2.0f, false, light, true, null);
                newGraphicsHolder.pop();
            });
        } else {
            for (int i = 0; i < 2; ++i) {
                StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
                boolean shouldFlip = i == 1;
                storedMatrixTransformations2.add(graphicsHolderNew -> {
                    if (shouldFlip) {
                        graphicsHolderNew.rotateYDegrees(180.0f);
                    }
                    graphicsHolderNew.translate(0.0, -0.04, 0.5 - (double)entity.zOffset - (double)0.003125f);
                });
                MainRenderer.scheduleRender((QueuedRenderLayer)QueuedRenderLayer.TEXT, (newGraphicsHolder, offset) -> {
                    storedMatrixTransformations2.transform(newGraphicsHolder, offset);
                    IDrawingExtension.drawStringWithFont(newGraphicsHolder, RenderTimeDisplay.getFormattedTime(entity.getWorld2().getLunarTime()), IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, 0.0f, 0.03f, -1.0f, -1.0f, 30.0f, -3276781, -3276781, 2.0f, false, light, true, null);
                    newGraphicsHolder.pop();
                });
            }
        }
    }

    public static String getFormattedTime(long ticks) {
        int hours = (int)((Math.floor((double)ticks / 1000.0) + 6.0) % 24.0);
        int minutes = (int)Math.floor((double)(ticks % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }
}

