/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.screen;

import forge.ziyue.tjmetro.mod.RegistryClient;
import forge.ziyue.tjmetro.mod.block.base.BlockCustomColorBase;
import forge.ziyue.tjmetro.mod.packet.PacketUpdateCustomColor;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.client.gui.components.AbstractWidget;
import org.apache.commons.lang3.StringUtils;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.CheckboxWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.TextCase;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;

public class ColorPickerScreen
extends ScreenExtension
implements IGui {
    protected float hue;
    protected float saturation;
    protected float brightness;
    protected DraggingState draggingState = DraggingState.NONE;
    protected final BlockPos pos;
    protected final int oldColor;
    protected final BlockCustomColorBase.BlockEntityBase entity;
    protected final TextFieldWidgetExtension textFieldColor;
    protected final TextFieldWidgetExtension textFieldRed;
    protected final TextFieldWidgetExtension textFieldGreen;
    protected final TextFieldWidgetExtension textFieldBlue;
    protected final CheckboxWidgetExtension checkboxDefaultColor;
    protected final ButtonWidgetExtension buttonReset;
    protected static final int RIGHT_WIDTH = 60;

    public ColorPickerScreen(BlockPos pos, BlockCustomColorBase.BlockEntityBase entity) {
        this.pos = pos;
        this.oldColor = entity.color;
        this.entity = entity;
        this.textFieldColor = new TextFieldWidgetExtension(0, 0, 0, 20, 6, TextCase.UPPER, "[^\\dA-F]", TextHelper.literal((String)Integer.toHexString(this.oldColor).toUpperCase(Locale.ENGLISH)).getString());
        this.textFieldRed = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", TextHelper.literal((String)String.valueOf(this.oldColor >> 16 & 0xFF)).getString());
        this.textFieldGreen = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", TextHelper.literal((String)String.valueOf(this.oldColor >> 8 & 0xFF)).getString());
        this.textFieldBlue = new TextFieldWidgetExtension(0, 0, 0, 20, 3, TextCase.DEFAULT, "\\D", TextHelper.literal((String)String.valueOf(this.oldColor & 0xFF)).getString());
        this.checkboxDefaultColor = new CheckboxWidgetExtension(0, 0, 0, 20, TextHelper.translatable((String)"gui.tjmetro.default_color", (Object[])new Object[0]), true, checked -> {
            if (checked.booleanValue()) {
                this.setHsb(entity.getDefaultColor(pos), true);
            }
        });
        this.checkboxDefaultColor.setChecked(this.oldColor == -1);
        this.buttonReset = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable((String)"gui.mtr.reset_sign", (Object[])new Object[0]), button -> {
            this.setHsb(this.oldColor, true);
            this.checkboxDefaultColor.setChecked(false);
            button.setActiveMapped(false);
        });
    }

    protected void init2() {
        super.init2();
        int startX = 80 + this.getMainWidth();
        int startY = 36;
        IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldColor, (int)(startX + 2), (int)61, (int)56);
        IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldRed, (int)(startX + 2), (int)105, (int)56);
        IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldGreen, (int)(startX + 2), (int)129, (int)56);
        IDrawing.setPositionAndWidth((TextFieldWidgetExtension)this.textFieldBlue, (int)(startX + 2), (int)153, (int)56);
        IDrawing.setPositionAndWidth((CheckboxWidgetExtension)this.checkboxDefaultColor, (int)(80 + this.getMainWidth() + 3), (int)20, (int)56);
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonReset, (int)startX, (int)this.getMainHeight(), (int)60);
        this.setHsb(this.oldColor == -1 ? this.entity.getDefaultColor(this.pos) : this.oldColor, true);
        this.textFieldColor.setChangedListener2(text -> this.textCallback((String)text, -1));
        this.textFieldRed.setChangedListener2(text -> this.textCallback((String)text, 16));
        this.textFieldGreen.setChangedListener2(text -> this.textCallback((String)text, 8));
        this.textFieldBlue.setChangedListener2(text -> this.textCallback((String)text, 0));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldColor));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldRed));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldGreen));
        this.addChild(new ClickableWidget((AbstractWidget)this.textFieldBlue));
        this.addChild(new ClickableWidget((AbstractWidget)this.checkboxDefaultColor));
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonReset));
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        int mainWidth = this.getMainWidth();
        int mainHeight = this.getMainHeight();
        graphicsHolder.drawCenteredText(TextHelper.translatable((String)"gui.mtr.color", (Object[])new Object[0]), 80 + mainWidth + 30, 45, -1);
        graphicsHolder.drawCenteredText("RGB", 80 + mainWidth + 30, 89, -1);
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        guiDrawing.beginDrawingRectangle();
        int selectedColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
        guiDrawing.drawRectangle((double)(80 + mainWidth + 3), 182.0, (double)(80 + mainWidth + 60 - 1), (double)(mainHeight - 1), selectedColor);
        for (int drawHue = 0; drawHue < mainHeight; ++drawHue) {
            int color = Color.HSBtoRGB((float)drawHue / (float)(mainHeight - 1), 1.0f, 1.0f);
            guiDrawing.drawRectangle((double)(40 + mainWidth), (double)(20 + drawHue), (double)(60 + mainWidth), (double)(20 + drawHue + 1), color);
        }
        for (int drawSaturation = 0; drawSaturation < mainWidth; ++drawSaturation) {
            for (int drawBrightness = 0; drawBrightness < mainHeight; ++drawBrightness) {
                int color = Color.HSBtoRGB(this.hue, (float)drawSaturation / (float)(mainWidth - 1), (float)drawBrightness / (float)(mainHeight - 1));
                guiDrawing.drawRectangle((double)(20 + drawSaturation), (double)(20 + mainHeight - drawBrightness - 1), (double)(20 + drawSaturation + 1), (double)(20 + mainHeight - drawBrightness), color);
            }
        }
        int selectedHueInt = Math.round(this.hue * (float)(mainHeight - 1));
        int selectedSaturationInt = Math.round(this.saturation * (float)(mainWidth - 1));
        int selectedBrightnessInt = Math.round(this.brightness * (float)(mainHeight - 1));
        guiDrawing.drawRectangle((double)(40 + mainWidth), (double)(20 + selectedHueInt - 1), (double)(60 + mainWidth), (double)(20 + selectedHueInt + 2), -16777216);
        guiDrawing.drawRectangle((double)(40 + mainWidth), (double)(20 + selectedHueInt), (double)(60 + mainWidth), (double)(20 + selectedHueInt + 1), -1);
        guiDrawing.drawRectangle((double)(20 + selectedSaturationInt - 1), (double)(20 + mainHeight - selectedBrightnessInt - 1), (double)(20 + selectedSaturationInt + 2), (double)(20 + mainHeight - selectedBrightnessInt), -16777216);
        guiDrawing.drawRectangle((double)(20 + selectedSaturationInt), (double)(20 + mainHeight - selectedBrightnessInt - 2), (double)(20 + selectedSaturationInt + 1), (double)(20 + mainHeight - selectedBrightnessInt + 1), -16777216);
        guiDrawing.drawRectangle((double)(20 + selectedSaturationInt), (double)(20 + mainHeight - selectedBrightnessInt - 1), (double)(20 + selectedSaturationInt + 1), (double)(20 + mainHeight - selectedBrightnessInt), -1);
        guiDrawing.finishDrawingRectangle();
    }

    public void tick2() {
        this.textFieldRed.tick2();
        this.textFieldGreen.tick2();
        this.textFieldBlue.tick2();
        this.textFieldColor.tick2();
    }

    public void onClose2() {
        RegistryClient.sendPacketToServer(new PacketUpdateCustomColor(this.pos, this.checkboxDefaultColor.isChecked2() ? -1 : Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF));
        super.onClose2();
    }

    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        int mainWidth = this.getMainWidth();
        int mainHeight = this.getMainHeight();
        this.draggingState = DraggingState.NONE;
        if (mouseY >= 20.0 && mouseY < (double)(20 + mainHeight)) {
            if (mouseX >= 20.0 && mouseX < (double)(20 + mainWidth)) {
                this.draggingState = DraggingState.SATURATION_BRIGHTNESS;
            } else if (mouseX >= (double)(40 + mainWidth) && mouseX < (double)(60 + mainWidth)) {
                this.draggingState = DraggingState.HUE;
            }
        }
        this.selectColor(mouseX, mouseY);
        return super.mouseClicked2(mouseX, mouseY, button);
    }

    public boolean mouseDragged2(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.selectColor(mouseX, mouseY);
        return super.mouseDragged2(mouseX, mouseY, button, deltaX, deltaY);
    }

    protected void selectColor(double mouseX, double mouseY) {
        if (this.checkboxDefaultColor.isChecked2()) {
            return;
        }
        int mainWidth = this.getMainWidth();
        int mainHeight = this.getMainHeight();
        switch (this.draggingState) {
            case SATURATION_BRIGHTNESS: {
                this.saturation = (float)MathHelper.clamp((double)((mouseX - 20.0) / (double)mainWidth), (double)0.0, (double)1.0);
                this.brightness = 1.0f - (float)MathHelper.clamp((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                break;
            }
            case HUE: {
                this.hue = (float)MathHelper.clamp((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
            }
        }
    }

    protected void setHsb(int color, boolean padZero) {
        float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        this.setColorText(color, padZero);
    }

    protected void setColorText(int color, boolean padZero) {
        String colorString = Integer.toHexString(color & 0xFFFFFF).toUpperCase(Locale.ENGLISH);
        this.textFieldColor.setText2(padZero ? StringUtils.leftPad((String)colorString, (int)6, (String)"0") : colorString);
        this.textFieldRed.setText2(String.valueOf(color >> 16 & 0xFF));
        this.textFieldGreen.setText2(String.valueOf(color >> 8 & 0xFF));
        this.textFieldBlue.setText2(String.valueOf(color & 0xFF));
        this.buttonReset.f_93623_ = (color & 0xFFFFFF) != this.oldColor;
    }

    protected void textCallback(String text, int shift) {
        try {
            boolean isHex = shift < 0;
            int compare = Integer.parseInt(text, isHex ? 16 : 10);
            int currentColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF;
            if ((isHex ? currentColor : currentColor >> shift & 0xFF) != compare) {
                this.setHsb(isHex ? compare : (currentColor & ~(255 << shift)) + (compare << shift), !isHex);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getMainWidth() {
        return this.f_96543_ - 100 - 60;
    }

    protected int getMainHeight() {
        return this.f_96544_ - 40;
    }

    protected static enum DraggingState {
        NONE,
        SATURATION_BRIGHTNESS,
        HUE;

    }
}

