/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.screen;

import forge.ziyue.tjmetro.mod.RegistryClient;
import forge.ziyue.tjmetro.mod.block.BlockStationNameEntranceTianjin;
import forge.ziyue.tjmetro.mod.block.BlockStationNamePlate;
import forge.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import forge.ziyue.tjmetro.mod.block.base.IRailwaySign;
import forge.ziyue.tjmetro.mod.packet.PacketUpdateRailwaySignConfig;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import org.mtr.core.data.Station;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectCollection;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.ClientWorld;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.ScreenExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.mapper.TexturedButtonWidgetExtension;
import org.mtr.mod.InitClient;
import org.mtr.mod.client.CustomResourceLoader;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderRailwaySign;
import org.mtr.mod.resource.SignResource;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.DashboardListSelectorScreen;
import org.mtr.mod.screen.EditStationScreen;
import org.mtr.mod.screen.PIDSConfigScreen;
import org.mtr.mod.screen.TexturedButtonWidgetHelper;

public class RailwaySignScreen
extends ScreenExtension
implements IGui {
    protected int editingIndex = -1;
    protected int page;
    protected int totalPages;
    protected int columns;
    protected int rows;
    protected final BlockPos signPos;
    protected final Type type;
    protected final int length;
    protected final String[] signIds;
    protected final LongAVLTreeSet selectedIds;
    protected final ObjectImmutableList<DashboardListItem> exitsForList;
    protected final ObjectImmutableList<DashboardListItem> platformsForList;
    protected final ObjectArraySet<DashboardListItem> routesForList;
    protected final ObjectArraySet<DashboardListItem> stationsForList;
    protected final ObjectArrayList<String> allSignIds = new ObjectArrayList();
    protected final ButtonWidgetExtension[] buttonsEdit;
    protected final ButtonWidgetExtension[] buttonsSelection;
    protected final ButtonWidgetExtension buttonClear;
    protected final TexturedButtonWidgetExtension buttonPrevPage;
    protected final TexturedButtonWidgetExtension buttonNextPage;
    protected static final int SIGN_SIZE = 32;
    protected static final int SIGN_BUTTON_SIZE = 16;
    protected static final int BUTTON_Y_START = 62;

    public RailwaySignScreen(BlockPos signPos) {
        int i;
        this.signPos = signPos;
        ClientWorld world = MinecraftClient.getInstance().getWorldMapped();
        this.allSignIds.addAll((ObjectList)CustomResourceLoader.getSortedSignIds());
        Station station = InitClient.findStation((BlockPos)signPos);
        if (station == null) {
            this.exitsForList = ObjectImmutableList.of();
            this.platformsForList = ObjectImmutableList.of();
            this.stationsForList = new ObjectArraySet();
            this.routesForList = new ObjectArraySet();
        } else {
            this.exitsForList = new ObjectImmutableList((ObjectList)EditStationScreen.getExitsForDashboardList((ObjectArrayList)EditStationScreen.getStationExits((Station)station, (boolean)true)));
            this.platformsForList = PIDSConfigScreen.getPlatformsForList((ObjectArrayList)new ObjectArrayList((ObjectCollection)station.savedRails));
            ObjectArraySet connectingStationsIncludingThisOne = new ObjectArraySet((ObjectSet)station.connectedStations);
            connectingStationsIncludingThisOne.add((Object)station);
            this.stationsForList = MinecraftClientData.convertDataSet((ObjectArraySet)connectingStationsIncludingThisOne);
            LongAVLTreeSet platformIds = new LongAVLTreeSet();
            connectingStationsIncludingThisOne.forEach(connectingStation -> connectingStation.savedRails.forEach(platform -> platformIds.add(platform.getId())));
            this.routesForList = new ObjectArraySet();
            IntAVLTreeSet addedColors = new IntAVLTreeSet();
            MinecraftClientData.getInstance().simplifiedRoutes.forEach(simplifiedRoute -> {
                int color = simplifiedRoute.getColor();
                if (!addedColors.contains(color) && simplifiedRoute.getPlatforms().stream().anyMatch(simplifiedRoutePlatform -> platformIds.contains(simplifiedRoutePlatform.getPlatformId()))) {
                    this.routesForList.add((Object)new DashboardListItem((long)color, simplifiedRoute.getName().split("\\|\\|")[0], color));
                    addedColors.add(color);
                }
            });
        }
        if (world != null) {
            BlockEntity entity = world.getBlockEntity(signPos);
            if (entity != null && entity.data instanceof BlockRailwaySignBase.BlockEntityBase) {
                BlockRailwaySignBase.BlockEntityBase entity1 = (BlockRailwaySignBase.BlockEntityBase)((Object)entity.data);
                this.signIds = entity1.getSignIds();
                this.selectedIds = entity1.getSelectedIds();
                this.type = Type.RAILWAY_SIGN;
            } else {
                this.signIds = new String[0];
                this.selectedIds = new LongAVLTreeSet();
                if (entity != null) {
                    if (entity.data instanceof BlockStationNameEntranceTianjin.BlockEntity) {
                        BlockStationNameEntranceTianjin.BlockEntity sign = (BlockStationNameEntranceTianjin.BlockEntity)((Object)entity.data);
                        this.selectedIds.add(sign.getSelectedId());
                        this.type = Type.STATION_NAME_ENTRANCE;
                    } else if (entity.data instanceof BlockStationNamePlate.BlockEntity) {
                        BlockStationNamePlate.BlockEntity plate = (BlockStationNamePlate.BlockEntity)((Object)entity.data);
                        this.selectedIds.add(plate.getPlatformId());
                        this.type = Type.STATION_NAME_PLATE;
                    } else {
                        this.type = Type.STATION_NAME_ENTRANCE;
                    }
                } else {
                    this.type = null;
                }
            }
            Block block = world.getBlockState(signPos).getBlock();
            if (block.data instanceof BlockRailwaySignBase) {
                BlockRailwaySignBase block1 = (BlockRailwaySignBase)((Object)block.data);
                this.length = block1.length;
            } else {
                this.length = 0;
            }
        } else {
            throw new NullPointerException("World is null");
        }
        this.buttonsEdit = new ButtonWidgetExtension[this.length];
        for (i = 0; i < this.buttonsEdit.length; ++i) {
            int index = i;
            this.buttonsEdit[i] = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable((String)"selectWorld.edit", (Object[])new Object[0]), button -> this.edit(index));
        }
        this.buttonsSelection = new ButtonWidgetExtension[this.allSignIds.size()];
        for (i = 0; i < this.allSignIds.size(); ++i) {
            int index = i;
            this.buttonsSelection[i] = new ButtonWidgetExtension(0, 0, 0, 16, button -> this.setNewSignId((String)this.allSignIds.get(index)));
        }
        this.buttonClear = new ButtonWidgetExtension(0, 0, 0, 20, TextHelper.translatable((String)"gui.mtr.reset_sign", (Object[])new Object[0]), button -> this.setNewSignId(null));
        this.buttonPrevPage = TexturedButtonWidgetHelper.create((int)0, (int)0, (int)0, (int)20, (Identifier)new Identifier("textures/gui/sprites/mtr/icon_left.png"), (Identifier)new Identifier("textures/gui/sprites/mtr/icon_left_highlighted.png"), button -> this.setPage(this.page - 1));
        this.buttonNextPage = TexturedButtonWidgetHelper.create((int)0, (int)0, (int)0, (int)20, (Identifier)new Identifier("textures/gui/sprites/mtr/icon_right.png"), (Identifier)new Identifier("textures/gui/sprites/mtr/icon_right_highlighted.png"), button -> this.setPage(this.page + 1));
    }

    protected void init2() {
        super.init2();
        for (int i = 0; i < this.buttonsEdit.length; ++i) {
            IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonsEdit[i], (int)((this.f_96543_ - 32 * this.length) / 2 + i * 32), (int)32, (int)32);
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonsEdit[i]));
        }
        this.columns = Math.max((this.f_96543_ - 48) / 128 * 2, 1);
        this.rows = Math.max((this.f_96544_ - 32 - 80) / 16, 1);
        int xOffsetSmall = (this.f_96543_ - 16 * (this.columns * 4 + 3)) / 2 + 16;
        int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
        this.totalPages = this.loopSigns((index, x, y, isBig) -> {
            IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonsSelection[index], (int)((isBig ? xOffsetBig : xOffsetSmall) + x), (int)(62 + y), (int)(isBig ? 48 : 16));
            this.buttonsSelection[index].f_93624_ = false;
            this.addChild(new ClickableWidget((AbstractWidget)this.buttonsSelection[index]));
        }, true);
        int buttonClearX = (this.f_96543_ - 144 - 80) / 2;
        int buttonY = this.f_96544_ - 40;
        IDrawing.setPositionAndWidth((ButtonWidgetExtension)this.buttonClear, (int)buttonClearX, (int)buttonY, (int)144);
        this.buttonClear.f_93624_ = false;
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonClear));
        IDrawing.setPositionAndWidth((TexturedButtonWidgetExtension)this.buttonPrevPage, (int)(buttonClearX + 144), (int)buttonY, (int)20);
        this.buttonPrevPage.f_93624_ = false;
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonPrevPage));
        IDrawing.setPositionAndWidth((TexturedButtonWidgetExtension)this.buttonNextPage, (int)(buttonClearX + 144 + 60), (int)buttonY, (int)20);
        this.buttonNextPage.f_93624_ = false;
        this.addChild(new ClickableWidget((AbstractWidget)this.buttonNextPage));
        if (this.type != Type.RAILWAY_SIGN) {
            MinecraftClient.getInstance().openScreen(new org.mtr.mapping.holder.Screen((Screen)(switch (this.type) {
                case Type.STATION_NAME_ENTRANCE -> new DashboardListSelectorScreen(this::onClose2, this.exitsForList, (LongCollection)this.selectedIds, true, false, null);
                case Type.STATION_NAME_PLATE -> new DashboardListSelectorScreen(this::onClose2, this.platformsForList, (LongCollection)this.selectedIds, true, false, null);
                case Type.STATION_NAVIGATOR -> new DashboardListSelectorScreen(this::onClose2, new ObjectImmutableList(this.routesForList), (LongCollection)this.selectedIds, false, false, null);
                default -> throw new IllegalStateException("Unknown enum type: " + this.type);
            })));
        }
    }

    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphicsHolder);
        super.render(graphicsHolder, mouseX, mouseY, delta);
        for (int i = 0; i < this.signIds.length; ++i) {
            if (this.signIds[i] == null) continue;
            RenderRailwaySign.drawSign((GraphicsHolder)graphicsHolder, null, (BlockPos)this.signPos, (String)this.signIds[i], (float)((float)(this.f_96543_ - 32 * this.length) / 2.0f + (float)(i * 32)), (float)0.0f, (float)32.0f, (float)RenderRailwaySign.getMaxWidth((String[])this.signIds, (int)i, (boolean)false), (float)RenderRailwaySign.getMaxWidth((String[])this.signIds, (int)i, (boolean)true), (LongAVLTreeSet)this.selectedIds, (Direction)Direction.UP, (int)0, (textureId, x, y, size, flipTexture) -> {
                GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
                guiDrawing.beginDrawingTexture(textureId);
                guiDrawing.drawTexture((double)x, (double)y, (double)(x + size), (double)(y + size), flipTexture ? 1.0f : 0.0f, 0.0f, flipTexture ? 0.0f : 1.0f, 1.0f);
                guiDrawing.finishDrawingTexture();
            });
        }
        if (this.editingIndex >= 0) {
            int xOffsetSmall = (this.f_96543_ - 16 * (this.columns * 4 + 3)) / 2 + 16;
            int xOffsetBig = xOffsetSmall + 16 * (this.columns + 1);
            this.loopSigns((index, x, y, isBig) -> {
                String signId = (String)this.allSignIds.get(index);
                SignResource sign = RenderRailwaySign.getSign((String)signId);
                if (sign != null) {
                    boolean moveRight = sign.hasCustomText && sign.getFlipCustomText();
                    RenderRailwaySign.drawSign((GraphicsHolder)graphicsHolder, null, (BlockPos)this.signPos, (String)signId, (float)((isBig ? xOffsetBig : xOffsetSmall) + x + (moveRight ? 32 : 0)), (float)(62 + y), (float)16.0f, (float)2.0f, (float)2.0f, (LongAVLTreeSet)this.selectedIds, (Direction)Direction.UP, (int)0, (textureId, x1, y1, size, flipTexture) -> {
                        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
                        guiDrawing.beginDrawingTexture(sign.getTexture());
                        guiDrawing.drawTexture((double)x1, (double)y1, (double)(x1 + size), (double)(y1 + size), flipTexture ? 1.0f : 0.0f, 0.0f, flipTexture ? 0.0f : 1.0f, 1.0f);
                        guiDrawing.finishDrawingTexture();
                    });
                }
            }, false);
            graphicsHolder.drawCenteredText(String.format("%s/%s", this.page + 1, this.totalPages), (this.f_96543_ - 144 - 80) / 2 + 144 + 40, this.f_96544_ - 40 + 6, -1);
        }
    }

    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        this.setPage(this.page + (int)Math.signum(-amount));
        return super.mouseScrolled2(mouseX, mouseY, amount);
    }

    public void onClose2() {
        RegistryClient.sendPacketToServer(new PacketUpdateRailwaySignConfig(this.signPos, this.selectedIds, this.signIds));
        super.onClose2();
    }

    public boolean isPauseScreen2() {
        return false;
    }

    public void resize2(MinecraftClient client, int width, int height) {
        super.resize2(client, width, height);
        for (ButtonWidgetExtension button : this.buttonsEdit) {
            button.f_93623_ = true;
        }
        for (ButtonWidgetExtension button : this.buttonsSelection) {
            button.f_93624_ = false;
        }
        this.editingIndex = -1;
    }

    protected int loopSigns(LoopSignsCallback loopSignsCallback, boolean ignorePage) {
        int pageCount = this.rows * this.columns;
        int indexSmall = 0;
        int indexBig = 0;
        int columnSmall = 0;
        int columnBig = 0;
        int rowSmall = 0;
        int rowBig = 0;
        int totalPagesSmallCount = 1;
        int totalPagesBigCount = 1;
        for (int i = 0; i < this.allSignIds.size(); ++i) {
            boolean onPage;
            SignResource sign = RenderRailwaySign.getSign((String)((String)this.allSignIds.get(i)));
            boolean isBig = sign != null && sign.hasCustomText;
            this.buttonsSelection[i].f_93624_ = onPage = (isBig ? indexBig : indexSmall) / pageCount == this.page;
            if (ignorePage || onPage) {
                loopSignsCallback.loopSignsCallback(i, (isBig ? columnBig * 3 : columnSmall) * 16, (isBig ? rowBig : rowSmall) * 16, isBig);
            }
            if (isBig) {
                ++columnBig;
                if (totalPagesBigCount < 0) {
                    totalPagesBigCount = -totalPagesBigCount + 1;
                }
                if (columnBig >= this.columns) {
                    columnBig = 0;
                    if (++rowBig >= this.rows) {
                        rowBig = 0;
                        totalPagesBigCount = -totalPagesBigCount;
                    }
                }
                ++indexBig;
                continue;
            }
            ++columnSmall;
            if (totalPagesSmallCount < 0) {
                totalPagesSmallCount = -totalPagesSmallCount + 1;
            }
            if (columnSmall >= this.columns) {
                columnSmall = 0;
                if (++rowSmall >= this.rows) {
                    rowSmall = 0;
                    totalPagesSmallCount = -totalPagesSmallCount;
                }
            }
            ++indexSmall;
        }
        return Math.max(Math.abs(totalPagesBigCount), Math.abs(totalPagesSmallCount));
    }

    protected void edit(int editingIndex) {
        this.editingIndex = editingIndex;
        for (ButtonWidgetExtension button : this.buttonsEdit) {
            button.f_93623_ = true;
        }
        this.buttonClear.f_93624_ = true;
        this.setPage(this.page);
        this.buttonsEdit[editingIndex].f_93623_ = false;
    }

    protected void setNewSignId(@Nullable String newSignId) {
        if (this.editingIndex >= 0 && this.editingIndex < this.signIds.length) {
            this.signIds[this.editingIndex] = newSignId;
            boolean isExitLetter = IRailwaySign.signIsExit(newSignId);
            boolean isPlatform = IRailwaySign.signIsPlatform(newSignId);
            boolean isLine = IRailwaySign.signIsLine(newSignId);
            boolean isStation = IRailwaySign.signIsStation(newSignId);
            if (isExitLetter || isPlatform || isLine || isStation) {
                MinecraftClient.getInstance().openScreen(new org.mtr.mapping.holder.Screen((Screen)new DashboardListSelectorScreen(this::onClose2, new ObjectImmutableList(isExitLetter ? this.exitsForList : (isPlatform ? this.platformsForList : (isLine ? this.routesForList : this.stationsForList))), (LongCollection)this.selectedIds, false, false, null)));
            }
        }
    }

    protected void setPage(int newPage) {
        this.page = MathHelper.clamp((int)newPage, (int)0, (int)(this.totalPages - 1));
        this.buttonPrevPage.f_93624_ = this.editingIndex >= 0 && this.page > 0;
        this.buttonNextPage.f_93624_ = this.editingIndex >= 0 && this.page < this.totalPages - 1;
    }

    public static enum Type {
        RAILWAY_SIGN,
        STATION_NAME_ENTRANCE,
        STATION_NAME_PLATE,
        STATION_NAVIGATOR;

    }

    @FunctionalInterface
    protected static interface LoopSignsCallback {
        public void loopSignsCallback(int var1, int var2, int var3, boolean var4);
    }
}

