/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.centralconfig;

import forge.ziyue.tjmetro.centralconfig.MasterCategory;
import forge.ziyue.tjmetro.centralconfig.ModuleCategory;
import java.util.HashSet;
import java.util.Set;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.util.text.ITextComponent;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Screen;

public final class CentralConfig {
    private final MasterCategory masterCategory;
    private final Set<ModuleCategory> moduleCategories = new HashSet<ModuleCategory>();

    public CentralConfig(MasterCategory masterCategory) {
        this.masterCategory = masterCategory;
    }

    public void registerModuleCategory(ModuleCategory moduleCategory) {
        if (!this.moduleCategories.add(moduleCategory)) {
            throw new IllegalArgumentException("Duplicate mod id: " + moduleCategory.modId);
        }
    }

    public Screen getConfigScreen() {
        return this.getConfigScreen(new Screen(null), (String)null);
    }

    public Screen getConfigScreen(ModuleCategory category) {
        return this.getConfigScreen(new Screen(null), category.modId);
    }

    public Screen getConfigScreen(String categoryModId) {
        return this.getConfigScreen(new Screen(null), categoryModId);
    }

    public Screen getConfigScreen(Screen parent) {
        return this.getConfigScreen(parent, (String)null);
    }

    public Screen getConfigScreen(Screen parent, ModuleCategory category) {
        return this.getConfigScreen(parent, category.modId);
    }

    public Screen getConfigScreen(Screen parent, String categoryModId) {
        ConfigBuilder builder = this.masterCategory.configBuilderSupplier.get().setParentScreen((net.minecraft.client.gui.screen.Screen)parent.data);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory defaultCategory = builder.getOrCreateCategory((ITextComponent)((MutableText)this.masterCategory.titleSupplier.get()).data);
        this.masterCategory.categoryBiConsumer.accept(entryBuilder, defaultCategory);
        for (ModuleCategory moduleCategory : this.moduleCategories) {
            ConfigCategory category = builder.getOrCreateCategory((ITextComponent)moduleCategory.titleSupplier.get().data);
            moduleCategory.categoryBiConsumer.accept(entryBuilder, category);
            if (!moduleCategory.modId.equals(categoryModId)) continue;
            builder.setFallbackCategory(category);
        }
        return new Screen(builder.build());
    }
}

