/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockList;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.IBlock;

public class BlockBench
extends BlockExtension
implements DirectionHelper,
IBlock {
    public BlockBench() {
        this(Blocks.createDefaultBlockSettings((boolean)false));
    }

    public BlockBench(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nullable
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction direction = ctx.getPlayerFacing();
        BlockPos pos = ctx.getBlockPos();
        return this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockBench.FACING.data), (Comparable)direction.data).with(new Property((net.minecraft.state.Property)BlockBench.SIDE_EXTENDED.data), (Comparable)this.getPos(direction, pos, ctx.getWorld()));
    }

    public void neighborUpdate2(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        world.setBlockState(pos, state.with(new Property((net.minecraft.state.Property)BlockBench.SIDE_EXTENDED.data), (Comparable)this.getPos(IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING), pos, world)));
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        VoxelShape top = IBlock.getVoxelShapeByDirection((double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)9.5, (double)15.0, (Direction)direction);
        VoxelShape left = IBlock.getVoxelShapeByDirection((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0, (Direction)direction);
        VoxelShape right = IBlock.getVoxelShapeByDirection((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)14.0, (Direction)direction);
        switch ((IBlock.EnumSide)IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE_EXTENDED)) {
            case SINGLE: {
                return VoxelShapes.union((VoxelShape)VoxelShapes.union((VoxelShape)top, (VoxelShape)left), (VoxelShape)right);
            }
            case LEFT: {
                return VoxelShapes.union((VoxelShape)top, (VoxelShape)left);
            }
            case RIGHT: {
                return VoxelShapes.union((VoxelShape)top, (VoxelShape)right);
            }
        }
        return top;
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)SIDE_EXTENDED);
    }

    public IBlock.EnumSide getPos(Direction direction, BlockPos blockPos, World world) {
        BlockState counterClockWiseState = world.getBlockState(blockPos.offset(direction.rotateYCounterclockwise()));
        BlockState clockWiseState = world.getBlockState(blockPos.offset(direction.rotateYClockwise()));
        boolean[] blockSame = new boolean[]{IBlockExtension.isBlock(counterClockWiseState, BlockList.BENCH.get()) && IBlock.getStatePropertySafe((BlockState)counterClockWiseState, (DirectionProperty)FACING) == direction, IBlockExtension.isBlock(clockWiseState, BlockList.BENCH.get()) && IBlock.getStatePropertySafe((BlockState)clockWiseState, (DirectionProperty)FACING) == direction};
        return blockSame[0] && blockSame[1] ? IBlock.EnumSide.MIDDLE : (blockSame[0] ? IBlock.EnumSide.LEFT : (blockSame[1] ? IBlock.EnumSide.RIGHT : IBlock.EnumSide.SINGLE));
    }
}

