/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.data.IGuiExtension;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.IBlock;

public class BlockPlayerDetector
extends BlockExtension
implements DirectionHelper,
BlockWithEntity {
    public static final BooleanProperty POWERED = BooleanProperty.of((String)"powered");

    public BlockPlayerDetector() {
        this(Blocks.createDefaultBlockSettings((boolean)false).breakInstantly());
    }

    public BlockPlayerDetector(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nullable
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        return this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockPlayerDetector.POWERED.data), (Comparable)Boolean.valueOf(false)).with(new Property((net.minecraft.state.Property)BlockPlayerDetector.FACING_NORMAL.data), (Comparable)ctx.getSide().data);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)POWERED);
        properties.add((HolderBase<?>)FACING_NORMAL);
    }

    public int getStrongRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)POWERED) ? 15 : 0;
    }

    public int getWeakRedstonePower2(BlockState state, BlockView world, BlockPos pos, Direction direction) {
        return IBlock.getStatePropertySafe((BlockState)state, (BooleanProperty)POWERED) ? 15 : 0;
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING_NORMAL);
        switch (direction) {
            case UP: {
                return Block.createCuboidShape((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
            }
            case DOWN: {
                return Block.createCuboidShape((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
            }
        }
        return IBlock.getVoxelShapeByDirection((double)1.7, (double)2.0, (double)14.8, (double)14.3, (double)4.0, (double)17.0, (Direction)direction);
    }

    public boolean emitsRedstonePower2(BlockState state) {
        return true;
    }

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.player_detector", (Object[])new Object[0]));
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockEntityExtension {
        public BlockEntity(BlockPos blockPos, BlockState blockState) {
            super(BlockEntityTypes.PLAYER_DETECTOR.get(), blockPos, blockState);
        }

        public void blockEntityTick() {
            boolean powered;
            PlayerEntity player = this.getWorld2().getClosestPlayer((double)this.getPos2().getX(), (double)this.getPos2().getY(), (double)this.getPos2().getZ(), 3.0, false);
            boolean bl = powered = player != null;
            if (powered != IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (BooleanProperty)POWERED)) {
                this.getWorld2().setBlockState(this.getPos2(), this.getCachedState2().with(new Property((net.minecraft.state.Property)BlockPlayerDetector.POWERED.data), (Comparable)Boolean.valueOf(powered)));
                this.getWorld2().updateNeighbors(this.getPos2(), this.getCachedState2().getBlock());
                this.getWorld2().updateNeighbors(this.getPos2().down(), this.getCachedState2().getBlock());
            }
        }
    }
}

