/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.BlockList;
import forge.ziyue.tjmetro.mod.ItemList;
import forge.ziyue.tjmetro.mod.Registry;
import forge.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import forge.ziyue.tjmetro.mod.block.base.IRailwaySign;
import forge.ziyue.tjmetro.mod.data.IGuiExtension;
import forge.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.IWorld;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.Item;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.Items;
import org.mtr.mod.block.BlockRouteSignBase;
import org.mtr.mod.block.IBlock;

public class BlockStationNamePlate
extends BlockRailwaySignBase {
    public static final IntegerProperty ARROW_DIRECTION = IntegerProperty.of((String)"arrow_direction", (int)0, (int)2);

    public BlockStationNamePlate() {
        this(Blocks.createDefaultBlockSettings((boolean)true));
    }

    public BlockStationNamePlate(BlockSettings settings) {
        super(settings, 8, false);
    }

    @Override
    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingItem((World)world, (PlayerEntity)player, item -> {
            BlockPos checkPos;
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            Direction hitSide = hit.getSide();
            if ((hitSide == facing || hitSide == facing.getOpposite()) && (checkPos = this.findEndWithDirection(world, pos, hitSide.getOpposite(), false)) != null) {
                if (item.data == Items.BRUSH.get().data) {
                    world.setBlockState(checkPos, world.getBlockState(checkPos).cycle(new Property((net.minecraft.state.Property)BlockStationNamePlate.ARROW_DIRECTION.data)));
                } else {
                    Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(checkPos));
                }
            }
        }, null, (Item[])new Item[]{Items.BRUSH.get(), ItemList.WRENCH.get()});
    }

    @Override
    @Nonnull
    public BlockState getStateForNeighborUpdate2(BlockState state, Direction direction, BlockState neighborState, WorldAccess world, BlockPos pos, BlockPos neighborPos) {
        return IRailwaySign.getStateForNeighborUpdate(state, direction, neighborState, BlockList.STATION_NAME_PLATE_MIDDLE.get());
    }

    @Override
    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (world.isClient()) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        for (int i = 1; i <= this.getMiddleLength(); ++i) {
            world.setBlockState(pos.offset(facing.rotateYClockwise(), i), BlockList.STATION_NAME_PLATE_MIDDLE.get().getDefaultState().with(new Property((net.minecraft.state.Property)BlockStationNamePlate.FACING.data), (Comparable)facing.data), 3);
        }
        world.setBlockState(pos.offset(facing.rotateYClockwise(), this.getMiddleLength() + 1), state.getBlock().getDefaultState().with(new Property((net.minecraft.state.Property)BlockStationNamePlate.FACING.data), (Comparable)facing.getOpposite().data).with(new Property((net.minecraft.state.Property)BlockStationNamePlate.ARROW_DIRECTION.data), (Comparable)Integer.valueOf(0)), 3);
        world.updateNeighbors(pos, org.mtr.mapping.holder.Blocks.getAirMapped());
        state.updateNeighbors(new WorldAccess((IWorld)world.data), pos, 3);
    }

    @Override
    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (this == BlockList.STATION_NAME_PLATE_MIDDLE.get().data) {
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)3.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        }
        VoxelShape main = IBlock.getVoxelShapeByDirection((double)0.0, (double)3.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        VoxelShape pole = IBlock.getVoxelShapeByDirection((double)-1.0, (double)3.0, (double)7.0, (double)0.25, (double)16.0, (double)9.0, (Direction)facing);
        return VoxelShapes.union((VoxelShape)main, (VoxelShape)pole);
    }

    @Override
    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        IGuiExtension.addHoldShiftTooltip(tooltip, TextHelper.translatable((String)"tooltip.tjmetro.station_name_plate", (Object[])new Object[0]));
    }

    @Override
    protected int getMiddleLength() {
        return 2;
    }

    @Override
    @Nonnull
    public String getTranslationKey2() {
        return "block.tjmetro.station_name_plate";
    }

    @Override
    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)ARROW_DIRECTION);
    }

    @Override
    protected BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        return IRailwaySign.findEndWithDirection(world, startPos, direction, allowOpposite, BlockList.STATION_NAME_PLATE_MIDDLE.get());
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == BlockList.STATION_NAME_PLATE_MIDDLE.get().data) {
            return null;
        }
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockRouteSignBase.BlockEntityBase {
        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.STATION_NAME_PLATE.get(), pos, state);
        }
    }
}

