/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block;

import forge.ziyue.tjmetro.mod.BlockEntityTypes;
import forge.ziyue.tjmetro.mod.Registry;
import forge.ziyue.tjmetro.mod.TianjinMetro;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import forge.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Blocks;
import org.mtr.mod.block.BlockRouteSignBase;
import org.mtr.mod.block.IBlock;

public class BlockStationNameSignTianjin
extends BlockExtension
implements DirectionHelper,
BlockWithEntity {
    public BlockStationNameSignTianjin() {
        this(Blocks.createDefaultBlockSettings((boolean)true, state -> 10));
    }

    public BlockStationNameSignTianjin(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nullable
    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction direction = ctx.getPlayerFacing();
        BlockState state = this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockStationNameSignTianjin.FACING.data), (Comparable)direction.data);
        if (IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)direction.rotateYClockwise(), (int)2)) {
            ctx.getWorld().setBlockState(ctx.getBlockPos().offset(direction.rotateYClockwise(), 1), state.with(new Property((net.minecraft.state.Property)IBlock.SIDE.data), (Comparable)IBlock.EnumSide.RIGHT));
            return state.with(new Property((net.minecraft.state.Property)IBlock.SIDE.data), (Comparable)IBlock.EnumSide.LEFT);
        }
        return null;
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlockExtension.checkHoldingBrushOrWrench(world, player, () -> Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(pos)));
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        IBlock.EnumSide side = (IBlock.EnumSide)IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)IBlock.SIDE);
        IBlockExtension.breakBlock(world, pos.offset(side == IBlock.EnumSide.LEFT ? direction.rotateYClockwise() : direction.rotateYCounterclockwise(), 1));
        super.onBreak2(world, pos, state, player);
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        Direction direction = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)IBlock.SIDE) == IBlock.EnumSide.LEFT) {
            return IBlock.getVoxelShapeByDirection((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0, (Direction)direction);
        }
        return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)1.0, (Direction)direction);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)IBlock.SIDE);
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public static class BlockEntity
    extends BlockRouteSignBase.BlockEntityBase {
        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.STATION_NAME_SIGN_TIANJIN.get(), pos, state);
        }

        public void setData(long platformId) {
            this.setPlatformId(platformId);
            BlockPos pos = IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (EnumProperty)IBlock.SIDE) == IBlock.EnumSide.LEFT ? this.getPos2().offset(IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (DirectionProperty)DirectionHelper.FACING).rotateYClockwise()) : this.getPos2().offset(IBlock.getStatePropertySafe((BlockState)this.getCachedState2(), (DirectionProperty)DirectionHelper.FACING).rotateYCounterclockwise());
            org.mtr.mapping.holder.BlockEntity blockEntity = this.getWorld2().getBlockEntity(pos);
            if (blockEntity.data instanceof BlockEntity) {
                BlockEntity entity = (BlockEntity)((Object)blockEntity.data);
                entity.setPlatformId(platformId);
                entity.markDirty2();
            } else {
                TianjinMetro.LOGGER.error("BlockStationNameSignTianjin.BlockEntity: Unable to set data for block entity at " + pos.toShortString());
            }
            this.markDirty2();
        }
    }
}

