/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block.base;

import forge.ziyue.tjmetro.mod.Registry;
import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import forge.ziyue.tjmetro.mod.packet.PacketOpenBlockEntityScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongCollection;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;

public abstract class BlockRailwaySignBase
extends BlockExtension
implements IBlock,
DirectionHelper,
BlockWithEntity {
    public final int length;
    public final boolean isOdd;

    public BlockRailwaySignBase(BlockSettings settings, int length, boolean isOdd) {
        super(settings);
        this.length = length;
        this.isOdd = isOdd;
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlockExtension.checkHoldingBrushOrWrench(world, player, () -> {
            BlockPos checkPos;
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            Direction hitSide = hit.getSide();
            if ((hitSide == facing || hitSide == facing.getOpposite()) && (checkPos = this.findEndWithDirection(world, pos, hitSide.getOpposite(), false)) != null) {
                Registry.sendPacketToClient(ServerPlayerEntity.cast((HolderBase)player), new PacketOpenBlockEntityScreen(checkPos));
            }
        });
    }

    @Nonnull
    public abstract BlockState getStateForNeighborUpdate2(BlockState var1, Direction var2, BlockState var3, WorldAccess var4, BlockPos var5, BlockPos var6);

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        return IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)(this.getMiddleLength() + 2)) ? this.getDefaultState2().with(new Property((net.minecraft.state.Property)BlockRailwaySignBase.FACING.data), (Comparable)facing.data) : null;
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        BlockPos checkPos = this.findEndWithDirection(world, pos, facing, true);
        if (checkPos != null) {
            IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)checkPos);
        }
        super.onBreak2(world, pos, state, player);
    }

    public abstract void onPlaced2(World var1, BlockPos var2, BlockState var3, @Nullable LivingEntity var4, ItemStack var5);

    @Nonnull
    public abstract VoxelShape getOutlineShape2(BlockState var1, BlockView var2, BlockPos var3, ShapeContext var4);

    @Nonnull
    public abstract String getTranslationKey2();

    public void addTooltips(ItemStack stack, @Nullable BlockView world, List<MutableText> tooltip, TooltipContext options) {
        tooltip.add(TextHelper.translatable((String)"tooltip.mtr.railway_sign_length", (Object[])new Object[]{this.length}).formatted(TextFormatting.GRAY));
        tooltip.add(TextHelper.translatable((String)(this.isOdd ? "tooltip.mtr.railway_sign_odd" : "tooltip.mtr.railway_sign_even"), (Object[])new Object[0]).formatted(TextFormatting.GRAY));
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
    }

    public int getXStart() {
        switch (this.length % 4) {
            default: {
                return this.isOdd ? 8 : 16;
            }
            case 1: {
                return this.isOdd ? 4 : 12;
            }
            case 2: {
                return this.isOdd ? 16 : 8;
            }
            case 3: 
        }
        return this.isOdd ? 12 : 4;
    }

    protected int getMiddleLength() {
        return (this.length - (4 - this.getXStart() / 4)) / 2;
    }

    protected abstract BlockPos findEndWithDirection(World var1, BlockPos var2, Direction var3, boolean var4);

    public static abstract class BlockEntityBase
    extends BlockEntityExtension {
        protected final LongAVLTreeSet selectedIds;
        protected final String[] signIds;
        protected static final String KEY_SELECTED_IDS = "selected_ids";
        protected static final String KEY_SIGN_LENGTH = "sign_length";

        public BlockEntityBase(BlockEntityType<?> type, int length, BlockPos pos, BlockState state) {
            super(type, pos, state);
            this.signIds = new String[length];
            this.selectedIds = new LongAVLTreeSet();
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.selectedIds.clear();
            Arrays.stream(compoundTag.getLongArray(KEY_SELECTED_IDS)).forEach(arg_0 -> ((LongAVLTreeSet)this.selectedIds).add(arg_0));
            for (int i = 0; i < this.signIds.length; ++i) {
                String signId = compoundTag.getString(KEY_SIGN_LENGTH + i);
                this.signIds[i] = signId.isEmpty() ? null : signId.toLowerCase(Locale.ENGLISH);
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.putLongArray(KEY_SELECTED_IDS, new ArrayList(this.selectedIds));
            for (int i = 0; i < this.signIds.length; ++i) {
                compoundTag.putString(KEY_SIGN_LENGTH + i, this.signIds[i] == null ? "" : this.signIds[i]);
            }
        }

        public void setData(LongAVLTreeSet selectedIds, String[] signTypes) {
            this.selectedIds.clear();
            this.selectedIds.addAll((LongCollection)selectedIds);
            if (this.signIds.length == signTypes.length) {
                System.arraycopy(signTypes, 0, this.signIds, 0, signTypes.length);
            }
            this.markDirty2();
        }

        public LongAVLTreeSet getSelectedIds() {
            return this.selectedIds;
        }

        public String[] getSignIds() {
            return this.signIds;
        }
    }
}

