/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.client;

import forge.ziyue.tjmetro.mod.TianjinMetro;
import forge.ziyue.tjmetro.mod.block.BlockStationNameEntranceTianjin;
import forge.ziyue.tjmetro.mod.client.DrawingHelper;
import forge.ziyue.tjmetro.mod.client.DynamicTextureCache;
import forge.ziyue.tjmetro.mod.config.ConfigClient;
import forge.ziyue.tjmetro.mod.data.IGuiExtension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.mtr.core.data.Data;
import org.mtr.core.data.Platform;
import org.mtr.core.data.SimplifiedRoute;
import org.mtr.core.data.SimplifiedRoutePlatform;
import org.mtr.core.data.Station;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.ints.IntList;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectIntImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectSet;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageFormat;
import org.mtr.mapping.mapper.TextHelper;
import org.mtr.mod.Init;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.config.Config;
import org.mtr.mod.data.IGui;
import org.mtr.mod.screen.DashboardListItem;
import org.mtr.mod.screen.EditStationScreen;

public class RouteMapGenerator
implements IGui {
    protected static int scale;
    protected static int lineSize;
    protected static int lineSpacing;
    protected static int fontSizeBig;
    protected static int fontSizeSmall;
    public static final int MIN_VERTICAL_SIZE = 5;
    public static final Identifier SUBWAY_LOGO_RESOURCE;
    public static final Identifier TRAIN_LOGO_RESOURCE;
    public static final Identifier TRAIN_BORDERLESS_LOGO_RESOURCE;
    public static final Identifier TRAIN_BMT_LOGO_RESOURCE;
    public static final Identifier TRAIN_JINJING_LOGO_RESOURCE;
    public static final Identifier EXIT_RESOURCE;
    public static final Identifier ARROW_RESOURCE;
    public static final Identifier CIRCLE_RESOURCE;
    public static final String TEMP_CIRCULAR_MARKER_CLOCKWISE;
    public static final String TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;

    public static void setConstants() {
        scale = (int)Math.pow(2.0, Config.getClient().getDynamicTextureResolution() + 5);
        lineSize = scale / 8;
        lineSpacing = lineSize * 3 / 2;
        fontSizeBig = lineSize * 2;
        fontSizeSmall = fontSizeBig / 2;
    }

    public static NativeImage generateDirectionArrow(long platformId, boolean hasLeft, boolean hasRight, IGui.HorizontalAlignment horizontalAlignment, boolean showToString, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int circleX;
            ObjectArrayList destinations = new ObjectArrayList();
            IntArrayList colors = RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                if (!simplifiedRoute.getName().isEmpty()) {
                    destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                }
            });
            boolean isTerminating = destinations.isEmpty();
            boolean leftToRight = horizontalAlignment == IGui.HorizontalAlignment.CENTER ? hasLeft || !hasRight : horizontalAlignment != IGui.HorizontalAlignment.RIGHT;
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            DynamicTextureCache clientCache = DynamicTextureCache.instance;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
            if (isTerminating) {
                circleX = (int)horizontalAlignment.getOffset(0.0f, (float)(tileSize - width));
            } else {
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "")).isEmpty()) {
                    if (isClockwise) {
                        destinationString = IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString);
                    } else if (isAnticlockwise) {
                        destinationString = IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString);
                    } else if (showToString) {
                        destinationString = IGuiExtension.insertTranslation("gui.mtr.to_cjk", "gui.mtr.to", 1, destinationString);
                    }
                }
                int tilePadding = tileSize / 4;
                int leftSize = ((hasLeft ? 1 : 0) + (leftToRight ? 1 : 0)) * (tileSize + tilePadding);
                int rightSize = ((hasRight ? 1 : 0) + (leftToRight ? 0 : 1)) * (tileSize + tilePadding);
                DynamicTextureCache.Text text = clientCache.getText(destinationString, width - leftSize - rightSize - padding * (showToString ? 2 : 1), (int)((float)tileSize * 1.25f), tileSize * 3 / 5, tileSize * 3 / 10, tilePadding, leftToRight ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
                int leftPadding = (int)horizontalAlignment.getOffset(0.0f, (float)(leftSize + rightSize + text.renderWidth() - tilePadding * 2 - width));
                DrawingHelper.drawString(nativeImage, text, leftPadding + leftSize - tilePadding, height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
                if (hasLeft) {
                    DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, leftPadding, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor, false);
                }
                if (hasRight) {
                    DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, leftPadding + leftSize + text.renderWidth() - tilePadding * 2 + rightSize - tileSize, padding, tileSize, tileSize, true, 0.0f, 1.0f, textColor, false);
                }
                circleX = leftPadding + leftSize + (leftToRight ? -tileSize - tilePadding : text.renderWidth() - tilePadding);
            }
            for (int i = 0; i < colors.size(); ++i) {
                DrawingHelper.drawResource(nativeImage, CIRCLE_RESOURCE, circleX, padding, tileSize, tileSize, false, (float)i / (float)colors.size(), ((float)i + 1.0f) / (float)colors.size(), colors.getInt(i), false);
            }
            Platform platform = (Platform)MinecraftClientData.getInstance().platformIdMap.get(platformId);
            if (platform != null) {
                DynamicTextureCache.Text text = clientCache.getText(platform.getName(), tileSize, (int)((float)tileSize * 1.25f * 3.0f / 4.0f), tileSize * 3 / 4, tileSize * 3 / 4, 0, IGui.HorizontalAlignment.CENTER);
                DrawingHelper.drawString(nativeImage, text, circleX + tileSize / 2, padding + tileSize / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            }
            if (transparentColor != 0) {
                DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(transparentColor));
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationName(long platformId, boolean isAPG, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            boolean leftToRight = horizontalAlignment != IGui.HorizontalAlignment.RIGHT;
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
            int tilePadding = tileSize / 4;
            int leftSize = (leftToRight ? 1 : 0) * (tileSize + tilePadding);
            int rightSize = (leftToRight ? 0 : 1) * (tileSize + tilePadding);
            DynamicTextureCache.Text stationName = DynamicTextureCache.instance.getText(RouteMapGenerator.getStationName(platformId), isAPG ? width - padding : width - leftSize - rightSize - padding, (int)((float)tileSize * 1.25f), tileSize * 3, tileSize * 3 / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
            DrawingHelper.drawString(nativeImage, stationName, width / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            if (transparentColor != 0) {
                DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(transparentColor));
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateSingleRowStationName(long platformId, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            DynamicTextureCache.Text text = DynamicTextureCache.instance.getText(RouteMapGenerator.getStationName(platformId).replace("|", " | "), fontSizeBig, fontSizeSmall);
            int padding = text.height() / 2;
            int height = text.height() + padding;
            int width = Math.max(Math.round((float)height * aspectRatio), text.renderWidth() + padding);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, -1);
            DrawingHelper.drawString(nativeImage, text, width / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
            return nativeImage;
        }
        catch (Exception e) {
            Init.LOGGER.error("", (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationNameBMT(long platformId, boolean flip, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            ObjectArrayList destinations = new ObjectArrayList();
            ObjectArrayList nextStations = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                if (!simplifiedRoute.getName().isEmpty()) {
                    destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                    nextStations.add((Object)((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex + 1)).getStationName());
                }
            });
            boolean isTerminating = destinations.isEmpty();
            boolean leftToRight = horizontalAlignment != IGui.HorizontalAlignment.RIGHT;
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
            int tilePadding = tileSize / 8;
            int leftSize = (leftToRight ? 1 : 0) * (tileSize + tilePadding);
            int rightSize = (leftToRight ? 0 : 1) * (tileSize + tilePadding);
            DynamicTextureCache.Text textStationName = DynamicTextureCache.instance.getText(RouteMapGenerator.getStationName(platformId), width - leftSize - rightSize - padding, (int)((float)tileSize * 1.25f), tileSize / 2, tileSize / 4, tilePadding, IGui.HorizontalAlignment.CENTER);
            DrawingHelper.drawString(nativeImage, textStationName, width / 2, (int)((float)tileSize / 3.8f), IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.TOP, backgroundColor, textColor, false);
            if (isTerminating) {
                DynamicTextureCache.Text terminus = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus_bmt"), width / 2, (int)((float)tileSize * 1.25f), fontSizeBig / 2, fontSizeSmall / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
                DrawingHelper.drawString(nativeImage, terminus, tileSize, height, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, backgroundColor, textColor, false);
                DrawingHelper.drawString(nativeImage, terminus, width - tileSize, height, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.BOTTOM, backgroundColor, textColor, false);
            } else {
                String nextStationString = IGui.mergeStations((List)nextStations);
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                nextStationString = IGuiExtension.insertTranslation("gui.tjmetro.next_station_bmt_cjk", "gui.tjmetro.next_station_bmt", 1, nextStationString);
                if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "")).isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.bound_for_bmt_cjk", "gui.tjmetro.bound_for", 1, destinationString));
                }
                DynamicTextureCache.Text textBoundFor = DynamicTextureCache.instance.getText(destinationString, width / 2 - tilePadding * 4, height, fontSizeBig / 2, fontSizeSmall / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
                DynamicTextureCache.Text textNextStation = DynamicTextureCache.instance.getText(nextStationString, width / 2 - tilePadding * 4, height, fontSizeBig / 2, fontSizeSmall / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
                DrawingHelper.drawString(nativeImage, flip ? textBoundFor : textNextStation, tilePadding, height, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                DrawingHelper.drawString(nativeImage, flip ? textNextStation : textBoundFor, width - tilePadding, height, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
            }
            if (transparentColor != 0) {
                DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(transparentColor));
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateNextStation(long platformId, int arrowDirection, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            NativeImage nativeImage;
            ObjectArrayList destinations = new ObjectArrayList();
            ObjectArrayList nextStations = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                if (!simplifiedRoute.getName().isEmpty()) {
                    destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                    nextStations.add((Object)((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex + 1)).getStationName());
                }
            });
            boolean isTerminating = destinations.isEmpty();
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            int tilePadding = tileSize / 4;
            int leftSize = tileSize + tilePadding;
            if (isTerminating) {
                nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
                DynamicTextureCache.Text destination = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus"), width, (int)((float)tileSize * 1.25f), tileSize * 3, tileSize * 3 / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
                DrawingHelper.drawString(nativeImage, destination, width / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            } else {
                boolean renderNextStation;
                int arrowSizeAndPadding;
                switch (arrowDirection) {
                    case 0: 
                    case 3: {
                        arrowSizeAndPadding = -tilePadding;
                        break;
                    }
                    default: {
                        arrowSizeAndPadding = tileSize;
                    }
                }
                String nextStationString = IGui.mergeStations((List)nextStations);
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "");
                if (!destinationString.isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.bound_for_bmt_cjk", "gui.tjmetro.bound_for", 1, destinationString));
                }
                DynamicTextureCache.Text textDestination = DynamicTextureCache.instance.getText(destinationString, width - leftSize - padding * 2, (int)((float)tileSize * 1.25f), tileSize, tileSize / 2, tilePadding, arrowDirection == 2 ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT);
                DynamicTextureCache.Text textNextStations = DynamicTextureCache.instance.getText(nextStationString, width - leftSize - padding * 2, (int)((float)tileSize * 1.25f), fontSizeBig, fontSizeSmall, tilePadding, arrowDirection == 2 ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
                DynamicTextureCache.Text textNextStationSign = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.next_station_cjk", "gui.tjmetro.next_station"), width, (int)((float)tileSize * 1.25f), fontSizeBig, fontSizeSmall, tilePadding, IGui.HorizontalAlignment.CENTER);
                int renderWidth = Math.max(width, leftSize + arrowSizeAndPadding + textDestination.width() + textNextStationSign.width() + tilePadding + textNextStations.width() + leftSize);
                boolean bl = renderNextStation = width - leftSize - arrowSizeAndPadding - textDestination.width() - leftSize > textNextStations.width();
                if (!renderNextStation) {
                    renderWidth = Math.max(width, renderWidth - textNextStations.width() - tilePadding - textNextStationSign.width());
                }
                nativeImage = new NativeImage(NativeImageFormat.RGBA, renderWidth, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, renderWidth, height, DrawingHelper.invertColor(backgroundColor));
                if (arrowDirection == 2) {
                    DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, renderWidth - leftSize - tileSize, padding, tileSize, tileSize, true, 0.0f, 1.0f, textColor, false);
                    DrawingHelper.drawString(nativeImage, textDestination, renderWidth - leftSize - tileSize, height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
                    if (renderNextStation) {
                        DrawingHelper.drawString(nativeImage, textNextStationSign, leftSize - tilePadding, height, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                        DrawingHelper.drawString(nativeImage, textNextStations, leftSize - tilePadding + textNextStationSign.width(), height, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                    }
                } else {
                    if (arrowSizeAndPadding > 0) {
                        DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, leftSize, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor, false);
                    }
                    DrawingHelper.drawString(nativeImage, textDestination, leftSize + arrowSizeAndPadding, height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
                    if (renderNextStation) {
                        DrawingHelper.drawString(nativeImage, textNextStations, renderWidth - leftSize + tilePadding, height, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                        DrawingHelper.drawString(nativeImage, textNextStationSign, renderWidth - leftSize - textNextStations.width() + tilePadding, height, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                    }
                }
            }
            if (transparentColor != 0) {
                DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(transparentColor));
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateNextStationJinjing(long platformId, int arrowDirection, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            NativeImage nativeImage;
            ObjectArrayList destinations = new ObjectArrayList();
            ObjectArrayList nextStations = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                if (!simplifiedRoute.getName().isEmpty()) {
                    destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                    nextStations.add((Object)((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex + 1)).getStationName());
                }
            });
            boolean isTerminating = destinations.isEmpty();
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            int tilePadding = tileSize / 4;
            int leftSize = tileSize + tilePadding;
            Platform platform = (Platform)MinecraftClientData.getInstance().platformIdMap.get(platformId);
            DynamicTextureCache.Text platformName = DynamicTextureCache.instance.getText(platform.getName(), width, tileSize, tileSize * 2, tileSize * 2, tilePadding, arrowDirection == 2 ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
            DynamicTextureCache.Text platformSign = DynamicTextureCache.instance.getText(TextHelper.translatable((String)"gui.tjmetro.platform", (Object[])new Object[0]).getString(), width, (int)((float)tileSize * 1.25f), tileSize * 3, tileSize * 3 / 2, tilePadding, arrowDirection == 2 ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT);
            int nonNextStationWidth = leftSize + platformName.width() + platformSign.width() + leftSize * 2;
            if (isTerminating) {
                DynamicTextureCache.Text destination = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus"), width, (int)((float)tileSize * 1.25f), tileSize * 3, tileSize * 3 / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
                int imageWidth = Math.max(nonNextStationWidth + destination.width() + leftSize, width);
                nativeImage = new NativeImage(NativeImageFormat.RGBA, imageWidth, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, imageWidth, height, DrawingHelper.invertColor(backgroundColor));
                if (arrowDirection == 2) {
                    DrawingHelper.drawString(nativeImage, platformName, imageWidth - leftSize - platformName.width(), height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.drawString(nativeImage, platformSign, imageWidth - leftSize - platformName.width(), height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.fillRectSafe(nativeImage, imageWidth - leftSize - platformName.width() - platformSign.width() - leftSize, 0, padding / 6, height, -16777216);
                    DrawingHelper.drawString(nativeImage, destination, imageWidth - nonNextStationWidth - (imageWidth - nonNextStationWidth - leftSize) / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                } else {
                    DrawingHelper.drawString(nativeImage, platformName, leftSize + platformName.width(), height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.drawString(nativeImage, platformSign, leftSize + platformName.width(), height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.fillRectSafe(nativeImage, leftSize + platformName.width() + platformSign.width() + leftSize, 0, padding / 6, height, -16777216);
                    DrawingHelper.drawString(nativeImage, destination, nonNextStationWidth + (imageWidth - nonNextStationWidth - leftSize) / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                }
            } else {
                boolean renderNextStation;
                int arrowSizeAndPadding;
                switch (arrowDirection) {
                    case 0: 
                    case 3: {
                        arrowSizeAndPadding = -tilePadding;
                        break;
                    }
                    default: {
                        arrowSizeAndPadding = tileSize;
                    }
                }
                String nextStationString = IGui.mergeStations((List)nextStations);
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "");
                if (!destinationString.isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.bound_for_bmt_cjk", "gui.tjmetro.bound_for", 1, destinationString));
                }
                DynamicTextureCache.Text textDestination = DynamicTextureCache.instance.getText(destinationString, width - leftSize - padding * 2, (int)((float)tileSize * 1.25f), tileSize, tileSize / 2, tilePadding, arrowDirection == 2 ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT);
                DynamicTextureCache.Text textNextStations = DynamicTextureCache.instance.getText(nextStationString, width - leftSize - padding * 2, (int)((float)tileSize * 1.25f), fontSizeBig, fontSizeSmall, tilePadding, arrowDirection == 2 ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
                DynamicTextureCache.Text textNextStationSign = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.next_station_cjk", "gui.tjmetro.next_station"), width, (int)((float)tileSize * 1.25f), fontSizeBig, fontSizeSmall, tilePadding, IGui.HorizontalAlignment.CENTER);
                int renderWidth = Math.max(width, nonNextStationWidth + arrowSizeAndPadding + textDestination.width() + textNextStationSign.width() + tilePadding + textNextStations.width() + leftSize);
                boolean bl = renderNextStation = width - leftSize - arrowSizeAndPadding - textDestination.width() - leftSize > textNextStations.width();
                if (!renderNextStation) {
                    renderWidth = Math.max(width, renderWidth - textNextStations.width() - tilePadding - textNextStationSign.width());
                }
                nativeImage = new NativeImage(NativeImageFormat.RGBA, renderWidth, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, renderWidth, height, DrawingHelper.invertColor(backgroundColor));
                if (arrowDirection == 2) {
                    DrawingHelper.drawString(nativeImage, platformName, renderWidth - leftSize - platformName.width(), height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.drawString(nativeImage, platformSign, renderWidth - leftSize - platformName.width(), height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.fillRectSafe(nativeImage, renderWidth - leftSize - platformName.width() - platformSign.width() - leftSize, 0, padding / 6, height, -16777216);
                    DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, renderWidth - nonNextStationWidth - tileSize, padding, tileSize, tileSize, true, 0.0f, 1.0f, textColor, false);
                    DrawingHelper.drawString(nativeImage, textDestination, renderWidth - nonNextStationWidth - arrowSizeAndPadding, height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
                    if (renderNextStation) {
                        DrawingHelper.drawString(nativeImage, textNextStationSign, leftSize - tilePadding, height, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                        DrawingHelper.drawString(nativeImage, textNextStations, leftSize - tilePadding + textNextStationSign.width(), height, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                    }
                } else {
                    if (arrowSizeAndPadding > 0) {
                        DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, nonNextStationWidth, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor, false);
                    }
                    DrawingHelper.drawString(nativeImage, platformName, leftSize + platformName.width(), height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.drawString(nativeImage, platformSign, leftSize + platformName.width(), height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.fillRectSafe(nativeImage, leftSize + platformName.width() + platformSign.width() + leftSize, 0, padding / 6, height, -16777216);
                    DrawingHelper.drawString(nativeImage, textDestination, nonNextStationWidth + arrowSizeAndPadding, height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    if (renderNextStation) {
                        DrawingHelper.drawString(nativeImage, textNextStations, renderWidth - leftSize + tilePadding, height, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                        DrawingHelper.drawString(nativeImage, textNextStationSign, renderWidth - leftSize - textNextStations.width() + tilePadding, height, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.BOTTOM, 0, textColor, false);
                    }
                }
            }
            if (transparentColor != 0) {
                DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(transparentColor));
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateRouteMap(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int routeCount;
            ObjectArrayList routeDetails = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                if (!simplifiedRoute.getName().isEmpty()) {
                    routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex.intValue()));
                }
            });
            if (routeDetails.isEmpty()) {
                MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(simplifiedRoute -> simplifiedRoute.getPlatformIndex(platformId) >= 0).sorted().forEach(simplifiedRoute -> {
                    int currentStationIndex = simplifiedRoute.getPlatformIndex(platformId);
                    if (!simplifiedRoute.getName().isEmpty()) {
                        routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex));
                    }
                });
            }
            if ((routeCount = routeDetails.size()) > 0) {
                float heightScale;
                float widthScale;
                int height;
                int width;
                float yOffset;
                float extraPadding;
                float rawHeight;
                int routeIndex;
                DynamicTextureCache clientCache = DynamicTextureCache.instance;
                ObjectArrayList stationsIdsBefore = new ObjectArrayList();
                ObjectArrayList stationsIdsAfter = new ObjectArrayList();
                ObjectArrayList stationPositions = new ObjectArrayList();
                IntAVLTreeSet colors = new IntAVLTreeSet();
                int[] colorIndices = new int[routeCount];
                int colorIndex = -1;
                int previousColor = -1;
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    stationsIdsBefore.add((Object)new LongArrayList());
                    stationsIdsAfter.add((Object)new LongArrayList());
                    stationPositions.add((Object)new Int2ObjectAVLTreeMap());
                    ObjectIntImmutablePair routeDetail = (ObjectIntImmutablePair)routeDetails.get(routeIndex);
                    ObjectArrayList simplifiedRoutePlatforms = ((SimplifiedRoute)routeDetail.left()).getPlatforms();
                    int currentIndex = routeDetail.rightInt();
                    for (int stationIndex = 0; stationIndex < simplifiedRoutePlatforms.size(); ++stationIndex) {
                        if (stationIndex == currentIndex) continue;
                        long stationId = ((SimplifiedRoutePlatform)simplifiedRoutePlatforms.get(stationIndex)).getStationId();
                        if (stationIndex < currentIndex) {
                            ((LongArrayList)stationsIdsBefore.get(stationsIdsBefore.size() - 1)).add(0, stationId);
                            continue;
                        }
                        ((LongArrayList)stationsIdsAfter.get(stationsIdsAfter.size() - 1)).add(stationId);
                    }
                    int color2 = ((SimplifiedRoute)routeDetail.left()).getColor();
                    colors.add(color2);
                    if (color2 != previousColor) {
                        previousColor = color2;
                    }
                    colorIndices[routeIndex] = ++colorIndex;
                }
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(0, (Object)new StationPosition(0.0f, RouteMapGenerator.getLineOffset(routeIndex, colorIndices), true));
                }
                boolean rotateStationName = ConfigClient.ROTATED_STATION_NAME.get();
                float[] bounds = new float[3];
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(flip ? stationsIdsBefore : stationsIdsAfter), colorIndices, bounds, flip, true);
                float xOffset = bounds[0] + 0.5f;
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(flip ? stationsIdsAfter : stationsIdsBefore), colorIndices, bounds, !flip, false);
                float rawHeightPart = Math.abs(bounds[1]) + (vertical ? 0.6f : 1.0f);
                float rawWidth = xOffset + bounds[0] + 0.5f;
                float rawHeightTotal = rawHeightPart + bounds[2] + (vertical ? 0.6f : 1.0f);
                if (vertical && rawHeightTotal < 5.0f) {
                    rawHeight = 5.0f;
                    extraPadding = (5.0f - rawHeightTotal) / 2.0f;
                    yOffset = rawHeightPart + extraPadding;
                } else {
                    rawHeight = rawHeightTotal;
                    extraPadding = 0.0f;
                    yOffset = rawHeightPart + (rotateStationName ? 0.4f : 0.0f);
                }
                if (rawWidth / rawHeight > aspectRatio) {
                    width = Math.round(rawWidth * (float)scale);
                    height = Math.round((float)width / aspectRatio);
                    widthScale = 1.0f;
                    heightScale = (float)height / rawHeight / (float)scale;
                } else {
                    height = Math.round(rawHeight * (float)scale);
                    width = Math.round((float)height * aspectRatio);
                    heightScale = 1.0f;
                    widthScale = (float)width / rawWidth / (float)scale;
                }
                if (width <= 0 || height <= 0) {
                    return null;
                }
                NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, -1);
                Object2ObjectOpenHashMap stationPositionsGrouped = new Object2ObjectOpenHashMap();
                for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                    SimplifiedRoute simplifiedRoute2 = (SimplifiedRoute)((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).left();
                    int currentIndex = ((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).rightInt();
                    Int2ObjectAVLTreeMap routeStationPositions = (Int2ObjectAVLTreeMap)stationPositions.get(routeIndex2);
                    for (int stationIndex = 0; stationIndex < simplifiedRoute2.getPlatforms().size(); ++stationIndex) {
                        StationPosition stationPosition = (StationPosition)routeStationPositions.get(stationIndex - currentIndex);
                        if (stationIndex < simplifiedRoute2.getPlatforms().size() - 1) {
                            DrawingHelper.drawLine(nativeImage, stationPosition, (StationPosition)routeStationPositions.get(stationIndex + 1 - currentIndex), widthScale, heightScale, xOffset, yOffset, stationIndex < currentIndex ? -5592406 : 0xFF000000 | simplifiedRoute2.getColor());
                        }
                        SimplifiedRoutePlatform simplifiedRoutePlatform = (SimplifiedRoutePlatform)simplifiedRoute2.getPlatforms().get(stationIndex);
                        String key2 = String.format("%s||%s", simplifiedRoutePlatform.getStationName(), simplifiedRoutePlatform.getStationId());
                        if (stationPosition.isCommon && !((ObjectOpenHashSet)stationPositionsGrouped.getOrDefault((Object)key2, (Object)new ObjectOpenHashSet())).stream().noneMatch(stationPosition2 -> ((StationPositionGrouped)stationPosition2).stationPosition.x == stationPosition.x)) continue;
                        IntArrayList interchangeColors = new IntArrayList();
                        ObjectArrayList interchangeNames = new ObjectArrayList();
                        simplifiedRoutePlatform.forEach((color, interchangeRouteNamesForColor) -> {
                            if (!colors.contains(color)) {
                                interchangeColors.add(color);
                                interchangeRouteNamesForColor.forEach(arg_0 -> ((ObjectArrayList)interchangeNames).add(arg_0));
                            }
                        });
                        Data.put((Map)stationPositionsGrouped, (Object)key2, (Object)new StationPositionGrouped(stationPosition, stationIndex - currentIndex, interchangeColors, (ObjectArrayList<String>)interchangeNames), ObjectOpenHashSet::new);
                    }
                }
                int maxStringWidth = (int)((double)scale * 0.9 * (double)((vertical ? heightScale : widthScale) / 2.0f + extraPadding / (float)routeCount));
                stationPositionsGrouped.forEach((key, stationPositionGroupedSet) -> stationPositionGroupedSet.forEach(stationPositionGrouped -> {
                    boolean passed;
                    int x = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.x + xOffset) * (float)scale * widthScale);
                    int y = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.y + yOffset) * (float)scale * heightScale);
                    int lines = ((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? colorIndices[colorIndices.length - 1] : 0;
                    boolean currentStation = ((StationPositionGrouped)stationPositionGrouped).stationOffset == 0;
                    boolean bl = passed = ((StationPositionGrouped)stationPositionGrouped).stationOffset < 0;
                    boolean textBelow = vertical || (((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? Math.abs(((StationPositionGrouped)stationPositionGrouped).stationOffset) % 2 == 0 : (float)y >= yOffset * (float)scale);
                    IntArrayList interchangeColors = ((StationPositionGrouped)stationPositionGrouped).interchangeColors;
                    if (!interchangeColors.isEmpty()) {
                        int lineHeight = lineSize * 2;
                        int lineWidth = (int)Math.ceil((float)lineSize / (float)interchangeColors.size());
                        for (int i = 0; i < interchangeColors.size(); ++i) {
                            for (int drawX = 0; drawX < lineWidth; ++drawX) {
                                for (int drawY = 0; drawY < lineHeight; ++drawY) {
                                    if (rotateStationName) {
                                        DrawingHelper.drawPixelSafe(nativeImage, x + drawX + lineWidth * i - lineWidth * interchangeColors.size() / 2, y + lines * lineSpacing + drawY, 0xFF000000 | interchangeColors.getInt(i));
                                        continue;
                                    }
                                    DrawingHelper.drawPixelSafe(nativeImage, x + drawX + lineWidth * i - lineWidth * interchangeColors.size() / 2, y + (textBelow ? -1 : lines * lineSpacing) + (textBelow ? -drawY : drawY), passed ? -5592406 : 0xFF000000 | interchangeColors.getInt(i));
                                }
                            }
                        }
                        DynamicTextureCache.Text text = clientCache.getText(IGui.mergeStations((List)((StationPositionGrouped)stationPositionGrouped).interchangeNames), maxStringWidth - (vertical ? lineHeight : 0), (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f / 2.0f), fontSizeBig / 2, fontSizeSmall / 2, 0, vertical ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.CENTER);
                        if (rotateStationName) {
                            DrawingHelper.drawString(nativeImage, text, x, y + lines * lineSpacing + lineHeight, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.TOP, 0, -16777216, vertical);
                        } else {
                            DrawingHelper.drawString(nativeImage, text, x, y + (textBelow ? -1 - lineHeight : lines * lineSpacing + lineHeight), IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.BOTTOM : IGui.VerticalAlignment.TOP, 0, passed ? -5592406 : -16777216, vertical);
                        }
                    }
                    DrawingHelper.drawStation(nativeImage, x, y, heightScale, lines, passed);
                    DynamicTextureCache.Text text = clientCache.getText(key.split("\\|\\|")[0], maxStringWidth, y - lineSize, (int)((currentStation ? 1.2 : 1.0) * (double)fontSizeBig), (int)((currentStation ? 1.2 : 1.0) * (double)fontSizeSmall), fontSizeSmall / 4, vertical ? IGui.HorizontalAlignment.RIGHT : (rotateStationName ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.CENTER), 1.25f, false, rotateStationName);
                    if (rotateStationName) {
                        DrawingHelper.drawString(nativeImage, text, x - lineSize * 3 / 2, y - lineSize, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, passed ? -5592406 : -16777216, vertical);
                    } else {
                        DrawingHelper.drawString(nativeImage, text, x, y + (textBelow ? lines * lineSpacing : -1) + (textBelow ? 1 : -1) * lineSize * 5 / 4, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.TOP : IGui.VerticalAlignment.BOTTOM, currentStation ? -16777216 : 0, passed ? -5592406 : (currentStation ? -1 : -16777216), vertical);
                    }
                }));
                if (transparentWhite) {
                    DrawingHelper.clearColor(nativeImage, -1);
                }
                return nativeImage;
            }
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static NativeImage generateRouteMapTRT(long platformId, boolean vertical, boolean flip, float aspectRatio, boolean transparentWhite) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int routeCount;
            ObjectArrayList routeDetails = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                if (!simplifiedRoute.getName().isEmpty()) {
                    routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex.intValue()));
                }
            });
            if (routeDetails.isEmpty()) {
                MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(simplifiedRoute -> simplifiedRoute.getPlatformIndex(platformId) >= 0).sorted().forEach(simplifiedRoute -> {
                    int currentStationIndex = simplifiedRoute.getPlatformIndex(platformId);
                    if (!simplifiedRoute.getName().isEmpty()) {
                        routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex));
                    }
                });
            }
            if ((routeCount = routeDetails.size()) > 0) {
                float heightScale;
                float widthScale;
                int height;
                int width;
                float yOffset;
                float extraPadding;
                float rawHeight;
                int routeIndex;
                DynamicTextureCache clientCache = DynamicTextureCache.instance;
                ObjectArrayList stationsIdsBefore = new ObjectArrayList();
                ObjectArrayList stationsIdsAfter = new ObjectArrayList();
                ObjectArrayList stationPositions = new ObjectArrayList();
                IntAVLTreeSet colors = new IntAVLTreeSet();
                int[] colorIndices = new int[routeCount];
                int colorIndex = -1;
                int previousColor = -1;
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    stationsIdsBefore.add((Object)new LongArrayList());
                    stationsIdsAfter.add((Object)new LongArrayList());
                    stationPositions.add((Object)new Int2ObjectAVLTreeMap());
                    ObjectIntImmutablePair routeDetail = (ObjectIntImmutablePair)routeDetails.get(routeIndex);
                    ObjectArrayList simplifiedRoutePlatforms = ((SimplifiedRoute)routeDetail.left()).getPlatforms();
                    int currentIndex = routeDetail.rightInt();
                    for (int stationIndex = 0; stationIndex < simplifiedRoutePlatforms.size(); ++stationIndex) {
                        if (stationIndex == currentIndex) continue;
                        long stationId = ((SimplifiedRoutePlatform)simplifiedRoutePlatforms.get(stationIndex)).getStationId();
                        if (stationIndex < currentIndex) {
                            ((LongArrayList)stationsIdsBefore.get(stationsIdsBefore.size() - 1)).add(0, stationId);
                            continue;
                        }
                        ((LongArrayList)stationsIdsAfter.get(stationsIdsAfter.size() - 1)).add(stationId);
                    }
                    int color2 = ((SimplifiedRoute)routeDetail.left()).getColor();
                    colors.add(color2);
                    if (color2 != previousColor) {
                        previousColor = color2;
                    }
                    colorIndices[routeIndex] = ++colorIndex;
                }
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(0, (Object)new StationPosition(0.0f, RouteMapGenerator.getLineOffset(routeIndex, colorIndices), true));
                }
                float[] bounds = new float[3];
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(flip ? stationsIdsBefore : stationsIdsAfter), colorIndices, bounds, flip, true);
                float xOffset = bounds[0] + 0.5f;
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(flip ? stationsIdsAfter : stationsIdsBefore), colorIndices, bounds, !flip, false);
                float rawHeightPart = Math.abs(bounds[1]) + (vertical ? 0.6f : 1.0f);
                float rawWidth = xOffset + bounds[0] + 0.5f;
                float rawHeightTotal = rawHeightPart + bounds[2] + (vertical ? 0.6f : 1.0f);
                if (vertical && rawHeightTotal < 5.0f) {
                    rawHeight = 5.0f;
                    extraPadding = (5.0f - rawHeightTotal) / 2.0f;
                    yOffset = rawHeightPart + extraPadding;
                } else {
                    rawHeight = rawHeightTotal;
                    extraPadding = 0.0f;
                    yOffset = rawHeightPart;
                }
                if (rawWidth / rawHeight > aspectRatio) {
                    width = Math.round(rawWidth * (float)scale);
                    height = Math.round((float)width / aspectRatio);
                    widthScale = 1.0f;
                    heightScale = (float)height / rawHeight / (float)scale;
                } else {
                    height = Math.round(rawHeight * (float)scale);
                    width = Math.round((float)height * aspectRatio);
                    heightScale = 1.0f;
                    widthScale = (float)width / rawWidth / (float)scale;
                }
                if (width <= 0 || height <= 0) {
                    return null;
                }
                NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, 0);
                Object2ObjectOpenHashMap stationPositionsGrouped = new Object2ObjectOpenHashMap();
                for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                    SimplifiedRoute simplifiedRoute2 = (SimplifiedRoute)((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).left();
                    int currentIndex = ((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).rightInt();
                    Int2ObjectAVLTreeMap routeStationPositions = (Int2ObjectAVLTreeMap)stationPositions.get(routeIndex2);
                    for (int stationIndex = 0; stationIndex < simplifiedRoute2.getPlatforms().size(); ++stationIndex) {
                        StationPosition stationPosition = (StationPosition)routeStationPositions.get(stationIndex - currentIndex);
                        if (stationIndex < simplifiedRoute2.getPlatforms().size() - 1) {
                            DrawingHelper.drawLine(nativeImage, stationPosition, (StationPosition)routeStationPositions.get(stationIndex + 1 - currentIndex), widthScale, heightScale, xOffset, yOffset, stationIndex < currentIndex ? -5592406 : 0xFF000000 | simplifiedRoute2.getColor());
                        }
                        SimplifiedRoutePlatform simplifiedRoutePlatform = (SimplifiedRoutePlatform)simplifiedRoute2.getPlatforms().get(stationIndex);
                        String key2 = String.format("%s||%s", simplifiedRoutePlatform.getStationName(), simplifiedRoutePlatform.getStationId());
                        if (stationPosition.isCommon && !((ObjectOpenHashSet)stationPositionsGrouped.getOrDefault((Object)key2, (Object)new ObjectOpenHashSet())).stream().noneMatch(stationPosition2 -> ((StationPositionGrouped)stationPosition2).stationPosition.x == stationPosition.x)) continue;
                        IntArrayList interchangeColors = new IntArrayList();
                        ObjectArrayList interchangeNames = new ObjectArrayList();
                        simplifiedRoutePlatform.forEach((color, interchangeRouteNamesForColor) -> {
                            if (!colors.contains(color)) {
                                interchangeRouteNamesForColor.forEach(name -> {
                                    interchangeColors.add(color);
                                    interchangeNames.add(name);
                                });
                            }
                        });
                        Data.put((Map)stationPositionsGrouped, (Object)key2, (Object)new StationPositionGrouped(stationPosition, stationIndex - currentIndex, interchangeColors, (ObjectArrayList<String>)interchangeNames), ObjectOpenHashSet::new);
                    }
                }
                int maxStringWidth = (int)((double)scale * 0.9 * (double)((vertical ? heightScale : widthScale) / 2.0f + extraPadding / (float)routeCount));
                stationPositionsGrouped.forEach((key, stationPositionGroupedSet) -> stationPositionGroupedSet.forEach(stationPositionGrouped -> {
                    boolean passed;
                    int x = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.x + xOffset) * (float)scale * widthScale);
                    int y = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.y + yOffset) * (float)scale * heightScale);
                    int lines = ((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? colorIndices[colorIndices.length - 1] : 0;
                    boolean currentStation = ((StationPositionGrouped)stationPositionGrouped).stationOffset == 0;
                    boolean bl = passed = ((StationPositionGrouped)stationPositionGrouped).stationOffset < 0;
                    boolean textBelow = vertical || (((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? Math.abs(((StationPositionGrouped)stationPositionGrouped).stationOffset) % 2 == 0 : (float)y >= yOffset * (float)scale);
                    IntArrayList interchangeColors = ((StationPositionGrouped)stationPositionGrouped).interchangeColors;
                    if (!interchangeColors.isEmpty()) {
                        int lineHeight = lineSize * 2;
                        int lineWidth = (int)Math.ceil((float)lineSize / (float)interchangeColors.size());
                        for (int i = 0; i < interchangeColors.size(); ++i) {
                            for (int drawX = 0; drawX < lineWidth; ++drawX) {
                                for (int drawY = 0; drawY < lineHeight; ++drawY) {
                                    DrawingHelper.drawPixelSafe(nativeImage, x + drawX + lineWidth * i - lineWidth * interchangeColors.size() / 2, y + (textBelow ? -1 : lines * lineSpacing) + (textBelow ? -drawY : drawY), 0xFF000000 | interchangeColors.getInt(i));
                                }
                            }
                        }
                        int interchangesWidth = 0;
                        int interchangesHeight = 0;
                        ObjectArrayList interchanges = new ObjectArrayList();
                        for (int i = 0; i < ((StationPositionGrouped)stationPositionGrouped).interchangeNames.size(); ++i) {
                            DynamicTextureCache.Text text = clientCache.getText((String)((StationPositionGrouped)stationPositionGrouped).interchangeNames.get(i), maxStringWidth, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f / 2.0f), fontSizeBig / 2, fontSizeSmall / 2, 0, IGui.HorizontalAlignment.CENTER);
                            interchanges.add((Object)text);
                            interchangesWidth += text.renderWidth();
                            interchangesHeight = Math.max(interchangesHeight, text.height());
                        }
                        if (interchangesWidth > 0) {
                            int renderX = x - interchangesWidth / 2;
                            for (int i = 0; i < interchanges.size(); ++i) {
                                DrawingHelper.fillRectSafe(nativeImage, renderX, y + (textBelow ? -lineHeight - interchangesHeight : lines * lineSpacing + lineHeight), ((DynamicTextureCache.Text)interchanges.get(i)).renderWidth(), interchangesHeight, DrawingHelper.invertColor(0xFF000000 | interchangeColors.getInt(i)));
                                DrawingHelper.drawString(nativeImage, (DynamicTextureCache.Text)interchanges.get(i), renderX, y + (textBelow ? -lineHeight : lines * lineSpacing + lineHeight + interchangesHeight / 2), IGui.HorizontalAlignment.LEFT, textBelow ? IGui.VerticalAlignment.BOTTOM : IGui.VerticalAlignment.CENTER, 0, -1, false);
                                renderX += ((DynamicTextureCache.Text)interchanges.get(i)).renderWidth();
                            }
                        }
                    }
                    DrawingHelper.drawStation(nativeImage, x, y, heightScale, lines, passed);
                    DynamicTextureCache.Text text = clientCache.getText(key.split("\\|\\|")[0], maxStringWidth, y - lineSize, (int)((currentStation ? 1.2 : 1.0) * (double)fontSizeBig), (int)((currentStation ? 1.2 : 1.0) * (double)fontSizeSmall), fontSizeSmall / 4, vertical ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.CENTER, 1.25f, false, false);
                    DrawingHelper.drawString(nativeImage, text, x, y + (textBelow ? lines * lineSpacing : -1) + (textBelow ? 1 : -1) * lineSize * 5 / 4, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.TOP : IGui.VerticalAlignment.BOTTOM, currentStation ? 0xFF000000 | ((SimplifiedRoute)((ObjectIntImmutablePair)routeDetails.get(lines)).left()).getColor() : 0, passed ? -5592406 : -1, vertical);
                }));
                return nativeImage;
            }
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static NativeImage generateRouteMapPSDBMT(long platformId, boolean flip, float aspectRatio, boolean transparentWhite) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int routeCount;
            ObjectArrayList routeDetails = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                if (!simplifiedRoute.getName().isEmpty()) {
                    routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex.intValue()));
                }
            });
            if (routeDetails.isEmpty()) {
                MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(simplifiedRoute -> simplifiedRoute.getPlatformIndex(platformId) >= 0).sorted().forEach(simplifiedRoute -> {
                    int currentStationIndex = simplifiedRoute.getPlatformIndex(platformId);
                    if (!simplifiedRoute.getName().isEmpty()) {
                        routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex));
                    }
                });
            }
            if ((routeCount = routeDetails.size()) > 0) {
                float heightScale;
                float widthScale;
                int height;
                int width;
                int routeIndex;
                DynamicTextureCache clientCache = DynamicTextureCache.instance;
                ObjectArrayList stationsIdsBefore = new ObjectArrayList();
                ObjectArrayList stationsIdsAfter = new ObjectArrayList();
                ObjectArrayList stationPositions = new ObjectArrayList();
                IntAVLTreeSet colors = new IntAVLTreeSet();
                int[] colorIndices = new int[routeCount];
                int colorIndex = -1;
                int previousColor = -1;
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    stationsIdsBefore.add((Object)new LongArrayList());
                    stationsIdsAfter.add((Object)new LongArrayList());
                    stationPositions.add((Object)new Int2ObjectAVLTreeMap());
                    ObjectIntImmutablePair routeDetail = (ObjectIntImmutablePair)routeDetails.get(routeIndex);
                    ObjectArrayList simplifiedRoutePlatforms = ((SimplifiedRoute)routeDetail.left()).getPlatforms();
                    int currentIndex = routeDetail.rightInt();
                    for (int stationIndex = 0; stationIndex < simplifiedRoutePlatforms.size(); ++stationIndex) {
                        if (stationIndex == currentIndex) continue;
                        long stationId = ((SimplifiedRoutePlatform)simplifiedRoutePlatforms.get(stationIndex)).getStationId();
                        if (stationIndex < currentIndex) {
                            ((LongArrayList)stationsIdsBefore.get(stationsIdsBefore.size() - 1)).add(0, stationId);
                            continue;
                        }
                        ((LongArrayList)stationsIdsAfter.get(stationsIdsAfter.size() - 1)).add(stationId);
                    }
                    int color2 = ((SimplifiedRoute)routeDetail.left()).getColor();
                    colors.add(color2);
                    if (color2 != previousColor) {
                        previousColor = color2;
                    }
                    colorIndices[routeIndex] = ++colorIndex;
                }
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(0, (Object)new StationPosition(0.0f, RouteMapGenerator.getLineOffset(routeIndex, colorIndices), true));
                }
                float[] bounds = new float[3];
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(flip ? stationsIdsBefore : stationsIdsAfter), colorIndices, bounds, flip, true);
                float xOffset = bounds[0] + 0.5f;
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(flip ? stationsIdsAfter : stationsIdsBefore), colorIndices, bounds, !flip, false);
                float rawHeightPart = Math.abs(bounds[1]) + 1.78f;
                float rawWidth = xOffset + bounds[0] + 0.5f;
                float rawHeight = rawHeightPart + bounds[2] + 1.0f;
                float extraPadding = 0.0f;
                if (rawWidth / rawHeight > aspectRatio) {
                    width = Math.round(rawWidth * (float)scale);
                    height = Math.round((float)width / aspectRatio);
                    widthScale = 1.0f;
                    heightScale = (float)height / rawHeight / (float)scale;
                } else {
                    height = Math.round(rawHeight * (float)scale);
                    width = Math.round((float)height * aspectRatio);
                    heightScale = 1.0f;
                    widthScale = (float)width / rawWidth / (float)scale;
                }
                if (width <= 0 || height <= 0) {
                    return null;
                }
                NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, -1);
                Object2ObjectOpenHashMap stationPositionsGrouped = new Object2ObjectOpenHashMap();
                for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                    SimplifiedRoute simplifiedRoute2 = (SimplifiedRoute)((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).left();
                    int currentIndex = ((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).rightInt();
                    Int2ObjectAVLTreeMap routeStationPositions = (Int2ObjectAVLTreeMap)stationPositions.get(routeIndex2);
                    for (int stationIndex = 0; stationIndex < simplifiedRoute2.getPlatforms().size(); ++stationIndex) {
                        StationPosition stationPosition = (StationPosition)routeStationPositions.get(stationIndex - currentIndex);
                        if (stationIndex < simplifiedRoute2.getPlatforms().size() - 1) {
                            DrawingHelper.drawLine(nativeImage, stationPosition, (StationPosition)routeStationPositions.get(stationIndex + 1 - currentIndex), widthScale, heightScale, xOffset, rawHeightPart + 0.4f, stationIndex < currentIndex ? -5592406 : 0xFF000000 | simplifiedRoute2.getColor());
                        }
                        SimplifiedRoutePlatform simplifiedRoutePlatform = (SimplifiedRoutePlatform)simplifiedRoute2.getPlatforms().get(stationIndex);
                        String key2 = String.format("%s||%s", simplifiedRoutePlatform.getStationName(), simplifiedRoutePlatform.getStationId());
                        if (stationPosition.isCommon && !((ObjectOpenHashSet)stationPositionsGrouped.getOrDefault((Object)key2, (Object)new ObjectOpenHashSet())).stream().noneMatch(stationPosition2 -> ((StationPositionGrouped)stationPosition2).stationPosition.x == stationPosition.x)) continue;
                        IntArrayList interchangeColors = new IntArrayList();
                        ObjectArrayList interchangeNames = new ObjectArrayList();
                        simplifiedRoutePlatform.forEach((color, interchangeRouteNamesForColor) -> {
                            if (!colors.contains(color)) {
                                interchangeRouteNamesForColor.forEach(name -> {
                                    interchangeColors.add(color);
                                    interchangeNames.add(name);
                                });
                            }
                        });
                        Data.put((Map)stationPositionsGrouped, (Object)key2, (Object)new StationPositionGrouped(stationPosition, stationIndex - currentIndex, interchangeColors, (ObjectArrayList<String>)interchangeNames), ObjectOpenHashSet::new);
                    }
                }
                int maxStringWidth = (int)((double)scale * 0.9 * (double)(widthScale / 2.0f + 0.0f / (float)routeCount));
                stationPositionsGrouped.forEach((key, stationPositionGroupedSet) -> stationPositionGroupedSet.forEach(stationPositionGrouped -> {
                    int x = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.x + xOffset) * (float)scale * widthScale);
                    int y = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.y + rawHeightPart + 0.4f) * (float)scale * heightScale);
                    int lines = ((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? colorIndices[colorIndices.length - 1] : 0;
                    boolean currentStation = ((StationPositionGrouped)stationPositionGrouped).stationOffset == 0;
                    IntArrayList interchangeColors = ((StationPositionGrouped)stationPositionGrouped).interchangeColors;
                    if (!interchangeColors.isEmpty()) {
                        int lineHeight = lineSize * 2;
                        int lineWidth = (int)Math.ceil((float)lineSize / 4.0f);
                        for (int drawX = 0; drawX < lineWidth; ++drawX) {
                            int drawY = 0;
                            while ((double)drawY < (double)lineSize * 1.8) {
                                DrawingHelper.drawPixelSafe(nativeImage, x + drawX - lineWidth / 2, y + lines * lineSpacing + drawY, -16777216);
                                ++drawY;
                            }
                        }
                        int padding = scale / 32;
                        int interchangesWidth = 0;
                        int interchangesHeight = 0;
                        ObjectArrayList interchanges = new ObjectArrayList();
                        for (int i = 0; i < ((StationPositionGrouped)stationPositionGrouped).interchangeNames.size(); ++i) {
                            DynamicTextureCache.Text text = clientCache.getText((String)((StationPositionGrouped)stationPositionGrouped).interchangeNames.get(i), maxStringWidth, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f / 2.0f), fontSizeBig / 2, fontSizeSmall / 2, 0, IGui.HorizontalAlignment.CENTER);
                            interchanges.add((Object)text);
                            interchangesWidth += text.renderWidth() + padding;
                            interchangesHeight = Math.max(interchangesHeight, text.height());
                        }
                        if ((interchangesWidth -= padding) > 0) {
                            int renderX = x - interchangesWidth / 2;
                            for (int i = 0; i < interchanges.size(); ++i) {
                                DrawingHelper.fillRectSafe(nativeImage, renderX, y + lines * lineSpacing + lineHeight, ((DynamicTextureCache.Text)interchanges.get(i)).renderWidth(), interchangesHeight, DrawingHelper.invertColor(0xFF000000 | interchangeColors.getInt(i)));
                                DrawingHelper.drawString(nativeImage, (DynamicTextureCache.Text)interchanges.get(i), renderX, y + lines * lineSpacing + lineHeight + interchangesHeight / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -1, false);
                                renderX += ((DynamicTextureCache.Text)interchanges.get(i)).renderWidth() + padding;
                            }
                        }
                    }
                    DrawingHelper.drawStationBMT(nativeImage, x, y, heightScale, lines, currentStation);
                    DrawingHelper.drawVerticalString(nativeImage, key.split("\\|\\|")[0], x, y - lineSize * 5 / 4, Integer.MAX_VALUE, y - lineSize * 4, fontSizeBig, fontSizeSmall, fontSizeSmall / 4, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0, currentStation ? -65536 : -16777216);
                }));
                if (transparentWhite) {
                    DrawingHelper.clearColor(nativeImage, -1);
                }
                return nativeImage;
            }
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static NativeImage generateRouteMapJinjing(long platformId, int arrowDirection, float aspectRatio, boolean transparentWhite) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            ObjectArrayList destinations = new ObjectArrayList();
            ObjectArrayList nextStations = new ObjectArrayList();
            ObjectArrayList routeDetails = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                if (!simplifiedRoute.getName().isEmpty()) {
                    String tempMarker;
                    routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex.intValue()));
                    switch (simplifiedRoute.getCircularState()) {
                        case CLOCKWISE: {
                            tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                            break;
                        }
                        case ANTICLOCKWISE: {
                            tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                            break;
                        }
                        default: {
                            tempMarker = "";
                        }
                    }
                    if (!simplifiedRoute.getName().isEmpty()) {
                        destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                        nextStations.add((Object)((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex + 1)).getStationName());
                    }
                }
            });
            if (routeDetails.isEmpty()) {
                MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(simplifiedRoute -> simplifiedRoute.getPlatformIndex(platformId) >= 0).sorted().forEach(simplifiedRoute -> {
                    int currentStationIndex = simplifiedRoute.getPlatformIndex(platformId);
                    if (!simplifiedRoute.getName().isEmpty()) {
                        routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex));
                    }
                });
            }
            boolean isTerminating = destinations.isEmpty();
            int routeCount = routeDetails.size();
            if (routeCount > 0) {
                float heightScale;
                float widthScale;
                int height;
                int width;
                int routeIndex;
                DynamicTextureCache clientCache = DynamicTextureCache.instance;
                ObjectArrayList stationsIdsBefore = new ObjectArrayList();
                ObjectArrayList stationsIdsAfter = new ObjectArrayList();
                ObjectArrayList stationPositions = new ObjectArrayList();
                IntAVLTreeSet colors = new IntAVLTreeSet();
                int[] colorIndices = new int[routeCount];
                int colorIndex = -1;
                int previousColor = -1;
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    stationsIdsBefore.add((Object)new LongArrayList());
                    stationsIdsAfter.add((Object)new LongArrayList());
                    stationPositions.add((Object)new Int2ObjectAVLTreeMap());
                    ObjectIntImmutablePair routeDetail = (ObjectIntImmutablePair)routeDetails.get(routeIndex);
                    ObjectArrayList simplifiedRoutePlatforms = ((SimplifiedRoute)routeDetail.left()).getPlatforms();
                    int currentIndex = routeDetail.rightInt();
                    for (int stationIndex = 0; stationIndex < simplifiedRoutePlatforms.size(); ++stationIndex) {
                        if (stationIndex == currentIndex) continue;
                        long stationId = ((SimplifiedRoutePlatform)simplifiedRoutePlatforms.get(stationIndex)).getStationId();
                        if (stationIndex < currentIndex) {
                            ((LongArrayList)stationsIdsBefore.get(stationsIdsBefore.size() - 1)).add(0, stationId);
                            continue;
                        }
                        ((LongArrayList)stationsIdsAfter.get(stationsIdsAfter.size() - 1)).add(stationId);
                    }
                    int color2 = ((SimplifiedRoute)routeDetail.left()).getColor();
                    colors.add(color2);
                    if (color2 != previousColor) {
                        previousColor = color2;
                    }
                    colorIndices[routeIndex] = ++colorIndex;
                }
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(0, (Object)new StationPosition(0.0f, RouteMapGenerator.getLineOffset(routeIndex, colorIndices), true));
                }
                boolean rotateStationName = ConfigClient.ROTATED_STATION_NAME.get();
                float[] bounds = new float[3];
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(arrowDirection == 2 ? stationsIdsBefore : stationsIdsAfter), colorIndices, bounds, arrowDirection == 2, true);
                float xOffset = bounds[0] + 0.5f;
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(arrowDirection == 2 ? stationsIdsAfter : stationsIdsBefore), colorIndices, bounds, arrowDirection != 2, false);
                float rawHeightPart = Math.abs(bounds[1]) + 1.0f;
                float rawWidth = xOffset + bounds[0] + 0.5f;
                float rawHeightTotal = rawHeightPart + bounds[2] + 3.0f;
                float yOffset = rawHeightPart + (rotateStationName ? 0.6f : 0.0f) + 1.7f;
                float extraPadding = 0.0f;
                if (rawWidth / rawHeightTotal > aspectRatio) {
                    width = Math.round(rawWidth * (float)scale);
                    height = Math.round((float)width / aspectRatio);
                    widthScale = 1.0f;
                    heightScale = (float)height / rawHeightTotal / (float)scale;
                } else {
                    height = Math.round(rawHeightTotal * (float)scale);
                    width = Math.round((float)height * aspectRatio);
                    heightScale = 1.0f;
                    widthScale = (float)width / rawWidth / (float)scale;
                }
                if (width <= 0 || height <= 0) {
                    return null;
                }
                int padding = Math.round((float)height * 0.25f);
                NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, -1);
                String nextStationString = IGui.mergeStations((List)nextStations);
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "");
                if (!destinationString.isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.train_to_cjk", "gui.tjmetro.train_to", 1, destinationString));
                }
                DynamicTextureCache.Text textCurrentStationSign = clientCache.getText(IGuiExtension.mergeTranslation("gui.tjmetro.current_station_cjk", "gui.tjmetro.current_station"), width, height, lineSize * 4, lineSize * 2, 0, IGui.HorizontalAlignment.CENTER);
                DynamicTextureCache.Text textCurrentStation = clientCache.getText(((Station)((Platform)MinecraftClientData.getInstance().platformIdMap.get((long)platformId)).area).getName(), width, height, lineSize * 5, lineSize * 3, 0, IGui.HorizontalAlignment.CENTER);
                int textY = (int)(((float)height - (rawHeightPart + 1.5f) * (float)scale * heightScale) / 2.0f);
                int arrowSize = arrowDirection % 3 == 0 ? 0 : padding;
                int arrowPadding = arrowDirection % 3 == 0 ? 0 : padding / 4;
                boolean shouldRenderCurrentStationText = isTerminating || (double)(textCurrentStation.width() + textCurrentStationSign.width() + padding / 4) / (double)width <= 0.4;
                int CurrentStationSignStartX = (width - textCurrentStationSign.width() - padding - textCurrentStation.width()) / 2;
                if (isTerminating) {
                    DynamicTextureCache.Text textTerminus = clientCache.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus"), arrowDirection == 2 ? width - CurrentStationSignStartX - textCurrentStationSign.width() - padding / 4 - textCurrentStation.width() : CurrentStationSignStartX - padding, height, lineSize * 4, lineSize * 2, 0, IGui.HorizontalAlignment.CENTER);
                    if (arrowDirection == 2) {
                        DrawingHelper.drawString(nativeImage, textTerminus, width - padding, textY, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                    } else {
                        DrawingHelper.drawString(nativeImage, textTerminus, padding, textY, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                    }
                } else {
                    DynamicTextureCache.Text textDestinations;
                    boolean renderDestinationOnly;
                    DynamicTextureCache.Text textNextStations;
                    DynamicTextureCache.Text textNextStationSign = clientCache.getText(IGuiExtension.mergeTranslation("gui.tjmetro.next_station_cjk", "gui.tjmetro.next_station"), width, height, lineSize * 4, lineSize * 2, 0, IGui.HorizontalAlignment.CENTER);
                    if (arrowDirection == 2) {
                        int leftWidthForText = shouldRenderCurrentStationText ? CurrentStationSignStartX - padding - textNextStationSign.width() - padding / 4 : width;
                        textNextStations = clientCache.getText(nextStationString, leftWidthForText, height, lineSize * 4, lineSize * 2, 0, IGui.HorizontalAlignment.CENTER);
                        int rightWidthForText = (shouldRenderCurrentStationText ? width / 2 - textCurrentStation.width() / 2 - padding / 2 : width - padding - textNextStationSign.width() - padding / 4 - textNextStations.width()) - padding - arrowSize - arrowPadding;
                        renderDestinationOnly = (double)rightWidthForText / (double)width < 0.3 && !shouldRenderCurrentStationText;
                        textDestinations = clientCache.getText(destinationString, renderDestinationOnly ? width - padding * 2 - arrowSize - arrowPadding : rightWidthForText, height, lineSize * 4, lineSize * 2, 0, IGui.HorizontalAlignment.RIGHT);
                    } else {
                        int rightWidthForText = shouldRenderCurrentStationText ? width - CurrentStationSignStartX - textCurrentStationSign.width() - padding / 4 - textCurrentStation.width() - textNextStationSign.width() - padding / 4 - padding : width;
                        textNextStations = clientCache.getText(nextStationString, rightWidthForText, height, lineSize * 4, lineSize * 2, 0, IGui.HorizontalAlignment.CENTER);
                        int leftWidthForText = shouldRenderCurrentStationText ? CurrentStationSignStartX - padding - arrowSize - arrowPadding : width - padding * 2 - textNextStations.width() - padding / 4 - textNextStationSign.width();
                        renderDestinationOnly = (double)leftWidthForText / (double)width < 0.3 && !shouldRenderCurrentStationText;
                        textDestinations = clientCache.getText(destinationString, renderDestinationOnly ? width - padding * 2 - arrowSize - arrowPadding : leftWidthForText, height, lineSize * 4, lineSize * 2, 0, IGui.HorizontalAlignment.LEFT);
                    }
                    if (arrowDirection == 2) {
                        if (!renderDestinationOnly) {
                            DrawingHelper.drawString(nativeImage, textNextStationSign, padding, textY, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                            DrawingHelper.drawString(nativeImage, textNextStations, padding + textNextStationSign.width() + padding / 4, textY, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                        }
                        DrawingHelper.drawString(nativeImage, textDestinations, width - padding - arrowSize - arrowPadding, textY, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                        DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, width - padding - arrowSize, textY - arrowSize / 2, arrowSize, arrowSize, true, 0.0f, 1.0f, -16777216, false);
                    } else {
                        DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, padding, textY - arrowSize / 2, arrowSize, arrowSize, false, 0.0f, 1.0f, -16777216, false);
                        DrawingHelper.drawString(nativeImage, textDestinations, padding + arrowSize + arrowPadding, textY, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                        if (!renderDestinationOnly) {
                            DrawingHelper.drawString(nativeImage, textNextStationSign, width - padding - textNextStations.width() - padding / 4, textY, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                            DrawingHelper.drawString(nativeImage, textNextStations, width - padding, textY, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                        }
                    }
                }
                if (shouldRenderCurrentStationText) {
                    DrawingHelper.drawString(nativeImage, textCurrentStationSign, CurrentStationSignStartX, textY, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                    DrawingHelper.drawString(nativeImage, textCurrentStation, (width - textCurrentStation.width() + padding) / 2, textY, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
                }
                Object2ObjectOpenHashMap stationPositionsGrouped = new Object2ObjectOpenHashMap();
                for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                    SimplifiedRoute simplifiedRoute2 = (SimplifiedRoute)((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).left();
                    int currentIndex = ((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).rightInt();
                    Int2ObjectAVLTreeMap routeStationPositions = (Int2ObjectAVLTreeMap)stationPositions.get(routeIndex2);
                    for (int stationIndex = 0; stationIndex < simplifiedRoute2.getPlatforms().size(); ++stationIndex) {
                        StationPosition stationPosition = (StationPosition)routeStationPositions.get(stationIndex - currentIndex);
                        if (stationIndex < simplifiedRoute2.getPlatforms().size() - 1) {
                            DrawingHelper.drawLine(nativeImage, stationPosition, (StationPosition)routeStationPositions.get(stationIndex + 1 - currentIndex), widthScale, heightScale, xOffset, yOffset, stationIndex < currentIndex ? -5592406 : 0xFF000000 | simplifiedRoute2.getColor());
                        }
                        SimplifiedRoutePlatform simplifiedRoutePlatform = (SimplifiedRoutePlatform)simplifiedRoute2.getPlatforms().get(stationIndex);
                        String key2 = String.format("%s||%s", simplifiedRoutePlatform.getStationName(), simplifiedRoutePlatform.getStationId());
                        if (stationPosition.isCommon && !((ObjectOpenHashSet)stationPositionsGrouped.getOrDefault((Object)key2, (Object)new ObjectOpenHashSet())).stream().noneMatch(stationPosition2 -> ((StationPositionGrouped)stationPosition2).stationPosition.x == stationPosition.x)) continue;
                        IntArrayList interchangeColors = new IntArrayList();
                        ObjectArrayList interchangeNames = new ObjectArrayList();
                        simplifiedRoutePlatform.forEach((color, interchangeRouteNamesForColor) -> {
                            if (!colors.contains(color)) {
                                interchangeColors.add(color);
                                interchangeRouteNamesForColor.forEach(arg_0 -> ((ObjectArrayList)interchangeNames).add(arg_0));
                            }
                        });
                        Data.put((Map)stationPositionsGrouped, (Object)key2, (Object)new StationPositionGrouped(stationPosition, stationIndex - currentIndex, interchangeColors, (ObjectArrayList<String>)interchangeNames), ObjectOpenHashSet::new);
                    }
                }
                int maxStringWidth = (int)((double)scale * 0.9 * (double)(widthScale / 2.0f + 0.0f / (float)routeCount));
                stationPositionsGrouped.forEach((key, stationPositionGroupedSet) -> stationPositionGroupedSet.forEach(stationPositionGrouped -> {
                    boolean passed;
                    int x = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.x + xOffset) * (float)scale * widthScale);
                    int y = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.y + yOffset) * (float)scale * heightScale);
                    int lines = ((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? colorIndices[colorIndices.length - 1] : 0;
                    boolean currentStation = ((StationPositionGrouped)stationPositionGrouped).stationOffset == 0;
                    boolean bl = passed = ((StationPositionGrouped)stationPositionGrouped).stationOffset < 0;
                    boolean textBelow = ((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? Math.abs(((StationPositionGrouped)stationPositionGrouped).stationOffset) % 2 == 0 : (float)y >= yOffset * (float)scale;
                    IntArrayList interchangeColors = ((StationPositionGrouped)stationPositionGrouped).interchangeColors;
                    if (!interchangeColors.isEmpty()) {
                        int lineHeight = lineSize * 2;
                        int lineWidth = (int)Math.ceil((float)lineSize / (float)interchangeColors.size());
                        for (int i = 0; i < interchangeColors.size(); ++i) {
                            for (int drawX = 0; drawX < lineWidth; ++drawX) {
                                for (int drawY = 0; drawY < lineHeight; ++drawY) {
                                    if (rotateStationName) {
                                        DrawingHelper.drawPixelSafe(nativeImage, x + drawX + lineWidth * i - lineWidth * interchangeColors.size() / 2, y + lines * lineSpacing + drawY, 0xFF000000 | interchangeColors.getInt(i));
                                        continue;
                                    }
                                    DrawingHelper.drawPixelSafe(nativeImage, x + drawX + lineWidth * i - lineWidth * interchangeColors.size() / 2, y + (textBelow ? -1 : lines * lineSpacing) + (textBelow ? -drawY : drawY), passed ? -5592406 : 0xFF000000 | interchangeColors.getInt(i));
                                }
                            }
                        }
                        DynamicTextureCache.Text text = clientCache.getText(IGui.mergeStations((List)((StationPositionGrouped)stationPositionGrouped).interchangeNames), maxStringWidth, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f / 2.0f), fontSizeBig / 2, fontSizeSmall / 2, 0, IGui.HorizontalAlignment.CENTER);
                        if (rotateStationName) {
                            DrawingHelper.drawString(nativeImage, text, x, y + lines * lineSpacing + lineHeight, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.TOP, 0, -16777216, false);
                        } else {
                            DrawingHelper.drawString(nativeImage, text, x, y + (textBelow ? -1 - lineHeight : lines * lineSpacing + lineHeight), IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.BOTTOM : IGui.VerticalAlignment.TOP, 0, passed ? -5592406 : -16777216, false);
                        }
                    }
                    DrawingHelper.drawStation(nativeImage, x, y, heightScale, lines, passed);
                    DynamicTextureCache.Text text = clientCache.getText(key.split("\\|\\|")[0], maxStringWidth, y - textY - textCurrentStation.height() / 2, (int)((currentStation ? 1.2 : 1.0) * (double)fontSizeBig), (int)((currentStation ? 1.2 : 1.0) * (double)fontSizeSmall), fontSizeSmall / 4, rotateStationName ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.CENTER, 1.25f, false, rotateStationName);
                    if (rotateStationName) {
                        DrawingHelper.drawString(nativeImage, text, x - lineSize * 3 / 2, y - lineSize, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, passed ? -5592406 : -16777216, false);
                    } else {
                        DrawingHelper.drawString(nativeImage, text, x, y + (textBelow ? lines * lineSpacing : -1) + (textBelow ? 1 : -1) * lineSize * 5 / 4, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.TOP : IGui.VerticalAlignment.BOTTOM, currentStation ? -16777216 : 0, passed ? -5592406 : (currentStation ? -1 : -16777216), false);
                    }
                }));
                if (transparentWhite) {
                    DrawingHelper.clearColor(nativeImage, -1);
                }
                return nativeImage;
            }
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static NativeImage generateRouteMapBMT(long platformId, boolean arrowLeft, float aspectRatio, int backgroundColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int routeCount;
            ObjectArrayList destinations = new ObjectArrayList();
            ObjectArrayList routeDetails = new ObjectArrayList();
            IntArrayList routeColors = RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                if (!simplifiedRoute.getName().isEmpty()) {
                    String tempMarker;
                    routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex.intValue()));
                    switch (simplifiedRoute.getCircularState()) {
                        case CLOCKWISE: {
                            tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                            break;
                        }
                        case ANTICLOCKWISE: {
                            tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                            break;
                        }
                        default: {
                            tempMarker = "";
                        }
                    }
                    if (!simplifiedRoute.getName().isEmpty()) {
                        destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                    }
                }
            });
            if (routeDetails.isEmpty()) {
                MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(simplifiedRoute -> simplifiedRoute.getPlatformIndex(platformId) >= 0).sorted().forEach(simplifiedRoute -> {
                    int currentStationIndex = simplifiedRoute.getPlatformIndex(platformId);
                    routeDetails.add((Object)new ObjectIntImmutablePair(simplifiedRoute, currentStationIndex));
                });
                destinations.add((Object)RouteMapGenerator.getStationName(platformId));
            }
            if ((routeCount = routeDetails.size()) > 0) {
                float heightScale;
                float widthScale;
                int height;
                int width;
                int routeIndex;
                DynamicTextureCache clientCache = DynamicTextureCache.instance;
                ObjectArrayList stationsIdsBefore = new ObjectArrayList();
                ObjectArrayList stationsIdsAfter = new ObjectArrayList();
                ObjectArrayList stationPositions = new ObjectArrayList();
                IntAVLTreeSet colors = new IntAVLTreeSet();
                int[] colorIndices = new int[routeCount];
                int colorIndex = -1;
                int previousColor = -1;
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    stationsIdsBefore.add((Object)new LongArrayList());
                    stationsIdsAfter.add((Object)new LongArrayList());
                    stationPositions.add((Object)new Int2ObjectAVLTreeMap());
                    ObjectIntImmutablePair routeDetail = (ObjectIntImmutablePair)routeDetails.get(routeIndex);
                    ObjectArrayList simplifiedRoutePlatforms = ((SimplifiedRoute)routeDetail.left()).getPlatforms();
                    int currentIndex = routeDetail.rightInt();
                    for (int stationIndex = 0; stationIndex < simplifiedRoutePlatforms.size(); ++stationIndex) {
                        if (stationIndex == currentIndex) continue;
                        long stationId = ((SimplifiedRoutePlatform)simplifiedRoutePlatforms.get(stationIndex)).getStationId();
                        if (stationIndex < currentIndex) {
                            ((LongArrayList)stationsIdsBefore.get(stationsIdsBefore.size() - 1)).add(0, stationId);
                            continue;
                        }
                        ((LongArrayList)stationsIdsAfter.get(stationsIdsAfter.size() - 1)).add(stationId);
                    }
                    int color2 = ((SimplifiedRoute)routeDetail.left()).getColor();
                    colors.add(color2);
                    if (color2 != previousColor) {
                        previousColor = color2;
                    }
                    colorIndices[routeIndex] = ++colorIndex;
                }
                for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                    ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(0, (Object)new StationPosition(0.0f, RouteMapGenerator.getLineOffset(routeIndex, colorIndices), true));
                }
                boolean rotateStationName = ConfigClient.ROTATED_STATION_NAME.get();
                float[] bounds = new float[3];
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(arrowLeft ? stationsIdsAfter : stationsIdsBefore), colorIndices, bounds, !arrowLeft, true);
                float xOffset = bounds[0] + 0.5f;
                RouteMapGenerator.setup((ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>>)stationPositions, (ObjectArrayList<LongArrayList>)(arrowLeft ? stationsIdsBefore : stationsIdsAfter), colorIndices, bounds, arrowLeft, false);
                float rawHeightPart = Math.abs(bounds[1]) + 1.0f;
                float rawWidth = xOffset + bounds[0] + 0.5f;
                float rawHeightTotal = rawHeightPart + bounds[2] + 3.0f;
                float yOffset = rawHeightPart + (rotateStationName ? 0.6f : 0.0f) + 1.5f;
                float extraPadding = 0.0f;
                if (rawWidth / rawHeightTotal > aspectRatio) {
                    width = Math.round(rawWidth * (float)scale);
                    height = Math.round((float)width / aspectRatio);
                    widthScale = 1.0f;
                    heightScale = (float)height / rawHeightTotal / (float)scale;
                } else {
                    height = Math.round(rawHeightTotal * (float)scale);
                    width = Math.round((float)height * aspectRatio);
                    heightScale = 1.0f;
                    widthScale = (float)width / rawWidth / (float)scale;
                }
                if (width <= 0 || height <= 0) {
                    return null;
                }
                NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "");
                if (!destinationString.isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.train_to_cjk", "gui.tjmetro.train_to", 1, destinationString));
                }
                List routeNames = routeDetails.stream().map(pair -> ((SimplifiedRoute)pair.left()).getName()).collect(Collectors.toList());
                String information = IGuiExtension.insertTranslation("gui.tjmetro.route_map_bmt_routes", "gui.tjmetro.route_map_bmt_routes", 2, IGui.mergeStations(routeNames), destinationString);
                int padding = (int)((double)((float)height / aspectRatio) * 0.1);
                DynamicTextureCache.Text textInformation = clientCache.getText(information, width - padding * 2, height, (int)((double)((float)(fontSizeBig * height) / aspectRatio) * 0.002), (int)((double)((float)(fontSizeSmall * height) / aspectRatio) * 0.002), 0, arrowLeft ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
                if (arrowLeft) {
                    DrawingHelper.drawString(nativeImage, textInformation, padding, (int)((double)((float)height / aspectRatio) * 0.2), IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -1, false);
                } else {
                    DrawingHelper.drawString(nativeImage, textInformation, width - padding, (int)((double)((float)height / aspectRatio) * 0.2), IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, -1, false);
                }
                int colorStripY = (int)((double)((float)height / aspectRatio) * 0.4);
                int heightPerColor = padding / 2 / routeColors.size();
                for (int i = 0; i < routeColors.size(); ++i) {
                    DrawingHelper.fillRectSafe(nativeImage, 0, colorStripY + heightPerColor * i, width, heightPerColor, DrawingHelper.invertColor(0xFF000000 | routeColors.getInt(i)));
                }
                Object2ObjectOpenHashMap stationPositionsGrouped = new Object2ObjectOpenHashMap();
                for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                    SimplifiedRoute simplifiedRoute2 = (SimplifiedRoute)((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).left();
                    int currentIndex = ((ObjectIntImmutablePair)routeDetails.get(routeIndex2)).rightInt();
                    Int2ObjectAVLTreeMap routeStationPositions = (Int2ObjectAVLTreeMap)stationPositions.get(routeIndex2);
                    for (int stationIndex = 0; stationIndex < simplifiedRoute2.getPlatforms().size(); ++stationIndex) {
                        StationPosition stationPosition = (StationPosition)routeStationPositions.get(stationIndex - currentIndex);
                        if (stationIndex < simplifiedRoute2.getPlatforms().size() - 1) {
                            DrawingHelper.drawLine(nativeImage, stationPosition, (StationPosition)routeStationPositions.get(stationIndex + 1 - currentIndex), widthScale, heightScale, xOffset, yOffset, stationIndex < currentIndex ? -5592406 : 0xFF000000 | simplifiedRoute2.getColor());
                        }
                        SimplifiedRoutePlatform simplifiedRoutePlatform = (SimplifiedRoutePlatform)simplifiedRoute2.getPlatforms().get(stationIndex);
                        String key2 = String.format("%s||%s", simplifiedRoutePlatform.getStationName(), simplifiedRoutePlatform.getStationId());
                        if (stationPosition.isCommon && !((ObjectOpenHashSet)stationPositionsGrouped.getOrDefault((Object)key2, (Object)new ObjectOpenHashSet())).stream().noneMatch(stationPosition2 -> ((StationPositionGrouped)stationPosition2).stationPosition.x == stationPosition.x)) continue;
                        IntArrayList interchangeColors = new IntArrayList();
                        ObjectArrayList interchangeNames = new ObjectArrayList();
                        simplifiedRoutePlatform.forEach((color, interchangeRouteNamesForColor) -> {
                            if (!colors.contains(color)) {
                                interchangeRouteNamesForColor.forEach(name -> {
                                    interchangeColors.add(color);
                                    interchangeNames.add(name);
                                });
                            }
                        });
                        Data.put((Map)stationPositionsGrouped, (Object)key2, (Object)new StationPositionGrouped(stationPosition, stationIndex - currentIndex, interchangeColors, (ObjectArrayList<String>)interchangeNames), ObjectOpenHashSet::new);
                    }
                }
                int maxStringWidth = (int)((double)scale * 0.9 * (double)(widthScale / 2.0f + 0.0f / (float)routeCount));
                stationPositionsGrouped.forEach((key, stationPositionGroupedSet) -> stationPositionGroupedSet.forEach(stationPositionGrouped -> {
                    boolean passed;
                    int x = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.x + xOffset) * (float)scale * widthScale);
                    int y = Math.round((((StationPositionGrouped)stationPositionGrouped).stationPosition.y + yOffset) * (float)scale * heightScale);
                    int lines = ((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? colorIndices[colorIndices.length - 1] : 0;
                    boolean currentStation = ((StationPositionGrouped)stationPositionGrouped).stationOffset == 0;
                    boolean bl = passed = ((StationPositionGrouped)stationPositionGrouped).stationOffset < 0;
                    boolean textBelow = ((StationPositionGrouped)stationPositionGrouped).stationPosition.isCommon ? Math.abs(((StationPositionGrouped)stationPositionGrouped).stationOffset) % 2 == 0 : (float)y >= yOffset * (float)scale;
                    IntArrayList interchangeColors = ((StationPositionGrouped)stationPositionGrouped).interchangeColors;
                    if (!interchangeColors.isEmpty()) {
                        int lineHeight = lineSize * 2;
                        int lineWidth = (int)Math.ceil((float)lineSize / 4.0f);
                        for (int drawX = 0; drawX < lineWidth; ++drawX) {
                            int drawY = 0;
                            while ((double)drawY < (double)lineSize * 1.8) {
                                DrawingHelper.drawPixelSafe(nativeImage, x + drawX - lineWidth / 2, y + lines * lineSpacing + drawY, -1);
                                ++drawY;
                            }
                        }
                        int interchangePadding = scale / 32;
                        int interchangesWidth = 0;
                        int interchangesHeight = 0;
                        ObjectArrayList interchanges = new ObjectArrayList();
                        for (int i = 0; i < ((StationPositionGrouped)stationPositionGrouped).interchangeNames.size(); ++i) {
                            DynamicTextureCache.Text text = clientCache.getText((String)((StationPositionGrouped)stationPositionGrouped).interchangeNames.get(i), maxStringWidth, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f / 2.0f), fontSizeBig / 2, fontSizeSmall / 2, 0, IGui.HorizontalAlignment.CENTER);
                            interchanges.add((Object)text);
                            interchangesWidth += text.renderWidth() + interchangePadding;
                            interchangesHeight = Math.max(interchangesHeight, text.height());
                        }
                        if ((interchangesWidth -= interchangePadding) > 0) {
                            int renderX = x - interchangesWidth / 2;
                            for (int i = 0; i < interchanges.size(); ++i) {
                                DrawingHelper.fillRectSafe(nativeImage, renderX, y + lines * lineSpacing + lineHeight, ((DynamicTextureCache.Text)interchanges.get(i)).renderWidth(), interchangesHeight, DrawingHelper.invertColor(0xFF000000 | interchangeColors.getInt(i)));
                                DrawingHelper.drawString(nativeImage, (DynamicTextureCache.Text)interchanges.get(i), renderX, y + lines * lineSpacing + lineHeight + interchangesHeight / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -1, false);
                                if ((renderX += ((DynamicTextureCache.Text)interchanges.get(i)).renderWidth() + interchangePadding) >= width) break;
                            }
                        }
                    }
                    DrawingHelper.drawStationRouteMapBMT(nativeImage, x, y, heightScale, lines, passed, currentStation);
                    DynamicTextureCache.Text text = clientCache.getText(key.split("\\|\\|")[0], maxStringWidth, y - colorStripY - padding, fontSizeBig, fontSizeSmall, fontSizeSmall / 4, rotateStationName ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.CENTER, 1.25f, false, rotateStationName);
                    if (rotateStationName) {
                        DrawingHelper.drawString(nativeImage, text, x - lineSize * 3 / 2, y - lineSize, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.BOTTOM, 0, passed ? -5592406 : (currentStation ? -16732976 : -1), false);
                    } else {
                        DrawingHelper.drawString(nativeImage, text, x, y + (textBelow ? lines * lineSpacing : -1) + (textBelow ? 1 : -1) * lineSize * 5 / 4, IGui.HorizontalAlignment.CENTER, textBelow ? IGui.VerticalAlignment.TOP : IGui.VerticalAlignment.BOTTOM, currentStation ? -16732976 : 0, passed ? -5592406 : (currentStation ? -1 : -16777216), false);
                    }
                }));
                return nativeImage;
            }
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static NativeImage generateRouteSquare(int color, String routeName, IGui.HorizontalAlignment horizontalAlignment) {
        try {
            int padding = scale / 32;
            DynamicTextureCache.Text text = DynamicTextureCache.instance.getText(routeName, Integer.MAX_VALUE, (int)((float)(fontSizeBig + fontSizeSmall) * 1.25f), fontSizeBig, fontSizeSmall, padding, horizontalAlignment);
            int width = text.renderWidth() + padding * 2;
            int height = text.height() + padding * 2;
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(0xFF000000 | color));
            DrawingHelper.drawString(nativeImage, text, width / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateExitSignLetter(String exitLetter, String exitNumber, int backgroundColor) {
        try {
            int size = scale / 2;
            boolean noNumber = exitNumber.isEmpty();
            int textSize = size * 7 / 8;
            DynamicTextureCache.Text letter = DynamicTextureCache.instance.getText(exitLetter, noNumber ? textSize : textSize * 2 / 3, textSize, textSize, size, size, IGui.HorizontalAlignment.CENTER);
            DynamicTextureCache.Text number = noNumber ? null : DynamicTextureCache.instance.getText(exitNumber, textSize / 3, textSize, textSize / 2, textSize / 2, size, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, size, size, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, size, size, backgroundColor);
            DrawingHelper.drawResource(nativeImage, EXIT_RESOURCE, 0, 0, size, size, false, 0.0f, 1.0f, 0, true);
            DrawingHelper.drawString(nativeImage, letter, size / 2 - (noNumber ? 0 : textSize / 6 - size / 32), size / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            if (!noNumber) {
                DrawingHelper.drawString(nativeImage, number, size / 2 + textSize / 3 - size / 32, size / 2 + textSize / 8, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateExitSignLetterTianjin(String exitLetter, String exitNumber, int backgroundColor, int textColor, boolean forceMTRFont) {
        try {
            int size = scale / 2;
            boolean noNumber = exitNumber.isEmpty();
            int textSize = size;
            DynamicTextureCache.Text letter = DynamicTextureCache.instance.getText(exitLetter, noNumber ? textSize : textSize * 2 / 3, textSize, textSize, size, size, IGui.HorizontalAlignment.CENTER, forceMTRFont);
            DynamicTextureCache.Text number = noNumber ? null : DynamicTextureCache.instance.getText(exitNumber, textSize / 3, textSize, textSize / 2, textSize / 2, size, IGui.HorizontalAlignment.CENTER, forceMTRFont);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, size, size, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, size, size, 0);
            DrawingHelper.drawString(nativeImage, letter, size / 2 - (noNumber ? 0 : textSize / 6 - size / 32), size / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, textColor, false);
            if (!noNumber) {
                DrawingHelper.drawString(nativeImage, number, size / 2 + textSize / 3 - size / 32, size / 2 + textSize / 8, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, textColor, false);
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateBoundFor(long platformId, IGui.HorizontalAlignment horizontalAlignment, float aspectRatio, float paddingScale, int backgroundColor, int textColor, boolean forceMTRFont) {
        try {
            DynamicTextureCache.Text boundFor;
            int height = scale;
            int width = (int)((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            ObjectArrayList destinations = new ObjectArrayList();
            IntArrayList allRoutes = RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
            });
            boolean isTerminating = destinations.isEmpty();
            if (isTerminating) {
                boundFor = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus"), width - padding * 2, height, tileSize * 3 / 5, tileSize * 3 / 10, padding, horizontalAlignment, forceMTRFont);
            } else {
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "")).isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.bound_for_cjk", "gui.tjmetro.bound_for", 1, destinationString));
                }
                boundFor = DynamicTextureCache.instance.getText(destinationString, width - padding * 2, height, tileSize * 3 / 5, tileSize * 3 / 10, padding, horizontalAlignment, forceMTRFont);
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
            DrawingHelper.drawString(nativeImage, boundFor, horizontalAlignment == IGui.HorizontalAlignment.LEFT ? 0 : width, height / 2, horizontalAlignment, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(backgroundColor));
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateTrainTo(long platformId, IGui.HorizontalAlignment horizontalAlignment, float aspectRatio, float paddingScale, int backgroundColor, int textColor, boolean forceMTRFont) {
        try {
            DynamicTextureCache.Text trainTo;
            int height = scale;
            int width = (int)((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            boolean leftToRight = horizontalAlignment == IGui.HorizontalAlignment.LEFT;
            ObjectArrayList destinations = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
            });
            boolean isTerminating = destinations.isEmpty();
            if (isTerminating) {
                trainTo = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus"), width - padding * 2, height, tileSize * 3 / 5, tileSize * 3 / 10, padding, horizontalAlignment, forceMTRFont);
            } else {
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "")).isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.train_to_cjk", "gui.tjmetro.train_to", 1, destinationString));
                }
                trainTo = DynamicTextureCache.instance.getText(destinationString, width - padding * 2 - tileSize, height, tileSize * 3 / 5, tileSize * 3 / 10, padding, horizontalAlignment, forceMTRFont);
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
            DrawingHelper.drawResource(nativeImage, SUBWAY_LOGO_RESOURCE, leftToRight ? 0 : width - tileSize, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor, false);
            DrawingHelper.drawString(nativeImage, trainTo, leftToRight ? tileSize : width - tileSize, height / 2, horizontalAlignment, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(backgroundColor));
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateCrossLineTrainTo(long platformId, IGui.HorizontalAlignment horizontalAlignment, float aspectRatio, float paddingScale, int backgroundColor, int textColor, boolean forceMTRFont) {
        try {
            DynamicTextureCache.Text trainTo;
            int height = scale;
            int width = (int)((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            boolean leftToRight = horizontalAlignment == IGui.HorizontalAlignment.LEFT;
            ObjectArrayList destinations = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
            });
            boolean isTerminating = destinations.isEmpty();
            if (isTerminating) {
                trainTo = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus"), width - padding * 2, height, tileSize * 3 / 5, tileSize * 3 / 10, padding, horizontalAlignment, forceMTRFont);
            } else {
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                if (!(destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "")).isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.cross_line_train_to_cjk", "gui.tjmetro.cross_line_train_to", 1, destinationString));
                }
                trainTo = DynamicTextureCache.instance.getText(destinationString, width - padding * 2 - tileSize, height, tileSize * 3 / 5, tileSize * 3 / 10, padding, horizontalAlignment, forceMTRFont);
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
            DrawingHelper.drawResource(nativeImage, SUBWAY_LOGO_RESOURCE, leftToRight ? 0 : width - tileSize, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor, false);
            DrawingHelper.drawString(nativeImage, trainTo, leftToRight ? tileSize : width - tileSize, height / 2, horizontalAlignment, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(backgroundColor));
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateSignText(String string, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, int backgroundColor, int textColor) {
        try {
            int height = scale;
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            int tilePadding = tileSize / 4;
            DynamicTextureCache.Text text = DynamicTextureCache.instance.getText(string, Integer.MAX_VALUE, (int)((float)tileSize * 1.25f), tileSize * 3 / 5, tileSize * 3 / 10, tilePadding, horizontalAlignment);
            int width = text.renderWidth() - tilePadding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, 0);
            DrawingHelper.drawString(nativeImage, text, width / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(backgroundColor));
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationNameEntrance(long stationId, long selectedId, int style, String stationName, BlockStationNameEntranceTianjin.Type type, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            Identifier resource;
            int size = scale * 2;
            int width = Math.round((float)size * aspectRatio);
            int padding = scale / 16;
            DynamicTextureCache.Text text = DynamicTextureCache.instance.getText(stationName, width - size - padding, size - padding * 2, fontSizeBig * 3, fontSizeSmall * 3, padding, IGui.HorizontalAlignment.CENTER);
            DynamicTextureCache.Text exit = DynamicTextureCache.instance.getText(EditStationScreen.deserializeExit((long)selectedId), width - size - padding, size - padding * 2, fontSizeBig * 3, fontSizeBig * 7, padding, IGui.HorizontalAlignment.CENTER);
            int iconOffset = (int)((float)size * 0.25f / 2.0f);
            int iconSize = (int)((float)size * 0.75f);
            boolean backgroundColor = false;
            AtomicInteger totalWidth = new AtomicInteger(iconOffset + iconSize + text.width());
            ArrayList routes = new ArrayList();
            switch (style) {
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    Station station = (Station)MinecraftClientData.getInstance().stationIdMap.get(stationId);
                    ObjectArraySet connectingStationsIncludingThisOne = new ObjectArraySet((ObjectSet)station.connectedStations);
                    connectingStationsIncludingThisOne.add((Object)station);
                    LongAVLTreeSet platformIds = new LongAVLTreeSet();
                    connectingStationsIncludingThisOne.forEach(connectingStation -> connectingStation.savedRails.forEach(platform -> platformIds.add(platform.getId())));
                    HashSet addedColors = new HashSet();
                    MinecraftClientData.getInstance().simplifiedRoutes.forEach(simplifiedRoute -> {
                        DashboardListItem route;
                        int color = simplifiedRoute.getColor();
                        if (!addedColors.contains(color) && simplifiedRoute.getPlatforms().stream().anyMatch(simplifiedRoutePlatform -> platformIds.contains(simplifiedRoutePlatform.getPlatformId())) && !(route = new DashboardListItem((long)color, simplifiedRoute.getName().split("\\|\\|")[0], color)).getName(false).isEmpty()) {
                            DynamicTextureCache.Text routeName = DynamicTextureCache.instance.getText(route.getName(false), Integer.MAX_VALUE, iconSize, (int)((float)fontSizeBig * 2.5f), (int)((float)fontSizeSmall * 2.5f), padding, IGui.HorizontalAlignment.LEFT);
                            routes.add(new ObjectIntImmutablePair((Object)routeName, route.getColor(false)));
                            totalWidth.addAndGet(padding * 5 + routeName.width());
                            addedColors.add(color);
                        }
                    });
                    totalWidth.addAndGet(iconOffset);
                    totalWidth.addAndGet(padding * (routes.isEmpty() ? -5 : -2));
                }
            }
            if (selectedId != -1L) {
                totalWidth.addAndGet(iconOffset + exit.width());
            }
            width = Math.max(width, totalWidth.get());
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, size, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, size, 0);
            AtomicInteger currentX = new AtomicInteger(iconOffset + iconSize);
            if (!routes.isEmpty()) {
                currentX.addAndGet(iconOffset);
            }
            routes.forEach(route -> {
                DrawingHelper.fillRectSafe(nativeImage, currentX.get(), iconOffset, padding * 3 + ((DynamicTextureCache.Text)route.left()).width(), iconSize, DrawingHelper.invertColor(0xFF000000 | (Integer)route.right()));
                DrawingHelper.drawString(nativeImage, (DynamicTextureCache.Text)route.left(), currentX.get() + padding, size / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, -1, false);
                currentX.addAndGet(padding * 5 + ((DynamicTextureCache.Text)route.left()).width());
            });
            if (!routes.isEmpty()) {
                currentX.addAndGet(padding * -3);
            }
            if (selectedId != -1L) {
                currentX.addAndGet(-iconOffset - exit.width());
            }
            switch (type) {
                case TRT: {
                    resource = TRAIN_LOGO_RESOURCE;
                    break;
                }
                case BMT: {
                    resource = TRAIN_BMT_LOGO_RESOURCE;
                    break;
                }
                case JINJING: {
                    resource = TRAIN_JINJING_LOGO_RESOURCE;
                    break;
                }
                default: {
                    resource = null;
                }
            }
            DrawingHelper.drawResource(nativeImage, resource, iconOffset, iconOffset, iconSize, iconSize, false, 0.0f, 1.0f, 0, true);
            DrawingHelper.drawString(nativeImage, text, (width + currentX.get()) / 2, size / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            if (selectedId != -1L) {
                DrawingHelper.drawString(nativeImage, exit, width - iconOffset, size / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, -1, false);
            }
            DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(0));
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationNamePlate(long platformId, int arrowDirection, int backgroundColor, float paddingScale, float aspectRatio, int textColor, int transparentColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            NativeImage nativeImage;
            if (platformId == 0L) {
                return null;
            }
            ObjectArrayList destinations = new ObjectArrayList();
            ObjectArrayList nextStations = new ObjectArrayList();
            RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                if (!simplifiedRoute.getName().isEmpty()) {
                    destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                    nextStations.add((Object)((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex + 1)).getStationName());
                }
            });
            boolean isTerminating = destinations.isEmpty();
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * paddingScale);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            int tilePadding = tileSize / 4;
            if (isTerminating) {
                DynamicTextureCache.Text destination = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus_bmt"), width, (int)((float)tileSize * 1.25f), tileSize, tileSize / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
                DynamicTextureCache.Text stationName = DynamicTextureCache.instance.getText(RouteMapGenerator.getStationName(platformId), width, height - tilePadding * 2, tileSize * 4 / 3, tileSize * 2 / 3, tilePadding, IGui.HorizontalAlignment.CENTER);
                int imageWidth = Math.max(width, destination.width() + destination.renderWidth() + stationName.width());
                nativeImage = new NativeImage(NativeImageFormat.RGBA, imageWidth, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, imageWidth, height, DrawingHelper.invertColor(backgroundColor));
                DrawingHelper.drawString(nativeImage, destination, tilePadding, height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                DrawingHelper.drawString(nativeImage, stationName, imageWidth / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                DrawingHelper.drawString(nativeImage, destination, imageWidth - tilePadding, height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
            } else {
                boolean renderNextStation;
                int arrowSizeAndPadding;
                switch (arrowDirection) {
                    case 0: 
                    case 3: {
                        arrowSizeAndPadding = -tilePadding;
                        break;
                    }
                    default: {
                        arrowSizeAndPadding = tileSize;
                    }
                }
                String nextStationString = IGui.mergeStations((List)nextStations);
                String destinationString = IGui.mergeStations((List)destinations);
                boolean isClockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_CLOCKWISE);
                boolean isAnticlockwise = destinationString.startsWith(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE);
                destinationString = destinationString.replace(TEMP_CIRCULAR_MARKER_CLOCKWISE, "").replace(TEMP_CIRCULAR_MARKER_ANTICLOCKWISE, "");
                if (!destinationString.isEmpty()) {
                    destinationString = isClockwise ? IGuiExtension.insertTranslation("gui.mtr.clockwise_via_cjk", "gui.mtr.clockwise_via", 1, destinationString) : (isAnticlockwise ? IGuiExtension.insertTranslation("gui.mtr.anticlockwise_via_cjk", "gui.mtr.anticlockwise_via", 1, destinationString) : IGuiExtension.insertTranslation("gui.tjmetro.bound_for_bmt_cjk", "gui.tjmetro.bound_for", 1, destinationString));
                }
                DynamicTextureCache.Text textDestination = DynamicTextureCache.instance.getText(destinationString, width - tilePadding - padding * 2, (int)((float)tileSize * 1.25f), tileSize, tileSize / 2, tilePadding, arrowDirection == 2 ? IGui.HorizontalAlignment.RIGHT : IGui.HorizontalAlignment.LEFT);
                DynamicTextureCache.Text textNextStations = DynamicTextureCache.instance.getText(IGuiExtension.insertTranslation("gui.tjmetro.next_station_bmt_cjk", "gui.tjmetro.next_station_bmt", 1, nextStationString), width - tilePadding - padding * 2, (int)((float)tileSize * 1.25f), fontSizeBig, fontSizeSmall, tilePadding, IGui.HorizontalAlignment.CENTER);
                DynamicTextureCache.Text textStationName = DynamicTextureCache.instance.getText(RouteMapGenerator.getStationName(platformId), width, (int)((float)tileSize * 1.25f), tileSize, tileSize / 2, tilePadding, IGui.HorizontalAlignment.CENTER);
                int imageWidth = Math.max(width, tilePadding + arrowSizeAndPadding + textDestination.width() + textStationName.width() + textNextStations.width() + tilePadding);
                boolean bl = renderNextStation = width - tilePadding - arrowSizeAndPadding - textDestination.width() - tilePadding - textStationName.width() > textNextStations.width() * 2 / 3;
                if (!renderNextStation) {
                    imageWidth = Math.max(width, imageWidth - textNextStations.width());
                }
                nativeImage = new NativeImage(NativeImageFormat.RGBA, imageWidth, height, false);
                DrawingHelper.fillRectSafe(nativeImage, 0, 0, imageWidth, height, DrawingHelper.invertColor(backgroundColor));
                if (arrowDirection == 2) {
                    DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, imageWidth - tilePadding - tileSize, padding, tileSize, tileSize, true, 0.0f, 1.0f, textColor, false);
                    DrawingHelper.drawString(nativeImage, textDestination, imageWidth - tilePadding - tileSize, height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.drawString(nativeImage, textStationName, (textStationName.width() - textStationName.renderWidth()) / 2 + tilePadding, height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    if (renderNextStation) {
                        DrawingHelper.drawString(nativeImage, textNextStations, (imageWidth + textStationName.width() - textDestination.width() - arrowSizeAndPadding) / 2, height, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0, -2302756, false);
                    }
                } else {
                    if (arrowSizeAndPadding > 0) {
                        DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, tilePadding, padding, tileSize, tileSize, false, 0.0f, 1.0f, textColor, false);
                    }
                    DrawingHelper.drawString(nativeImage, textDestination, tilePadding + arrowSizeAndPadding, height / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    DrawingHelper.drawString(nativeImage, textStationName, imageWidth - (textStationName.width() - textStationName.renderWidth()) / 2 - tilePadding, height / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, 0, textColor, false);
                    if (renderNextStation) {
                        DrawingHelper.drawString(nativeImage, textNextStations, (imageWidth + arrowSizeAndPadding + textDestination.width() - textStationName.width()) / 2, height, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0, -2302756, false);
                    }
                }
            }
            if (transparentColor != 0) {
                DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(transparentColor));
            }
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationNameSignTianjin(long platformId, float aspectRatio, int backgroundColor) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            DynamicTextureCache.Text destinationOrNextStation;
            if (platformId == 0L) {
                return null;
            }
            ObjectArrayList destinations = new ObjectArrayList();
            ObjectArrayList nextStations = new ObjectArrayList();
            IntArrayList routeColors = RouteMapGenerator.getRouteStream(platformId, (simplifiedRoute, currentStationIndex) -> {
                String tempMarker;
                switch (simplifiedRoute.getCircularState()) {
                    case CLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_CLOCKWISE;
                        break;
                    }
                    case ANTICLOCKWISE: {
                        tempMarker = TEMP_CIRCULAR_MARKER_ANTICLOCKWISE;
                        break;
                    }
                    default: {
                        tempMarker = "";
                    }
                }
                if (!simplifiedRoute.getName().isEmpty()) {
                    destinations.add((Object)(tempMarker + ((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex.intValue())).getDestination()));
                    nextStations.add((Object)((SimplifiedRoutePlatform)simplifiedRoute.getPlatforms().get(currentStationIndex + 1)).getStationName());
                }
            });
            boolean isTerminating = destinations.isEmpty();
            int height = scale;
            int width = Math.round((float)height * aspectRatio);
            int padding = Math.round((float)height * 0.05f);
            int tileSize = height - padding * 2;
            if (width <= 0 || height <= 0) {
                return null;
            }
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, DrawingHelper.invertColor(backgroundColor));
            int tilePadding = tileSize / 4;
            DynamicTextureCache.Text stationName = DynamicTextureCache.instance.getText(RouteMapGenerator.getStationName(platformId), width - padding * 2, height - tilePadding * 2, fontSizeBig, fontSizeSmall, 0, IGui.HorizontalAlignment.CENTER);
            if (isTerminating) {
                destinationOrNextStation = DynamicTextureCache.instance.getText(IGuiExtension.mergeTranslation("gui.tjmetro.terminus_cjk", "gui.tjmetro.terminus"), width, (int)((float)tileSize * 1.25f), fontSizeBig / 2, fontSizeSmall / 2, 0, IGui.HorizontalAlignment.CENTER);
            } else {
                String nextStationString = IGui.mergeStations((List)nextStations);
                destinationOrNextStation = DynamicTextureCache.instance.getText(IGuiExtension.insertTranslation("gui.tjmetro.next_station_format_cjk", "gui.tjmetro.next_station_format", 1, nextStationString), width - padding * 2, (int)((float)tileSize * 1.25f), fontSizeBig / 2, fontSizeSmall / 2, 0, IGui.HorizontalAlignment.CENTER);
            }
            DrawingHelper.drawString(nativeImage, stationName, width / 2, (height - destinationOrNextStation.height() - padding * 3) / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -16777216, false);
            int colorStripY = height - destinationOrNextStation.height() - padding * 3;
            int heightPerColor = padding / routeColors.size();
            for (int i = 0; i < routeColors.size(); ++i) {
                DrawingHelper.fillRectSafe(nativeImage, 0, colorStripY + heightPerColor * i, width, heightPerColor, DrawingHelper.invertColor(0xFF000000 | routeColors.getInt(i)));
            }
            DrawingHelper.drawString(nativeImage, destinationOrNextStation, width / 2, height - padding, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.BOTTOM, 0, -16777216, false);
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationNavigator(LongAVLTreeSet selectedRoutes, boolean arrowLeft, int backgroundColor, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int size = scale * 2;
            int width = Math.round((float)size * aspectRatio);
            int padding = scale / 16;
            int iconOffset = (int)((float)size * 0.25f / 2.0f);
            int iconSize = (int)((float)size * 0.75f);
            AtomicInteger totalWidth = new AtomicInteger((iconOffset + iconSize) * 2);
            ArrayList routes = new ArrayList();
            totalWidth.addAndGet(iconOffset);
            selectedRoutes.forEach(routeId -> {
                SimplifiedRoute route = MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(route1 -> route1.getId() == routeId).findFirst().get();
                DynamicTextureCache.Text routeName = DynamicTextureCache.instance.getText(route.getName().split("\\|\\|")[0], Integer.MAX_VALUE, iconSize, (int)((float)fontSizeBig * 2.5f), (int)((float)fontSizeSmall * 2.5f), padding, arrowLeft ? IGui.HorizontalAlignment.LEFT : IGui.HorizontalAlignment.RIGHT);
                routes.add(new ObjectIntImmutablePair((Object)routeName, route.getColor()));
                totalWidth.addAndGet(padding * 5 + routeName.width());
            });
            width = Math.max(width, totalWidth.get());
            NativeImage nativeImage = new NativeImage(NativeImageFormat.RGBA, width, size, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, size, backgroundColor);
            if (arrowLeft) {
                AtomicInteger currentX = new AtomicInteger((iconOffset + iconSize) * 2);
                DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, iconOffset, iconOffset, iconSize, iconSize, false, 0.0f, 1.0f, 0, true);
                DrawingHelper.drawResource(nativeImage, TRAIN_BORDERLESS_LOGO_RESOURCE, iconOffset + iconSize + iconOffset, iconOffset, iconSize, iconSize, false, 0.0f, 1.0f, 0, true);
                currentX.addAndGet(iconOffset);
                routes.forEach(route -> {
                    DrawingHelper.fillRectSafe(nativeImage, currentX.get(), iconOffset, padding * 3 + ((DynamicTextureCache.Text)route.left()).width(), iconSize, DrawingHelper.invertColor(0xFF000000 | (Integer)route.right()));
                    DrawingHelper.drawString(nativeImage, (DynamicTextureCache.Text)route.left(), currentX.get() + padding, size / 2, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.CENTER, (Integer)route.right(), -1, false);
                    currentX.addAndGet(padding * 5 + ((DynamicTextureCache.Text)route.left()).width());
                });
                if (!routes.isEmpty()) {
                    currentX.addAndGet(padding * -3);
                }
            } else {
                AtomicInteger currentX = new AtomicInteger(width - (iconOffset + iconSize) * 2);
                DrawingHelper.drawResource(nativeImage, ARROW_RESOURCE, width - iconOffset - iconSize, iconOffset, iconSize, iconSize, true, 0.0f, 1.0f, 0, true);
                DrawingHelper.drawResource(nativeImage, TRAIN_BORDERLESS_LOGO_RESOURCE, width - (iconOffset + iconSize) * 2, iconOffset, iconSize, iconSize, false, 0.0f, 1.0f, 0, true);
                currentX.addAndGet(-iconOffset);
                routes.forEach(route -> {
                    DrawingHelper.fillRectSafe(nativeImage, currentX.get() - padding * 3 - ((DynamicTextureCache.Text)route.left()).width(), iconOffset, padding * 3 + ((DynamicTextureCache.Text)route.left()).width(), iconSize, DrawingHelper.invertColor(0xFF000000 | (Integer)route.right()));
                    DrawingHelper.drawString(nativeImage, (DynamicTextureCache.Text)route.left(), currentX.get() - padding * 3 / 2, size / 2, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.CENTER, (Integer)route.right(), -1, false);
                    currentX.addAndGet(-(padding * 5 + ((DynamicTextureCache.Text)route.left()).width()));
                });
                if (!routes.isEmpty()) {
                    currentX.addAndGet(padding * 3);
                }
            }
            DrawingHelper.clearColor(nativeImage, DrawingHelper.invertColor(backgroundColor));
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generateStationNameProjector(String stationName, float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            return null;
        }
        try {
            int height = scale * 2;
            int width = Math.round((float)height * aspectRatio);
            int padding = scale / 16;
            DynamicTextureCache.Text text = DynamicTextureCache.instance.getText(stationName, width - padding * 2, height - padding * 2, fontSizeBig * 2, fontSizeSmall * 2, padding, IGui.HorizontalAlignment.CENTER);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), width, height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, width, height, 0);
            DrawingHelper.drawString(nativeImage, text, width / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, 0, -1, false);
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static NativeImage generatePlainText(String text, int backgroundColor, int textColor) {
        try {
            int height = scale;
            int padding = scale / 16;
            DynamicTextureCache.Text instanceText = DynamicTextureCache.instance.getText(text, Integer.MAX_VALUE, height, fontSizeBig, fontSizeBig, padding, null);
            NativeImage nativeImage = new NativeImage(NativeImageFormat.getAbgrMapped(), instanceText.renderWidth(), height, false);
            DrawingHelper.fillRectSafe(nativeImage, 0, 0, instanceText.renderWidth(), height, 0);
            DrawingHelper.drawString(nativeImage, instanceText, instanceText.renderWidth() / 2, height / 2, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, backgroundColor, textColor, false);
            return nativeImage;
        }
        catch (Exception e) {
            TianjinMetro.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected static void setup(ObjectArrayList<Int2ObjectAVLTreeMap<StationPosition>> stationPositions, ObjectArrayList<LongArrayList> stationsIdLists, int[] colorIndices, float[] bounds, boolean passed, boolean reverse) {
        int passedMultiplier = passed ? -1 : 1;
        int reverseMultiplier = reverse ? -1 : 1;
        bounds[0] = 0.0f;
        LongArrayList commonStationIds = new LongArrayList();
        ((LongArrayList)stationsIdLists.get(0)).forEach(stationId -> {
            if (stationId != 0L && !commonStationIds.contains(stationId) && stationsIdLists.stream().allMatch(stationsIds -> stationsIds.contains(stationId))) {
                commonStationIds.add(stationId);
            }
        });
        int positionXOffset = 0;
        int routeCount = stationsIdLists.size();
        int[] traverseIndex = new int[routeCount];
        for (int commonStationIndex = 0; commonStationIndex <= commonStationIds.size(); ++commonStationIndex) {
            int routeIndex;
            boolean lastStation = commonStationIndex == commonStationIds.size();
            long commonStationId = lastStation ? -1L : commonStationIds.getLong(commonStationIndex);
            int intermediateSegmentsMaxCount = 0;
            int[] intermediateSegmentsCounts = new int[routeCount];
            for (int routeIndex2 = 0; routeIndex2 < routeCount; ++routeIndex2) {
                intermediateSegmentsCounts[routeIndex2] = (lastStation ? ((LongArrayList)stationsIdLists.get(routeIndex2)).size() : ((LongArrayList)stationsIdLists.get(routeIndex2)).indexOf(commonStationId) + 1) - traverseIndex[routeIndex2];
                intermediateSegmentsMaxCount = Math.max(intermediateSegmentsMaxCount, intermediateSegmentsCounts[routeIndex2]);
            }
            IntArrayList routesIndicesInSection = new IntArrayList();
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                if (lastStation && intermediateSegmentsCounts[routeIndex] <= 0) continue;
                routesIndicesInSection.add(routeIndex);
            }
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                if (intermediateSegmentsCounts[routeIndex] <= 0) continue;
                float increment = (float)intermediateSegmentsMaxCount / (float)intermediateSegmentsCounts[routeIndex];
                for (int j = 0; j < intermediateSegmentsCounts[routeIndex] - (lastStation ? 0 : 1); ++j) {
                    float stationX = (float)positionXOffset + increment * (float)(j + 1);
                    bounds[0] = Math.max(bounds[0], stationX / 2.0f);
                    float stationY = (float)routesIndicesInSection.indexOf(routeIndex) - (float)(routesIndicesInSection.size() - 1) / 2.0f + RouteMapGenerator.getLineOffset(routeIndex, colorIndices);
                    bounds[1] = Math.min(bounds[1], stationY);
                    bounds[2] = Math.max(bounds[2], stationY);
                    ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(passedMultiplier * (j + traverseIndex[routeIndex] + 1), (Object)new StationPosition((float)reverseMultiplier * stationX / 2.0f, stationY, false));
                }
                int n = routeIndex;
                traverseIndex[n] = traverseIndex[n] + intermediateSegmentsCounts[routeIndex];
            }
            if (lastStation) continue;
            positionXOffset += intermediateSegmentsMaxCount;
            for (routeIndex = 0; routeIndex < routeCount; ++routeIndex) {
                float stationY = RouteMapGenerator.getLineOffset(routeIndex, colorIndices);
                bounds[1] = Math.min(bounds[1], stationY);
                bounds[2] = Math.max(bounds[2], stationY);
                ((Int2ObjectAVLTreeMap)stationPositions.get(routeIndex)).put(passedMultiplier * traverseIndex[routeIndex], (Object)new StationPosition((float)(reverseMultiplier * positionXOffset) / 2.0f, stationY, true));
            }
            bounds[0] = (float)positionXOffset / 2.0f;
        }
    }

    protected static float getLineOffset(int routeIndex, int[] colorIndices) {
        return (float)lineSpacing / (float)scale * ((float)colorIndices[routeIndex] - (float)colorIndices[colorIndices.length - 1] / 2.0f);
    }

    protected static String getStationName(long platformId) {
        Platform platform = (Platform)MinecraftClientData.getInstance().platformIdMap.get(platformId);
        Station station = platform == null ? null : (Station)platform.area;
        return station == null ? "" : station.getName();
    }

    protected static IntArrayList getRouteStream(long platformId, BiConsumer<SimplifiedRoute, Integer> nonTerminatingCallback) {
        IntArrayList colors = new IntArrayList();
        IntArrayList terminatingColors = new IntArrayList();
        MinecraftClientData.getInstance().simplifiedRoutes.stream().filter(simplifiedRoute -> simplifiedRoute.getPlatformIndex(platformId) >= 0).sorted().forEach(simplifiedRoute -> {
            int currentStationIndex = simplifiedRoute.getPlatformIndex(platformId);
            if (currentStationIndex < simplifiedRoute.getPlatforms().size() - 1) {
                nonTerminatingCallback.accept((SimplifiedRoute)simplifiedRoute, currentStationIndex);
                if (!colors.contains(simplifiedRoute.getColor())) {
                    colors.add(simplifiedRoute.getColor());
                }
            } else if (!terminatingColors.contains(simplifiedRoute.getColor())) {
                terminatingColors.add(simplifiedRoute.getColor());
            }
        });
        if (colors.isEmpty()) {
            colors.addAll((IntList)terminatingColors);
        }
        return colors;
    }

    static {
        SUBWAY_LOGO_RESOURCE = new Identifier("tjmetro", "textures/sign/to_subway.png");
        TRAIN_LOGO_RESOURCE = new Identifier("tjmetro", "textures/sign/train.png");
        TRAIN_BORDERLESS_LOGO_RESOURCE = new Identifier("tjmetro", "textures/sign/train_borderless.png");
        TRAIN_BMT_LOGO_RESOURCE = new Identifier("tjmetro", "textures/sign/to_subway_bmt.png");
        TRAIN_JINJING_LOGO_RESOURCE = new Identifier("tjmetro", "textures/sign/to_subway_jinjing.png");
        EXIT_RESOURCE = new Identifier("mtr", "textures/block/sign/exit_letter_blank.png");
        ARROW_RESOURCE = new Identifier("mtr", "textures/block/sign/arrow.png");
        CIRCLE_RESOURCE = new Identifier("mtr", "textures/block/sign/circle.png");
        TEMP_CIRCULAR_MARKER_CLOCKWISE = String.format("temp_circular_marker_%s_clockwise", Integer.toHexString(new Random().nextInt()));
        TEMP_CIRCULAR_MARKER_ANTICLOCKWISE = String.format("temp_circular_marker_%s_anticlockwise", Integer.toHexString(new Random().nextInt()));
    }

    protected static final class StationPositionGrouped {
        private final StationPosition stationPosition;
        private final int stationOffset;
        private final IntArrayList interchangeColors;
        private final ObjectArrayList<String> interchangeNames;

        public StationPositionGrouped(StationPosition stationPosition, int stationOffset, IntArrayList interchangeColors, ObjectArrayList<String> interchangeNames) {
            this.stationPosition = stationPosition;
            this.stationOffset = stationOffset;
            this.interchangeColors = interchangeColors;
            this.interchangeNames = interchangeNames;
        }

        public StationPosition stationPosition() {
            return this.stationPosition;
        }

        public int stationOffset() {
            return this.stationOffset;
        }

        public IntArrayList interchangeColors() {
            return this.interchangeColors;
        }

        public ObjectArrayList<String> interchangeNames() {
            return this.interchangeNames;
        }
    }

    protected static final class StationPosition {
        private final float x;
        private final float y;
        private final boolean isCommon;

        public StationPosition(float x, float y, boolean isCommon) {
            this.x = x;
            this.y = y;
            this.isCommon = isCommon;
        }

        public float x() {
            return this.x;
        }

        public float y() {
            return this.y;
        }

        public boolean isCommon() {
            return this.isCommon;
        }
    }
}

