/*
 * Decompiled with CFR 0.152.
 */
package fabric.ziyue.tjmetro.mod.client;

import fabric.ziyue.tjmetro.mod.TianjinMetro;
import fabric.ziyue.tjmetro.mod.client.DynamicTextureCache;
import fabric.ziyue.tjmetro.mod.client.RouteMapGenerator;
import fabric.ziyue.tjmetro.mod.data.IGuiExtension;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.InputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.mtr.core.tool.Utilities;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.NativeImage;
import org.mtr.mapping.holder.NativeImageFormat;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import org.mtr.mod.data.IGui;

public class DrawingHelper {
    protected static void drawLine(NativeImage nativeImage, RouteMapGenerator.StationPosition stationPosition1, RouteMapGenerator.StationPosition stationPosition2, float widthScale, float heightScale, float xOffset, float yOffset, int color) {
        int x1 = Math.round((stationPosition1.x() + xOffset) * (float)RouteMapGenerator.scale * widthScale);
        int x2 = Math.round((stationPosition2.x() + xOffset) * (float)RouteMapGenerator.scale * widthScale);
        int y1 = Math.round((stationPosition1.y() + yOffset) * (float)RouteMapGenerator.scale * heightScale);
        int y2 = Math.round((stationPosition2.y() + yOffset) * (float)RouteMapGenerator.scale * heightScale);
        int xChange = x2 - x1;
        int yChange = y2 - y1;
        int xChangeAbs = Math.abs(xChange);
        int yChangeAbs = Math.abs(yChange);
        int changeDifference = Math.abs(yChangeAbs - xChangeAbs);
        if (xChangeAbs > yChangeAbs) {
            boolean y1OffsetGreater = Math.abs((float)y1 - yOffset * (float)RouteMapGenerator.scale) > Math.abs((float)y2 - yOffset * (float)RouteMapGenerator.scale);
            DrawingHelper.drawLine(nativeImage, x1, y1, x2 - x1, y1OffsetGreater ? 0 : y2 - y1, y1OffsetGreater ? changeDifference : yChangeAbs, color);
            DrawingHelper.drawLine(nativeImage, x2, y2, x1 - x2, y1OffsetGreater ? y1 - y2 : 0, y1OffsetGreater ? yChangeAbs : changeDifference, color);
        } else {
            int halfXChangeAbs = xChangeAbs / 2;
            DrawingHelper.drawLine(nativeImage, x1, y1, x2 - x1, y2 - y1, halfXChangeAbs, color);
            DrawingHelper.drawLine(nativeImage, x2, y2, x1 - x2, y1 - y2, halfXChangeAbs, color);
            DrawingHelper.drawLine(nativeImage, (x1 + x2) / 2, y1 + (int)Math.copySign(halfXChangeAbs, y2 - y1), 0, y2 - y1, changeDifference, color);
        }
    }

    public static void drawLine(NativeImage nativeImage, int x, int y, int directionX, int directionY, int length, int color) {
        int xWidth;
        int halfLineHeight = RouteMapGenerator.lineSize / 2;
        int n = xWidth = directionX == 0 ? halfLineHeight : 0;
        int yWidth = directionX == 0 ? 0 : (directionY == 0 ? halfLineHeight : Math.round((float)RouteMapGenerator.lineSize * MathHelper.getSquareRootOfTwoMapped() / 2.0f));
        int yMin = y - halfLineHeight - (directionY < 0 ? length : 0) + 1;
        int yMax = y + halfLineHeight + (directionY > 0 ? length : 0) - 1;
        int drawOffset = directionX != 0 && directionY != 0 ? halfLineHeight : 0;
        for (int i = -drawOffset; i < Math.abs(length) + drawOffset; ++i) {
            int drawX = x + (directionX == 0 ? 0 : (int)Math.copySign(i, directionX)) + (directionX < 0 ? -1 : 0);
            int drawY = y + (directionY == 0 ? 0 : (int)Math.copySign(i, directionY)) + (directionY < 0 ? -1 : 0);
            for (int xOffset = 0; xOffset < xWidth; ++xOffset) {
                DrawingHelper.drawPixelSafe(nativeImage, drawX - xOffset - 1, drawY, color);
                DrawingHelper.drawPixelSafe(nativeImage, drawX + xOffset, drawY, color);
            }
            for (int yOffset = 0; yOffset < yWidth; ++yOffset) {
                DrawingHelper.drawPixelSafe(nativeImage, drawX, Math.max(drawY - yOffset, yMin) - 1, color);
                DrawingHelper.drawPixelSafe(nativeImage, drawX, Math.min(drawY + yOffset, yMax), color);
            }
        }
    }

    public static void drawResource(NativeImage nativeImage, Identifier resource, int x, int y, int width, int height, boolean flipX, float v1, float v2, int color, boolean useActualColor) {
        ResourceManagerHelper.readResource((Identifier)resource, inputStream -> {
            try {
                NativeImage nativeImageResource = NativeImage.read((NativeImageFormat)NativeImageFormat.getAbgrMapped(), (InputStream)inputStream);
                int resourceWidth = nativeImageResource.getWidth();
                int resourceHeight = nativeImageResource.getHeight();
                for (int drawX = 0; drawX < width; ++drawX) {
                    for (int drawY = Math.round(v1 * (float)height); drawY < Math.round(v2 * (float)height); ++drawY) {
                        int newColor;
                        float pixelX = (float)drawX / (float)width * (float)resourceWidth;
                        float pixelY = (float)drawY / (float)height * (float)resourceHeight;
                        int floorX = (int)pixelX;
                        int floorY = (int)pixelY;
                        int ceilX = floorX + 1;
                        int ceilY = floorY + 1;
                        float percentX1 = (float)ceilX - pixelX;
                        float percentY1 = (float)ceilY - pixelY;
                        float percentX2 = pixelX - (float)floorX;
                        float percentY2 = pixelY - (float)floorY;
                        int pixel1 = nativeImageResource.getColor(MathHelper.clamp((int)floorX, (int)0, (int)(resourceWidth - 1)), MathHelper.clamp((int)floorY, (int)0, (int)(resourceHeight - 1)));
                        int pixel2 = nativeImageResource.getColor(MathHelper.clamp((int)ceilX, (int)0, (int)(resourceWidth - 1)), MathHelper.clamp((int)floorY, (int)0, (int)(resourceHeight - 1)));
                        int pixel3 = nativeImageResource.getColor(MathHelper.clamp((int)floorX, (int)0, (int)(resourceWidth - 1)), MathHelper.clamp((int)ceilY, (int)0, (int)(resourceHeight - 1)));
                        int pixel4 = nativeImageResource.getColor(MathHelper.clamp((int)ceilX, (int)0, (int)(resourceWidth - 1)), MathHelper.clamp((int)ceilY, (int)0, (int)(resourceHeight - 1)));
                        if (useActualColor) {
                            newColor = DrawingHelper.invertColor(pixel1);
                        } else {
                            float luminance1 = (float)(pixel1 >> 24 & 0xFF) * percentX1 * percentY1;
                            float luminance2 = (float)(pixel2 >> 24 & 0xFF) * percentX2 * percentY1;
                            float luminance3 = (float)(pixel3 >> 24 & 0xFF) * percentX1 * percentY2;
                            float luminance4 = (float)(pixel4 >> 24 & 0xFF) * percentX2 * percentY2;
                            newColor = (color & 0xFFFFFF) + ((int)(luminance1 + luminance2 + luminance3 + luminance4) << 24);
                        }
                        DrawingHelper.blendPixel(nativeImage, (flipX ? width - drawX - 1 : drawX) + x, drawY + y, newColor);
                    }
                }
            }
            catch (Exception e) {
                TianjinMetro.LOGGER.error("", (Throwable)e);
            }
        });
    }

    public static void drawStation(NativeImage nativeImage, int x, int y, float heightScale, int lines, boolean passed) {
        for (int offsetX = -RouteMapGenerator.lineSize; offsetX < RouteMapGenerator.lineSize; ++offsetX) {
            for (int offsetY = -RouteMapGenerator.lineSize; offsetY < RouteMapGenerator.lineSize; ++offsetY) {
                int i;
                int extraOffsetY = offsetY > 0 ? (int)((float)(lines * RouteMapGenerator.lineSpacing) * heightScale) : 0;
                int repeatDraw = offsetY == 0 ? (int)((float)(lines * RouteMapGenerator.lineSpacing) * heightScale) : 0;
                double squareSum = ((double)offsetX + 0.5) * ((double)offsetX + 0.5) + ((double)offsetY + 0.5) * ((double)offsetY + 0.5);
                if (squareSum <= 0.5 * (double)RouteMapGenerator.lineSize * (double)RouteMapGenerator.lineSize) {
                    for (i = 0; i <= repeatDraw; ++i) {
                        DrawingHelper.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, -1);
                    }
                    continue;
                }
                if (!(squareSum <= (double)(RouteMapGenerator.lineSize * RouteMapGenerator.lineSize))) continue;
                for (i = 0; i <= repeatDraw; ++i) {
                    DrawingHelper.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, passed ? -5592406 : -16777216);
                }
            }
        }
    }

    public static void drawStationRouteMapBMT(NativeImage nativeImage, int x, int y, float heightScale, int lines, boolean passed, boolean current) {
        for (int offsetX = -RouteMapGenerator.lineSize; offsetX < RouteMapGenerator.lineSize; ++offsetX) {
            for (int offsetY = -RouteMapGenerator.lineSize; offsetY < RouteMapGenerator.lineSize; ++offsetY) {
                int i;
                int extraOffsetY = offsetY > 0 ? (int)((float)(lines * RouteMapGenerator.lineSpacing) * heightScale) : 0;
                int repeatDraw = offsetY == 0 ? (int)((float)(lines * RouteMapGenerator.lineSpacing) * heightScale) : 0;
                double squareSum = ((double)offsetX + 0.5) * ((double)offsetX + 0.5) + ((double)offsetY + 0.5) * ((double)offsetY + 0.5);
                if (squareSum <= 0.5 * (double)RouteMapGenerator.lineSize * (double)RouteMapGenerator.lineSize) {
                    for (i = 0; i <= repeatDraw; ++i) {
                        DrawingHelper.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, passed ? -5592406 : (current ? -16732976 : -1));
                    }
                    continue;
                }
                if (!(squareSum <= (double)(RouteMapGenerator.lineSize * RouteMapGenerator.lineSize))) continue;
                for (i = 0; i <= repeatDraw; ++i) {
                    DrawingHelper.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, -16762980);
                }
            }
        }
    }

    public static void drawStationBMT(NativeImage nativeImage, int x, int y, float heightScale, int lines, boolean current) {
        for (int offsetX = -RouteMapGenerator.lineSize; offsetX < RouteMapGenerator.lineSize; ++offsetX) {
            for (int offsetY = -RouteMapGenerator.lineSize; offsetY < RouteMapGenerator.lineSize; ++offsetY) {
                int i;
                int extraOffsetY = offsetY > 0 ? (int)((float)(lines * RouteMapGenerator.lineSpacing) * heightScale) : 0;
                int repeatDraw = offsetY == 0 ? (int)((float)(lines * RouteMapGenerator.lineSpacing) * heightScale) : 0;
                double squareSum = ((double)offsetX + 0.5) * ((double)offsetX + 0.5) + ((double)offsetY + 0.5) * ((double)offsetY + 0.5);
                if (squareSum <= 0.7 * (double)RouteMapGenerator.lineSize * (double)RouteMapGenerator.lineSize) {
                    for (i = 0; i <= repeatDraw; ++i) {
                        DrawingHelper.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, current ? -65536 : -16777216);
                    }
                    continue;
                }
                if (!(squareSum <= (double)(RouteMapGenerator.lineSize * RouteMapGenerator.lineSize))) continue;
                for (i = 0; i <= repeatDraw; ++i) {
                    DrawingHelper.drawPixelSafe(nativeImage, x + offsetX, y + offsetY + extraOffsetY + i, -1);
                }
            }
        }
    }

    public static void drawVerticalString(NativeImage nativeImage, String text, int x, int y, int maxWidth, int maxHeight, int fontSizeCjk, int fontSize, int padding, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, int backgroundColor, int textColor) {
        DynamicTextureCache.Text textNonCJK;
        DynamicTextureCache.Text textCJK;
        ImmutablePair<String, String> pair = IGuiExtension.splitTranslation(text);
        if (((String)pair.left).isEmpty()) {
            textCJK = DynamicTextureCache.Text.empty();
            padding = 0;
        } else {
            textCJK = DynamicTextureCache.instance.getText(IGui.formatVerticalChinese((String)((String)pair.left)), maxWidth, Integer.MAX_VALUE, fontSizeCjk, fontSizeCjk, padding, IGui.HorizontalAlignment.LEFT, 1.0f, false);
            if (textCJK.height() > maxHeight) {
                try {
                    BufferedImage image = new BufferedImage(textCJK.renderWidth(), textCJK.height(), 10);
                    byte[] imageBuffer = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    System.arraycopy(textCJK.pixels(), 0, imageBuffer, 0, textCJK.pixels().length);
                    BufferedImage scaledImage = new BufferedImage(textCJK.renderWidth(), maxHeight, 10);
                    Graphics2D graphics = scaledImage.createGraphics();
                    graphics.setColor(Color.WHITE);
                    graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics.drawImage(image, 0, 0, textCJK.renderWidth(), maxHeight, null);
                    byte[] pixels = ((DataBufferByte)scaledImage.getRaster().getDataBuffer()).getData();
                    graphics.dispose();
                    scaledImage.flush();
                    image.flush();
                    textCJK = new DynamicTextureCache.Text(pixels, textCJK.width(), maxHeight, textCJK.renderWidth());
                }
                catch (Exception e) {
                    TianjinMetro.LOGGER.warn("Error when scaling vertical string. Skipping!", (Throwable)e);
                }
            }
        }
        if (((String)pair.right).isEmpty()) {
            textNonCJK = DynamicTextureCache.Text.empty();
            padding = 0;
        } else {
            textNonCJK = DynamicTextureCache.instance.getText((String)pair.right, maxHeight, maxWidth, fontSize, fontSize, padding, IGui.HorizontalAlignment.LEFT, 1.0f, false);
        }
        int width = textCJK.width() + textNonCJK.height() - padding * 2;
        switch (horizontalAlignment) {
            case LEFT: {
                DrawingHelper.drawString(nativeImage, textCJK, x, y, horizontalAlignment, verticalAlignment, backgroundColor, textColor, false);
                DrawingHelper.drawString(nativeImage, textNonCJK, x + textCJK.width(), y, horizontalAlignment, verticalAlignment, backgroundColor, textColor, true);
                break;
            }
            case CENTER: {
                DrawingHelper.drawString(nativeImage, textCJK, x - (textNonCJK.height() - textCJK.width()) / 2 + padding, y, IGui.HorizontalAlignment.RIGHT, verticalAlignment, backgroundColor, textColor, false);
                DrawingHelper.drawString(nativeImage, textNonCJK, x - (textNonCJK.height() - textCJK.width()) / 2, y, IGui.HorizontalAlignment.LEFT, verticalAlignment, backgroundColor, textColor, true);
                break;
            }
            case RIGHT: {
                DrawingHelper.drawString(nativeImage, textCJK, x - width, y, IGui.HorizontalAlignment.LEFT, verticalAlignment, backgroundColor, textColor, false);
                DrawingHelper.drawString(nativeImage, textNonCJK, x - width + textCJK.width(), y, IGui.HorizontalAlignment.LEFT, verticalAlignment, backgroundColor, textColor, true);
            }
        }
    }

    public static void drawString(NativeImage nativeImage, DynamicTextureCache.Text text, int x, int y, IGui.HorizontalAlignment horizontalAlignment, IGui.VerticalAlignment verticalAlignment, int backgroundColor, int textColor, boolean rotate90) {
        int drawY;
        int drawX;
        if (text == null || text.pixels() == null) {
            return;
        }
        if ((backgroundColor >> 24 & 0xFF) > 0) {
            for (drawX = 0; drawX < (rotate90 ? text.height() : text.renderWidth()); ++drawX) {
                for (drawY = 0; drawY < (rotate90 ? text.renderWidth() : text.height()); ++drawY) {
                    DrawingHelper.drawPixelSafe(nativeImage, (int)horizontalAlignment.getOffset((float)(drawX + x), (float)(rotate90 ? text.height() : text.renderWidth())), (int)verticalAlignment.getOffset((float)(drawY + y), (float)(rotate90 ? text.renderWidth() : text.height())), backgroundColor);
                }
            }
        }
        drawX = 0;
        drawY = rotate90 ? text.renderWidth() - 1 : 0;
        for (int i = 0; i < text.renderWidth() * text.height(); ++i) {
            DrawingHelper.blendPixel(nativeImage, (int)horizontalAlignment.getOffset((float)(x + drawX), (float)(rotate90 ? text.height() : text.renderWidth())), (int)verticalAlignment.getOffset((float)(y + drawY), (float)(rotate90 ? text.renderWidth() : text.height())), ((text.pixels()[i] & 0xFF) << 24) + (textColor & 0xFFFFFF));
            if (rotate90) {
                if (--drawY >= 0) continue;
                drawY = text.renderWidth() - 1;
                ++drawX;
                continue;
            }
            if (++drawX != text.renderWidth()) continue;
            drawX = 0;
            ++drawY;
        }
    }

    public static void blendPixel(NativeImage nativeImage, int x, int y, int color) {
        float percent;
        if (Utilities.isBetween((double)x, (double)0.0, (double)(nativeImage.getWidth() - 1)) && Utilities.isBetween((double)y, (double)0.0, (double)(nativeImage.getHeight() - 1)) && (percent = (float)(color >> 24 & 0xFF) / 255.0f) > 0.0f) {
            int existingPixel = nativeImage.getColor(x, y);
            boolean existingTransparent = (existingPixel >> 24 & 0xFF) == 0;
            int r1 = existingTransparent ? 255 : existingPixel & 0xFF;
            int g1 = existingTransparent ? 255 : existingPixel >> 8 & 0xFF;
            int b1 = existingTransparent ? 255 : existingPixel >> 16 & 0xFF;
            int r2 = color >> 16 & 0xFF;
            int g2 = color >> 8 & 0xFF;
            int b2 = color & 0xFF;
            float inversePercent = 1.0f - percent;
            int finalColor = 0xFF000000 | ((int)((float)r1 * inversePercent + (float)r2 * percent) << 16) + ((int)((float)g1 * inversePercent + (float)g2 * percent) << 8) + (int)((float)b1 * inversePercent + (float)b2 * percent);
            DrawingHelper.drawPixelSafe(nativeImage, x, y, finalColor);
        }
    }

    public static void fillRectSafe(NativeImage nativeImage, int x, int y, int width, int height, int color) {
        if (width <= 0 || height <= 0 || x >= nativeImage.getWidth() || y >= nativeImage.getHeight()) {
            return;
        }
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        if (x + width > nativeImage.getWidth()) {
            width = nativeImage.getWidth() - x;
        }
        if (y + height > nativeImage.getHeight()) {
            height = nativeImage.getHeight() - y;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        nativeImage.fillRect(x, y, width, height, color);
    }

    public static void drawPixelSafe(NativeImage nativeImage, int x, int y, int color) {
        if (Utilities.isBetween((double)x, (double)0.0, (double)(nativeImage.getWidth() - 1)) && Utilities.isBetween((double)y, (double)0.0, (double)(nativeImage.getHeight() - 1))) {
            nativeImage.setPixelColor(x, y, DrawingHelper.invertColor(color));
        }
    }

    public static int invertColor(int color) {
        return ((color & 0xFF000000) != 0 ? -16777216 : 0) + ((color & 0xFF) << 16) + (color & 0xFF00) + ((color & 0xFF0000) >> 16);
    }

    public static void clearColor(NativeImage nativeImage, int color) {
        for (int x = 0; x < nativeImage.getWidth(); ++x) {
            for (int y = 0; y < nativeImage.getHeight(); ++y) {
                if (nativeImage.getColor(x, y) != color) continue;
                nativeImage.setPixelColor(x, y, 0);
            }
        }
    }
}

