/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.block.base;

import forge.ziyue.tjmetro.mod.block.IBlockExtension;
import forge.ziyue.tjmetro.mod.block.base.BlockRailwaySignBase;
import forge.ziyue.tjmetro.mod.client.DynamicTextureCache;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.serializer.JsonReader;
import org.mtr.core.serializer.ReaderBase;
import org.mtr.libraries.com.google.gson.JsonElement;
import org.mtr.libraries.com.google.gson.JsonObject;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.resource.SignResource;

public interface IRailwaySign
extends DirectionHelper {
    public static final List<String> EXIT_SIGNS = Arrays.asList("exit_letter", "exit_letter_flipped", SignType.EXIT_LETTER_TEXT.signId, SignType.EXIT_LETTER_TEXT_FLIPPED.signId);
    public static final List<String> LINE_SIGNS = Arrays.asList("line", "line_flipped");
    public static final List<String> PLATFORM_SIGNS = Arrays.asList("platform", "platform_flipped", SignType.BOUND_FOR_TEXT.signId, SignType.BOUND_FOR_TEXT_FLIPPED.signId, SignType.TRAIN_TO_TEXT.signId, SignType.TRAIN_TO_TEXT_FLIPPED.signId, SignType.CROSS_LINE_TRAIN_TO_TEXT.signId, SignType.CROSS_LINE_TRAIN_TO_TEXT_FLIPPED.signId);
    public static final List<String> STATION_SIGNS = Arrays.asList("station", "station_flipped", SignType.STATION_TEXT.signId, SignType.STATION_TEXT_FLIPPED.signId);

    public static void onPlaced(World world, BlockPos pos, BlockState state, Block middle, int middleLength) {
        if (world.isClient()) {
            return;
        }
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        for (int i = 1; i <= middleLength; ++i) {
            world.setBlockState(pos.offset(facing.rotateYClockwise(), i), middle.getDefaultState().with(new org.mtr.mapping.holder.Property((Property)IRailwaySign.FACING.data), (Comparable)facing.data), 3);
        }
        world.setBlockState(pos.offset(facing.rotateYClockwise(), middleLength + 1), state.getBlock().getDefaultState().with(new org.mtr.mapping.holder.Property((Property)IRailwaySign.FACING.data), (Comparable)facing.getOpposite().data), 3);
        world.updateNeighbors(pos, Blocks.getAirMapped());
        state.updateNeighbors(new WorldAccess((LevelAccessor)world.data), pos, 3);
    }

    public static BlockState getStateForNeighborUpdate(BlockState state, Direction direction, BlockState newState, Block middle) {
        boolean isNext;
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        boolean bl = isNext = direction == facing.rotateYClockwise() || IBlockExtension.isBlock(state, middle) && direction == facing.rotateYCounterclockwise();
        if (isNext && !(newState.getBlock().data instanceof BlockRailwaySignBase)) {
            return Blocks.getAirMapped().getDefaultState();
        }
        return state;
    }

    public static VoxelShape getOutlineShape(BlockState state, int xStart, Block middle) {
        Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
        if (IBlockExtension.isBlock(state, middle)) {
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        }
        VoxelShape main = IBlock.getVoxelShapeByDirection((double)((double)xStart - 0.75), (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        VoxelShape pole = IBlock.getVoxelShapeByDirection((double)(xStart - 2), (double)0.0, (double)7.0, (double)((double)xStart - 0.75), (double)16.0, (double)9.0, (Direction)facing);
        return VoxelShapes.union((VoxelShape)main, (VoxelShape)pole);
    }

    public static BlockPos findEndWithDirection(World world, BlockPos startPos, Direction direction, boolean allowOpposite, Block middle) {
        int i = 0;
        while (true) {
            BlockPos checkPos = startPos.offset(direction.rotateYCounterclockwise(), i);
            BlockState checkState = world.getBlockState(checkPos);
            if (checkState.getBlock().data instanceof BlockRailwaySignBase) {
                Direction facing = IBlock.getStatePropertySafe((BlockState)checkState, (DirectionProperty)FACING);
                if (!IBlockExtension.isBlock(checkState, middle) && (facing == direction || allowOpposite && facing == direction.getOpposite())) {
                    return checkPos;
                }
            } else {
                return null;
            }
            ++i;
        }
    }

    public static boolean signIsExit(String signId) {
        return EXIT_SIGNS.contains(signId);
    }

    public static boolean signIsLine(String signId) {
        return LINE_SIGNS.contains(signId);
    }

    public static boolean signIsPlatform(String signId) {
        return PLATFORM_SIGNS.contains(signId);
    }

    public static boolean signIsStation(String signId) {
        return STATION_SIGNS.contains(signId);
    }

    public static Identifier getExitSignResource(String signId, String exitLetter, String exitNumber, int backgroundColor, int textColor, boolean forceMTRFont) {
        if (signId.equals(SignType.EXIT_LETTER_TEXT.signId) || signId.equals(SignType.EXIT_LETTER_TEXT_FLIPPED.signId)) {
            return DynamicTextureCache.instance.getExitSignLetterTianjin((String)exitLetter, (String)exitNumber, (int)backgroundColor, (int)textColor, (boolean)forceMTRFont).identifier;
        }
        if (forceMTRFont) {
            return org.mtr.mod.client.DynamicTextureCache.instance.getExitSignLetter((String)exitLetter, (String)exitNumber, (int)backgroundColor).identifier;
        }
        return DynamicTextureCache.instance.getExitSignLetter((String)exitLetter, (String)exitNumber, (int)backgroundColor).identifier;
    }

    public static Identifier getPlatformSignResource(String signId, long platformId, IGui.HorizontalAlignment horizontalAlignment, float paddingScale, float aspectRatio, int backgroundColor, int textColor, int transparentColor, boolean forceMTRFont) {
        if (signId.equals(SignType.BOUND_FOR_TEXT.signId) || signId.equals(SignType.BOUND_FOR_TEXT_FLIPPED.signId)) {
            return DynamicTextureCache.instance.getBoundFor((long)platformId, (IGui.HorizontalAlignment)horizontalAlignment, (float)aspectRatio, (float)paddingScale, (int)backgroundColor, (int)textColor, (boolean)forceMTRFont).identifier;
        }
        if (signId.equals(SignType.TRAIN_TO_TEXT.signId) || signId.equals(SignType.TRAIN_TO_TEXT_FLIPPED.signId)) {
            return DynamicTextureCache.instance.getTrainTo((long)platformId, (IGui.HorizontalAlignment)horizontalAlignment, (float)aspectRatio, (float)paddingScale, (int)backgroundColor, (int)textColor, (boolean)forceMTRFont).identifier;
        }
        if (signId.equals(SignType.CROSS_LINE_TRAIN_TO_TEXT.signId) || signId.equals(SignType.CROSS_LINE_TRAIN_TO_TEXT_FLIPPED.signId)) {
            return DynamicTextureCache.instance.getCrossLineTrainTo((long)platformId, (IGui.HorizontalAlignment)horizontalAlignment, (float)aspectRatio, (float)paddingScale, (int)backgroundColor, (int)textColor, (boolean)forceMTRFont).identifier;
        }
        if (forceMTRFont) {
            return org.mtr.mod.client.DynamicTextureCache.instance.getDirectionArrow((long)platformId, (boolean)false, (boolean)false, (IGui.HorizontalAlignment)horizontalAlignment, (boolean)false, (float)paddingScale, (float)aspectRatio, (int)backgroundColor, (int)textColor, (int)transparentColor).identifier;
        }
        return DynamicTextureCache.instance.getDirectionArrow((long)platformId, (boolean)false, (boolean)false, (IGui.HorizontalAlignment)horizontalAlignment, (boolean)false, (float)paddingScale, (float)aspectRatio, (int)backgroundColor, (int)textColor, (int)transparentColor).identifier;
    }

    public static enum SignType {
        TIANJIN_METRO_LOGO_TEXT("tianjin_metro_logo", "tianjin_metro", false, false),
        TIANJIN_METRO_LOGO_TEXT_FLIPPED("tianjin_metro_logo", "tianjin_metro", false, true),
        TIANJIN_METRO_MOD_LOGO_TEXT("tianjin_metro_mod_logo", "tianjin_metro", false, false),
        TIANJIN_METRO_MOD_LOGO_TEXT_FLIPPED("tianjin_metro_mod_logo", "tianjin_metro", false, true),
        TIANJIN_METRO_OLD_LOGO_TEXT("tianjin_metro_old_logo", "tianjin_metro", false, false),
        TIANJIN_METRO_OLD_LOGO_TEXT_FLIPPED("tianjin_metro_old_logo", "tianjin_metro", false, true),
        TRAIN_TEXT("train", "train", false, false),
        TRAIN_TEXT_FLIPPED("train", "train", false, true),
        STATION_TEXT("train", "station", false, false),
        STATION_TEXT_FLIPPED("train", "station", false, true),
        EMERGENCY_EXIT_TEXT("emergency_exit", "emergency_exit", false, false),
        EMERGENCY_EXIT_TEXT_FLIPPED("emergency_exit", "emergency_exit", true, true),
        NO_THROUGHFARE_TEXT("no_throughfare", "no_throughfare", false, false),
        NO_THROUGHFARE_TEXT_FLIPPED("no_throughfare", "no_throughfare", false, true),
        SECURITY_CHECK_TEXT("security_check", "security_check", false, false),
        SECURITY_CHECK_TEXT_FLIPPED("security_check", "security_check", false, true),
        AUTOMATIC_TICKET_TEXT("automatic_ticket", "automatic_ticket", false, false),
        AUTOMATIC_TICKET_TEXT_FLIPPED("automatic_ticket", "automatic_ticket", false, true),
        RAILWAY_STATION_TEXT("railway_station", "railway_station", false, false),
        RAILWAY_STATION_TEXT_FLIPPED("railway_station", "railway_station", false, true),
        ACCESSIBLE_ELEVATOR_TEXT("accessible_elevator", "accessible_elevator", false, false),
        ACCESSIBLE_ELEVATOR_TEXT_FLIPPED("accessible_elevator", "accessible_elevator", false, true),
        ACCESSIBLE_TOILET_TEXT("accessible_toilet", "accessible_toilet", false, false),
        ACCESSIBLE_TOILET_TEXT_FLIPPED("accessible_toilet", "accessible_toilet", false, true),
        FARE_ADJUSTMENT_TEXT("fare_adjustment", "fare_adjustment", false, false),
        FARE_ADJUSTMENT_TEXT_FLIPPED("fare_adjustment", "fare_adjustment", false, true),
        INQUIRY_TEXT("inquiry", "inquiry", false, false),
        INQUIRY_TEXT_FLIPPED("inquiry", "inquiry", false, true),
        EXIT_LETTER_TEXT("exit_letter", "exit_bmt", false, false),
        EXIT_LETTER_TEXT_FLIPPED("exit_letter", "exit_bmt", false, true),
        BOUND_FOR_TEXT("bound_for", "bound_for", false, false),
        BOUND_FOR_TEXT_FLIPPED("bound_for", "bound_for", false, true),
        ACCESSIBLE_PASSAGE_TEXT("accessible_passage", "accessible_passage", false, false),
        ACCESSIBLE_PASSAGE_TEXT_FLIPPED("accessible_passage", "accessible_passage", true, true),
        TOILET_TEXT("toilet", "toilet", false, false),
        TOILET_TEXT_FLIPPED("toilet", "toilet", false, true),
        TO_SUBWAY_TEXT("to_subway", "to_subway", false, false),
        TO_SUBWAY_TEXT_FLIPPED("to_subway", "to_subway", false, true),
        TRAIN_TO_TEXT("to_subway", "train_to", false, false),
        TRAIN_TO_TEXT_FLIPPED("to_subway", "train_to", false, true),
        CROSS_LINE_TRAIN_TO_TEXT("to_subway", "cross_line_train_to", false, false),
        CROSS_LINE_TRAIN_TO_TEXT_FLIPPED("to_subway", "cross_line_train_to", false, true),
        CUSTOMER_SERVICE_CENTER_TEXT("customer_service_center", "customer_service_center", false, false),
        CUSTOMER_SERVICE_CENTER_TEXT_FLIPPED("customer_service_center", "customer_service_center", false, true),
        BABY_CARE_TEXT("baby_care", "baby_care", false, false),
        BABY_CARE_TEXT_FLIPPED("baby_care", "baby_care", false, true),
        POLICE_OFFICE_TEXT("police_office", "police_office", false, false),
        POLICE_OFFICE_TEXT_FLIPPED("police_office", "police_office", false, true),
        OUTBOUND_TRANSFER_TEXT("to_subway", "outbound_transfer", false, false),
        OUTBOUND_TRANSFER_TEXT_FLIPPED("to_subway", "outbound_transfer", false, true),
        TO_SUBWAY_JINJING_TEXT("to_subway_jinjing", "to_subway", false, false),
        TO_SUBWAY_JINJING_TEXT_FLIPPED("to_subway_jinjing", "to_subway", true, true),
        SELF_SERVICE_TICKETING_TEXT("self_service_ticketing", "self_service_ticketing", false, false),
        SELF_SERVICE_TICKETING_TEXT_FLIPPED("self_service_ticketing", "self_service_ticketing", false, true),
        TIANJIN_METRO_LOGO("tianjin_metro_logo", false),
        TIANJIN_METRO_MOD_LOGO("tianjin_metro_mod_logo", false),
        TIANJIN_METRO_OLD_LOGO("tianjin_metro_old_logo", false),
        TRAIN("train", false),
        EMERGENCY_EXIT("emergency_exit", false),
        EMERGENCY_EXIT_FLIPPED("emergency_exit", true),
        NO_THROUGHFARE("no_throughfare", false),
        SECURITY_CHECK("security_check", false),
        AUTOMATIC_TICKET("automatic_ticket", false),
        RAILWAY_STATION("railway_station", false),
        ACCESSIBLE_ELEVATOR("accessible_elevator", false),
        ACCESSIBLE_TOILET("accessible_toilet", false),
        FARE_ADJUSTMENT("fare_adjustment", false),
        INQUIRY("inquiry", false),
        STAIRS("stairs", false),
        STAIRS_FLIPPED("stairs", true),
        ACCESSIBLE_PASSAGE("accessible_passage", false),
        ACCESSIBLE_PASSAGE_FLIPPED("accessible_passage", true),
        ESCALATOR("escalator", false),
        ESCALATOR_FLIPPED("escalator", true),
        TOILET("toilet", false),
        TO_SUBWAY("to_subway", false),
        EXIT("exit", false, false),
        CUSTOMER_SERVICE_CENTER("customer_service_center", false),
        BABY_CARE("baby_care", false),
        POLICE_OFFICE("police_office", false),
        EXIT_TRANSPARENT("exit_transparent", false),
        TO_SUBWAY_JINJING("to_subway_jinjing", false),
        TO_SUBWAY_JINJING_FLIPPED("to_subway_jinjing", true),
        SELF_SERVICE_TICKETING("self_service_ticketing", false),
        NO_ENTRY_BMT_TEXT("no_entry_bmt", "no_entry_bmt", false, false),
        NO_ENTRY_BMT_TEXT_FLIPPED("no_entry_bmt", "no_entry_bmt", false, true),
        TO_SUBWAY_BMT_TEXT("to_subway_bmt", "to_subway_bmt", false, false),
        TO_SUBWAY_BMT_TEXT_FLIPPED("to_subway_bmt", "to_subway_bmt", true, true),
        EXIT_BMT_UP_TEXT("exit_bmt_up", "exit_bmt", false, false),
        EXIT_BMT_DOWN_TEXT("exit_bmt_down", "exit_bmt", false, false),
        EXIT_BMT_UP_TEXT_FLIPPED("exit_bmt_up", "exit_bmt", false, true),
        EXIT_BMT_DOWN_TEXT_FLIPPED("exit_bmt_down", "exit_bmt", false, true),
        EXIT_BMT_LEFT_TEXT("exit_bmt_left", "exit_bmt", false, false),
        EXIT_BMT_RIGHT_TEXT("exit_bmt_right", "exit_bmt", false, true),
        TICKETS_BMT_TEXT("fare_adjustment", "tickets_bmt", false, false),
        TICKETS_BMT_TEXT_FLIPPED("fare_adjustment", "tickets_bmt", false, true),
        TO_TRAIN_BMT_TEXT("to_train_bmt", "to_train_bmt", false, false),
        TO_TRAIN_BMT_TEXT_FLIPPED("to_train_bmt", "to_train_bmt", false, true),
        NO_ENTRY_BMT("no_entry_bmt", false),
        TO_SUBWAY_BMT("to_subway_bmt", false),
        TO_SUBWAY_BMT_FLIPPED("to_subway_bmt", true),
        EXIT_BMT_UP("exit_bmt_up", false),
        EXIT_BMT_DOWN("exit_bmt_down", false),
        EXIT_BMT_LEFT("exit_bmt_left", false),
        EXIT_BMT_RIGHT("exit_bmt_right", false),
        TO_TRAIN_BMT("to_train_bmt", false);

        public final String signId = String.format(this.toString().contains("BMT") ? "\u0001_TJMETRO_%s" : "\u0000_TJMETRO_%s", new Object[]{this}).toLowerCase();
        public final SignResource sign;

        private SignType(String texture, String translation, boolean flipTexture, boolean flipCustomText, boolean hasCustomText, boolean small, int backgroundColor) {
            JsonObject object = new JsonObject();
            object.addProperty("id", this.signId);
            object.addProperty("textureResource", "tjmetro:textures/sign/" + texture + ".png");
            object.addProperty("flipTexture", Boolean.valueOf(flipTexture));
            object.addProperty("customText", (String)(hasCustomText ? "sign.tjmetro." + translation : ""));
            object.addProperty("flipCustomText", Boolean.valueOf(flipCustomText));
            object.addProperty("small", Boolean.valueOf(small));
            object.addProperty("backgroundColor", (Number)backgroundColor);
            this.sign = new SignResource((ReaderBase)new JsonReader((JsonElement)object));
        }

        private SignType(String texture, String translation, boolean flipTexture, boolean flipCustomText) {
            this(texture, translation, flipTexture, flipCustomText, true, true, 0);
        }

        private SignType(String texture, String translation, boolean flipTexture, boolean flipCustomText, boolean small) {
            this(texture, translation, flipTexture, flipCustomText, true, small, 0);
        }

        private SignType(String texture, boolean flipTexture) {
            this(texture, texture, flipTexture, false, false, true, 0);
        }

        private SignType(String texture, boolean flipTexture, boolean small) {
            this(texture, texture, flipTexture, false, false, small, 0);
        }
    }
}

