/*
 * Decompiled with CFR 0.152.
 */
package forge.ziyue.tjmetro.mod.packet;

import forge.ziyue.tjmetro.mod.block.BlockRailwaySignWallDouble;
import java.util.ArrayList;
import java.util.List;
import org.mtr.libraries.it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.MinecraftServer;
import org.mtr.mapping.holder.ServerPlayerEntity;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public final class PacketUpdateRailwaySignDoubleConfig
extends PacketHandler {
    private final BlockPos blockPos;
    private final List<LongAVLTreeSet> selectedIds;
    private final String[][] signIds;

    public PacketUpdateRailwaySignDoubleConfig(PacketBufferReceiver packetBufferReceiver) {
        int j;
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        this.selectedIds = new ArrayList<LongAVLTreeSet>();
        this.selectedIds.add(new LongAVLTreeSet());
        this.selectedIds.add(new LongAVLTreeSet());
        for (int i = 0; i < 2; ++i) {
            int selectedIdsLength = packetBufferReceiver.readInt();
            for (j = 0; j < selectedIdsLength; ++j) {
                this.selectedIds.get(i).add(packetBufferReceiver.readLong());
            }
        }
        int signLength = packetBufferReceiver.readInt();
        this.signIds = new String[2][signLength];
        for (int i = 0; i < 2; ++i) {
            for (j = 0; j < signLength; ++j) {
                String signId = packetBufferReceiver.readString();
                this.signIds[i][j] = signId.isEmpty() ? null : signId;
            }
        }
    }

    public PacketUpdateRailwaySignDoubleConfig(BlockPos blockPos, List<LongAVLTreeSet> selectedIds, String[][] signIds) {
        this.blockPos = blockPos;
        this.selectedIds = selectedIds;
        this.signIds = signIds;
    }

    public void write(PacketBufferSender packetBufferSender) {
        int i;
        packetBufferSender.writeLong(this.blockPos.asLong());
        for (i = 0; i < 2; ++i) {
            packetBufferSender.writeInt(this.selectedIds.get(i).size());
            this.selectedIds.get(i).forEach(arg_0 -> ((PacketBufferSender)packetBufferSender).writeLong(arg_0));
        }
        packetBufferSender.writeInt(this.signIds[0].length);
        for (i = 0; i < 2; ++i) {
            for (String signType : this.signIds[i]) {
                packetBufferSender.writeString(signType == null ? "" : signType);
            }
        }
    }

    public void runServer(MinecraftServer minecraftServer, ServerPlayerEntity serverPlayerEntity) {
        BlockEntity entity = serverPlayerEntity.getEntityWorld().getBlockEntity(this.blockPos);
        if (entity != null && entity.data instanceof BlockRailwaySignWallDouble.BlockEntity) {
            BlockRailwaySignWallDouble.BlockEntity entity1 = (BlockRailwaySignWallDouble.BlockEntity)((Object)entity.data);
            entity1.setData(this.selectedIds, this.signIds);
        }
    }
}

