/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.data.item;

import com.google.common.cache.CacheBuilder;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.data.item.ItemHasher;
import com.viaversion.viaversion.api.minecraft.data.StructuredData;
import com.viaversion.viaversion.api.minecraft.item.HashedItem;
import com.viaversion.viaversion.api.minecraft.item.HashedStructuredItem;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.mcstructs.converter.impl.v1_21_5.HashConverter_v1_21_5;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentRegistry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21_5.ItemComponents_v1_21_5;
import com.viaversion.viaversion.rewriter.item.ItemDataComponentConverter;
import com.viaversion.viaversion.util.SerializerVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ItemHasherBase
implements ItemHasher {
    public static final int UNKNOWN_HASH = Integer.MIN_VALUE;
    private final Map<Integer, HashedItem> hashes = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(1024L).build().asMap();
    private final List<String> enchantments = new ArrayList<String>();
    private final ItemDataComponentConverter itemComponentConverter;
    protected final UserConnection connection;
    private boolean processingClientboundInventoryPacket;

    public ItemHasherBase(UserConnection connection, SerializerVersion serializerVersion, MappingData mappingData) {
        ItemDataComponentConverter.RegistryAccess registryAccess = ItemDataComponentConverter.RegistryAccess.of(this.enchantments, ItemComponentRegistry.V1_21_5.getRegistries(), mappingData);
        this.itemComponentConverter = new ItemDataComponentConverter(serializerVersion, registryAccess);
        this.connection = connection;
    }

    @Override
    public void setEnchantments(List<String> enchantments) {
        this.enchantments.clear();
        this.enchantments.addAll(enchantments);
    }

    public HashedItem toHashedItem(Item item) {
        return ItemHasherBase.toHashedItem(this.itemComponentConverter, item);
    }

    public static HashedItem toHashedItem(ItemDataComponentConverter converter, Item item) {
        HashedStructuredItem hashedItem = new HashedStructuredItem(item.identifier(), item.amount());
        for (StructuredData<?> data : item.dataContainer().data().values()) {
            if (data.isEmpty()) {
                hashedItem.removedDataIds().add(data.id());
                continue;
            }
            ItemDataComponentConverter.Result<?> result = converter.viaToMcStructs(data);
            int hash = result != null ? ItemHasherBase.hash(result) : Integer.MIN_VALUE;
            hashedItem.dataHashesById().put(data.id(), hash);
        }
        return hashedItem;
    }

    public void trackOriginalHashedItem(CompoundTag customData, HashedItem originalHashedItem) {
        int customDataHash = this.hashTag(customData);
        this.hashes.put(customDataHash, originalHashedItem);
    }

    public @Nullable HashedItem originalHashedItem(int customDataHash, HashedItem clientItem) {
        HashedItem originalItem = this.hashes.get(customDataHash);
        if (originalItem == null) {
            return null;
        }
        originalItem = originalItem.copy();
        for (Int2IntMap.Entry entry : originalItem.dataHashesById().int2IntEntrySet()) {
            int typeId = entry.getIntKey();
            if (entry.getIntValue() != Integer.MIN_VALUE || !clientItem.dataHashesById().containsKey(typeId)) continue;
            int clientProvidedHash = clientItem.dataHashesById().get(typeId);
            originalItem.dataHashesById().put(typeId, clientProvidedHash);
        }
        return originalItem;
    }

    @Override
    public boolean isProcessingClientboundInventoryPacket() {
        return this.processingClientboundInventoryPacket;
    }

    @Override
    public void setProcessingClientboundInventoryPacket(boolean processingClientboundInventoryPacket) {
        this.processingClientboundInventoryPacket = processingClientboundInventoryPacket;
    }

    private static <T> int hash(ItemDataComponentConverter.Result<T> result) {
        return result.type().getCodec().serialize(HashConverter_v1_21_5.CRC32C, result.value()).getOrThrow().asInt();
    }

    private int hashTag(CompoundTag tag) {
        return ItemComponents_v1_21_5.V1_21_5.CUSTOM_DATA.getCodec().serialize(HashConverter_v1_21_5.CRC32C, tag).getOrThrow().asInt();
    }
}

