/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents;

import com.viaversion.viaversion.libs.mcstructs.converter.DataConverter;
import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import java.util.Objects;

public class ItemComponent<T> {
    private final Identifier name;
    final Codec<T> codec;

    public ItemComponent(String name, Codec<T> codec) {
        this.name = Identifier.of(name);
        this.codec = codec;
    }

    public Identifier getName() {
        return this.name;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public <D> D serialize(DataConverter<D> converter, T value) {
        return this.codec.serialize(converter, value).getOrThrow(cause -> new IllegalStateException("Failed to serialize component " + this.name.get(), (Throwable)cause));
    }

    public <D> T deserialize(DataConverter<D> converter, D data) {
        return this.codec.deserialize(converter, data).getOrThrow(cause -> new IllegalStateException("Failed to deserialize component " + this.name.get(), (Throwable)cause));
    }

    public String toString() {
        return ToString.of(this).add("name", this.name).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemComponent that = (ItemComponent)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

