/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents;

import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ItemComponentList
implements Iterable<ItemComponent<?>> {
    private final List<ItemComponent<?>> components = new ArrayList();

    public int size() {
        return this.components.size();
    }

    public <T> Optional<ItemComponent<T>> getByName(String name) {
        return this.getByName(Identifier.of(name));
    }

    public <T> Optional<ItemComponent<T>> getByName(Identifier identifier) {
        for (ItemComponent<?> component : this.components) {
            if (!component.getName().equals(identifier)) continue;
            return Optional.of(component);
        }
        return Optional.empty();
    }

    public <T> Optional<ItemComponent<T>> getById(int id) {
        if (id < 0 || id >= this.components.size()) {
            return Optional.empty();
        }
        return Optional.of(this.components.get(id));
    }

    public int getId(ItemComponent<?> component) {
        return this.components.indexOf(component);
    }

    void register(ItemComponent<?> component) {
        this.components.add(component);
    }

    void unregister(ItemComponent<?> component) {
        this.components.remove(component);
    }

    void sort(String[] names) {
        ArrayList<ItemComponent> sorted = new ArrayList<ItemComponent>();
        ArrayList missed = new ArrayList(this.components);
        for (String name : names) {
            ItemComponent itemComponent2;
            block3: {
                for (ItemComponent itemComponent2 : missed) {
                    if (!itemComponent2.getName().equals(Identifier.of(name))) continue;
                    break block3;
                }
                throw new IllegalArgumentException("Component '" + name + "' was not found in the registry or was already sorted");
            }
            sorted.add(itemComponent2);
            missed.remove(itemComponent2);
        }
        if (!missed.isEmpty()) {
            throw new IllegalArgumentException("Missed components after sorting " + missed.stream().map(c -> c.getName().get()).collect(Collectors.joining("/")));
        }
        this.components.clear();
        this.components.addAll(sorted);
    }

    @Override
    public Iterator<ItemComponent<?>> iterator() {
        return new Iterator<ItemComponent<?>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ItemComponentList.this.components.size();
            }

            @Override
            public ItemComponent<?> next() {
                return (ItemComponent)ItemComponentList.this.components.get(this.index++);
            }
        };
    }
}

