/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents;

import com.viaversion.viaversion.libs.mcstructs.converter.DataConverter;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponent;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ItemComponentMap {
    private final ItemComponentRegistry registry;
    private final Map<ItemComponent<?>, Object> components = new HashMap();
    private final List<ItemComponent<?>> markedForRemoval = new ArrayList();

    public ItemComponentMap(ItemComponentRegistry registry) {
        this.registry = registry;
    }

    public ItemComponentRegistry getRegistry() {
        return this.registry;
    }

    public Map<ItemComponent<?>, ?> getValues() {
        return Collections.unmodifiableMap(this.components);
    }

    public int getValuesSize() {
        return this.components.size();
    }

    public List<ItemComponent<?>> getMarkedForRemoval() {
        return Collections.unmodifiableList(this.markedForRemoval);
    }

    public int getMarkedForRemovalSize() {
        return this.markedForRemoval.size();
    }

    public int size() {
        return this.components.size() + this.markedForRemoval.size();
    }

    public boolean isEmpty() {
        return this.components.isEmpty() && this.markedForRemoval.isEmpty();
    }

    public boolean contains(ItemComponent<?> component) {
        return this.components.containsKey(component) || this.markedForRemoval.contains(component);
    }

    public <T> ItemComponentMap set(ItemComponent<T> component, T value) {
        this.components.put(component, value);
        this.markedForRemoval.remove(component);
        return this;
    }

    @Nullable
    public <T> T get(ItemComponent<T> component) {
        return (T)this.components.get(component);
    }

    public ItemComponentMap remove(ItemComponent<?> component) {
        this.components.remove(component);
        this.markedForRemoval.remove(component);
        return this;
    }

    public ItemComponentMap markForRemoval(ItemComponent<?> component) {
        this.components.remove(component);
        this.markedForRemoval.add(component);
        return this;
    }

    public boolean isMarkedForRemoval(ItemComponent<?> component) {
        return this.markedForRemoval.contains(component);
    }

    public <T> T to(DataConverter<T> converter) {
        return this.registry.mapTo(converter, this);
    }

    public String toString() {
        return ToString.of(this).add("registry", this.registry).add("components", this.components, map -> !map.isEmpty()).add("markedForRemoval", this.markedForRemoval, list -> !list.isEmpty()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemComponentMap that = (ItemComponentMap)o;
        return Objects.equals(this.registry, that.registry) && Objects.equals(this.components, that.components) && Objects.equals(this.markedForRemoval, that.markedForRemoval);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.components, this.markedForRemoval);
    }
}

