/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents;

import com.viaversion.viaversion.libs.mcstructs.converter.DataConverter;
import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.codec.DataDeserializer;
import com.viaversion.viaversion.libs.mcstructs.converter.codec.DataSerializer;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Result;
import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponent;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentList;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentMap;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.Registries;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.Verifiers;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_20_5.ItemComponents_v1_20_5;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21.ItemComponents_v1_21;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21_2.ItemComponents_v1_21_2;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21_4.ItemComponents_v1_21_4;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21_5.ItemComponents_v1_21_5;
import javax.annotation.Nullable;

public abstract class ItemComponentRegistry {
    public static final ItemComponents_v1_20_5 V1_20_5 = new ItemComponents_v1_20_5();
    public static final ItemComponents_v1_21 V1_21 = new ItemComponents_v1_21();
    public static final ItemComponents_v1_21_2 V1_21_2 = new ItemComponents_v1_21_2();
    public static final ItemComponents_v1_21_4 V1_21_4 = new ItemComponents_v1_21_4();
    public static final ItemComponents_v1_21_5 V1_21_5 = new ItemComponents_v1_21_5();
    public static final ItemComponentRegistry LATEST = V1_21_5;
    private final ItemComponentList components;
    protected final Registries registries;
    protected final Verifiers verifiers;
    private final Codec<ItemComponent<?>> componentCodec = Codec.STRING_IDENTIFIER.flatMap(itemComponent -> Result.success(itemComponent.getName()), identifier -> {
        ItemComponent component = this.getComponent((Identifier)identifier);
        if (component == null) {
            return Result.error("Unknown item component: " + identifier);
        }
        return Result.success(component);
    });
    private final Codec<ItemComponentMap> mapCodec = Codec.ofThrowing(new DataSerializer<ItemComponentMap>(){

        @Override
        public <S> Result<S> serialize(DataConverter<S> converter, ItemComponentMap element) {
            return Result.success(ItemComponentRegistry.this.mapTo(converter, element));
        }
    }, new DataDeserializer<ItemComponentMap>(){

        @Override
        public <S> Result<ItemComponentMap> deserialize(DataConverter<S> converter, S data) {
            return Result.success(ItemComponentRegistry.this.mapFrom(converter, data));
        }
    });

    public ItemComponentRegistry() {
        this.components = new ItemComponentList();
        this.registries = new Registries();
        this.verifiers = new Verifiers(){};
    }

    public ItemComponentRegistry(Registries registries, Verifiers verifiers) {
        this.components = new ItemComponentList();
        this.registries = registries;
        this.verifiers = verifiers;
    }

    public ItemComponentList getComponentList() {
        return this.components;
    }

    @Nullable
    public <T> ItemComponent<T> getComponent(Identifier name) {
        return this.components.getByName(name).orElse(null);
    }

    public Registries getRegistries() {
        return this.registries;
    }

    public Verifiers getVerifiers() {
        return this.verifiers;
    }

    public Codec<ItemComponent<?>> getComponentCodec() {
        return this.componentCodec;
    }

    public Codec<ItemComponentMap> getMapCodec() {
        return this.mapCodec;
    }

    public abstract ItemComponentMap getItemDefaults();

    public abstract <D> D mapTo(DataConverter<D> var1, ItemComponentMap var2);

    public abstract <D> ItemComponentMap mapFrom(DataConverter<D> var1, D var2);

    protected <T> ItemComponent<T> copy(String name, ItemComponent<T> component) {
        return this.register(name, component.codec);
    }

    protected <T> ItemComponent<T> registerNonSerializable(String name) {
        return this.register(name, Codec.failing("The component " + name + " is not serializable!"));
    }

    protected <T> ItemComponent<T> register(String name, Codec<T> codec) {
        this.unregister(name);
        ItemComponent<T> itemComponent = new ItemComponent<T>(name, codec);
        this.components.register(itemComponent);
        return itemComponent;
    }

    protected void unregister(String name) {
        this.components.getByName(name).ifPresent(this.components::unregister);
    }

    protected void sort(String ... sortedNames) {
        this.components.sort(sortedNames);
    }
}

