/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl;

import com.viaversion.viaversion.libs.mcstructs.converter.DataConverter;
import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Result;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentRegistry;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.TextComponentCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class TypeSerializers {
    protected final ItemComponentRegistry registry;
    protected final TextComponentCodec textComponentCodec;
    private final Map<String, Codec<?>> codecCache;

    public TypeSerializers(ItemComponentRegistry registry, TextComponentCodec textComponentCodec) {
        this.registry = registry;
        this.textComponentCodec = textComponentCodec;
        this.codecCache = new HashMap();
    }

    public TextComponentCodec getTextComponentCodec() {
        return this.textComponentCodec;
    }

    protected <T> Codec<T> init(String key, Supplier<Codec<T>> codecSupplier) {
        if (this.codecCache.containsKey(key)) {
            Codec<?> codec = this.codecCache.get(key);
            if (codec == null) {
                UnfinishedCodec unfinishedCodec = new UnfinishedCodec();
                this.codecCache.put(key, unfinishedCodec);
                return unfinishedCodec;
            }
            return codec;
        }
        this.codecCache.put(key, null);
        Codec<T> codec = codecSupplier.get();
        if (this.codecCache.get(key) != null) {
            UnfinishedCodec unfinishedCodec = (UnfinishedCodec)this.codecCache.get(key);
            unfinishedCodec.codec = codec;
            return unfinishedCodec;
        }
        this.codecCache.put(key, codec);
        return codec;
    }

    private static class UnfinishedCodec<T>
    implements Codec<T> {
        private Codec<T> codec = Codec.failing("Codec not initialized yet");

        private UnfinishedCodec() {
        }

        @Override
        public <S> Result<S> serialize(DataConverter<S> converter, T element) {
            return this.codec.serialize(converter, element);
        }

        @Override
        public <S> Result<T> deserialize(DataConverter<S> converter, S data) {
            return this.codec.deserialize(converter, data);
        }
    }
}

