/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_20_5;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.viaversion.libs.mcstructs.converter.DataConverter;
import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.codec.map.MapCodecMerger;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Result;
import com.viaversion.viaversion.libs.mcstructs.converter.types.NamedType;
import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponent;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentMap;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentRegistry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.Registries;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.Verifiers;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_20_5.TypeSerializers_v1_20_5;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_20_5.Types_v1_20_5;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.EitherEntry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryEntry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.TagEntryList;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import com.viaversion.viaversion.libs.mcstructs.text.serializer.TextComponentCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemComponents_v1_20_5
extends ItemComponentRegistry {
    private final TypeSerializers_v1_20_5 typeSerializers = new TypeSerializers_v1_20_5(this, TextComponentCodec.V1_20_5);
    public final ItemComponent<CompoundTag> CUSTOM_DATA = this.register("custom_data", this.typeSerializers.customData());
    public final ItemComponent<Integer> MAX_STACK_SIZE = this.register("max_stack_size", Codec.rangedInt(1, 99));
    public final ItemComponent<Integer> MAX_DAMAGE = this.register("max_damage", Codec.minInt(1));
    public final ItemComponent<Integer> DAMAGE = this.register("damage", Codec.minInt(0));
    public final ItemComponent<Types_v1_20_5.Unbreakable> UNBREAKABLE = this.register("unbreakable", MapCodecMerger.codec(Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.Unbreakable::isShowInTooltip, Types_v1_20_5.Unbreakable::new));
    public final ItemComponent<TextComponent> CUSTOM_NAME = this.register("custom_name", this.typeSerializers.textComponent(Integer.MAX_VALUE));
    public final ItemComponent<TextComponent> ITEM_NAME = this.register("item_name", this.typeSerializers.textComponent(Integer.MAX_VALUE));
    public final ItemComponent<List<TextComponent>> LORE = this.register("lore", this.typeSerializers.textComponent(Integer.MAX_VALUE).listOf(256));
    public final ItemComponent<Types_v1_20_5.Rarity> RARITY = this.register("rarity", Codec.named((NamedType[])Types_v1_20_5.Rarity.values()));
    public final ItemComponent<Types_v1_20_5.Enchantments> ENCHANTMENTS = this.register("enchantments", Codec.oneOf(MapCodecMerger.codec(this.typeSerializers.enchantmentLevels().mapCodec("levels").required(), Types_v1_20_5.Enchantments::getEnchantments, Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.Enchantments::isShowInTooltip, Types_v1_20_5.Enchantments::new), this.typeSerializers.enchantmentLevels().map(Types_v1_20_5.Enchantments::getEnchantments, map -> new Types_v1_20_5.Enchantments((Map<RegistryEntry, Integer>)map, true))));
    public final ItemComponent<Types_v1_20_5.BlockPredicatesChecker> CAN_PLACE_ON = this.register("can_place_on", Codec.oneOf(MapCodecMerger.codec(this.typeSerializers.blockPredicate().listOf(1, Integer.MAX_VALUE).mapCodec("predicates").required(), Types_v1_20_5.BlockPredicatesChecker::getPredicates, Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.BlockPredicatesChecker::isShowInTooltip, Types_v1_20_5.BlockPredicatesChecker::new), this.typeSerializers.blockPredicate().flatMap(predicates -> Result.error("Can't encode single block predicate"), predicate -> {
        Types_v1_20_5.BlockPredicatesChecker checker = new Types_v1_20_5.BlockPredicatesChecker();
        ArrayList<Types_v1_20_5.BlockPredicate> predicates = new ArrayList<Types_v1_20_5.BlockPredicate>();
        predicates.add((Types_v1_20_5.BlockPredicate)predicate);
        checker.setPredicates(predicates);
        return Result.success(checker);
    })));
    public final ItemComponent<Types_v1_20_5.BlockPredicatesChecker> CAN_BREAK = this.copy("can_break", this.CAN_PLACE_ON);
    public final ItemComponent<Types_v1_20_5.AttributeModifiers> ATTRIBUTE_MODIFIERS = this.register("attribute_modifiers", Codec.oneOf(MapCodecMerger.codec(this.typeSerializers.attributeModifier().listOf().mapCodec("modifiers").required(), Types_v1_20_5.AttributeModifiers::getModifiers, Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.AttributeModifiers::isShowInTooltip, Types_v1_20_5.AttributeModifiers::new), this.typeSerializers.attributeModifier().flatMap(modifiers -> Result.error("Can't encode single attribute modifier"), modifier -> {
        Types_v1_20_5.AttributeModifiers attributeModifiers = new Types_v1_20_5.AttributeModifiers();
        ArrayList<Types_v1_20_5.AttributeModifier> list = new ArrayList<Types_v1_20_5.AttributeModifier>();
        list.add((Types_v1_20_5.AttributeModifier)modifier);
        attributeModifiers.setModifiers(list);
        return Result.success(attributeModifiers);
    })));
    public final ItemComponent<Integer> CUSTOM_MODEL_DATA = this.register("custom_model_data", Codec.INTEGER);
    public final ItemComponent<Boolean> HIDE_ADDITIONAL_TOOLTIP = this.register("hide_additional_tooltip", Codec.UNIT);
    public final ItemComponent<Boolean> HIDE_TOOLTIP = this.register("hide_tooltip", Codec.UNIT);
    public final ItemComponent<Integer> REPAIR_COST = this.register("repair_cost", Codec.minInt(0));
    public final ItemComponent<Boolean> CREATIVE_SLOT_LOCK = this.registerNonSerializable("creative_slot_lock");
    public final ItemComponent<Boolean> ENCHANTMENT_GLINT_OVERRIDE = this.register("enchantment_glint_override", Codec.BOOLEAN);
    public final ItemComponent<Boolean> INTANGIBLE_PROJECTILE = this.register("intangible_projectile", Codec.UNIT);
    public final ItemComponent<Types_v1_20_5.Food> FOOD = this.register("food", MapCodecMerger.codec(Codec.minInt(0).mapCodec("nutrition").required(), Types_v1_20_5.Food::getNutrition, Codec.FLOAT.mapCodec("saturation").required(), Types_v1_20_5.Food::getSaturation, Codec.BOOLEAN.mapCodec("can_always_eat").optional().defaulted(false), Types_v1_20_5.Food::isCanAlwaysEat, Codec.minExclusiveFloat(0.0f).mapCodec("eat_seconds").optional().defaulted(Float.valueOf(1.6f)), Types_v1_20_5.Food::getEatSeconds, MapCodecMerger.codec(this.typeSerializers.statusEffect().mapCodec("effect").required(), Types_v1_20_5.Food.Effect::getEffect, Codec.rangedFloat(0.0f, 1.0f).mapCodec("probability").optional().defaulted(Float.valueOf(1.0f)), Types_v1_20_5.Food.Effect::getProbability, Types_v1_20_5.Food.Effect::new).listOf().mapCodec("effects").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.Food::getEffects, Types_v1_20_5.Food::new));
    public final ItemComponent<Boolean> FIRE_RESISTANT = this.register("fire_resistant", Codec.UNIT);
    public final ItemComponent<Types_v1_20_5.ToolComponent> TOOL;
    public final ItemComponent<Types_v1_20_5.Enchantments> STORED_ENCHANTMENTS;
    public final ItemComponent<Types_v1_20_5.DyedColor> DYED_COLOR;
    public final ItemComponent<Integer> MAP_COLOR;
    public final ItemComponent<Integer> MAP_ID;
    public final ItemComponent<Map<String, Types_v1_20_5.MapDecoration>> MAP_DECORATIONS;
    public final ItemComponent<Types_v1_20_5.MapPostProcessing> MAP_POST_PROCESSING;
    public final ItemComponent<List<Types_v1_20_5.ItemStack>> CHARGED_PROJECTILES;
    public final ItemComponent<List<Types_v1_20_5.ItemStack>> BUNDLE_CONTENTS;
    public final ItemComponent<Types_v1_20_5.PotionContents> POTION_CONTENTS;
    public final ItemComponent<List<Types_v1_20_5.SuspiciousStewEffect>> SUSPICIOUS_STEW_EFFECTS;
    public final ItemComponent<Types_v1_20_5.WritableBook> WRITABLE_BOOK_CONTENT;
    public final ItemComponent<Types_v1_20_5.WrittenBook> WRITTEN_BOOK_CONTENT;
    public final ItemComponent<Types_v1_20_5.ArmorTrim> TRIM;
    public final ItemComponent<Map<RegistryEntry, String>> DEBUG_STICK_STATE;
    public final ItemComponent<CompoundTag> ENTITY_DATA;
    public final ItemComponent<CompoundTag> BUCKET_ENTITY_DATA;
    public final ItemComponent<CompoundTag> BLOCK_ENTITY_DATA;
    public final ItemComponent<EitherEntry<Types_v1_20_5.Instrument>> INSTRUMENT;
    public final ItemComponent<Integer> OMINOUS_BOTTLE_AMPLIFIER;
    public final ItemComponent<List<Identifier>> RECIPES;
    public final ItemComponent<Types_v1_20_5.LodestoneTracker> LODESTONE_TRACKER;
    public final ItemComponent<Types_v1_20_5.FireworkExplosions> FIREWORK_EXPLOSION;
    public final ItemComponent<Types_v1_20_5.Fireworks> FIREWORKS;
    public final ItemComponent<Types_v1_20_5.GameProfile> PROFILE;
    public final ItemComponent<Identifier> NOTE_BLOCK_SOUND;
    public final ItemComponent<List<Types_v1_20_5.BannerPattern>> BANNER_PATTERNS;
    public final ItemComponent<Types_v1_20_5.DyeColor> BASE_COLOR;
    public final ItemComponent<List<RegistryEntry>> POT_DECORATIONS;
    public final ItemComponent<List<Types_v1_20_5.ContainerSlot>> CONTAINER;
    public final ItemComponent<Map<String, String>> BLOCK_STATE;
    public final ItemComponent<List<Types_v1_20_5.BeeData>> BEES;
    public final ItemComponent<String> LOCK;
    public final ItemComponent<Types_v1_20_5.ContainerLoot> CONTAINER_LOOT;

    public ItemComponents_v1_20_5() {
        this.TOOL = this.register("tool", MapCodecMerger.codec(MapCodecMerger.codec(TagEntryList.codec(this.registries.block, false).mapCodec("blocks").required(), Types_v1_20_5.ToolComponent.Rule::getBlocks, Codec.minExclusiveFloat(0.0f).mapCodec("speed").optional().defaulted(null), Types_v1_20_5.ToolComponent.Rule::getSpeed, Codec.BOOLEAN.mapCodec("correct_for_drops").optional().defaulted(null), Types_v1_20_5.ToolComponent.Rule::getCorrectForDrops, Types_v1_20_5.ToolComponent.Rule::new).listOf().mapCodec("rules").required(), Types_v1_20_5.ToolComponent::getRules, Codec.FLOAT.mapCodec("default_mining_speed").optional().defaulted(Float.valueOf(1.0f)), Types_v1_20_5.ToolComponent::getDefaultMiningSpeed, Codec.minInt(0).mapCodec("damage_per_block").optional().defaulted(1), Types_v1_20_5.ToolComponent::getDamagePerBlock, Types_v1_20_5.ToolComponent::new));
        this.STORED_ENCHANTMENTS = this.copy("stored_enchantments", this.ENCHANTMENTS);
        this.DYED_COLOR = this.register("dyed_color", MapCodecMerger.codec(Codec.INTEGER.mapCodec("rgb").required(), Types_v1_20_5.DyedColor::getRgb, Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.DyedColor::isShowInTooltip, Types_v1_20_5.DyedColor::new));
        this.MAP_COLOR = this.register("map_color", Codec.INTEGER);
        this.MAP_ID = this.register("map_id", Codec.INTEGER);
        this.MAP_DECORATIONS = this.register("map_decorations", Codec.mapOf(Codec.STRING, MapCodecMerger.codec(this.registries.mapDecorationType.entryCodec().mapCodec("type").required(), Types_v1_20_5.MapDecoration::getType, Codec.DOUBLE.mapCodec("x").required(), Types_v1_20_5.MapDecoration::getX, Codec.DOUBLE.mapCodec("z").required(), Types_v1_20_5.MapDecoration::getZ, Codec.FLOAT.mapCodec("rotation").required(), Types_v1_20_5.MapDecoration::getRotation, Types_v1_20_5.MapDecoration::new)));
        this.MAP_POST_PROCESSING = this.registerNonSerializable("map_post_processing");
        this.CHARGED_PROJECTILES = this.register("charged_projectiles", this.typeSerializers.itemStack().listOf());
        this.BUNDLE_CONTENTS = this.register("bundle_contents", this.typeSerializers.itemStack().listOf());
        this.POTION_CONTENTS = this.register("potion_contents", Codec.oneOf(MapCodecMerger.codec(this.registries.potion.entryCodec().mapCodec("potion").optional().defaulted(null), Types_v1_20_5.PotionContents::getPotion, Codec.INTEGER.mapCodec("custom_color").optional().defaulted(null), Types_v1_20_5.PotionContents::getCustomColor, this.typeSerializers.statusEffect().listOf().mapCodec("custom_effects").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.PotionContents::getCustomEffects, Types_v1_20_5.PotionContents::new), this.registries.potion.entryCodec().map(Types_v1_20_5.PotionContents::getPotion, id -> new Types_v1_20_5.PotionContents((RegistryEntry)id, null, (List<Types_v1_20_5.StatusEffect>)new ArrayList<Types_v1_20_5.StatusEffect>()))));
        this.SUSPICIOUS_STEW_EFFECTS = this.register("suspicious_stew_effects", MapCodecMerger.codec(this.registries.statusEffect.entryCodec().mapCodec("id").required(), Types_v1_20_5.SuspiciousStewEffect::getId, Codec.INTEGER.mapCodec("duration").optional().lenient().defaulted(0), Types_v1_20_5.SuspiciousStewEffect::getDuration, Types_v1_20_5.SuspiciousStewEffect::new).listOf());
        this.WRITABLE_BOOK_CONTENT = this.register("writable_book_content", MapCodecMerger.codec(this.typeSerializers.rawFilteredPair(Codec.sizedString(0, 1024)).listOf().mapCodec("pages").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.WritableBook::getPages, Types_v1_20_5.WritableBook::new));
        this.WRITTEN_BOOK_CONTENT = this.register("written_book_content", MapCodecMerger.codec(this.typeSerializers.rawFilteredPair(Codec.sizedString(0, 32)).mapCodec("title").required(), Types_v1_20_5.WrittenBook::getTitle, Codec.STRING.mapCodec("author").required(), Types_v1_20_5.WrittenBook::getAuthor, Codec.rangedInt(0, 3).mapCodec("generation").optional().defaulted(0), Types_v1_20_5.WrittenBook::getGeneration, this.typeSerializers.rawFilteredPair(this.typeSerializers.textComponent(Short.MAX_VALUE)).listOf().mapCodec("pages").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.WrittenBook::getPages, Codec.BOOLEAN.mapCodec("resolved").optional().defaulted(false), Types_v1_20_5.WrittenBook::isResolved, Types_v1_20_5.WrittenBook::new));
        this.TRIM = this.register("trim", MapCodecMerger.codec(this.typeSerializers.armorTrimMaterial().mapCodec("material").required(), Types_v1_20_5.ArmorTrim::getMaterial, this.typeSerializers.armorTrimPattern().mapCodec("pattern").required(), Types_v1_20_5.ArmorTrim::getPattern, Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.ArmorTrim::isShowInTooltip, Types_v1_20_5.ArmorTrim::new));
        this.DEBUG_STICK_STATE = this.register("debug_stick_state", Codec.mapOf(this.registries.block.entryCodec(), block -> Codec.STRING.verified(value -> {
            if (this.verifiers.verifyBlockState((RegistryEntry)block, (String)value)) {
                return Result.success(null);
            }
            return Result.error("Invalid " + block + " block state value: " + value);
        })));
        this.ENTITY_DATA = this.register("entity_data", this.typeSerializers.customData().verified(tag -> {
            if (!(tag.get("id") instanceof StringTag)) {
                return Result.error("Entity data tag does not contain an id");
            }
            return Result.success(null);
        }));
        this.BUCKET_ENTITY_DATA = this.register("bucket_entity_data", this.typeSerializers.customData());
        this.BLOCK_ENTITY_DATA = this.register("block_entity_data", this.typeSerializers.customData().verified(tag -> {
            if (!(tag.get("id") instanceof StringTag)) {
                return Result.error("Block entity data tag does not contain an id");
            }
            return Result.success(null);
        }));
        this.INSTRUMENT = this.register("instrument", EitherEntry.codec(this.registries.instrument, MapCodecMerger.codec(this.typeSerializers.soundEvent().mapCodec("sound_event").required(), Types_v1_20_5.Instrument::getSoundEvent, Codec.minInt(1).mapCodec("use_duration").required(), Types_v1_20_5.Instrument::getUseDuration, Codec.minExclusiveFloat(0.0f).mapCodec("range").required(), Types_v1_20_5.Instrument::getRange, Types_v1_20_5.Instrument::new)));
        this.OMINOUS_BOTTLE_AMPLIFIER = this.register("ominous_bottle_amplifier", Codec.rangedInt(1, 4));
        this.RECIPES = this.register("recipes", Codec.STRING_IDENTIFIER.listOf());
        this.LODESTONE_TRACKER = this.register("lodestone_tracker", MapCodecMerger.codec(MapCodecMerger.codec(this.registries.dimension.entryCodec().mapCodec("dimension").required(), Types_v1_20_5.LodestoneTracker.GlobalPos::getDimension, this.typeSerializers.blockPos().mapCodec("pos").required(), Types_v1_20_5.LodestoneTracker.GlobalPos::getPos, Types_v1_20_5.LodestoneTracker.GlobalPos::new).mapCodec("target").optional().defaulted(null), Types_v1_20_5.LodestoneTracker::getTarget, Codec.BOOLEAN.mapCodec("tracked").optional().defaulted(true), Types_v1_20_5.LodestoneTracker::isTracked, Types_v1_20_5.LodestoneTracker::new));
        this.FIREWORK_EXPLOSION = this.register("firework_explosion", MapCodecMerger.codec(Codec.named((NamedType[])Types_v1_20_5.FireworkExplosions.ExplosionShape.values()).mapCodec("shape").required(), Types_v1_20_5.FireworkExplosions::getShape, Codec.INTEGER.listOf().mapCodec("colors").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.FireworkExplosions::getColors, Codec.INTEGER.listOf().mapCodec("fade_colors").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.FireworkExplosions::getFadeColors, Codec.BOOLEAN.mapCodec("has_trail").optional().defaulted(false), Types_v1_20_5.FireworkExplosions::isHasTrail, Codec.BOOLEAN.mapCodec("has_twinkle").optional().defaulted(false), Types_v1_20_5.FireworkExplosions::isHasTwinkle, Types_v1_20_5.FireworkExplosions::new));
        this.FIREWORKS = this.register("fireworks", MapCodecMerger.codec(Codec.UNSIGNED_BYTE.mapCodec("flight_duration").optional().defaulted(0), Types_v1_20_5.Fireworks::getFlightDuration, this.FIREWORK_EXPLOSION.getCodec().listOf().mapCodec("explosions").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.Fireworks::getExplosions, Types_v1_20_5.Fireworks::new));
        this.PROFILE = this.register("profile", Codec.oneOf(MapCodecMerger.codec(this.typeSerializers.playerName().mapCodec("name").optional().defaulted(null), Types_v1_20_5.GameProfile::getName, Codec.INT_ARRAY_UUID.mapCodec("id").optional().defaulted(null), Types_v1_20_5.GameProfile::getUuid, Codec.oneOf(Codec.mapOf(Codec.STRING, Codec.STRING.listOf()).flatMap(properties -> Result.error("Can't serialize properties to String/String map"), map -> {
            HashMap<String, List> properties = new HashMap<String, List>();
            for (Map.Entry entry : map.entrySet()) {
                for (String val : (List)entry.getValue()) {
                    properties.computeIfAbsent((String)entry.getKey(), key -> new ArrayList()).add(new Types_v1_20_5.GameProfile.Property((String)entry.getKey(), val, null));
                }
            }
            return Result.success(properties);
        }), MapCodecMerger.codec(Codec.STRING.mapCodec("name").required(), Types_v1_20_5.GameProfile.Property::getName, Codec.STRING.mapCodec("value").required(), Types_v1_20_5.GameProfile.Property::getValue, Codec.STRING.mapCodec("signature").optional().lenient().defaulted(null), Types_v1_20_5.GameProfile.Property::getSignature, Types_v1_20_5.GameProfile.Property::new).listOf().map(properties -> {
            ArrayList list = new ArrayList();
            for (Map.Entry entry : properties.entrySet()) {
                list.addAll((Collection)entry.getValue());
            }
            return list;
        }, list -> {
            HashMap<String, List> properties = new HashMap<String, List>();
            for (Types_v1_20_5.GameProfile.Property property : list) {
                properties.computeIfAbsent(property.getName(), key -> new ArrayList()).add(property);
            }
            return properties;
        })).mapCodec("properties").optional().defaulted(Map::isEmpty, HashMap::new), Types_v1_20_5.GameProfile::getProperties, Types_v1_20_5.GameProfile::new), this.typeSerializers.playerName().map(Types_v1_20_5.GameProfile::getName, name -> new Types_v1_20_5.GameProfile((String)name, null, (Map<String, List<Types_v1_20_5.GameProfile.Property>>)new HashMap<String, List<Types_v1_20_5.GameProfile.Property>>()))));
        this.NOTE_BLOCK_SOUND = this.register("note_block_sound", Codec.STRING_IDENTIFIER);
        this.BANNER_PATTERNS = this.register("banner_patterns", MapCodecMerger.codec(EitherEntry.codec(this.registries.bannerPattern, MapCodecMerger.codec(Codec.STRING_IDENTIFIER.mapCodec("asset_id").required(), Types_v1_20_5.BannerPattern.Pattern::getAssetId, Codec.STRING.mapCodec("translation_key").required(), Types_v1_20_5.BannerPattern.Pattern::getTranslationKey, Types_v1_20_5.BannerPattern.Pattern::new)).mapCodec("pattern").required(), Types_v1_20_5.BannerPattern::getPattern, this.typeSerializers.dyeColor().mapCodec("color").required(), Types_v1_20_5.BannerPattern::getColor, Types_v1_20_5.BannerPattern::new).listOf());
        this.BASE_COLOR = this.register("base_color", this.typeSerializers.dyeColor());
        this.POT_DECORATIONS = this.register("pot_decorations", this.registries.item.entryCodec().listOf(4));
        this.CONTAINER = this.register("container", MapCodecMerger.codec(Codec.rangedInt(0, 255).mapCodec("slot").required(), Types_v1_20_5.ContainerSlot::getSlot, this.typeSerializers.itemStack().mapCodec("item").required(), Types_v1_20_5.ContainerSlot::getItem, Types_v1_20_5.ContainerSlot::new).listOf(256));
        this.BLOCK_STATE = this.register("block_state", Codec.mapOf(Codec.STRING, Codec.STRING));
        this.BEES = this.register("bees", MapCodecMerger.codec(this.typeSerializers.customData().mapCodec("entity_data").optional().defaulted(CompoundTag::isEmpty, CompoundTag::new), Types_v1_20_5.BeeData::getEntityData, Codec.INTEGER.mapCodec("ticks_in_hive").required(), Types_v1_20_5.BeeData::getTicksInHive, Codec.INTEGER.mapCodec("min_ticks_in_hive").required(), Types_v1_20_5.BeeData::getMinTicksInHive, Types_v1_20_5.BeeData::new).listOf());
        this.LOCK = this.register("lock", Codec.STRING);
        this.CONTAINER_LOOT = this.register("container_loot", MapCodecMerger.codec(Codec.STRING_IDENTIFIER.mapCodec("loot_table").required(), Types_v1_20_5.ContainerLoot::getLootTable, Codec.LONG.mapCodec("seed").optional().defaulted(0L), Types_v1_20_5.ContainerLoot::getSeed, Types_v1_20_5.ContainerLoot::new));
        this.sort("custom_data", "max_stack_size", "max_damage", "damage", "unbreakable", "custom_name", "item_name", "lore", "rarity", "enchantments", "can_place_on", "can_break", "attribute_modifiers", "custom_model_data", "hide_additional_tooltip", "hide_tooltip", "repair_cost", "creative_slot_lock", "enchantment_glint_override", "intangible_projectile", "food", "fire_resistant", "tool", "stored_enchantments", "dyed_color", "map_color", "map_id", "map_decorations", "map_post_processing", "charged_projectiles", "bundle_contents", "potion_contents", "suspicious_stew_effects", "writable_book_content", "written_book_content", "trim", "debug_stick_state", "entity_data", "bucket_entity_data", "block_entity_data", "instrument", "ominous_bottle_amplifier", "recipes", "lodestone_tracker", "firework_explosion", "fireworks", "profile", "note_block_sound", "banner_patterns", "base_color", "pot_decorations", "container", "block_state", "bees", "lock", "container_loot");
    }

    public ItemComponents_v1_20_5(Registries registryVerifier, Verifiers verifiers) {
        super(registryVerifier, verifiers);
        this.TOOL = this.register("tool", MapCodecMerger.codec(MapCodecMerger.codec(TagEntryList.codec(this.registries.block, false).mapCodec("blocks").required(), Types_v1_20_5.ToolComponent.Rule::getBlocks, Codec.minExclusiveFloat(0.0f).mapCodec("speed").optional().defaulted(null), Types_v1_20_5.ToolComponent.Rule::getSpeed, Codec.BOOLEAN.mapCodec("correct_for_drops").optional().defaulted(null), Types_v1_20_5.ToolComponent.Rule::getCorrectForDrops, Types_v1_20_5.ToolComponent.Rule::new).listOf().mapCodec("rules").required(), Types_v1_20_5.ToolComponent::getRules, Codec.FLOAT.mapCodec("default_mining_speed").optional().defaulted(Float.valueOf(1.0f)), Types_v1_20_5.ToolComponent::getDefaultMiningSpeed, Codec.minInt(0).mapCodec("damage_per_block").optional().defaulted(1), Types_v1_20_5.ToolComponent::getDamagePerBlock, Types_v1_20_5.ToolComponent::new));
        this.STORED_ENCHANTMENTS = this.copy("stored_enchantments", this.ENCHANTMENTS);
        this.DYED_COLOR = this.register("dyed_color", MapCodecMerger.codec(Codec.INTEGER.mapCodec("rgb").required(), Types_v1_20_5.DyedColor::getRgb, Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.DyedColor::isShowInTooltip, Types_v1_20_5.DyedColor::new));
        this.MAP_COLOR = this.register("map_color", Codec.INTEGER);
        this.MAP_ID = this.register("map_id", Codec.INTEGER);
        this.MAP_DECORATIONS = this.register("map_decorations", Codec.mapOf(Codec.STRING, MapCodecMerger.codec(this.registries.mapDecorationType.entryCodec().mapCodec("type").required(), Types_v1_20_5.MapDecoration::getType, Codec.DOUBLE.mapCodec("x").required(), Types_v1_20_5.MapDecoration::getX, Codec.DOUBLE.mapCodec("z").required(), Types_v1_20_5.MapDecoration::getZ, Codec.FLOAT.mapCodec("rotation").required(), Types_v1_20_5.MapDecoration::getRotation, Types_v1_20_5.MapDecoration::new)));
        this.MAP_POST_PROCESSING = this.registerNonSerializable("map_post_processing");
        this.CHARGED_PROJECTILES = this.register("charged_projectiles", this.typeSerializers.itemStack().listOf());
        this.BUNDLE_CONTENTS = this.register("bundle_contents", this.typeSerializers.itemStack().listOf());
        this.POTION_CONTENTS = this.register("potion_contents", Codec.oneOf(MapCodecMerger.codec(this.registries.potion.entryCodec().mapCodec("potion").optional().defaulted(null), Types_v1_20_5.PotionContents::getPotion, Codec.INTEGER.mapCodec("custom_color").optional().defaulted(null), Types_v1_20_5.PotionContents::getCustomColor, this.typeSerializers.statusEffect().listOf().mapCodec("custom_effects").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.PotionContents::getCustomEffects, Types_v1_20_5.PotionContents::new), this.registries.potion.entryCodec().map(Types_v1_20_5.PotionContents::getPotion, id -> new Types_v1_20_5.PotionContents((RegistryEntry)id, null, (List<Types_v1_20_5.StatusEffect>)new ArrayList<Types_v1_20_5.StatusEffect>()))));
        this.SUSPICIOUS_STEW_EFFECTS = this.register("suspicious_stew_effects", MapCodecMerger.codec(this.registries.statusEffect.entryCodec().mapCodec("id").required(), Types_v1_20_5.SuspiciousStewEffect::getId, Codec.INTEGER.mapCodec("duration").optional().lenient().defaulted(0), Types_v1_20_5.SuspiciousStewEffect::getDuration, Types_v1_20_5.SuspiciousStewEffect::new).listOf());
        this.WRITABLE_BOOK_CONTENT = this.register("writable_book_content", MapCodecMerger.codec(this.typeSerializers.rawFilteredPair(Codec.sizedString(0, 1024)).listOf().mapCodec("pages").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.WritableBook::getPages, Types_v1_20_5.WritableBook::new));
        this.WRITTEN_BOOK_CONTENT = this.register("written_book_content", MapCodecMerger.codec(this.typeSerializers.rawFilteredPair(Codec.sizedString(0, 32)).mapCodec("title").required(), Types_v1_20_5.WrittenBook::getTitle, Codec.STRING.mapCodec("author").required(), Types_v1_20_5.WrittenBook::getAuthor, Codec.rangedInt(0, 3).mapCodec("generation").optional().defaulted(0), Types_v1_20_5.WrittenBook::getGeneration, this.typeSerializers.rawFilteredPair(this.typeSerializers.textComponent(Short.MAX_VALUE)).listOf().mapCodec("pages").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.WrittenBook::getPages, Codec.BOOLEAN.mapCodec("resolved").optional().defaulted(false), Types_v1_20_5.WrittenBook::isResolved, Types_v1_20_5.WrittenBook::new));
        this.TRIM = this.register("trim", MapCodecMerger.codec(this.typeSerializers.armorTrimMaterial().mapCodec("material").required(), Types_v1_20_5.ArmorTrim::getMaterial, this.typeSerializers.armorTrimPattern().mapCodec("pattern").required(), Types_v1_20_5.ArmorTrim::getPattern, Codec.BOOLEAN.mapCodec("show_in_tooltip").optional().defaulted(true), Types_v1_20_5.ArmorTrim::isShowInTooltip, Types_v1_20_5.ArmorTrim::new));
        this.DEBUG_STICK_STATE = this.register("debug_stick_state", Codec.mapOf(this.registries.block.entryCodec(), block -> Codec.STRING.verified(value -> {
            if (this.verifiers.verifyBlockState((RegistryEntry)block, (String)value)) {
                return Result.success(null);
            }
            return Result.error("Invalid " + block + " block state value: " + value);
        })));
        this.ENTITY_DATA = this.register("entity_data", this.typeSerializers.customData().verified(tag -> {
            if (!(tag.get("id") instanceof StringTag)) {
                return Result.error("Entity data tag does not contain an id");
            }
            return Result.success(null);
        }));
        this.BUCKET_ENTITY_DATA = this.register("bucket_entity_data", this.typeSerializers.customData());
        this.BLOCK_ENTITY_DATA = this.register("block_entity_data", this.typeSerializers.customData().verified(tag -> {
            if (!(tag.get("id") instanceof StringTag)) {
                return Result.error("Block entity data tag does not contain an id");
            }
            return Result.success(null);
        }));
        this.INSTRUMENT = this.register("instrument", EitherEntry.codec(this.registries.instrument, MapCodecMerger.codec(this.typeSerializers.soundEvent().mapCodec("sound_event").required(), Types_v1_20_5.Instrument::getSoundEvent, Codec.minInt(1).mapCodec("use_duration").required(), Types_v1_20_5.Instrument::getUseDuration, Codec.minExclusiveFloat(0.0f).mapCodec("range").required(), Types_v1_20_5.Instrument::getRange, Types_v1_20_5.Instrument::new)));
        this.OMINOUS_BOTTLE_AMPLIFIER = this.register("ominous_bottle_amplifier", Codec.rangedInt(1, 4));
        this.RECIPES = this.register("recipes", Codec.STRING_IDENTIFIER.listOf());
        this.LODESTONE_TRACKER = this.register("lodestone_tracker", MapCodecMerger.codec(MapCodecMerger.codec(this.registries.dimension.entryCodec().mapCodec("dimension").required(), Types_v1_20_5.LodestoneTracker.GlobalPos::getDimension, this.typeSerializers.blockPos().mapCodec("pos").required(), Types_v1_20_5.LodestoneTracker.GlobalPos::getPos, Types_v1_20_5.LodestoneTracker.GlobalPos::new).mapCodec("target").optional().defaulted(null), Types_v1_20_5.LodestoneTracker::getTarget, Codec.BOOLEAN.mapCodec("tracked").optional().defaulted(true), Types_v1_20_5.LodestoneTracker::isTracked, Types_v1_20_5.LodestoneTracker::new));
        this.FIREWORK_EXPLOSION = this.register("firework_explosion", MapCodecMerger.codec(Codec.named((NamedType[])Types_v1_20_5.FireworkExplosions.ExplosionShape.values()).mapCodec("shape").required(), Types_v1_20_5.FireworkExplosions::getShape, Codec.INTEGER.listOf().mapCodec("colors").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.FireworkExplosions::getColors, Codec.INTEGER.listOf().mapCodec("fade_colors").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.FireworkExplosions::getFadeColors, Codec.BOOLEAN.mapCodec("has_trail").optional().defaulted(false), Types_v1_20_5.FireworkExplosions::isHasTrail, Codec.BOOLEAN.mapCodec("has_twinkle").optional().defaulted(false), Types_v1_20_5.FireworkExplosions::isHasTwinkle, Types_v1_20_5.FireworkExplosions::new));
        this.FIREWORKS = this.register("fireworks", MapCodecMerger.codec(Codec.UNSIGNED_BYTE.mapCodec("flight_duration").optional().defaulted(0), Types_v1_20_5.Fireworks::getFlightDuration, this.FIREWORK_EXPLOSION.getCodec().listOf().mapCodec("explosions").optional().defaulted(List::isEmpty, ArrayList::new), Types_v1_20_5.Fireworks::getExplosions, Types_v1_20_5.Fireworks::new));
        this.PROFILE = this.register("profile", Codec.oneOf(MapCodecMerger.codec(this.typeSerializers.playerName().mapCodec("name").optional().defaulted(null), Types_v1_20_5.GameProfile::getName, Codec.INT_ARRAY_UUID.mapCodec("id").optional().defaulted(null), Types_v1_20_5.GameProfile::getUuid, Codec.oneOf(Codec.mapOf(Codec.STRING, Codec.STRING.listOf()).flatMap(properties -> Result.error("Can't serialize properties to String/String map"), map -> {
            HashMap<String, List> properties = new HashMap<String, List>();
            for (Map.Entry entry : map.entrySet()) {
                for (String val : (List)entry.getValue()) {
                    properties.computeIfAbsent((String)entry.getKey(), key -> new ArrayList()).add(new Types_v1_20_5.GameProfile.Property((String)entry.getKey(), val, null));
                }
            }
            return Result.success(properties);
        }), MapCodecMerger.codec(Codec.STRING.mapCodec("name").required(), Types_v1_20_5.GameProfile.Property::getName, Codec.STRING.mapCodec("value").required(), Types_v1_20_5.GameProfile.Property::getValue, Codec.STRING.mapCodec("signature").optional().lenient().defaulted(null), Types_v1_20_5.GameProfile.Property::getSignature, Types_v1_20_5.GameProfile.Property::new).listOf().map(properties -> {
            ArrayList list = new ArrayList();
            for (Map.Entry entry : properties.entrySet()) {
                list.addAll((Collection)entry.getValue());
            }
            return list;
        }, list -> {
            HashMap<String, List> properties = new HashMap<String, List>();
            for (Types_v1_20_5.GameProfile.Property property : list) {
                properties.computeIfAbsent(property.getName(), key -> new ArrayList()).add(property);
            }
            return properties;
        })).mapCodec("properties").optional().defaulted(Map::isEmpty, HashMap::new), Types_v1_20_5.GameProfile::getProperties, Types_v1_20_5.GameProfile::new), this.typeSerializers.playerName().map(Types_v1_20_5.GameProfile::getName, name -> new Types_v1_20_5.GameProfile((String)name, null, (Map<String, List<Types_v1_20_5.GameProfile.Property>>)new HashMap<String, List<Types_v1_20_5.GameProfile.Property>>()))));
        this.NOTE_BLOCK_SOUND = this.register("note_block_sound", Codec.STRING_IDENTIFIER);
        this.BANNER_PATTERNS = this.register("banner_patterns", MapCodecMerger.codec(EitherEntry.codec(this.registries.bannerPattern, MapCodecMerger.codec(Codec.STRING_IDENTIFIER.mapCodec("asset_id").required(), Types_v1_20_5.BannerPattern.Pattern::getAssetId, Codec.STRING.mapCodec("translation_key").required(), Types_v1_20_5.BannerPattern.Pattern::getTranslationKey, Types_v1_20_5.BannerPattern.Pattern::new)).mapCodec("pattern").required(), Types_v1_20_5.BannerPattern::getPattern, this.typeSerializers.dyeColor().mapCodec("color").required(), Types_v1_20_5.BannerPattern::getColor, Types_v1_20_5.BannerPattern::new).listOf());
        this.BASE_COLOR = this.register("base_color", this.typeSerializers.dyeColor());
        this.POT_DECORATIONS = this.register("pot_decorations", this.registries.item.entryCodec().listOf(4));
        this.CONTAINER = this.register("container", MapCodecMerger.codec(Codec.rangedInt(0, 255).mapCodec("slot").required(), Types_v1_20_5.ContainerSlot::getSlot, this.typeSerializers.itemStack().mapCodec("item").required(), Types_v1_20_5.ContainerSlot::getItem, Types_v1_20_5.ContainerSlot::new).listOf(256));
        this.BLOCK_STATE = this.register("block_state", Codec.mapOf(Codec.STRING, Codec.STRING));
        this.BEES = this.register("bees", MapCodecMerger.codec(this.typeSerializers.customData().mapCodec("entity_data").optional().defaulted(CompoundTag::isEmpty, CompoundTag::new), Types_v1_20_5.BeeData::getEntityData, Codec.INTEGER.mapCodec("ticks_in_hive").required(), Types_v1_20_5.BeeData::getTicksInHive, Codec.INTEGER.mapCodec("min_ticks_in_hive").required(), Types_v1_20_5.BeeData::getMinTicksInHive, Types_v1_20_5.BeeData::new).listOf());
        this.LOCK = this.register("lock", Codec.STRING);
        this.CONTAINER_LOOT = this.register("container_loot", MapCodecMerger.codec(Codec.STRING_IDENTIFIER.mapCodec("loot_table").required(), Types_v1_20_5.ContainerLoot::getLootTable, Codec.LONG.mapCodec("seed").optional().defaulted(0L), Types_v1_20_5.ContainerLoot::getSeed, Types_v1_20_5.ContainerLoot::new));
        this.sort("custom_data", "max_stack_size", "max_damage", "damage", "unbreakable", "custom_name", "item_name", "lore", "rarity", "enchantments", "can_place_on", "can_break", "attribute_modifiers", "custom_model_data", "hide_additional_tooltip", "hide_tooltip", "repair_cost", "creative_slot_lock", "enchantment_glint_override", "intangible_projectile", "food", "fire_resistant", "tool", "stored_enchantments", "dyed_color", "map_color", "map_id", "map_decorations", "map_post_processing", "charged_projectiles", "bundle_contents", "potion_contents", "suspicious_stew_effects", "writable_book_content", "written_book_content", "trim", "debug_stick_state", "entity_data", "bucket_entity_data", "block_entity_data", "instrument", "ominous_bottle_amplifier", "recipes", "lodestone_tracker", "firework_explosion", "fireworks", "profile", "note_block_sound", "banner_patterns", "base_color", "pot_decorations", "container", "block_state", "bees", "lock", "container_loot");
    }

    @Override
    public ItemComponentMap getItemDefaults() {
        return new ItemComponentMap(this).set(this.MAX_STACK_SIZE, 64).set(this.LORE, new ArrayList()).set(this.ENCHANTMENTS, new Types_v1_20_5.Enchantments(new HashMap<RegistryEntry, Integer>(), true)).set(this.REPAIR_COST, 0).set(this.ATTRIBUTE_MODIFIERS, new Types_v1_20_5.AttributeModifiers(new ArrayList<Types_v1_20_5.AttributeModifier>(), true)).set(this.RARITY, Types_v1_20_5.Rarity.COMMON);
    }

    @Override
    public <D> D mapTo(DataConverter<D> converter, ItemComponentMap map) {
        HashMap<D, D> out = new HashMap<D, D>();
        for (Map.Entry<ItemComponent<?>, ?> entry : map.getValues().entrySet()) {
            ItemComponent<?> component = entry.getKey();
            Object value = entry.getValue();
            String name = component.getName().get();
            out.put(converter.createString(name), component.serialize(converter, value));
        }
        for (ItemComponent itemComponent : map.getMarkedForRemoval()) {
            String name = "!" + itemComponent.getName().get();
            out.put(converter.createString(name), converter.emptyMap());
        }
        return converter.createUnsafeMap(out);
    }

    @Override
    public <D> ItemComponentMap mapFrom(DataConverter<D> converter, D data) {
        Map<String, D> map = converter.asStringTypeMap(data).getOrThrow();
        ItemComponentMap out = new ItemComponentMap(this);
        for (Map.Entry<String, D> entry : map.entrySet()) {
            Identifier id;
            ItemComponent component;
            String name = entry.getKey();
            boolean forRemoval = name.startsWith("!");
            if (forRemoval) {
                name = name.substring(1);
            }
            if ((component = this.getComponent(id = Identifier.of(name))) == null) {
                throw new IllegalArgumentException("Unknown item component: " + id);
            }
            if (forRemoval) {
                out.markForRemoval(component);
                continue;
            }
            out.set(component, component.deserialize(converter, entry.getValue()));
        }
        return out;
    }
}

