/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry;

import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Either;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.Registry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryEntry;
import java.util.Objects;
import javax.annotation.Nonnull;
import lombok.Generated;

public class EitherEntry<T> {
    private final RegistryEntry entry;
    private final T value;

    public static <T> Codec<EitherEntry<T>> codec(Registry registry, Codec<T> codec) {
        return Codec.either(codec, registry.entryCodec()).map(Either::swap, Either::swap).map(EitherEntry::either, EitherEntry::new);
    }

    public EitherEntry(Either<RegistryEntry, T> either) {
        if (either.isLeft()) {
            this.entry = either.getLeft();
            this.value = null;
        } else {
            this.entry = null;
            this.value = either.getRight();
        }
    }

    public EitherEntry(@Nonnull RegistryEntry entry) {
        this.entry = entry;
        this.value = null;
    }

    public EitherEntry(@Nonnull T value) {
        this.entry = null;
        this.value = value;
    }

    public boolean isLeft() {
        return this.entry != null;
    }

    public RegistryEntry getLeft() {
        if (this.entry == null) {
            throw new IllegalStateException("Either is not left");
        }
        return this.entry;
    }

    public boolean isRight() {
        return this.value != null;
    }

    public T getRight() {
        if (this.value == null) {
            throw new IllegalStateException("Either is not right");
        }
        return this.value;
    }

    public Either<RegistryEntry, T> either() {
        if (this.entry != null) {
            return Either.left(this.entry);
        }
        return Either.right(this.value);
    }

    public String toString() {
        return ToString.of(this).add("entry", this.entry, Objects::nonNull).add("value", this.value, Objects::nonNull).toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EitherEntry)) {
            return false;
        }
        EitherEntry other = (EitherEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RegistryEntry this$entry = this.entry;
        RegistryEntry other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !((Object)this$entry).equals(other$entry)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EitherEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegistryEntry $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : ((Object)$entry).hashCode());
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

