/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry;

import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Result;
import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.EitherEntry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryEntry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryTag;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Registry {
    private final Identifier name;
    private final Codec<RegistryEntry> entryCodec;

    protected Registry(@Nonnull Identifier name) {
        this.name = name;
        this.entryCodec = Codec.STRING_IDENTIFIER.flatMap(registryEntry -> Result.success(registryEntry.getId()), identifier -> {
            RegistryEntry entry = this.getEntry((Identifier)identifier);
            if (entry == null) {
                return Result.error("Entry " + identifier + " not found in registry " + name);
            }
            return Result.success(entry);
        });
    }

    public Identifier getName() {
        return this.name;
    }

    public Codec<RegistryEntry> entryCodec() {
        return this.entryCodec;
    }

    @Nullable
    public abstract RegistryEntry getEntry(Identifier var1);

    @Nullable
    public abstract RegistryEntry getEntry(int var1);

    @Nullable
    public abstract Integer getNetworkId(Identifier var1);

    @Nullable
    public abstract Identifier getId(int var1);

    @Nullable
    public <T> EitherEntry<T> getLeftEntry(Identifier id) {
        RegistryEntry entry = this.getEntry(id);
        if (entry == null) {
            return null;
        }
        return new EitherEntry<RegistryEntry>(entry);
    }

    @Nullable
    public <T> EitherEntry<T> getLeftEntry(int networkId) {
        RegistryEntry entry = this.getEntry(networkId);
        if (entry == null) {
            return null;
        }
        return new EitherEntry<RegistryEntry>(entry);
    }

    @Nullable
    public abstract RegistryTag getTag(Identifier var1);

    public String toString() {
        return ToString.of(this).add("name", this.name).toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Registry registry = (Registry)o;
        return Objects.equals(this.name, registry.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

