/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry;

import com.viaversion.viaversion.libs.mcstructs.converter.codec.Codec;
import com.viaversion.viaversion.libs.mcstructs.converter.model.Either;
import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.Registry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryEntry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryTag;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;

public class TagEntryList {
    private final RegistryTag tag;
    private final List<RegistryEntry> entries;

    private static Codec<List<RegistryEntry>> homogenousList(Codec<RegistryEntry> entryCodec, boolean requireList) {
        Codec<List<RegistryEntry>> listCodec = entryCodec.listOf();
        if (requireList) {
            return listCodec;
        }
        return Codec.either(listCodec, entryCodec).map(registryEntries -> {
            if (registryEntries.size() == 1) {
                return Either.right(registryEntries.get(0));
            }
            return Either.left(registryEntries);
        }, either -> either.xmap(Function.identity(), xva$0 -> Arrays.asList(xva$0)));
    }

    public static Codec<TagEntryList> codec(Registry registry, boolean requireList) {
        return Codec.either(RegistryTag.codec(registry), TagEntryList.homogenousList(registry.entryCodec(), requireList)).map(tagEntryList -> tagEntryList.isTag() ? Either.left(tagEntryList.getTag()) : Either.right(tagEntryList.getEntries()), either -> either.xmap(TagEntryList::new, TagEntryList::new));
    }

    public TagEntryList(RegistryTag tag) {
        this.tag = tag;
        this.entries = null;
    }

    public TagEntryList(List<RegistryEntry> entries) {
        this.tag = null;
        this.entries = entries;
    }

    public boolean isTag() {
        return this.tag != null;
    }

    public boolean isEntries() {
        return this.entries != null;
    }

    public RegistryTag getTag() {
        return this.tag;
    }

    public List<RegistryEntry> getEntries() {
        return this.entries;
    }

    public String toString() {
        return ToString.of(this).add("tag", this.tag, Objects::nonNull).add("entries", this.entries, Objects::nonNull).toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagEntryList)) {
            return false;
        }
        TagEntryList other = (TagEntryList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RegistryTag this$tag = this.getTag();
        RegistryTag other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        List<RegistryEntry> this$entries = this.getEntries();
        List<RegistryEntry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TagEntryList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegistryTag $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        List<RegistryEntry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }
}

