/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.protocols.v1_21_4to1_21_5.storage;

import com.google.common.cache.CacheBuilder;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.data.item.ItemHasher;
import com.viaversion.viaversion.api.minecraft.data.StructuredData;
import com.viaversion.viaversion.libs.mcstructs.converter.impl.v1_21_5.HashConverter_v1_21_5;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentRegistry;
import com.viaversion.viaversion.rewriter.item.ItemDataComponentConverter;
import com.viaversion.viaversion.util.SerializerVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ItemHashStorage1_21_5
implements ItemHasher {
    private final Map<Long, StructuredData<?>> hashToStructuredData = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(512L).build().asMap();
    private final List<String> enchantmentRegistry = new ArrayList<String>();
    private final ItemDataComponentConverter itemComponentConverter;
    private boolean processingClientboundInventoryPacket;

    public ItemHashStorage1_21_5(MappingData mappingData) {
        ItemDataComponentConverter.RegistryAccess registryAccess = ItemDataComponentConverter.RegistryAccess.of(this.enchantmentRegistry, ItemComponentRegistry.V1_21_5.getRegistries(), mappingData);
        this.itemComponentConverter = new ItemDataComponentConverter(SerializerVersion.V1_21_5, registryAccess);
    }

    @Override
    public void setEnchantments(List<String> enchantments) {
        this.enchantmentRegistry.clear();
        this.enchantmentRegistry.addAll(enchantments);
    }

    public void trackStructuredData(StructuredData<?> structuredData) {
        if (structuredData.isEmpty()) {
            return;
        }
        ItemDataComponentConverter.Result<?> result = this.itemComponentConverter.viaToMcStructs(structuredData);
        if (result == null) {
            return;
        }
        long key = (long)structuredData.id() << 32 | (long)ItemHashStorage1_21_5.hash(result);
        this.hashToStructuredData.computeIfAbsent(key, $ -> structuredData.copy());
    }

    public StructuredData<?> dataFromHash(int dataComponentId, int hash) {
        long key = (long)dataComponentId << 32 | (long)hash;
        StructuredData<?> data = this.hashToStructuredData.get(key);
        return data != null ? data.copy() : null;
    }

    private static <T> int hash(ItemDataComponentConverter.Result<T> result) {
        return result.type().getCodec().serialize(HashConverter_v1_21_5.CRC32C, result.value()).getOrThrow().asInt();
    }

    @Override
    public boolean isProcessingClientboundInventoryPacket() {
        return this.processingClientboundInventoryPacket;
    }

    @Override
    public void setProcessingClientboundInventoryPacket(boolean processingClientboundInventoryPacket) {
        this.processingClientboundInventoryPacket = processingClientboundInventoryPacket;
    }
}

