/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter.item;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.minecraft.GameProfile;
import com.viaversion.viaversion.api.minecraft.data.StructuredData;
import com.viaversion.viaversion.api.minecraft.data.StructuredDataKey;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.data.Bee;
import com.viaversion.viaversion.api.minecraft.item.data.Enchantments;
import com.viaversion.viaversion.api.minecraft.item.data.FilterableComponent;
import com.viaversion.viaversion.api.minecraft.item.data.FilterableString;
import com.viaversion.viaversion.api.minecraft.item.data.FireworkExplosion;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.objects.Reference2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.mcstructs.converter.impl.v1_21_5.NbtConverter_v1_21_5;
import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponent;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentMap;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.ItemComponentRegistry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.Registries;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_20_5.Types_v1_20_5;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21_2.Types_v1_21_2;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21_4.Types_v1_21_4;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.v1_21_5.Types_v1_21_5;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.Registry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryEntry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryTag;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import com.viaversion.viaversion.rewriter.item.RegistryAccessImpl;
import com.viaversion.viaversion.util.SerializerVersion;
import com.viaversion.viaversion.util.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ItemDataComponentConverter {
    private final Map<StructuredDataKey<?>, Converter<?, ?>> converters = new Reference2ObjectOpenHashMap();
    private final SerializerVersion serializerVersion;
    private final RegistryAccess registryAccess;

    public ItemDataComponentConverter(SerializerVersion serializerVersion, RegistryAccess registryAccess) {
        this.serializerVersion = serializerVersion;
        this.registryAccess = registryAccess;
        this.direct(StructuredDataKey.CUSTOM_DATA, ItemComponentRegistry.V1_21_5.CUSTOM_DATA);
        this.direct(StructuredDataKey.MAX_STACK_SIZE, ItemComponentRegistry.V1_21_5.MAX_STACK_SIZE);
        this.direct(StructuredDataKey.MAX_DAMAGE, ItemComponentRegistry.V1_21_5.MAX_DAMAGE);
        this.direct(StructuredDataKey.DAMAGE, ItemComponentRegistry.V1_21_5.DAMAGE);
        this.unit(StructuredDataKey.UNBREAKABLE1_21_5, ItemComponentRegistry.V1_21_5.UNBREAKABLE);
        this.textComponent(StructuredDataKey.CUSTOM_NAME, ItemComponentRegistry.V1_21_5.CUSTOM_NAME);
        this.textComponent(StructuredDataKey.ITEM_NAME, ItemComponentRegistry.V1_21_5.ITEM_NAME);
        this.identifier(StructuredDataKey.ITEM_MODEL, ItemComponentRegistry.V1_21_5.ITEM_MODEL);
        this.register(StructuredDataKey.LORE, this.stringArrayToTextComponentArray(ItemComponentRegistry.V1_21_5.LORE));
        this.intToEnum(StructuredDataKey.RARITY, ItemComponentRegistry.V1_21_5.RARITY, Types_v1_20_5.Rarity.class);
        this.register(StructuredDataKey.ENCHANTMENTS1_21_5, this.convertEnchantmentsFunction(ItemComponentRegistry.V1_21_5.ENCHANTMENTS));
        this.notImplemented(StructuredDataKey.CAN_PLACE_ON1_21_5);
        this.notImplemented(StructuredDataKey.CAN_BREAK1_21_5);
        this.notImplemented(StructuredDataKey.ATTRIBUTE_MODIFIERS1_21_5);
        this.register(StructuredDataKey.CUSTOM_MODEL_DATA1_21_4, customModelData -> {
            ArrayList<Float> floats = new ArrayList<Float>(customModelData.floats().length);
            for (float f : customModelData.floats()) {
                floats.add(Float.valueOf(f));
            }
            ArrayList<Boolean> booleans = new ArrayList<Boolean>(customModelData.booleans().length);
            for (boolean b : customModelData.booleans()) {
                booleans.add(b);
            }
            return new Result<Types_v1_21_4.CustomModelData>(ItemComponentRegistry.V1_21_5.CUSTOM_MODEL_DATA, new Types_v1_21_4.CustomModelData(floats, booleans, Arrays.asList(customModelData.strings()), ItemDataComponentConverter.intArrayToIntList(customModelData.colors())));
        });
        this.notImplemented(StructuredDataKey.TOOLTIP_DISPLAY);
        this.direct(StructuredDataKey.REPAIR_COST, ItemComponentRegistry.V1_21_5.REPAIR_COST);
        this.unit(StructuredDataKey.CREATIVE_SLOT_LOCK, ItemComponentRegistry.V1_21_5.CREATIVE_SLOT_LOCK);
        this.direct(StructuredDataKey.ENCHANTMENT_GLINT_OVERRIDE, ItemComponentRegistry.V1_21_5.ENCHANTMENT_GLINT_OVERRIDE);
        this.register(StructuredDataKey.INTANGIBLE_PROJECTILE, value -> new Result<Object>(ItemComponentRegistry.V1_21_5.INTANGIBLE_PROJECTILE, null));
        this.register(StructuredDataKey.FOOD1_21_2, foodProperties -> new Result<Types_v1_21_2.Food>(ItemComponentRegistry.V1_21_5.FOOD, new Types_v1_21_2.Food(foodProperties.nutrition(), foodProperties.saturationModifier(), foodProperties.canAlwaysEat())));
        this.notImplemented(StructuredDataKey.CONSUMABLE1_21_2);
        this.item(StructuredDataKey.USE_REMAINDER1_21_5, ItemComponentRegistry.V1_21_5.USE_REMAINDER);
        this.register(StructuredDataKey.USE_COOLDOWN, useCooldown -> new Result<Types_v1_21_2.UseCooldown>(ItemComponentRegistry.V1_21_5.USE_COOLDOWN, new Types_v1_21_2.UseCooldown(useCooldown.seconds(), Identifier.of(useCooldown.cooldownGroup()))));
        this.register(StructuredDataKey.DAMAGE_RESISTANT, damageResistant -> new Result<Types_v1_21_2.DamageResistant>(ItemComponentRegistry.V1_21_5.DAMAGE_RESISTANT, new Types_v1_21_2.DamageResistant(new RegistryTag(this.registries().damageType, Identifier.of(damageResistant.typesTagKey())))));
        this.notImplemented(StructuredDataKey.TOOL1_21_5);
        this.register(StructuredDataKey.WEAPON, weapon -> new Result<Types_v1_21_5.Weapon>(ItemComponentRegistry.V1_21_5.WEAPON, new Types_v1_21_5.Weapon(weapon.itemDamagePerAttack(), weapon.disableBlockingForSeconds())));
        this.register(StructuredDataKey.ENCHANTABLE, structuredData -> new Result<Types_v1_21_2.Enchantable>(ItemComponentRegistry.V1_21_5.ENCHANTABLE, new Types_v1_21_2.Enchantable((int)structuredData)));
        this.notImplemented(StructuredDataKey.EQUIPPABLE1_21_5);
        this.notImplemented(StructuredDataKey.REPAIRABLE);
        this.unit(StructuredDataKey.GLIDER, ItemComponentRegistry.V1_21_5.GLIDER);
        this.identifier(StructuredDataKey.TOOLTIP_STYLE, ItemComponentRegistry.V1_21_5.TOOLTIP_STYLE);
        this.notImplemented(StructuredDataKey.DEATH_PROTECTION);
        this.notImplemented(StructuredDataKey.BLOCKS_ATTACKS);
        this.register(StructuredDataKey.STORED_ENCHANTMENTS1_21_5, this.convertEnchantmentsFunction(ItemComponentRegistry.V1_21_5.STORED_ENCHANTMENTS));
        this.register(StructuredDataKey.DYED_COLOR1_21_5, dyedColor -> new Result<Integer>(ItemComponentRegistry.V1_21_5.DYED_COLOR, dyedColor.rgb()));
        this.direct(StructuredDataKey.MAP_COLOR, ItemComponentRegistry.V1_21_5.MAP_COLOR);
        this.direct(StructuredDataKey.MAP_ID, ItemComponentRegistry.V1_21_5.MAP_ID);
        this.register(StructuredDataKey.MAP_DECORATIONS, ItemDataComponentConverter.passthroughNbtCodec(ItemComponentRegistry.V1_21_5.MAP_DECORATIONS));
        this.intToEnum(StructuredDataKey.MAP_POST_PROCESSING, ItemComponentRegistry.V1_21_5.MAP_POST_PROCESSING, Types_v1_20_5.MapPostProcessing.class);
        this.register(StructuredDataKey.CHARGED_PROJECTILES1_21_5, this.convertItemArrayFunction(ItemComponentRegistry.V1_21_5.CHARGED_PROJECTILES));
        this.register(StructuredDataKey.BUNDLE_CONTENTS1_21_5, this.convertItemArrayFunction(ItemComponentRegistry.V1_21_5.BUNDLE_CONTENTS));
        this.notImplemented(StructuredDataKey.POTION_CONTENTS1_21_2);
        this.direct(StructuredDataKey.POTION_DURATION_SCALE, ItemComponentRegistry.V1_21_5.POTION_DURATION_SCALE);
        this.notImplemented(StructuredDataKey.SUSPICIOUS_STEW_EFFECTS);
        this.register(StructuredDataKey.WRITABLE_BOOK_CONTENT, pages -> {
            ArrayList<Types_v1_20_5.RawFilteredPair<String>> resultPages = new ArrayList<Types_v1_20_5.RawFilteredPair<String>>(((FilterableString[])pages).length);
            for (FilterableString page : pages) {
                resultPages.add(new Types_v1_20_5.RawFilteredPair<String>((String)page.raw(), (String)page.filtered()));
            }
            return new Result<Types_v1_20_5.WritableBook>(ItemComponentRegistry.V1_21_5.WRITABLE_BOOK_CONTENT, new Types_v1_20_5.WritableBook(resultPages));
        });
        this.register(StructuredDataKey.WRITTEN_BOOK_CONTENT, writtenBook -> {
            Types_v1_20_5.RawFilteredPair<String> resultTitle = new Types_v1_20_5.RawFilteredPair<String>((String)writtenBook.title().raw(), (String)writtenBook.title().filtered());
            ArrayList<Types_v1_20_5.RawFilteredPair<TextComponent>> resultPages = new ArrayList<Types_v1_20_5.RawFilteredPair<TextComponent>>(writtenBook.pages().length);
            for (FilterableComponent page : writtenBook.pages()) {
                resultPages.add(new Types_v1_20_5.RawFilteredPair<TextComponent>(this.convertTextComponent((Tag)page.raw()), this.convertTextComponent((Tag)page.filtered())));
            }
            return new Result<Types_v1_20_5.WrittenBook>(ItemComponentRegistry.V1_21_5.WRITTEN_BOOK_CONTENT, new Types_v1_20_5.WrittenBook(resultTitle, writtenBook.author(), writtenBook.generation(), resultPages, writtenBook.resolved()));
        });
        this.notImplemented(StructuredDataKey.TRIM1_21_5);
        this.register(StructuredDataKey.DEBUG_STICK_STATE, ItemDataComponentConverter.passthroughNbtCodec(ItemComponentRegistry.V1_21_5.DEBUG_STICK_STATE));
        this.direct(StructuredDataKey.ENTITY_DATA, ItemComponentRegistry.V1_21_5.ENTITY_DATA);
        this.direct(StructuredDataKey.BUCKET_ENTITY_DATA, ItemComponentRegistry.V1_21_5.BUCKET_ENTITY_DATA);
        this.direct(StructuredDataKey.BLOCK_ENTITY_DATA, ItemComponentRegistry.V1_21_5.BLOCK_ENTITY_DATA);
        this.notImplemented(StructuredDataKey.INSTRUMENT1_21_5);
        this.notImplemented(StructuredDataKey.PROVIDES_TRIM_MATERIAL);
        this.direct(StructuredDataKey.OMINOUS_BOTTLE_AMPLIFIER, ItemComponentRegistry.V1_21_5.OMINOUS_BOTTLE_AMPLIFIER);
        this.notImplemented(StructuredDataKey.JUKEBOX_PLAYABLE1_21_5);
        this.registryTag(StructuredDataKey.PROVIDES_BANNER_PATTERNS, ItemComponentRegistry.V1_21_5.PROVIDES_BANNER_PATTERNS, this.registries().bannerPattern);
        this.register(StructuredDataKey.RECIPES, ItemDataComponentConverter.passthroughNbtCodec(ItemComponentRegistry.V1_21_5.RECIPES));
        this.register(StructuredDataKey.LODESTONE_TRACKER, lodestoneTracker -> {
            Types_v1_20_5.LodestoneTracker.GlobalPos targetGlobalPos;
            if (lodestoneTracker.position() != null) {
                Types_v1_20_5.BlockPos targetPos = new Types_v1_20_5.BlockPos(lodestoneTracker.position().x(), lodestoneTracker.position().y(), lodestoneTracker.position().z());
                targetGlobalPos = new Types_v1_20_5.LodestoneTracker.GlobalPos(new RegistryEntry(this.registries().dimension, Identifier.of(lodestoneTracker.position().dimension())), targetPos);
            } else {
                targetGlobalPos = null;
            }
            return new Result<Types_v1_20_5.LodestoneTracker>(ItemComponentRegistry.V1_21_5.LODESTONE_TRACKER, new Types_v1_20_5.LodestoneTracker(targetGlobalPos, lodestoneTracker.tracked()));
        });
        this.register(StructuredDataKey.FIREWORK_EXPLOSION, fireworkExplosion -> new Result<Types_v1_20_5.FireworkExplosions>(ItemComponentRegistry.V1_21_5.FIREWORK_EXPLOSION, ItemDataComponentConverter.convertFireworkExplosion(fireworkExplosion)));
        this.register(StructuredDataKey.FIREWORKS, fireworks -> {
            ArrayList<Types_v1_20_5.FireworkExplosions> resultExplosions = new ArrayList<Types_v1_20_5.FireworkExplosions>(fireworks.explosions().length);
            for (FireworkExplosion explosion : fireworks.explosions()) {
                resultExplosions.add(ItemDataComponentConverter.convertFireworkExplosion(explosion));
            }
            return new Result<Types_v1_20_5.Fireworks>(ItemComponentRegistry.V1_21_5.FIREWORKS, new Types_v1_20_5.Fireworks(fireworks.flightDuration(), resultExplosions));
        });
        this.register(StructuredDataKey.PROFILE, profile -> {
            HashMap<String, List<Types_v1_20_5.GameProfile.Property>> resultProperties = new HashMap<String, List<Types_v1_20_5.GameProfile.Property>>();
            for (GameProfile.Property property : profile.properties()) {
                List propertyList = resultProperties.computeIfAbsent(property.name(), k -> new ArrayList());
                propertyList.add(new Types_v1_20_5.GameProfile.Property(property.name(), property.value(), property.signature()));
            }
            return new Result<Types_v1_20_5.GameProfile>(ItemComponentRegistry.V1_21_5.PROFILE, new Types_v1_20_5.GameProfile(profile.name(), profile.id(), resultProperties));
        });
        this.identifier(StructuredDataKey.NOTE_BLOCK_SOUND, ItemComponentRegistry.V1_21_5.NOTE_BLOCK_SOUND);
        this.notImplemented(StructuredDataKey.BANNER_PATTERNS);
        this.intToEnum(StructuredDataKey.BASE_COLOR, ItemComponentRegistry.V1_21_5.BASE_COLOR, Types_v1_20_5.DyeColor.class);
        this.notImplemented(StructuredDataKey.POT_DECORATIONS);
        this.register(StructuredDataKey.CONTAINER1_21_5, items -> {
            ArrayList<Types_v1_20_5.ContainerSlot> resultSlots = new ArrayList<Types_v1_20_5.ContainerSlot>();
            for (int i = 0; i < ((Item[])items).length; ++i) {
                Item item = items[i];
                if (item.isEmpty()) continue;
                resultSlots.add(new Types_v1_20_5.ContainerSlot(i, this.convertItemStack(item)));
            }
            return new Result(ItemComponentRegistry.V1_21_5.CONTAINER, resultSlots);
        });
        this.register(StructuredDataKey.BLOCK_STATE, blockState -> new Result<Map<String, String>>(ItemComponentRegistry.V1_21_5.BLOCK_STATE, blockState.properties()));
        this.register(StructuredDataKey.BEES, bees -> {
            ArrayList<Types_v1_20_5.BeeData> resultBeeData = new ArrayList<Types_v1_20_5.BeeData>();
            for (Bee bee : bees) {
                resultBeeData.add(new Types_v1_20_5.BeeData(bee.entityData(), bee.ticksInHive(), bee.minTicksInHive()));
            }
            return new Result(ItemComponentRegistry.V1_21_5.BEES, resultBeeData);
        });
        this.register(StructuredDataKey.LOCK, ItemDataComponentConverter.passthroughNbtCodec(ItemComponentRegistry.V1_21_5.LOCK));
        this.register(StructuredDataKey.CONTAINER_LOOT, ItemDataComponentConverter.passthroughNbtCodec(ItemComponentRegistry.V1_21_5.CONTAINER_LOOT));
        this.notImplemented(StructuredDataKey.BREAK_SOUND);
        this.intToEnum(StructuredDataKey.VILLAGER_VARIANT, ItemComponentRegistry.V1_21_5.VILLAGER_VARIANT, Types_v1_21_5.VillagerVariant.class);
        this.notImplemented(StructuredDataKey.WOLF_VARIANT);
        this.notImplemented(StructuredDataKey.WOLF_SOUND_VARIANT);
        this.intToEnum(StructuredDataKey.WOLF_COLLAR, ItemComponentRegistry.V1_21_5.WOLF_COLLAR, Types_v1_20_5.DyeColor.class);
        this.intToEnum(StructuredDataKey.FOX_VARIANT, ItemComponentRegistry.V1_21_5.FOX_VARIANT, Types_v1_21_5.FoxVariant.class);
        this.intToEnum(StructuredDataKey.SALMON_SIZE, ItemComponentRegistry.V1_21_5.SALMON_SIZE, Types_v1_21_5.SalmonSize.class);
        this.intToEnum(StructuredDataKey.PARROT_VARIANT, ItemComponentRegistry.V1_21_5.PARROT_VARIANT, Types_v1_21_5.ParrotVariant.class);
        this.intToEnum(StructuredDataKey.TROPICAL_FISH_PATTERN, ItemComponentRegistry.V1_21_5.TROPICAL_FISH_PATTERN, Types_v1_21_5.TropicalFishPattern.class);
        this.intToEnum(StructuredDataKey.TROPICAL_FISH_BASE_COLOR, ItemComponentRegistry.V1_21_5.TROPICAL_FISH_BASE_COLOR, Types_v1_20_5.DyeColor.class);
        this.intToEnum(StructuredDataKey.TROPICAL_FISH_PATTERN_COLOR, ItemComponentRegistry.V1_21_5.TROPICAL_FISH_PATTERN_COLOR, Types_v1_20_5.DyeColor.class);
        this.intToEnum(StructuredDataKey.MOOSHROOM_VARIANT, ItemComponentRegistry.V1_21_5.MOOSHROOM_VARIANT, Types_v1_21_5.MooshroomVariant.class);
        this.intToEnum(StructuredDataKey.RABBIT_VARIANT, ItemComponentRegistry.V1_21_5.RABBIT_VARIANT, Types_v1_21_5.RabbitVariant.class);
        this.notImplemented(StructuredDataKey.PIG_VARIANT);
        this.notImplemented(StructuredDataKey.COW_VARIANT);
        this.notImplemented(StructuredDataKey.CHICKEN_VARIANT);
        this.notImplemented(StructuredDataKey.FROG_VARIANT);
        this.intToEnum(StructuredDataKey.HORSE_VARIANT, ItemComponentRegistry.V1_21_5.HORSE_VARIANT, Types_v1_21_5.HorseVariant.class);
        this.notImplemented(StructuredDataKey.PAINTING_VARIANT);
        this.intToEnum(StructuredDataKey.LLAMA_VARIANT, ItemComponentRegistry.V1_21_5.LLAMA_VARIANT, Types_v1_21_5.LlamaVariant.class);
        this.intToEnum(StructuredDataKey.AXOLOTL_VARIANT, ItemComponentRegistry.V1_21_5.AXOLOTL_VARIANT, Types_v1_21_5.AxolotlVariant.class);
        this.notImplemented(StructuredDataKey.CAT_VARIANT);
        this.intToEnum(StructuredDataKey.CAT_COLLAR, ItemComponentRegistry.V1_21_5.CAT_COLLAR, Types_v1_20_5.DyeColor.class);
        this.intToEnum(StructuredDataKey.SHEEP_COLOR, ItemComponentRegistry.V1_21_5.SHEEP_COLOR, Types_v1_20_5.DyeColor.class);
        this.intToEnum(StructuredDataKey.SHULKER_COLOR, ItemComponentRegistry.V1_21_5.SHULKER_COLOR, Types_v1_20_5.DyeColor.class);
    }

    public <I> Result<?> viaToMcStructs(StructuredData<I> structuredData) {
        Converter<?, ?> conversionFunction = this.converters.get(structuredData.key());
        if (conversionFunction == null) {
            throw new IllegalArgumentException("Unknown structured data key: " + String.valueOf(structuredData.key()));
        }
        return conversionFunction.convert(structuredData.value());
    }

    private <I, O> void register(StructuredDataKey<I> key, Converter<I, O> converter) {
        this.converters.put(key, converter);
    }

    private <I> void direct(StructuredDataKey<I> key, ItemComponent<I> result) {
        this.register(key, value -> new Result<Object>(result, value));
    }

    private <I> void notImplemented(StructuredDataKey<I> key) {
        this.register(key, value -> null);
    }

    private void unit(StructuredDataKey<Unit> key, ItemComponent<?> result) {
        this.register(key, value -> new Result<Object>(result, null));
    }

    private <O extends Enum<O>> void intToEnum(StructuredDataKey<Integer> key, ItemComponent<O> result, Class<O> enumClass) {
        this.register(key, ordinal -> {
            Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
            return new Result<Enum>(result, enumConstants[ordinal]);
        });
    }

    private void textComponent(StructuredDataKey<Tag> key, ItemComponent<TextComponent> result) {
        this.register(key, tag -> new Result<TextComponent>(result, this.convertTextComponent((Tag)tag)));
    }

    private void item(StructuredDataKey<Item> key, ItemComponent<Types_v1_20_5.ItemStack> result) {
        this.register(key, item -> new Result<Types_v1_20_5.ItemStack>(result, this.convertItemStack((Item)item)));
    }

    private void identifier(StructuredDataKey<String> key, ItemComponent<Identifier> result) {
        this.register(key, value -> new Result<Identifier>(result, Identifier.of(value)));
    }

    private void registryTag(StructuredDataKey<String> key, ItemComponent<RegistryTag> result, Registry registry) {
        this.register(key, value -> new Result<RegistryTag>(result, new RegistryTag(registry, Identifier.of(value))));
    }

    private Converter<Tag[], List<TextComponent>> stringArrayToTextComponentArray(ItemComponent<List<TextComponent>> itemComponent) {
        return tags -> {
            ArrayList<TextComponent> textComponents = new ArrayList<TextComponent>(((Tag[])tags).length);
            for (Tag tag : tags) {
                textComponents.add(this.convertTextComponent(tag));
            }
            return new Result(itemComponent, textComponents);
        };
    }

    private static <I extends Tag, O> Converter<I, O> passthroughNbtCodec(ItemComponent<O> itemComponent) {
        return tag -> new Result(itemComponent, itemComponent.getCodec().deserialize(NbtConverter_v1_21_5.INSTANCE, tag).getOrThrow());
    }

    private static Types_v1_20_5.FireworkExplosions convertFireworkExplosion(FireworkExplosion explosion) {
        Types_v1_20_5.FireworkExplosions.ExplosionShape explosionShape = Types_v1_20_5.FireworkExplosions.ExplosionShape.values()[explosion.shape()];
        return new Types_v1_20_5.FireworkExplosions(explosionShape, ItemDataComponentConverter.intArrayToIntList(explosion.colors()), ItemDataComponentConverter.intArrayToIntList(explosion.fadeColors()), explosion.hasTrail(), explosion.hasTwinkle());
    }

    private TextComponent convertTextComponent(Tag tag) {
        return tag != null ? this.serializerVersion.toComponent(tag) : null;
    }

    private static List<Integer> intArrayToIntList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int i : array) {
            list.add(i);
        }
        return list;
    }

    private Converter<Item[], List<Types_v1_20_5.ItemStack>> convertItemArrayFunction(ItemComponent<List<Types_v1_20_5.ItemStack>> itemComponent) {
        return items -> {
            ArrayList<Types_v1_20_5.ItemStack> itemStacks = new ArrayList<Types_v1_20_5.ItemStack>(((Item[])items).length);
            for (Item item : items) {
                itemStacks.add(this.convertItemStack(item));
            }
            return new Result(itemComponent, itemStacks);
        };
    }

    private Converter<Enchantments, Map<RegistryEntry, Integer>> convertEnchantmentsFunction(ItemComponent<Map<RegistryEntry, Integer>> itemComponent) {
        return enchantments -> {
            HashMap<RegistryEntry, Integer> enchantmentMap = new HashMap<RegistryEntry, Integer>();
            for (Int2IntMap.Entry entry : enchantments.enchantments().int2IntEntrySet()) {
                enchantmentMap.put(this.registryAccess.getEnchantment(entry.getIntKey()), entry.getIntValue());
            }
            return new Result(itemComponent, enchantmentMap);
        };
    }

    private Types_v1_20_5.ItemStack convertItemStack(Item item) {
        Types_v1_20_5.ItemStack itemStack = new Types_v1_20_5.ItemStack(this.registryAccess.getItem(item.identifier()), item.amount(), new ItemComponentMap(ItemComponentRegistry.V1_21_5));
        ItemComponentMap itemComponentMap = itemStack.getComponents();
        for (StructuredData<?> structuredData : item.dataContainer().data().values()) {
            if (structuredData.isPresent()) {
                Result<?> itemComponent = this.viaToMcStructs(structuredData);
                if (itemComponent == null) continue;
                this.setGeneric(itemComponentMap, itemComponent);
                continue;
            }
            itemComponentMap.markForRemoval(ItemComponentRegistry.V1_21_5.getComponentList().getById(structuredData.id()).get());
        }
        return itemStack;
    }

    private <O> void setGeneric(ItemComponentMap map, Result<O> result) {
        map.set(result.type(), result.value());
    }

    private Registries registries() {
        return ItemComponentRegistry.V1_21_5.getRegistries();
    }

    public static interface RegistryAccess {
        public RegistryEntry getItem(int var1);

        public RegistryEntry getEnchantment(int var1);

        public static RegistryAccess of(List<String> enchantments, Registries registries, MappingData mappingData) {
            return new RegistryAccessImpl(enchantments, registries, mappingData);
        }
    }

    @FunctionalInterface
    public static interface Converter<I, O> {
        public Result<O> convert(I var1);
    }

    public record Result<O>(ItemComponent<O> type, @Nullable O value) {
    }
}

