/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.rewriter.item;

import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.libs.mcstructs.core.Identifier;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.impl.Registries;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.Registry;
import com.viaversion.viaversion.libs.mcstructs.itemcomponents.registry.RegistryEntry;
import com.viaversion.viaversion.rewriter.item.ItemDataComponentConverter;
import java.util.List;

final class RegistryAccessImpl
implements ItemDataComponentConverter.RegistryAccess {
    private final List<String> enchantments;
    private final Registries registries;
    private final MappingData mappingData;

    RegistryAccessImpl(List<String> enchantments, Registries registries, MappingData mappingData) {
        this.enchantments = enchantments;
        this.registries = registries;
        this.mappingData = mappingData;
    }

    @Override
    public RegistryEntry getItem(int networkId) {
        String identifier = this.mappingData.getFullItemMappings().mappedIdentifier(networkId);
        Registry registry = this.registries.item;
        if (identifier != null) {
            return new RegistryEntry(registry, Identifier.of(identifier));
        }
        return new RegistryEntry(registry, Identifier.of("viaversion", "unknown/item/" + networkId));
    }

    @Override
    public RegistryEntry getEnchantment(int networkId) {
        Registry registry = this.registries.enchantment;
        if (networkId < 0 || networkId >= this.enchantments.size()) {
            return new RegistryEntry(registry, Identifier.of("viaversion", "unknown/enchantment/" + networkId));
        }
        return new RegistryEntry(registry, Identifier.of(this.enchantments.get(networkId)));
    }
}

