/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.converter.model;

import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class Either<L, R> {
    private final L left;
    private final R right;

    public static <L, R> Either<L, R> left(@Nonnull L left) {
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> right(@Nonnull R right) {
        return new Either<Object, R>(null, right);
    }

    public static <T> T unwrap(Either<? extends T, ? extends T> either) {
        return either.isLeft() ? either.getLeft() : either.getRight();
    }

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getLeft() {
        return this.left;
    }

    public R getRight() {
        return this.right;
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public <ML, MR> Either<ML, MR> map(Function<L, ML> leftMapper, Function<R, MR> rightMapper) {
        if (this.isLeft()) {
            return Either.left(leftMapper.apply(this.left));
        }
        return Either.right(rightMapper.apply(this.right));
    }

    public <T> T xmap(Function<L, T> leftMapper, Function<R, T> rightMapper) {
        return this.isLeft() ? leftMapper.apply(this.left) : rightMapper.apply(this.right);
    }

    public String toString() {
        if (this.isLeft()) {
            return "Left{" + this.left + "}";
        }
        return "Right{" + this.right + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Either either = (Either)o;
        return Objects.equals(this.left, either.left) && Objects.equals(this.right, either.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

