/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.libs.mcstructs.converter.model;

import com.viaversion.viaversion.libs.mcstructs.core.utils.ToString;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Result<T> {
    private final T result;
    private final IllegalStateException error;

    public static <T> Result<T> success(T result) {
        return new Result<T>(result, null);
    }

    public static <T> Result<T> error(String error) {
        return new Result<Object>(null, new IllegalStateException(error));
    }

    public static <T> Result<T> error(Throwable cause) {
        return new Result<Object>(null, new IllegalStateException(cause));
    }

    public static <T> Result<T> mergeErrors(String error, Collection<Result<?>> errors) {
        String errorMessages = errors.stream().filter(Result::isError).map(Result::error).map((? super T s) -> "[" + s + "]").collect(Collectors.joining(","));
        IllegalStateException exception = new IllegalStateException(error + ": " + errorMessages);
        errors.stream().filter(Result::isError).map((? super T r) -> r.error).forEach(exception::addSuppressed);
        return new Result<Object>(null, exception);
    }

    public static <T> Result<T> unexpected(Object actual, Class<?> ... expected) {
        return Result.unexpected(actual, (String[])Arrays.stream(expected).map(Class::getSimpleName).toArray(String[]::new));
    }

    public static <T> Result<T> unexpected(Object actual, String ... expected) {
        return Result.error("Expected " + String.join((CharSequence)"/", expected) + " but got " + (actual == null ? "null" : actual.getClass().getSimpleName()));
    }

    private Result(T result, IllegalStateException error) {
        this.result = result;
        this.error = error;
    }

    public T get() {
        this.validate();
        return this.result;
    }

    public T getOrThrow() {
        if (this.isError()) {
            throw this.error;
        }
        return this.result;
    }

    public T getOrThrow(Function<Throwable, ? extends Throwable> exceptionSupplier) {
        if (this.isError()) {
            throw exceptionSupplier.apply(this.error);
        }
        return this.result;
    }

    public T orElse(T other) {
        return this.isError() ? other : this.result;
    }

    public T orElseThrow(Function<Throwable, ? extends Throwable> exceptionSupplier) {
        if (this.isError()) {
            throw exceptionSupplier.apply(this.error);
        }
        return this.result;
    }

    public <N> Result<N> map(Function<T, N> mapper) {
        if (this.isError()) {
            return this.mapError();
        }
        return Result.success(mapper.apply(this.result));
    }

    public <N> Result<N> mapResult(Function<T, Result<N>> mapper) {
        if (this.isError()) {
            return this.mapError();
        }
        return mapper.apply(this.result);
    }

    public <N> Result<N> mapError() {
        if (!this.isError()) {
            return Result.error("No error");
        }
        return this;
    }

    public String error() {
        return this.error.getMessage();
    }

    public boolean isSuccessful() {
        return !this.isError();
    }

    public boolean isError() {
        return this.error != null;
    }

    public void validate() {
        if (this.isError()) {
            throw new IllegalStateException("Tried to get result from error", this.error);
        }
    }

    public String toString() {
        return ToString.of(this).add("result", this.result, r -> this.error == null).add("error", this.error, Objects::nonNull).toString();
    }
}

