/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types.misc;

import com.google.common.base.Preconditions;
import com.viaversion.viaversion.api.data.MappingData;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.type.OptionalType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.util.Key;
import io.netty.buffer.ByteBuf;

public class HolderSetType
extends Type<HolderSet> {
    private final MappingData.MappingType mappingType;

    public HolderSetType() {
        this((MappingData.MappingType)null);
    }

    public HolderSetType(MappingData.MappingType mappingType) {
        super(HolderSet.class);
        this.mappingType = mappingType;
    }

    @Override
    public HolderSet read(ByteBuf buffer) {
        int size = Types.VAR_INT.readPrimitive(buffer) - 1;
        if (size == -1) {
            String tag = (String)Types.STRING.read(buffer);
            return HolderSet.of(tag);
        }
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            values[i] = Types.VAR_INT.readPrimitive(buffer);
        }
        return HolderSet.of(values);
    }

    @Override
    public void write(ByteBuf buffer, HolderSet object) {
        if (object.hasTagKey()) {
            Types.VAR_INT.writePrimitive(buffer, 0);
            Types.STRING.write(buffer, object.tagKey());
        } else {
            int[] values = object.ids();
            Types.VAR_INT.writePrimitive(buffer, values.length + 1);
            for (int value : values) {
                Types.VAR_INT.writePrimitive(buffer, value);
            }
        }
    }

    @Override
    public void write(Ops ops, HolderSet value) {
        if (value.hasTagKey()) {
            ops.write(Types.TAG_KEY, Key.of(value.tagKey()));
        } else {
            Preconditions.checkArgument((this.mappingType != null ? 1 : 0) != 0, (Object)"Cannot write HolderSet with direct ids without a mapping type");
            if (value.ids().length == 1) {
                Key key = ops.context().registryAccess().key(this.mappingType, value.ids()[0]);
                ops.write(Types.RESOURCE_LOCATION, key);
                return;
            }
            ops.writeList(list -> {
                for (int id : value.ids()) {
                    Key key = ops.context().registryAccess().key(this.mappingType, id);
                    list.write(Types.RESOURCE_LOCATION, key);
                }
            });
        }
    }

    public static final class OptionalHolderSetType
    extends OptionalType<HolderSet> {
        public OptionalHolderSetType() {
            super(Types.HOLDER_SET);
        }
    }
}

