/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft;

import com.google.common.base.Preconditions;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntFunction;
import java.util.function.Function;

record IdHolder<T>(int id) implements Holder<T>
{
    IdHolder {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"id cannot be negative");
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean hasId() {
        return true;
    }

    @Override
    public T value() {
        throw new IllegalArgumentException("Holder is not direct");
    }

    @Override
    public Holder<T> updateId(Int2IntFunction rewriteFunction) {
        int rewrittenId = rewriteFunction.applyAsInt(this.id);
        if (rewrittenId == this.id) {
            return this;
        }
        if (rewrittenId == -1) {
            throw new IllegalArgumentException("Received invalid id in updateId");
        }
        return Holder.of(rewrittenId);
    }

    @Override
    public Holder<T> updateValue(Function<T, T> rewriteFunction) {
        return this;
    }
}

