/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.codec.hash;

import com.viaversion.viaversion.codec.hash.HashFunction;
import java.util.Arrays;

public final class HashBuilder {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final HashFunction hashFunction;
    private byte[] bytes = EMPTY_BYTES;
    private int index;

    public HashBuilder(HashFunction hashFunction) {
        this.hashFunction = hashFunction;
    }

    public HashBuilder writeByte(byte b) {
        this.ensureSize(1);
        this.bytes[this.index++] = b;
        return this;
    }

    public HashBuilder writeBytes(byte[] bytes) {
        this.ensureSize(bytes.length);
        System.arraycopy(bytes, 0, this.bytes, this.index, bytes.length);
        this.index += bytes.length;
        return this;
    }

    public void writeBytesDirect(byte[] bytes) {
        if (this.bytes.length == 0) {
            this.bytes = bytes;
            this.index = bytes.length;
        } else {
            this.writeBytes(bytes);
        }
    }

    public HashBuilder writeBoolean(boolean value) {
        this.ensureSize(1);
        this.bytes[this.index++] = (byte)(value ? 1 : 0);
        return this;
    }

    public HashBuilder writeShort(short s) {
        this.ensureSize(2);
        this.bytes[this.index++] = (byte)s;
        this.bytes[this.index++] = (byte)(s >> 8);
        return this;
    }

    public HashBuilder writeChar(char c) {
        this.ensureSize(2);
        this.bytes[this.index++] = (byte)c;
        this.bytes[this.index++] = (byte)(c >> 8);
        return this;
    }

    public HashBuilder writeString(CharSequence sequence) {
        this.ensureSize(sequence.length());
        for (int i = 0; i < sequence.length(); ++i) {
            this.writeChar(sequence.charAt(i));
        }
        return this;
    }

    public HashBuilder writeInt(int i) {
        this.ensureSize(4);
        this.bytes[this.index++] = (byte)i;
        this.bytes[this.index++] = (byte)(i >> 8);
        this.bytes[this.index++] = (byte)(i >> 16);
        this.bytes[this.index++] = (byte)(i >> 24);
        return this;
    }

    public HashBuilder writeLong(long l) {
        this.ensureSize(8);
        this.bytes[this.index++] = (byte)l;
        this.bytes[this.index++] = (byte)(l >> 8);
        this.bytes[this.index++] = (byte)(l >> 16);
        this.bytes[this.index++] = (byte)(l >> 24);
        this.bytes[this.index++] = (byte)(l >> 32);
        this.bytes[this.index++] = (byte)(l >> 40);
        this.bytes[this.index++] = (byte)(l >> 48);
        this.bytes[this.index++] = (byte)(l >> 56);
        return this;
    }

    public HashBuilder writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
        return this;
    }

    public HashBuilder writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
        return this;
    }

    public HashBuilder preSize(int bytes) {
        if (this.bytes.length == 0) {
            this.bytes = new byte[bytes];
        } else {
            this.ensureSize(bytes);
        }
        return this;
    }

    private void ensureSize(int bytes) {
        int length = this.bytes.length;
        if (this.index + bytes > length) {
            int newLength = Math.max(length * 2, this.index + bytes);
            this.bytes = Arrays.copyOf(this.bytes, newLength);
        }
    }

    public int hash() {
        return this.hashFunction.hashBytes(this.bytes, this.index);
    }

    public void reset() {
        this.index = 0;
        this.bytes = EMPTY_BYTES;
    }

    public HashFunction function() {
        return this.hashFunction;
    }
}

