/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.misc.HolderType;
import com.viaversion.viaversion.util.Key;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public record PaintingVariant(int width, int height, String assetId, @Nullable Tag title, @Nullable Tag author) {
    public static HolderType<PaintingVariant> TYPE1_21 = new HolderType<PaintingVariant>(){

        @Override
        public PaintingVariant readDirect(ByteBuf buffer) {
            int width = Types.VAR_INT.readPrimitive(buffer);
            int height = Types.VAR_INT.readPrimitive(buffer);
            String assetId = (String)Types.STRING.read(buffer);
            return new PaintingVariant(width, height, assetId);
        }

        @Override
        public void writeDirect(ByteBuf buffer, PaintingVariant variant) {
            Types.VAR_INT.writePrimitive(buffer, variant.width());
            Types.VAR_INT.writePrimitive(buffer, variant.height());
            Types.STRING.write(buffer, variant.assetId());
        }
    };
    public static HolderType<PaintingVariant> TYPE1_21_2 = new HolderType<PaintingVariant>(){

        @Override
        public PaintingVariant readDirect(ByteBuf buffer) {
            int width = Types.VAR_INT.readPrimitive(buffer);
            int height = Types.VAR_INT.readPrimitive(buffer);
            String assetId = (String)Types.STRING.read(buffer);
            Tag title = (Tag)Types.OPTIONAL_TAG.read(buffer);
            Tag author = (Tag)Types.OPTIONAL_TAG.read(buffer);
            return new PaintingVariant(width, height, assetId, title, author);
        }

        @Override
        public void writeDirect(ByteBuf buffer, PaintingVariant variant) {
            Types.VAR_INT.writePrimitive(buffer, variant.width());
            Types.VAR_INT.writePrimitive(buffer, variant.height());
            Types.STRING.write(buffer, variant.assetId());
            Types.OPTIONAL_TAG.write(buffer, variant.title());
            Types.OPTIONAL_TAG.write(buffer, variant.author());
        }

        @Override
        public void writeDirect(Ops ops, PaintingVariant value) {
            ops.writeMap(map -> map.write("width", Types.INT, value.width()).write("height", Types.INT, value.height()).write("asset_id", Types.RESOURCE_LOCATION, Key.of(value.assetId())).writeOptional("title", Types.TAG, value.title()).writeOptional("author", Types.TAG, value.author()));
        }
    };

    public PaintingVariant(int width, int height, String assetId) {
        this(width, height, assetId, null, null);
    }
}

