/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.misc.HolderType;
import com.viaversion.viaversion.util.Copyable;
import io.netty.buffer.ByteBuf;

public record ChatType(ChatTypeDecoration chatDecoration, ChatTypeDecoration narrationDecoration) implements Copyable
{
    public static final HolderType<ChatType> TYPE = new HolderType<ChatType>(){

        @Override
        public ChatType readDirect(ByteBuf buffer) {
            ChatTypeDecoration chatDecoration = (ChatTypeDecoration)ChatTypeDecoration.TYPE.read(buffer);
            ChatTypeDecoration narrationDecoration = (ChatTypeDecoration)ChatTypeDecoration.TYPE.read(buffer);
            return new ChatType(chatDecoration, narrationDecoration);
        }

        @Override
        public void writeDirect(ByteBuf buffer, ChatType value) {
            ChatTypeDecoration.TYPE.write(buffer, value.chatDecoration());
            ChatTypeDecoration.TYPE.write(buffer, value.narrationDecoration());
        }
    };

    @Override
    public ChatType copy() {
        return new ChatType(this.chatDecoration.copy(), this.narrationDecoration.copy());
    }

    public record ChatTypeDecoration(String translationKey, int[] parameters, Tag style) implements Copyable
    {
        public static final Type<ChatTypeDecoration> TYPE = new Type<ChatTypeDecoration>(ChatTypeDecoration.class){

            @Override
            public ChatTypeDecoration read(ByteBuf buffer) {
                String translationKey = (String)Types.STRING.read(buffer);
                int[] parameters = (int[])Types.INT_ARRAY_PRIMITIVE.read(buffer);
                Tag style = (Tag)Types.TAG.read(buffer);
                return new ChatTypeDecoration(translationKey, parameters, style);
            }

            @Override
            public void write(ByteBuf buffer, ChatTypeDecoration value) {
                Types.STRING.write(buffer, value.translationKey());
                Types.INT_ARRAY_PRIMITIVE.write(buffer, value.parameters());
                Types.TAG.write(buffer, value.style());
            }
        };

        @Override
        public ChatTypeDecoration copy() {
            return new ChatTypeDecoration(this.translationKey, (int[])this.parameters.clone(), this.style.copy());
        }
    }
}

