/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.type.TransformingType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.util.Copyable;
import com.viaversion.viaversion.util.Rewritable;

public record PotDecorations(int[] itemIds) implements Copyable,
Rewritable
{
    public static final Type<PotDecorations> TYPE = new TransformingType<int[], PotDecorations>(Types.VAR_INT_ARRAY_PRIMITIVE, PotDecorations.class, PotDecorations::new, PotDecorations::itemIds){

        @Override
        public void write(Ops ops, PotDecorations value) {
            ops.writeList(list -> {
                for (int itemId : value.itemIds) {
                    list.write(Types.RESOURCE_LOCATION, ops.context().registryAccess().item(itemId));
                }
            });
        }
    };

    public PotDecorations(int backItem, int leftItem, int rightItem, int frontItem) {
        this(new int[]{backItem, leftItem, rightItem, frontItem});
    }

    public int backItem() {
        return this.item(0);
    }

    public int leftItem() {
        return this.item(1);
    }

    public int rightItem() {
        return this.item(2);
    }

    public int frontItem() {
        return this.item(3);
    }

    private int item(int index) {
        return index < 0 || index >= this.itemIds.length ? -1 : this.itemIds[index];
    }

    @Override
    public PotDecorations rewrite(UserConnection connection, Protocol<?, ?, ?, ?> protocol, boolean clientbound) {
        int[] newItems = new int[this.itemIds.length];
        for (int i = 0; i < this.itemIds.length; ++i) {
            newItems[i] = Rewritable.rewriteItem(protocol, clientbound, this.itemIds[i]);
        }
        return new PotDecorations(newItems);
    }

    @Override
    public PotDecorations copy() {
        return new PotDecorations(Copyable.copy(this.itemIds));
    }
}

